/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import org.opencv.core.Mat;

public class QRCodeDetector {
    protected final long nativeObj;

    protected QRCodeDetector(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static QRCodeDetector __fromPtr__(long addr) {
        return new QRCodeDetector(addr);
    }

    public QRCodeDetector() {
        this.nativeObj = QRCodeDetector.QRCodeDetector_0();
    }

    public boolean detect(Mat img, Mat points) {
        return QRCodeDetector.detect_0(this.nativeObj, img.nativeObj, points.nativeObj);
    }

    public String decode(Mat img, Mat points, Mat straight_qrcode) {
        return QRCodeDetector.decode_0(this.nativeObj, img.nativeObj, points.nativeObj, straight_qrcode.nativeObj);
    }

    public String decode(Mat img, Mat points) {
        return QRCodeDetector.decode_1(this.nativeObj, img.nativeObj, points.nativeObj);
    }

    public String detectAndDecode(Mat img, Mat points, Mat straight_qrcode) {
        return QRCodeDetector.detectAndDecode_0(this.nativeObj, img.nativeObj, points.nativeObj, straight_qrcode.nativeObj);
    }

    public String detectAndDecode(Mat img, Mat points) {
        return QRCodeDetector.detectAndDecode_1(this.nativeObj, img.nativeObj, points.nativeObj);
    }

    public String detectAndDecode(Mat img) {
        return QRCodeDetector.detectAndDecode_2(this.nativeObj, img.nativeObj);
    }

    public void setEpsX(double epsX) {
        QRCodeDetector.setEpsX_0(this.nativeObj, epsX);
    }

    public void setEpsY(double epsY) {
        QRCodeDetector.setEpsY_0(this.nativeObj, epsY);
    }

    protected void finalize() throws Throwable {
        QRCodeDetector.delete(this.nativeObj);
    }

    private static native long QRCodeDetector_0();

    private static native boolean detect_0(long var0, long var2, long var4);

    private static native String decode_0(long var0, long var2, long var4, long var6);

    private static native String decode_1(long var0, long var2, long var4);

    private static native String detectAndDecode_0(long var0, long var2, long var4, long var6);

    private static native String detectAndDecode_1(long var0, long var2, long var4);

    private static native String detectAndDecode_2(long var0, long var2);

    private static native void setEpsX_0(long var0, double var2);

    private static native void setEpsY_0(long var0, double var2);

    private static native void delete(long var0);
}

