// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;

public class opencv_signal extends org.bytedeco.opencv.presets.opencv_signal {
    static { Loader.load(); }

// Parsed from <opencv2/signal.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html
// #ifndef OPENCV_SIGNAL_HPP
// #define OPENCV_SIGNAL_HPP

/**
* \defgroup signal Signal Processing
* \{
* This module includes signal processing algorithms.
* \}
*/

// #include "opencv2/core.hpp"
// #include "opencv2/signal/signal_resample.hpp"

// #endif


// Parsed from <opencv2/signal/signal_resample.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html
// #ifndef OPENCV_SIGNAL_SIGNAL_RESAMPLE_HPP
// #define OPENCV_SIGNAL_SIGNAL_RESAMPLE_HPP

// #include <opencv2/core.hpp>

/** \addtogroup signal
 *  \{
<p>
/** \brief Signal resampling
 *
 * @param inputSignal [in]              Array with input signal.
 * @param outSignal [out]                Array with output signal
 * @param inFreq [in]                   Input signal frequency.
 * @param outFreq [in]                  Output signal frequency.
 * Signal resampling implemented a cubic interpolation function and a filtering function based on Kaiser window and Bessel function, used to construct a FIR filter.
 * Result is similar to {@code scipy.signal.resample}.
<p>
Detail: https://en.wikipedia.org/wiki/Sample-rate_conversion
*/
@Namespace("cv::signal") public static native void resampleSignal(@ByVal Mat inputSignal, @ByVal Mat outSignal, int inFreq, int outFreq);
@Namespace("cv::signal") public static native void resampleSignal(@ByVal UMat inputSignal, @ByVal UMat outSignal, int inFreq, int outFreq);
@Namespace("cv::signal") public static native void resampleSignal(@ByVal GpuMat inputSignal, @ByVal GpuMat outSignal, int inFreq, int outFreq);

/** \} */



// #endif


}
