// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_core;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.opencv.global.opencv_core.*;

@Name("std::vector<cv::KeyPoint>") @Properties(inherit = org.bytedeco.opencv.presets.opencv_core.class)
public class KeyPointVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public KeyPointVector(Pointer p) { super(p); }
    public KeyPointVector(KeyPoint value) { this(1); put(0, value); }
    public KeyPointVector(KeyPoint ... array) { this(array.length); put(array); }
    public KeyPointVector()       { allocate();  }
    public KeyPointVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator =") @ByRef KeyPointVector put(@ByRef KeyPointVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    public KeyPoint front() { return get(0); }
    public KeyPoint back() { return get(size() - 1); }
    @Index(function = "at") public native @ByRef KeyPoint get(@Cast("size_t") long i);
    public native KeyPointVector put(@Cast("size_t") long i, KeyPoint value);

    public native @ByVal Iterator insert(@ByVal Iterator pos, @ByRef KeyPoint value);
    public native @ByVal Iterator erase(@ByVal Iterator pos);
    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator ++") @ByRef Iterator increment();
        public native @Name("operator ==") boolean equals(@ByRef Iterator it);
        public native @Name("operator *") @ByRef @Const KeyPoint get();
    }

    public KeyPoint[] get() {
        KeyPoint[] array = new KeyPoint[size() < Integer.MAX_VALUE ? (int)size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; i++) {
            array[i] = get(i);
        }
        return array;
    }
    @Override public String toString() {
        return java.util.Arrays.toString(get());
    }

    public KeyPoint pop_back() {
        long size = size();
        KeyPoint value = get(size - 1);
        resize(size - 1);
        return value;
    }
    public KeyPointVector push_back(KeyPoint value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public KeyPointVector put(KeyPoint value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public KeyPointVector put(KeyPoint ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

