// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_cudacodec;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;

import static org.bytedeco.opencv.global.opencv_cudacodec.*;


/** \brief Different parameters for CUDA video encoder.
*/
@Namespace("cv::cudacodec") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_cudacodec.class)
public class EncoderParams extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public EncoderParams(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public EncoderParams(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public EncoderParams position(long position) {
        return (EncoderParams)super.position(position);
    }
    @Override public EncoderParams getPointer(long i) {
        return new EncoderParams((Pointer)this).offsetAddress(i);
    }

    public EncoderParams() { super((Pointer)null); allocate(); }
    private native void allocate();
    public native @Cast("cv::cudacodec::EncodePreset") int nvPreset(); public native EncoderParams nvPreset(int setter);
    public native @Cast("cv::cudacodec::EncodeTuningInfo") int tuningInfo(); public native EncoderParams tuningInfo(int setter);
    public native @Cast("cv::cudacodec::EncodeProfile") int encodingProfile(); public native EncoderParams encodingProfile(int setter);
    public native @Cast("cv::cudacodec::EncodeParamsRcMode") int rateControlMode(); public native EncoderParams rateControlMode(int setter);
    public native @Cast("cv::cudacodec::EncodeMultiPass") int multiPassEncoding(); public native EncoderParams multiPassEncoding(int setter);
    /** QP's for \ref ENC_PARAMS_RC_CONSTQP. */
    public native @ByRef EncodeQp constQp(); public native EncoderParams constQp(EncodeQp setter);
    /** target bitrate for \ref ENC_PARAMS_RC_VBR and \ref ENC_PARAMS_RC_CBR. */
    public native int averageBitRate(); public native EncoderParams averageBitRate(int setter);
    /** upper bound on bitrate for \ref ENC_PARAMS_RC_VBR and \ref ENC_PARAMS_RC_CONSTQP. */
    public native int maxBitRate(); public native EncoderParams maxBitRate(int setter);
    /** value 0 - 51 where video quality decreases as targetQuality increases, used with \ref ENC_PARAMS_RC_VBR. */
    public native @Cast("uint8_t") byte targetQuality(); public native EncoderParams targetQuality(byte setter);
    /** the number of pictures in one GOP, ensuring \ref idrPeriod >= \ref gopLength. */
    public native int gopLength(); public native EncoderParams gopLength(int setter);
    /** IDR interval, ensuring \ref idrPeriod >= \ref gopLength. */
    public native int idrPeriod(); public native EncoderParams idrPeriod(int setter);
}
