// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_cudacodec;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;

import static org.bytedeco.opencv.global.opencv_cudacodec.*;


/** \brief Struct providing information about video file format. :
 */
@Namespace("cv::cudacodec") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_cudacodec.class)
public class FormatInfo extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FormatInfo(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public FormatInfo(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public FormatInfo position(long position) {
        return (FormatInfo)super.position(position);
    }
    @Override public FormatInfo getPointer(long i) {
        return new FormatInfo((Pointer)this).offsetAddress(i);
    }

    public FormatInfo() { super((Pointer)null); allocate(); }
    private native void allocate();

    public native @Cast("cv::cudacodec::Codec") int codec(); public native FormatInfo codec(int setter);
    public native @Cast("cv::cudacodec::ChromaFormat") int chromaFormat(); public native FormatInfo chromaFormat(int setter);
    public native int nBitDepthMinus8(); public native FormatInfo nBitDepthMinus8(int setter);
    public native int nBitDepthChromaMinus8(); public native FormatInfo nBitDepthChromaMinus8(int setter);
    /** Coded sequence width in pixels. */
    public native int ulWidth(); public native FormatInfo ulWidth(int setter);
    /** Coded sequence height in pixels. */
    public native int ulHeight(); public native FormatInfo ulHeight(int setter);
    /** Width of the decoded frame returned by nextFrame(frame). */
    public native int width(); public native FormatInfo width(int setter);
    /** Height of the decoded frame returned by nextFrame(frame). */
    public native int height(); public native FormatInfo height(int setter);
    public native int ulMaxWidth(); public native FormatInfo ulMaxWidth(int setter);
    public native int ulMaxHeight(); public native FormatInfo ulMaxHeight(int setter);
    /** ROI inside the decoded frame returned by nextFrame(frame), containing the useable video frame. */
    public native @ByRef Rect displayArea(); public native FormatInfo displayArea(Rect setter);
    public native @Cast("bool") boolean valid(); public native FormatInfo valid(boolean setter);
    public native double fps(); public native FormatInfo fps(double setter);
    /** Maximum number of internal decode surfaces. */
    public native int ulNumDecodeSurfaces(); public native FormatInfo ulNumDecodeSurfaces(int setter);
    public native @Cast("cv::cudacodec::DeinterlaceMode") int deinterlaceMode(); public native FormatInfo deinterlaceMode(int setter);
    /** Post-processed size of the output frame. */
    public native @ByRef Size targetSz(); public native FormatInfo targetSz(Size setter);
    /** Region of interest decoded from video source. */
    public native @ByRef Rect srcRoi(); public native FormatInfo srcRoi(Rect setter);
    /** Region of interest in the output frame containing the decoded frame. */
    public native @ByRef Rect targetRoi(); public native FormatInfo targetRoi(Rect setter);
    /** Output value indicating if the black level, luma and chroma of the source are represented using the full or limited range (AKA TV or "analogue" range) of values as defined in Annex E of the ITU-T Specification.  Internally the conversion from NV12 to BGR obeys ITU 709. */
    public native @Cast("bool") boolean videoFullRangeFlag(); public native FormatInfo videoFullRangeFlag(boolean setter);
    /** Flag requesting histogram output if supported. Exception will be thrown when requested but not supported. */
    public native @Cast("bool") boolean enableHistogram(); public native FormatInfo enableHistogram(boolean setter);
    /** Bit depth of histogram bins if histogram output is requested and supported. */
    public native int nCounterBitDepth(); public native FormatInfo nCounterBitDepth(int setter);
    /** Max number of histogram bins if histogram output is requested and supported. */
    public native int nMaxHistogramBins(); public native FormatInfo nMaxHistogramBins(int setter);
}
