// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_cudacodec;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;

import static org.bytedeco.opencv.global.opencv_cudacodec.*;


/** \brief Interface for video demultiplexing. :
<p>
User can implement own demultiplexing by implementing this interface.
 */
@Namespace("cv::cudacodec") @Properties(inherit = org.bytedeco.opencv.presets.opencv_cudacodec.class)
public class RawVideoSource extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RawVideoSource(Pointer p) { super(p); }


    /** \brief Returns next packet with RAW video frame.
    <p>
    @param data Pointer to frame data.
    @param size Size in bytes of current frame.
     */
    public native @Cast("bool") boolean getNextPacket(@Cast("unsigned char**") PointerPointer data, @Cast("size_t*") SizeTPointer size);
    public native @Cast("bool") boolean getNextPacket(@Cast("unsigned char**") @ByPtrPtr BytePointer data, @Cast("size_t*") SizeTPointer size);
    public native @Cast("bool") boolean getNextPacket(@Cast("unsigned char**") @ByPtrPtr ByteBuffer data, @Cast("size_t*") SizeTPointer size);
    public native @Cast("bool") boolean getNextPacket(@Cast("unsigned char**") @ByPtrPtr byte[] data, @Cast("size_t*") SizeTPointer size);

    /** \brief Returns true if the last packet contained a key frame.
     */
    public native @Cast("bool") boolean lastPacketContainsKeyFrame();

    /** \brief Returns information about video file format.
    */
    public native @ByVal FormatInfo format();

    /** \brief Updates the coded width and height inside format.
    */
    public native void updateFormat(@Const @ByRef FormatInfo videoFormat);

    /** \brief Returns any extra data associated with the video source.
    <p>
    @param extraData 1D cv::Mat containing the extra data if it exists.
     */
    public native void getExtraData(@ByRef Mat extraData);

    /** \brief Retrieves the specified property used by the VideoSource.
    <p>
    @param propertyId Property identifier from cv::VideoCaptureProperties (eg. cv::CAP_PROP_POS_MSEC, cv::CAP_PROP_POS_FRAMES, ...)
    or one from \ref videoio_flags_others.
    @param propertyVal Value for the specified property.
    <p>
    @return {@code true} unless the property is unset set or not supported.
     */
    public native @Cast("bool") boolean get(int propertyId, @ByRef DoublePointer propertyVal);
    public native @Cast("bool") boolean get(int propertyId, @ByRef DoubleBuffer propertyVal);
    public native @Cast("bool") boolean get(int propertyId, @ByRef double[] propertyVal);

    /** \brief Retrieve the index of the first frame that will returned after construction.
    <p>
    @return index of the index of the first frame that will returned after construction.
    <p>
    \note To reduce the decoding overhead when initializing VideoReader to start its decoding from frame N, RawVideoSource should seek to the first valid key frame less than or equal to N and return that index here.
     */
    public native int getFirstFrameIdx();
}
