// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_cudacodec;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;

import static org.bytedeco.opencv.global.opencv_cudacodec.*;


/** \brief Video writer interface, see createVideoWriter().
<p>
Available if Nvidia's Video Codec SDK is installed.
<p>
Only Codec::H264 and Codec::HEVC are supported with encoding support dependent on the GPU, refer to the Nvidia Video Codec SDK Video Encode and Decode GPU Support Matrix for details.
<p>
\note
   -   An example on how to use the VideoWriter class can be found at
        opencv_source_code/samples/gpu/video_writer.cpp
*/
@Name("cv::cudacodec::VideoWriter") @Properties(inherit = org.bytedeco.opencv.presets.opencv_cudacodec.class)
public class VideoWriter extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public VideoWriter(Pointer p) { super(p); }


    /** \brief Writes the next video frame.
    <p>
    @param frame The framet to be written.
    <p>
    The method encodes the specified image to a video stream. The image must have the same size and the same
    surface format as has been specified when opening the video writer.
    */
    public native void write(@ByVal Mat frame);
    public native void write(@ByVal UMat frame);
    public native void write(@ByVal GpuMat frame);

    /** \brief Retrieve the encoding parameters.
    */
    public native @ByVal EncoderParams getEncoderParams();

    /** \brief Waits until the encoding process has finished before calling EncoderCallback::onEncodingFinished().
    */
    public native void release();
}
