// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_features2d;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;

import static org.bytedeco.opencv.global.opencv_features2d.*;



/** \brief Class for implementing the wrapper which makes detectors and extractors to be affine invariant,
described as ASIFT in \cite YM11 .
*/
@Namespace("cv") @Properties(inherit = org.bytedeco.opencv.presets.opencv_features2d.class)
public class AffineFeature extends Feature2D {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AffineFeature(Pointer p) { super(p); }
    /** Downcast constructor. */
    public AffineFeature(Algorithm pointer) { super((Pointer)null); allocate(pointer); }
    @Namespace private native @Name("dynamic_cast<cv::AffineFeature*>") void allocate(Algorithm pointer);

    /**
    @param backend The detector/extractor you want to use as backend.
    @param maxTilt The highest power index of tilt factor. 5 is used in the paper as tilt sampling range n.
    @param minTilt The lowest power index of tilt factor. 0 is used in the paper.
    @param tiltStep Tilt sampling step {@code \delta_t} in Algorithm 1 in the paper.
    @param rotateStepBase Rotation sampling step factor b in Algorithm 1 in the paper.
    */
    public static native @Ptr AffineFeature create(@Ptr Feature2D backend,
            int maxTilt/*=5*/, int minTilt/*=0*/, float tiltStep/*=1.4142135623730951f*/, float rotateStepBase/*=72*/);
    public static native @Ptr AffineFeature create(@Ptr Feature2D backend);

    public native void setViewParams(@StdVector FloatPointer tilts, @StdVector FloatPointer rolls);
    public native void setViewParams(@StdVector FloatBuffer tilts, @StdVector FloatBuffer rolls);
    public native void setViewParams(@StdVector float[] tilts, @StdVector float[] rolls);
    public native void getViewParams(@StdVector FloatPointer tilts, @StdVector FloatPointer rolls);
    public native void getViewParams(@StdVector FloatBuffer tilts, @StdVector FloatBuffer rolls);
    public native void getViewParams(@StdVector float[] tilts, @StdVector float[] rolls);
    public native @Str @Override BytePointer getDefaultName();
}
