// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_features2d;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;

import static org.bytedeco.opencv.global.opencv_features2d.*;


/** \brief Maximally stable extremal region extractor
<p>
The class encapsulates all the parameters of the %MSER extraction algorithm (see [wiki
article](http://en.wikipedia.org/wiki/Maximally_stable_extremal_regions)).
<p>
- there are two different implementation of %MSER: one for grey image, one for color image
<p>
- the grey image algorithm is taken from: \cite nister2008linear ;  the paper claims to be faster
than union-find method; it actually get 1.5~2m/s on my centrino L7200 1.2GHz laptop.
<p>
- the color image algorithm is taken from: \cite forssen2007maximally ; it should be much slower
than grey image method ( 3~4 times )
<p>
- (Python) A complete example showing the use of the %MSER detector can be found at samples/python/mser.py
*/
@Namespace("cv") @Properties(inherit = org.bytedeco.opencv.presets.opencv_features2d.class)
public class MSER extends Feature2D {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MSER(Pointer p) { super(p); }
    /** Downcast constructor. */
    public MSER(Algorithm pointer) { super((Pointer)null); allocate(pointer); }
    @Namespace private native @Name("dynamic_cast<cv::MSER*>") void allocate(Algorithm pointer);

    /** \brief Full constructor for %MSER detector
    <p>
    @param delta it compares {@code (size_{i}-size_{i-delta})/size_{i-delta}}
    @param min_area prune the area which smaller than minArea
    @param max_area prune the area which bigger than maxArea
    @param max_variation prune the area have similar size to its children
    @param min_diversity for color image, trace back to cut off mser with diversity less than min_diversity
    @param max_evolution  for color image, the evolution steps
    @param area_threshold for color image, the area threshold to cause re-initialize
    @param min_margin for color image, ignore too small margin
    @param edge_blur_size for color image, the aperture size for edge blur
     */
    public static native @Ptr MSER create( int delta/*=5*/, int min_area/*=60*/, int max_area/*=14400*/,
              double max_variation/*=0.25*/, double min_diversity/*=.2*/,
              int max_evolution/*=200*/, double area_threshold/*=1.01*/,
              double min_margin/*=0.003*/, int edge_blur_size/*=5*/ );
    public static native @Ptr MSER create( );

    /** \brief Detect %MSER regions
    <p>
    @param image input image (8UC1, 8UC3 or 8UC4, must be greater or equal than 3x3)
    @param msers resulting list of point sets
    @param bboxes resulting bounding boxes
    */
    public native void detectRegions( @ByVal Mat image,
                                            @ByRef PointVectorVector msers,
                                            @ByRef RectVector bboxes );
    public native void detectRegions( @ByVal UMat image,
                                            @ByRef PointVectorVector msers,
                                            @ByRef RectVector bboxes );
    public native void detectRegions( @ByVal GpuMat image,
                                            @ByRef PointVectorVector msers,
                                            @ByRef RectVector bboxes );

    public native void setDelta(int delta);
    public native int getDelta();

    public native void setMinArea(int minArea);
    public native int getMinArea();

    public native void setMaxArea(int maxArea);
    public native int getMaxArea();

    public native void setMaxVariation(double maxVariation);
    public native double getMaxVariation();

    public native void setMinDiversity(double minDiversity);
    public native double getMinDiversity();

    public native void setMaxEvolution(int maxEvolution);
    public native int getMaxEvolution();

    public native void setAreaThreshold(double areaThreshold);
    public native double getAreaThreshold();

    public native void setMinMargin(double min_margin);
    public native double getMinMargin();

    public native void setEdgeBlurSize(int edge_blur_size);
    public native int getEdgeBlurSize();

    public native void setPass2Only(@Cast("bool") boolean f);
    public native @Cast("bool") boolean getPass2Only();

    public native @Str @Override BytePointer getDefaultName();
}
