// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_objdetect;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;

import static org.bytedeco.opencv.global.opencv_objdetect.*;


/** \brief Board of ArUco markers
 *
 * A board is a set of markers in the 3D space with a common coordinate system.
 * The common form of a board of marker is a planar (2D) board, however any 3D layout can be used.
 * A Board object is composed by:
 * - The object points of the marker corners, i.e. their coordinates respect to the board system.
 * - The dictionary which indicates the type of markers of the board
 * - The identifier of all the markers in the board.
 */
@Namespace("cv::aruco") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_objdetect.class)
public class Board extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Board(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Board(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public Board position(long position) {
        return (Board)super.position(position);
    }
    @Override public Board getPointer(long i) {
        return new Board((Pointer)this).offsetAddress(i);
    }

    /** \brief Common Board constructor
     *
     * @param objPoints array of object points of all the marker corners in the board
     * @param dictionary the dictionary of markers employed for this board
     * @param ids vector of the identifiers of the markers in the board
     */
    public Board(@ByVal MatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal Mat ids) { super((Pointer)null); allocate(objPoints, dictionary, ids); }
    private native void allocate(@ByVal MatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal Mat ids);
    public Board(@ByVal UMatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal Mat ids) { super((Pointer)null); allocate(objPoints, dictionary, ids); }
    private native void allocate(@ByVal UMatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal Mat ids);
    public Board(@ByVal GpuMatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal Mat ids) { super((Pointer)null); allocate(objPoints, dictionary, ids); }
    private native void allocate(@ByVal GpuMatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal Mat ids);
    public Board(@ByVal MatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal UMat ids) { super((Pointer)null); allocate(objPoints, dictionary, ids); }
    private native void allocate(@ByVal MatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal UMat ids);
    public Board(@ByVal UMatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal UMat ids) { super((Pointer)null); allocate(objPoints, dictionary, ids); }
    private native void allocate(@ByVal UMatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal UMat ids);
    public Board(@ByVal GpuMatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal UMat ids) { super((Pointer)null); allocate(objPoints, dictionary, ids); }
    private native void allocate(@ByVal GpuMatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal UMat ids);
    public Board(@ByVal MatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal GpuMat ids) { super((Pointer)null); allocate(objPoints, dictionary, ids); }
    private native void allocate(@ByVal MatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal GpuMat ids);
    public Board(@ByVal UMatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal GpuMat ids) { super((Pointer)null); allocate(objPoints, dictionary, ids); }
    private native void allocate(@ByVal UMatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal GpuMat ids);
    public Board(@ByVal GpuMatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal GpuMat ids) { super((Pointer)null); allocate(objPoints, dictionary, ids); }
    private native void allocate(@ByVal GpuMatVector objPoints, @Const @ByRef Dictionary dictionary, @ByVal GpuMat ids);

    /** \brief return the Dictionary of markers employed for this board
     */
    public native @Const @ByRef Dictionary getDictionary();

    /** \brief return array of object points of all the marker corners in the board.
     *
     * Each marker include its 4 corners in this order:
     * -   objPoints[i][0] - left-top point of i-th marker
     * -   objPoints[i][1] - right-top point of i-th marker
     * -   objPoints[i][2] - right-bottom point of i-th marker
     * -   objPoints[i][3] - left-bottom point of i-th marker
     *
     * Markers are placed in a certain order - row by row, left to right in every row. For M markers, the size is Mx4.
     */
    public native @Const @ByRef Point3fVectorVector getObjPoints();

    /** \brief vector of the identifiers of the markers in the board (should be the same size as objPoints)
     * @return vector of the identifiers of the markers
     */
    public native @StdVector IntPointer getIds();

    /** \brief get coordinate of the bottom right corner of the board, is set when calling the function create()
     */
    public native @Const @ByRef Point3f getRightBottomCorner();

    /** \brief Given a board configuration and a set of detected markers, returns the corresponding
     * image points and object points, can be used in solvePnP()
     *
     * @param detectedCorners List of detected marker corners of the board.
     * For cv::Board and cv::GridBoard the method expects std::vector<std::vector<Point2f>> or std::vector<Mat> with Aruco marker corners.
     * For cv::CharucoBoard the method expects std::vector<Point2f> or Mat with ChAruco corners (chess board corners matched with Aruco markers).
     *
     * @param detectedIds List of identifiers for each marker or charuco corner.
     * For any Board class the method expects std::vector<int> or Mat.
     *
     * @param objPoints Vector of marker points in the board coordinate space.
     * For any Board class the method expects std::vector<cv::Point3f> objectPoints or cv::Mat
     *
     * @param imgPoints Vector of marker points in the image coordinate space.
     * For any Board class the method expects std::vector<cv::Point2f> objectPoints or cv::Mat
     *
     * @see solvePnP
     */
    public native void matchImagePoints(@ByVal MatVector detectedCorners, @ByVal Mat detectedIds,
                                      @ByVal Mat objPoints, @ByVal Mat imgPoints);
    public native void matchImagePoints(@ByVal UMatVector detectedCorners, @ByVal Mat detectedIds,
                                      @ByVal Mat objPoints, @ByVal Mat imgPoints);
    public native void matchImagePoints(@ByVal GpuMatVector detectedCorners, @ByVal Mat detectedIds,
                                      @ByVal Mat objPoints, @ByVal Mat imgPoints);
    public native void matchImagePoints(@ByVal MatVector detectedCorners, @ByVal UMat detectedIds,
                                      @ByVal UMat objPoints, @ByVal UMat imgPoints);
    public native void matchImagePoints(@ByVal UMatVector detectedCorners, @ByVal UMat detectedIds,
                                      @ByVal UMat objPoints, @ByVal UMat imgPoints);
    public native void matchImagePoints(@ByVal GpuMatVector detectedCorners, @ByVal UMat detectedIds,
                                      @ByVal UMat objPoints, @ByVal UMat imgPoints);
    public native void matchImagePoints(@ByVal MatVector detectedCorners, @ByVal GpuMat detectedIds,
                                      @ByVal GpuMat objPoints, @ByVal GpuMat imgPoints);
    public native void matchImagePoints(@ByVal UMatVector detectedCorners, @ByVal GpuMat detectedIds,
                                      @ByVal GpuMat objPoints, @ByVal GpuMat imgPoints);
    public native void matchImagePoints(@ByVal GpuMatVector detectedCorners, @ByVal GpuMat detectedIds,
                                      @ByVal GpuMat objPoints, @ByVal GpuMat imgPoints);

     /** \brief Draw a planar board
     *
     * @param outSize size of the output image in pixels.
     * @param img output image with the board. The size of this image will be outSize
     * and the board will be on the center, keeping the board proportions.
     * @param marginSize minimum margins (in pixels) of the board in the output image
     * @param borderBits width of the marker borders.
     *
     * This function return the image of the board, ready to be printed.
     */
    public native void generateImage(@ByVal Size outSize, @ByVal Mat img, int marginSize/*=0*/, int borderBits/*=1*/);
    public native void generateImage(@ByVal Size outSize, @ByVal Mat img);
    public native void generateImage(@ByVal Size outSize, @ByVal UMat img, int marginSize/*=0*/, int borderBits/*=1*/);
    public native void generateImage(@ByVal Size outSize, @ByVal UMat img);
    public native void generateImage(@ByVal Size outSize, @ByVal GpuMat img, int marginSize/*=0*/, int borderBits/*=1*/);
    public native void generateImage(@ByVal Size outSize, @ByVal GpuMat img);

    @Deprecated public Board() { super((Pointer)null); allocate(); }
    @Deprecated private native void allocate();

    @Opaque public static class Impl extends Pointer {
        /** Empty constructor. Calls {@code super((Pointer)null)}. */
        public Impl() { super((Pointer)null); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Impl(Pointer p) { super(p); }
    }
}
