// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_objdetect;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;

import static org.bytedeco.opencv.global.opencv_objdetect.*;


/**
\defgroup objdetect Object Detection
<p>
\{
    \defgroup objdetect_cascade_classifier Cascade Classifier for Object Detection
    <p>
    The object detector described below has been initially proposed by Paul Viola \cite Viola01 and
    improved by Rainer Lienhart \cite Lienhart02 .
    <p>
    First, a classifier (namely a *cascade of boosted classifiers working with haar-like features*) is
    trained with a few hundred sample views of a particular object (i.e., a face or a car), called
    positive examples, that are scaled to the same size (say, 20x20), and negative examples - arbitrary
    images of the same size.
    <p>
    After a classifier is trained, it can be applied to a region of interest (of the same size as used
    during the training) in an input image. The classifier outputs a "1" if the region is likely to show
    the object (i.e., face/car), and "0" otherwise. To search for the object in the whole image one can
    move the search window across the image and check every location using the classifier. The
    classifier is designed so that it can be easily "resized" in order to be able to find the objects of
    interest at different sizes, which is more efficient than resizing the image itself. So, to find an
    object of an unknown size in the image the scan procedure should be done several times at different
    scales.
    <p>
    The word "cascade" in the classifier name means that the resultant classifier consists of several
    simpler classifiers (*stages*) that are applied subsequently to a region of interest until at some
    stage the candidate is rejected or all the stages are passed. The word "boosted" means that the
    classifiers at every stage of the cascade are complex themselves and they are built out of basic
    classifiers using one of four different boosting techniques (weighted voting). Currently Discrete
    Adaboost, Real Adaboost, Gentle Adaboost and Logitboost are supported. The basic classifiers are
    decision-tree classifiers with at least 2 leaves. Haar-like features are the input to the basic
    classifiers, and are calculated as described below. The current algorithm uses the following
    Haar-like features:
    <p>
    ![image](pics/haarfeatures.png)
    <p>
    The feature used in a particular classifier is specified by its shape (1a, 2b etc.), position within
    the region of interest and the scale (this scale is not the same as the scale used at the detection
    stage, though these two scales are multiplied). For example, in the case of the third line feature
    (2c) the response is calculated as the difference between the sum of image pixels under the
    rectangle covering the whole feature (including the two white stripes and the black stripe in the
    middle) and the sum of the image pixels under the black stripe multiplied by 3 in order to
    compensate for the differences in the size of areas. The sums of pixel values over a rectangular
    regions are calculated rapidly using integral images (see below and the integral description).
    <p>
    Check \ref tutorial_cascade_classifier "the corresponding tutorial" for more details.
    <p>
    The following reference is for the detection part only. There is a separate application called
    opencv_traincascade that can train a cascade of boosted classifiers from a set of samples.
    <p>
    \note In the new C++ interface it is also possible to use LBP (local binary pattern) features in
    addition to Haar-like features. .. [Viola01] Paul Viola and Michael J. Jones. Rapid Object Detection
    using a Boosted Cascade of Simple Features. IEEE CVPR, 2001. The paper is available online at
    <https://github.com/SvHey/thesis/blob/master/Literature/ObjectDetection/violaJones_CVPR2001.pdf>
    <p>
    \defgroup objdetect_hog HOG (Histogram of Oriented Gradients) descriptor and object detector
    \defgroup objdetect_barcode Barcode detection and decoding
    \defgroup objdetect_qrcode QRCode detection and encoding
    \defgroup objdetect_dnn_face DNN-based face detection and recognition
    <p>
    Check \ref tutorial_dnn_face "the corresponding tutorial" for more details.
    <p>
    \defgroup objdetect_common Common functions and classes
    \defgroup objdetect_aruco ArUco markers and boards detection for robust camera pose estimation
    \{
        ArUco Marker Detection
        Square fiducial markers (also known as Augmented Reality Markers) are useful for easy,
        fast and robust camera pose estimation.
        <p>
        The main functionality of ArucoDetector class is detection of markers in an image. If the markers are grouped
        as a board, then you can try to recover the missing markers with ArucoDetector::refineDetectedMarkers().
        ArUco markers can also be used for advanced chessboard corner finding. To do this, group the markers in the
        CharucoBoard and find the corners of the chessboard with the CharucoDetector::detectBoard().
        <p>
        The implementation is based on the ArUco Library by R. Muñoz-Salinas and S. Garrido-Jurado \cite Aruco2014.
        <p>
        Markers can also be detected based on the AprilTag 2 \cite wang2016iros fiducial detection method.
        <p>
        @see \cite Aruco2014
        This code has been originally developed by Sergio Garrido-Jurado as a project
        for Google Summer of Code 2015 (GSoC 15).
    \}
<p>
\}
 */

@Opaque @Properties(inherit = org.bytedeco.opencv.presets.opencv_objdetect.class)
public class CvHaarClassifierCascade extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public CvHaarClassifierCascade() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CvHaarClassifierCascade(Pointer p) { super(p); }
}
