// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_objdetect;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;

import static org.bytedeco.opencv.global.opencv_objdetect.*;


/** \addtogroup objdetect_aruco
 *  \{
<p>
<p>
/** \brief Dictionary is a set of unique ArUco markers of the same size
 *
 * {@code bytesList} storing as 2-dimensions Mat with 4-th channels (CV_8UC4 type was used) and contains the marker codewords where:
 * - bytesList.rows is the dictionary size
 * - each marker is encoded using {@code nbytes = ceil(markerSize*markerSize/8.)} bytes
 * - each row contains all 4 rotations of the marker, so its length is {@code 4*nbytes}
 * - the byte order in the bytesList[i] row:
 * {@code //bytes without rotation/bytes with rotation 1/bytes with rotation 2/bytes with rotation 3//}
 * So {@code bytesList.ptr(i)[k*nbytes + j]} is the j-th byte of i-th marker, in its k-th rotation.
 * \note Python bindings generate matrix with shape of bytesList {@code dictionary_size x nbytes x 4},
 * but it should be indexed like C++ version. Python example for j-th byte of i-th marker, in its k-th rotation:
 * {@code aruco_dict.bytesList[id].ravel()[k*nbytes + j]}
 */
@Namespace("cv::aruco") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_objdetect.class)
public class Dictionary extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Dictionary(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Dictionary(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public Dictionary position(long position) {
        return (Dictionary)super.position(position);
    }
    @Override public Dictionary getPointer(long i) {
        return new Dictionary((Pointer)this).offsetAddress(i);
    }

    /** marker code information. See class description for more details */
    public native @ByRef Mat bytesList(); public native Dictionary bytesList(Mat setter);
    /** number of bits per dimension */
    public native int markerSize(); public native Dictionary markerSize(int setter);
    /** maximum number of bits that can be corrected */
    public native int maxCorrectionBits(); public native Dictionary maxCorrectionBits(int setter);

    public Dictionary() { super((Pointer)null); allocate(); }
    private native void allocate();

    /** \brief Basic ArUco dictionary constructor
     *
     * @param bytesList bits for all ArUco markers in dictionary see memory layout in the class description
     * @param _markerSize ArUco marker size in units
     * @param maxcorr maximum number of bits that can be corrected
     */
    public Dictionary(@Const @ByRef Mat bytesList, int _markerSize, int maxcorr/*=0*/) { super((Pointer)null); allocate(bytesList, _markerSize, maxcorr); }
    private native void allocate(@Const @ByRef Mat bytesList, int _markerSize, int maxcorr/*=0*/);
    public Dictionary(@Const @ByRef Mat bytesList, int _markerSize) { super((Pointer)null); allocate(bytesList, _markerSize); }
    private native void allocate(@Const @ByRef Mat bytesList, int _markerSize);

    /** \brief Read a new dictionary from FileNode.
     *
     * Dictionary example in YAML format:\n
     * nmarkers: 35\n
     * markersize: 6\n
     * maxCorrectionBits: 5\n
     * marker_0: "101011111011111001001001101100000000"\n
     * ...\n
     * marker_34: "011111010000111011111110110101100101"
     */
    public native @Cast("bool") boolean readDictionary(@Const @ByRef FileNode fn);

    /** \brief Write a dictionary to FileStorage, format is the same as in readDictionary().
     */
    public native void writeDictionary(@ByRef FileStorage fs, @Str BytePointer name/*=cv::String()*/);
    public native void writeDictionary(@ByRef FileStorage fs);
    public native void writeDictionary(@ByRef FileStorage fs, @Str String name/*=cv::String()*/);

    /** \brief Given a matrix of bits. Returns whether if marker is identified or not.
     *
     * Returns reference to the marker id in the dictionary (if any) and its rotation.
     */
    public native @Cast("bool") boolean identify(@Const @ByRef Mat onlyBits, @ByRef IntPointer idx, @ByRef IntPointer rotation, double maxCorrectionRate);
    public native @Cast("bool") boolean identify(@Const @ByRef Mat onlyBits, @ByRef IntBuffer idx, @ByRef IntBuffer rotation, double maxCorrectionRate);
    public native @Cast("bool") boolean identify(@Const @ByRef Mat onlyBits, @ByRef int[] idx, @ByRef int[] rotation, double maxCorrectionRate);

    /** \brief Returns Hamming distance of the input bits to the specific id.
     *
     * If {@code allRotations} flag is set, the four posible marker rotations are considered
     */
    public native int getDistanceToId(@ByVal Mat bits, int id, @Cast("bool") boolean allRotations/*=true*/);
    public native int getDistanceToId(@ByVal Mat bits, int id);
    public native int getDistanceToId(@ByVal UMat bits, int id, @Cast("bool") boolean allRotations/*=true*/);
    public native int getDistanceToId(@ByVal UMat bits, int id);
    public native int getDistanceToId(@ByVal GpuMat bits, int id, @Cast("bool") boolean allRotations/*=true*/);
    public native int getDistanceToId(@ByVal GpuMat bits, int id);


    /** \brief Generate a canonical marker image
     */
    public native void generateImageMarker(int id, int sidePixels, @ByVal Mat _img, int borderBits/*=1*/);
    public native void generateImageMarker(int id, int sidePixels, @ByVal Mat _img);
    public native void generateImageMarker(int id, int sidePixels, @ByVal UMat _img, int borderBits/*=1*/);
    public native void generateImageMarker(int id, int sidePixels, @ByVal UMat _img);
    public native void generateImageMarker(int id, int sidePixels, @ByVal GpuMat _img, int borderBits/*=1*/);
    public native void generateImageMarker(int id, int sidePixels, @ByVal GpuMat _img);


    /** \brief Transform matrix of bits to list of bytes with 4 marker rotations
      */
    public static native @ByVal Mat getByteListFromBits(@Const @ByRef Mat bits);


    /** \brief Transform list of bytes to matrix of bits
      */
    public static native @ByVal Mat getBitsFromByteList(@Const @ByRef Mat byteList, int markerSize);
}
