// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_objdetect;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;

import static org.bytedeco.opencv.global.opencv_objdetect.*;


/** \addtogroup objdetect_common
 *  \{ */

@Namespace("cv") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_objdetect.class)
public class GraphicalCodeDetector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public GraphicalCodeDetector(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public GraphicalCodeDetector(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public GraphicalCodeDetector position(long position) {
        return (GraphicalCodeDetector)super.position(position);
    }
    @Override public GraphicalCodeDetector getPointer(long i) {
        return new GraphicalCodeDetector((Pointer)this).offsetAddress(i);
    }

    @Deprecated public GraphicalCodeDetector() { super((Pointer)null); allocate(); }
    @Deprecated private native void allocate();

    public GraphicalCodeDetector(@Const @ByRef GraphicalCodeDetector arg0) { super((Pointer)null); allocate(arg0); }
    private native void allocate(@Const @ByRef GraphicalCodeDetector arg0);
    public native @ByRef @Name("operator =") GraphicalCodeDetector put(@Const @ByRef GraphicalCodeDetector arg0);

    /** \brief Detects graphical code in image and returns the quadrangle containing the code.
     @param img grayscale or color (BGR) image containing (or not) graphical code.
     @param points Output vector of vertices of the minimum-area quadrangle containing the code.
     */
    public native @Cast("bool") boolean detect(@ByVal Mat img, @ByVal Mat points);
    public native @Cast("bool") boolean detect(@ByVal UMat img, @ByVal UMat points);
    public native @Cast("bool") boolean detect(@ByVal GpuMat img, @ByVal GpuMat points);

    /** \brief Decodes graphical code in image once it's found by the detect() method.
     <p>
     Returns UTF8-encoded output string or empty string if the code cannot be decoded.
     @param img grayscale or color (BGR) image containing graphical code.
     @param points Quadrangle vertices found by detect() method (or some other algorithm).
     @param straight_code The optional output image containing binarized code, will be empty if not found.
     */
    public native @StdString BytePointer decode(@ByVal Mat img, @ByVal Mat points, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat straight_code);
    public native @StdString BytePointer decode(@ByVal Mat img, @ByVal Mat points);
    public native @StdString String decode(@ByVal UMat img, @ByVal UMat points, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat straight_code);
    public native @StdString String decode(@ByVal UMat img, @ByVal UMat points);
    public native @StdString BytePointer decode(@ByVal GpuMat img, @ByVal GpuMat points, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat straight_code);
    public native @StdString BytePointer decode(@ByVal GpuMat img, @ByVal GpuMat points);

    /** \brief Both detects and decodes graphical code
     <p>
     @param img grayscale or color (BGR) image containing graphical code.
     @param points optional output array of vertices of the found graphical code quadrangle, will be empty if not found.
     @param straight_code The optional output image containing binarized code
     */
    public native @StdString BytePointer detectAndDecode(@ByVal Mat img, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat points,
                                            @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat straight_code);
    public native @StdString BytePointer detectAndDecode(@ByVal Mat img);
    public native @StdString String detectAndDecode(@ByVal UMat img, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat points,
                                            @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat straight_code);
    public native @StdString String detectAndDecode(@ByVal UMat img);
    public native @StdString BytePointer detectAndDecode(@ByVal GpuMat img, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat points,
                                            @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat straight_code);
    public native @StdString BytePointer detectAndDecode(@ByVal GpuMat img);


    /** \brief Detects graphical codes in image and returns the vector of the quadrangles containing the codes.
     @param img grayscale or color (BGR) image containing (or not) graphical codes.
     @param points Output vector of vector of vertices of the minimum-area quadrangle containing the codes.
     */
    public native @Cast("bool") boolean detectMulti(@ByVal Mat img, @ByVal Mat points);
    public native @Cast("bool") boolean detectMulti(@ByVal UMat img, @ByVal UMat points);
    public native @Cast("bool") boolean detectMulti(@ByVal GpuMat img, @ByVal GpuMat points);

    /** \brief Decodes graphical codes in image once it's found by the detect() method.
     @param img grayscale or color (BGR) image containing graphical codes.
     @param decoded_info UTF8-encoded output vector of string or empty vector of string if the codes cannot be decoded.
     @param points vector of Quadrangle vertices found by detect() method (or some other algorithm).
     @param straight_code The optional output vector of images containing binarized codes
     */
    public native @Cast("bool") boolean decodeMulti(@ByVal Mat img, @ByVal Mat points, @ByRef StringVector decoded_info,
                                 @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector straight_code);
    public native @Cast("bool") boolean decodeMulti(@ByVal Mat img, @ByVal Mat points, @ByRef StringVector decoded_info);
    public native @Cast("bool") boolean decodeMulti(@ByVal Mat img, @ByVal Mat points, @ByRef StringVector decoded_info,
                                 @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector straight_code);
    public native @Cast("bool") boolean decodeMulti(@ByVal Mat img, @ByVal Mat points, @ByRef StringVector decoded_info,
                                 @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector straight_code);
    public native @Cast("bool") boolean decodeMulti(@ByVal UMat img, @ByVal UMat points, @ByRef StringVector decoded_info,
                                 @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector straight_code);
    public native @Cast("bool") boolean decodeMulti(@ByVal UMat img, @ByVal UMat points, @ByRef StringVector decoded_info);
    public native @Cast("bool") boolean decodeMulti(@ByVal UMat img, @ByVal UMat points, @ByRef StringVector decoded_info,
                                 @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector straight_code);
    public native @Cast("bool") boolean decodeMulti(@ByVal UMat img, @ByVal UMat points, @ByRef StringVector decoded_info,
                                 @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector straight_code);
    public native @Cast("bool") boolean decodeMulti(@ByVal GpuMat img, @ByVal GpuMat points, @ByRef StringVector decoded_info,
                                 @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector straight_code);
    public native @Cast("bool") boolean decodeMulti(@ByVal GpuMat img, @ByVal GpuMat points, @ByRef StringVector decoded_info);
    public native @Cast("bool") boolean decodeMulti(@ByVal GpuMat img, @ByVal GpuMat points, @ByRef StringVector decoded_info,
                                 @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector straight_code);
    public native @Cast("bool") boolean decodeMulti(@ByVal GpuMat img, @ByVal GpuMat points, @ByRef StringVector decoded_info,
                                 @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector straight_code);

    /** \brief Both detects and decodes graphical codes
    @param img grayscale or color (BGR) image containing graphical codes.
    @param decoded_info UTF8-encoded output vector of string or empty vector of string if the codes cannot be decoded.
    @param points optional output vector of vertices of the found graphical code quadrangles. Will be empty if not found.
    @param straight_code The optional vector of images containing binarized codes
    <p>
    - If there are QR codes encoded with a Structured Append mode on the image and all of them detected and decoded correctly,
    method writes a full message to position corresponds to 0-th code in a sequence. The rest of QR codes from the same sequence
    have empty string.
    */
    public native @Cast("bool") boolean detectAndDecodeMulti(@ByVal Mat img, @ByRef StringVector decoded_info, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat points,
                                          @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector straight_code);
    public native @Cast("bool") boolean detectAndDecodeMulti(@ByVal Mat img, @ByRef StringVector decoded_info);
    public native @Cast("bool") boolean detectAndDecodeMulti(@ByVal Mat img, @ByRef StringVector decoded_info, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat points,
                                          @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector straight_code);
    public native @Cast("bool") boolean detectAndDecodeMulti(@ByVal Mat img, @ByRef StringVector decoded_info, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat points,
                                          @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector straight_code);
    public native @Cast("bool") boolean detectAndDecodeMulti(@ByVal UMat img, @ByRef StringVector decoded_info, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat points,
                                          @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector straight_code);
    public native @Cast("bool") boolean detectAndDecodeMulti(@ByVal UMat img, @ByRef StringVector decoded_info);
    public native @Cast("bool") boolean detectAndDecodeMulti(@ByVal UMat img, @ByRef StringVector decoded_info, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat points,
                                          @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector straight_code);
    public native @Cast("bool") boolean detectAndDecodeMulti(@ByVal UMat img, @ByRef StringVector decoded_info, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat points,
                                          @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector straight_code);
    public native @Cast("bool") boolean detectAndDecodeMulti(@ByVal GpuMat img, @ByRef StringVector decoded_info, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat points,
                                          @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector straight_code);
    public native @Cast("bool") boolean detectAndDecodeMulti(@ByVal GpuMat img, @ByRef StringVector decoded_info);
    public native @Cast("bool") boolean detectAndDecodeMulti(@ByVal GpuMat img, @ByRef StringVector decoded_info, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat points,
                                          @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector straight_code);
    public native @Cast("bool") boolean detectAndDecodeMulti(@ByVal GpuMat img, @ByRef StringVector decoded_info, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat points,
                                          @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector straight_code);
    @Opaque public static class Impl extends Pointer {
        /** Empty constructor. Calls {@code super((Pointer)null)}. */
        public Impl() { super((Pointer)null); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Impl(Pointer p) { super(p); }
    }
}
