/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.imgcodecs;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.core.Scalar;
import org.opencv.utils.Converters;

public class Animation {
    protected final long nativeObj;

    protected Animation(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static Animation __fromPtr__(long addr) {
        return new Animation(addr);
    }

    public int get_loop_count() {
        return Animation.get_loop_count_0(this.nativeObj);
    }

    public void set_loop_count(int loop_count) {
        Animation.set_loop_count_0(this.nativeObj, loop_count);
    }

    public Scalar get_bgcolor() {
        return new Scalar(Animation.get_bgcolor_0(this.nativeObj));
    }

    public void set_bgcolor(Scalar bgcolor) {
        Animation.set_bgcolor_0(this.nativeObj, bgcolor.val[0], bgcolor.val[1], bgcolor.val[2], bgcolor.val[3]);
    }

    public MatOfInt get_durations() {
        return MatOfInt.fromNativeAddr(Animation.get_durations_0(this.nativeObj));
    }

    public void set_durations(MatOfInt durations) {
        MatOfInt durations_mat = durations;
        Animation.set_durations_0(this.nativeObj, durations_mat.nativeObj);
    }

    public List<Mat> get_frames() {
        ArrayList<Mat> retVal = new ArrayList<Mat>();
        Mat retValMat = new Mat(Animation.get_frames_0(this.nativeObj));
        Converters.Mat_to_vector_Mat(retValMat, retVal);
        return retVal;
    }

    public void set_frames(List<Mat> frames) {
        Mat frames_mat = Converters.vector_Mat_to_Mat(frames);
        Animation.set_frames_0(this.nativeObj, frames_mat.nativeObj);
    }

    protected void finalize() throws Throwable {
        Animation.delete(this.nativeObj);
    }

    private static native int get_loop_count_0(long var0);

    private static native void set_loop_count_0(long var0, int var2);

    private static native double[] get_bgcolor_0(long var0);

    private static native void set_bgcolor_0(long var0, double var2, double var4, double var6, double var8);

    private static native long get_durations_0(long var0);

    private static native void set_durations_0(long var0, long var2);

    private static native long get_frames_0(long var0);

    private static native void set_frames_0(long var0, long var2);

    private static native void delete(long var0);
}

