// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_cudafeatures2d;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_cudaarithm.*;
import static org.bytedeco.opencv.global.opencv_cudaarithm.*;
import org.bytedeco.opencv.opencv_cudafilters.*;
import static org.bytedeco.opencv.global.opencv_cudafilters.*;
import static org.bytedeco.opencv.global.opencv_cudawarping.*;

import static org.bytedeco.opencv.global.opencv_cudafeatures2d.*;


//
// Feature2DAsync
//

/** \brief Abstract base class for CUDA asynchronous 2D image feature detectors and descriptor extractors.
 */
@Namespace("cv::cuda") @Properties(inherit = org.bytedeco.opencv.presets.opencv_cudafeatures2d.class)
public class Feature2DAsync extends Feature2D {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Feature2DAsync(Pointer p) { super(p); }


    /** \brief Detects keypoints in an image.
    <p>
    @param image Image.
    @param keypoints The detected keypoints.
    @param mask Mask specifying where to look for keypoints (optional). It must be a 8-bit integer
    matrix with non-zero values in the region of interest.
    @param stream CUDA stream.
     */
    public native void detectAsync(@ByVal Mat image,
                                 @ByVal Mat keypoints,
                                 @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask,
                                 @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detectAsync(@ByVal Mat image,
                                 @ByVal Mat keypoints);
    public native void detectAsync(@ByVal UMat image,
                                 @ByVal UMat keypoints,
                                 @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask,
                                 @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detectAsync(@ByVal UMat image,
                                 @ByVal UMat keypoints);
    public native void detectAsync(@ByVal GpuMat image,
                                 @ByVal GpuMat keypoints,
                                 @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask,
                                 @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detectAsync(@ByVal GpuMat image,
                                 @ByVal GpuMat keypoints);

    /** \brief Computes the descriptors for a set of keypoints detected in an image.
    <p>
    @param image Image.
    @param keypoints Input collection of keypoints.
    @param descriptors Computed descriptors. Row j is the descriptor for j-th keypoint.
    @param stream CUDA stream.
     */
    public native void computeAsync(@ByVal Mat image,
                                  @ByVal Mat keypoints,
                                  @ByVal Mat descriptors,
                                  @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void computeAsync(@ByVal Mat image,
                                  @ByVal Mat keypoints,
                                  @ByVal Mat descriptors);
    public native void computeAsync(@ByVal UMat image,
                                  @ByVal UMat keypoints,
                                  @ByVal UMat descriptors,
                                  @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void computeAsync(@ByVal UMat image,
                                  @ByVal UMat keypoints,
                                  @ByVal UMat descriptors);
    public native void computeAsync(@ByVal GpuMat image,
                                  @ByVal GpuMat keypoints,
                                  @ByVal GpuMat descriptors,
                                  @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void computeAsync(@ByVal GpuMat image,
                                  @ByVal GpuMat keypoints,
                                  @ByVal GpuMat descriptors);

    /** Detects keypoints and computes the descriptors. */
    public native void detectAndComputeAsync(@ByVal Mat image,
                                           @ByVal Mat mask,
                                           @ByVal Mat keypoints,
                                           @ByVal Mat descriptors,
                                           @Cast("bool") boolean useProvidedKeypoints/*=false*/,
                                           @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detectAndComputeAsync(@ByVal Mat image,
                                           @ByVal Mat mask,
                                           @ByVal Mat keypoints,
                                           @ByVal Mat descriptors);
    public native void detectAndComputeAsync(@ByVal UMat image,
                                           @ByVal UMat mask,
                                           @ByVal UMat keypoints,
                                           @ByVal UMat descriptors,
                                           @Cast("bool") boolean useProvidedKeypoints/*=false*/,
                                           @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detectAndComputeAsync(@ByVal UMat image,
                                           @ByVal UMat mask,
                                           @ByVal UMat keypoints,
                                           @ByVal UMat descriptors);
    public native void detectAndComputeAsync(@ByVal GpuMat image,
                                           @ByVal GpuMat mask,
                                           @ByVal GpuMat keypoints,
                                           @ByVal GpuMat descriptors,
                                           @Cast("bool") boolean useProvidedKeypoints/*=false*/,
                                           @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
    public native void detectAndComputeAsync(@ByVal GpuMat image,
                                           @ByVal GpuMat mask,
                                           @ByVal GpuMat keypoints,
                                           @ByVal GpuMat descriptors);

    /** Converts keypoints array from internal representation to standard vector. */
    public native void convert(@ByVal Mat gpu_keypoints,
                             @ByRef KeyPointVector keypoints);
    public native void convert(@ByVal UMat gpu_keypoints,
                             @ByRef KeyPointVector keypoints);
    public native void convert(@ByVal GpuMat gpu_keypoints,
                             @ByRef KeyPointVector keypoints);
}
