// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_tracking;

import org.bytedeco.javacpp.annotation.Index;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import org.bytedeco.opencv.opencv_plot.*;
import static org.bytedeco.opencv.global.opencv_plot.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_video.*;
import static org.bytedeco.opencv.global.opencv_video.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;

import static org.bytedeco.opencv.global.opencv_tracking.*;


/** \brief Class that manages the extraction and selection of features
<p>
\cite AAM Feature Extraction and Feature Set Refinement (Feature Processing and Feature Selection).
See table I and section III C \cite AMVOT Appearance modelling -\> Visual representation (Table II,
section 3.1 - 3.2)
<p>
TrackerFeatureSet is an aggregation of TrackerFeature
<p>
@see
   TrackerFeature
 <p>
 */
@Namespace("cv") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_tracking.class)
public class TrackerFeatureSet extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TrackerFeatureSet(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public TrackerFeatureSet(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public TrackerFeatureSet position(long position) {
        return (TrackerFeatureSet)super.position(position);
    }
    @Override public TrackerFeatureSet getPointer(long i) {
        return new TrackerFeatureSet(this).position(position + i);
    }


  public TrackerFeatureSet() { super((Pointer)null); allocate(); }
  private native void allocate();

  /** \brief Extract features from the images collection
    @param images The input images
     */
  public native void extraction( @Const @ByRef MatVector images );

  /** \brief Identify most effective features for all feature types (optional)
     */
  public native void selection();

  /** \brief Remove outliers for all feature types (optional)
     */
  public native void removeOutliers();

  /** \brief Add TrackerFeature in the collection. Return true if TrackerFeature is added, false otherwise
    @param trackerFeatureType The TrackerFeature name
    <p>
    The modes available now:
    <p>
    -   "HAAR" -- Haar Feature-based
    <p>
    The modes that will be available soon:
    <p>
    -   "HOG" -- Histogram of Oriented Gradients features
    -   "LBP" -- Local Binary Pattern features
    -   "FEATURE2D" -- All types of Feature2D
    <p>
    Example TrackerFeatureSet::addTrackerFeature : :
    <pre>{@code
        //sample usage:

        Ptr<TrackerFeature> trackerFeature = new TrackerFeatureHAAR( HAARparameters );
        featureSet->addTrackerFeature( trackerFeature );

        //or add CSC sampler with default parameters
        //featureSet->addTrackerFeature( "HAAR" );
    }</pre>
    \note If you use the second method, you must initialize the TrackerFeature
     */
  public native @Cast("bool") boolean addTrackerFeature( @Str BytePointer trackerFeatureType );
  public native @Cast("bool") boolean addTrackerFeature( @Str String trackerFeatureType );

  /** \overload
    @param feature The TrackerFeature class
    */
  public native @Cast("bool") boolean addTrackerFeature( @Ptr @ByVal TrackerFeature feature );

  /** \brief Get the TrackerFeature collection (TrackerFeature name, TrackerFeature pointer)
     */
  public native @Const @ByRef StringTrackerFeaturePairVector getTrackerFeature();

  /** \brief Get the responses
    <p>
    \note Be sure to call extraction before getResponses Example TrackerFeatureSet::getResponses : :
     */
  public native @Const @ByRef MatVector getResponses();

}
