// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.global;

import org.bytedeco.opencv.opencv_text.*;

import org.bytedeco.javacpp.annotation.Index;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_ml.*;
import static org.bytedeco.opencv.global.opencv_ml.*;

public class opencv_text extends org.bytedeco.opencv.presets.opencv_text {
    static { Loader.load(); }

// Targeting ..\opencv_text\IntDeque.java


// Targeting ..\opencv_text\ERStatVector.java


// Targeting ..\opencv_text\ERStatVectorVector.java


// Targeting ..\opencv_text\IntVector.java


// Targeting ..\opencv_text\FloatVector.java


// Targeting ..\opencv_text\DoubleVector.java


// Parsed from <opencv2/text.hpp>

/*
By downloading, copying, installing or using the software you agree to this
license. If you do not agree to this license, do not download, install,
copy or use the software.

                          License Agreement
               For Open Source Computer Vision Library
                       (3-clause BSD License)

Copyright (C) 2013, OpenCV Foundation, all rights reserved.
Third party copyrights are property of their respective owners.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

  * Neither the names of the copyright holders nor the names of the contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

This software is provided by the copyright holders and contributors "as is" and
any express or implied warranties, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose are
disclaimed. In no event shall copyright holders or contributors be liable for
any direct, indirect, incidental, special, exemplary, or consequential damages
(including, but not limited to, procurement of substitute goods or services;
loss of use, data, or profits; or business interruption) however caused
and on any theory of liability, whether in contract, strict liability,
or tort (including negligence or otherwise) arising in any way out of
the use of this software, even if advised of the possibility of such damage.
*/

// #ifndef __OPENCV_TEXT_HPP__
// #define __OPENCV_TEXT_HPP__

// #include "opencv2/text/erfilter.hpp"
// #include "opencv2/text/ocr.hpp"
// #include "opencv2/text/textDetector.hpp"
// #include "opencv2/text/swt_text_detection.hpp"

/** \defgroup text Scene Text Detection and Recognition
<p>
The opencv_text module provides different algorithms for text detection and recognition in natural
scene images.
  <p>
  \{
    \defgroup text_detect Scene Text Detection
<p>
Class-specific Extremal Regions for Scene Text Detection
--------------------------------------------------------
<p>
The scene text detection algorithm described below has been initially proposed by Lukás Neumann &
Jiri Matas \cite Neumann11. The main idea behind Class-specific Extremal Regions is similar to the MSER
in that suitable Extremal Regions (ERs) are selected from the whole component tree of the image.
However, this technique differs from MSER in that selection of suitable ERs is done by a sequential
classifier trained for character detection, i.e. dropping the stability requirement of MSERs and
selecting class-specific (not necessarily stable) regions.
<p>
The component tree of an image is constructed by thresholding by an increasing value step-by-step
from 0 to 255 and then linking the obtained connected components from successive levels in a
hierarchy by their inclusion relation:
<p>
![image](pics/component_tree.png)
<p>
The component tree may contain a huge number of regions even for a very simple image as shown in
the previous image. This number can easily reach the order of 1 x 10\^6 regions for an average 1
Megapixel image. In order to efficiently select suitable regions among all the ERs the algorithm
make use of a sequential classifier with two differentiated stages.
<p>
In the first stage incrementally computable descriptors (area, perimeter, bounding box, and Euler's
number) are computed (in O(1)) for each region r and used as features for a classifier which
estimates the class-conditional probability p(r|character). Only the ERs which correspond to local
maximum of the probability p(r|character) are selected (if their probability is above a global limit
p_min and the difference between local maximum and local minimum is greater than a delta_min
value).
<p>
In the second stage, the ERs that passed the first stage are classified into character and
non-character classes using more informative but also more computationally expensive features. (Hole
area ratio, convex hull ratio, and the number of outer boundary inflexion points).
<p>
This ER filtering process is done in different single-channel projections of the input image in
order to increase the character localization recall.
<p>
After the ER filtering is done on each input channel, character candidates must be grouped in
high-level text blocks (i.e. words, text lines, paragraphs, ...). The opencv_text module implements
two different grouping algorithms: the Exhaustive Search algorithm proposed in \cite Neumann12 for
grouping horizontally aligned text, and the method proposed by Lluis Gomez and Dimosthenis Karatzas
in \cite Gomez13 \cite Gomez14 for grouping arbitrary oriented text (see erGrouping).
<p>
To see the text detector at work, have a look at the textdetection demo:
<https://github.com/opencv/opencv_contrib/blob/master/modules/text/samples/textdetection.cpp>
    <p>
    \defgroup text_recognize Scene Text Recognition
  \}
*/

// #endif


// Parsed from <opencv2/text/erfilter.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_TEXT_ERFILTER_HPP__
// #define __OPENCV_TEXT_ERFILTER_HPP__

// #include "opencv2/core.hpp"
// #include <vector>
// #include <deque>
// #include <string>
// Targeting ..\opencv_text\ERStat.java


// Targeting ..\opencv_text\ERFilter.java





/** \brief Create an Extremal Region Filter for the 1st stage classifier of N&M algorithm \cite Neumann12.
<p>
@param  cb :   Callback with the classifier. Default classifier can be implicitly load with function
loadClassifierNM1, e.g. from file in samples/cpp/trained_classifierNM1.xml
@param  thresholdDelta :   Threshold step in subsequent thresholds when extracting the component tree
@param  minArea :   The minimum area (% of image size) allowed for retreived ER's
@param  maxArea :   The maximum area (% of image size) allowed for retreived ER's
@param  minProbability :   The minimum probability P(er|character) allowed for retreived ER's
@param  nonMaxSuppression :   Whenever non-maximum suppression is done over the branch probabilities
@param  minProbabilityDiff :   The minimum probability difference between local maxima and local minima ERs
<p>
The component tree of the image is extracted by a threshold increased step by step from 0 to 255,
incrementally computable descriptors (aspect_ratio, compactness, number of holes, and number of
horizontal crossings) are computed for each ER and used as features for a classifier which estimates
the class-conditional probability P(er|character). The value of P(er|character) is tracked using the
inclusion relation of ER across all thresholds and only the ERs which correspond to local maximum of
the probability P(er|character) are selected (if the local maximum of the probability is above a
global limit pmin and the difference between local maximum and local minimum is greater than
minProbabilityDiff).
 */
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM1(@Ptr ERFilter.Callback cb,
                                                  int thresholdDelta/*=1*/, float minArea/*=(float)0.00025*/,
                                                  float maxArea/*=(float)0.13*/, float minProbability/*=(float)0.4*/,
                                                  @Cast("bool") boolean nonMaxSuppression/*=true*/,
                                                  float minProbabilityDiff/*=(float)0.1*/);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM1(@Ptr ERFilter.Callback cb);

/** \brief Create an Extremal Region Filter for the 2nd stage classifier of N&M algorithm \cite Neumann12.
<p>
@param  cb :   Callback with the classifier. Default classifier can be implicitly load with function
loadClassifierNM2, e.g. from file in samples/cpp/trained_classifierNM2.xml
@param  minProbability :   The minimum probability P(er|character) allowed for retreived ER's
<p>
In the second stage, the ERs that passed the first stage are classified into character and
non-character classes using more informative but also more computationally expensive features. The
classifier uses all the features calculated in the first stage and the following additional
features: hole area ratio, convex hull ratio, and number of outer inflexion points.
 */
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM2(@Ptr ERFilter.Callback cb,
                                                  float minProbability/*=(float)0.3*/);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM2(@Ptr ERFilter.Callback cb);

/** \brief Reads an Extremal Region Filter for the 1st stage classifier of N&M algorithm
    from the provided path e.g. /path/to/cpp/trained_classifierNM1.xml
<p>
\overload
 */
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM1(@Str BytePointer filename,
                                                  int thresholdDelta/*=1*/, float minArea/*=(float)0.00025*/,
                                                  float maxArea/*=(float)0.13*/, float minProbability/*=(float)0.4*/,
                                                  @Cast("bool") boolean nonMaxSuppression/*=true*/,
                                                  float minProbabilityDiff/*=(float)0.1*/);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM1(@Str BytePointer filename);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM1(@Str String filename,
                                                  int thresholdDelta/*=1*/, float minArea/*=(float)0.00025*/,
                                                  float maxArea/*=(float)0.13*/, float minProbability/*=(float)0.4*/,
                                                  @Cast("bool") boolean nonMaxSuppression/*=true*/,
                                                  float minProbabilityDiff/*=(float)0.1*/);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM1(@Str String filename);

/** \brief Reads an Extremal Region Filter for the 2nd stage classifier of N&M algorithm
    from the provided path e.g. /path/to/cpp/trained_classifierNM2.xml
<p>
\overload
 */
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM2(@Str BytePointer filename,
                                                  float minProbability/*=(float)0.3*/);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM2(@Str BytePointer filename);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM2(@Str String filename,
                                                  float minProbability/*=(float)0.3*/);
@Namespace("cv::text") public static native @Ptr ERFilter createERFilterNM2(@Str String filename);

/** \brief Allow to implicitly load the default classifier when creating an ERFilter object.
<p>
@param filename The XML or YAML file with the classifier model (e.g. trained_classifierNM1.xml)
<p>
returns a pointer to ERFilter::Callback.
 */
@Namespace("cv::text") public static native @Ptr ERFilter.Callback loadClassifierNM1(@Str BytePointer filename);
@Namespace("cv::text") public static native @Ptr ERFilter.Callback loadClassifierNM1(@Str String filename);

/** \brief Allow to implicitly load the default classifier when creating an ERFilter object.
<p>
@param filename The XML or YAML file with the classifier model (e.g. trained_classifierNM2.xml)
<p>
returns a pointer to ERFilter::Callback.
 */
@Namespace("cv::text") public static native @Ptr ERFilter.Callback loadClassifierNM2(@Str BytePointer filename);
@Namespace("cv::text") public static native @Ptr ERFilter.Callback loadClassifierNM2(@Str String filename);


/** computeNMChannels operation modes */
/** enum cv::text:: */
public static final int ERFILTER_NM_RGBLGrad = 0,
       ERFILTER_NM_IHSGrad = 1;

/** \brief Compute the different channels to be processed independently in the N&M algorithm \cite Neumann12.
<p>
@param _src Source image. Must be RGB CV_8UC3.
<p>
@param _channels Output vector\<Mat\> where computed channels are stored.
<p>
@param _mode Mode of operation. Currently the only available options are:
**ERFILTER_NM_RGBLGrad** (used by default) and **ERFILTER_NM_IHSGrad**.
<p>
In N&M algorithm, the combination of intensity (I), hue (H), saturation (S), and gradient magnitude
channels (Grad) are used in order to obtain high localization recall. This implementation also
provides an alternative combination of red (R), green (G), blue (B), lightness (L), and gradient
magnitude (Grad).
 */
@Namespace("cv::text") public static native void computeNMChannels(@ByVal Mat _src, @ByVal MatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal Mat _src, @ByVal MatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal Mat _src, @ByVal UMatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal Mat _src, @ByVal UMatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal Mat _src, @ByVal GpuMatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal Mat _src, @ByVal GpuMatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal UMat _src, @ByVal MatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal UMat _src, @ByVal MatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal UMat _src, @ByVal UMatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal UMat _src, @ByVal UMatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal UMat _src, @ByVal GpuMatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal UMat _src, @ByVal GpuMatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal GpuMat _src, @ByVal MatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal GpuMat _src, @ByVal MatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal GpuMat _src, @ByVal UMatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal GpuMat _src, @ByVal UMatVector _channels);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal GpuMat _src, @ByVal GpuMatVector _channels, int _mode/*=cv::text::ERFILTER_NM_RGBLGrad*/);
@Namespace("cv::text") public static native void computeNMChannels(@ByVal GpuMat _src, @ByVal GpuMatVector _channels);



/** text::erGrouping operation modes */
/** enum cv::text::erGrouping_Modes */
public static final int

    /** Exhaustive Search algorithm proposed in \cite Neumann11 for grouping horizontally aligned text.
    The algorithm models a verification function for all the possible ER sequences. The
    verification fuction for ER pairs consists in a set of threshold-based pairwise rules which
    compare measurements of two regions (height ratio, centroid angle, and region distance). The
    verification function for ER triplets creates a word text line estimate using Least
    Median-Squares fitting for a given triplet and then verifies that the estimate is valid (based
    on thresholds created during training). Verification functions for sequences larger than 3 are
    approximated by verifying that the text line parameters of all (sub)sequences of length 3 are
    consistent.
    */
    ERGROUPING_ORIENTATION_HORIZ = 0,
    /** Text grouping method proposed in \cite Gomez13 \cite Gomez14 for grouping arbitrary oriented text. Regions
    are agglomerated by Single Linkage Clustering in a weighted feature space that combines proximity
    (x,y coordinates) and similarity measures (color, size, gradient magnitude, stroke width, etc.).
    SLC provides a dendrogram where each node represents a text group hypothesis. Then the algorithm
    finds the branches corresponding to text groups by traversing this dendrogram with a stopping rule
    that combines the output of a rotation invariant text group classifier and a probabilistic measure
    for hierarchical clustering validity assessment.
    <p>
    \note This mode is not supported due NFA code removal ( https://github.com/opencv/opencv_contrib/issues/2235 )
     */
    ERGROUPING_ORIENTATION_ANY = 1;

/** \brief Find groups of Extremal Regions that are organized as text blocks.
<p>
@param img Original RGB or Greyscale image from wich the regions were extracted.
<p>
@param channels Vector of single channel images CV_8UC1 from wich the regions were extracted.
<p>
@param regions Vector of ER's retrieved from the ERFilter algorithm from each channel.
<p>
@param groups The output of the algorithm is stored in this parameter as set of lists of indexes to
provided regions.
<p>
@param groups_rects The output of the algorithm are stored in this parameter as list of rectangles.
<p>
@param method Grouping method (see text::erGrouping_Modes). Can be one of ERGROUPING_ORIENTATION_HORIZ,
ERGROUPING_ORIENTATION_ANY.
<p>
@param filename The XML or YAML file with the classifier model (e.g.
samples/trained_classifier_erGrouping.xml). Only to use when grouping method is
ERGROUPING_ORIENTATION_ANY.
<p>
@param minProbablity The minimum probability for accepting a group. Only to use when grouping
method is ERGROUPING_ORIENTATION_ANY.
 */
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal MatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal UMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString BytePointer filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat img, @ByVal GpuMatVector channels,
                                           @ByRef ERStatVectorVector regions,
                                           @Cast("std::vector<std::vector<cv::Vec2i> >*") @ByRef PointVectorVector groups,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @StdString String filename/*=std::string()*/,
                                           float minProbablity/*=0.5*/);

@Namespace("cv::text") public static native void erGrouping(@ByVal Mat image, @ByVal Mat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str BytePointer filename/*=cv::String()*/,
                                           float minProbablity/*=(float)0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat image, @ByVal Mat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal Mat image, @ByVal Mat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str String filename/*=cv::String()*/,
                                           float minProbablity/*=(float)0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat image, @ByVal UMat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str String filename/*=cv::String()*/,
                                           float minProbablity/*=(float)0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat image, @ByVal UMat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal UMat image, @ByVal UMat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str BytePointer filename/*=cv::String()*/,
                                           float minProbablity/*=(float)0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat image, @ByVal GpuMat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str BytePointer filename/*=cv::String()*/,
                                           float minProbablity/*=(float)0.5*/);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat image, @ByVal GpuMat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void erGrouping(@ByVal GpuMat image, @ByVal GpuMat channel,
                                           @ByVal PointVectorVector regions,
                                           @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str String filename/*=cv::String()*/,
                                           float minProbablity/*=(float)0.5*/);

/** \brief Converts MSER contours (vector\<Point\>) to ERStat regions.
<p>
@param image Source image CV_8UC1 from which the MSERs where extracted.
<p>
@param contours Input vector with all the contours (vector\<Point\>).
<p>
@param regions Output where the ERStat regions are stored.
<p>
It takes as input the contours provided by the OpenCV MSER feature detector and returns as output
two vectors of ERStats. This is because MSER() output contains both MSER+ and MSER- regions in a
single vector\<Point\>, the function separates them in two different vectors (this is as if the
ERStats where extracted from two different channels).
<p>
An example of MSERsToERStats in use can be found in the text detection webcam_demo:
<https://github.com/opencv/opencv_contrib/blob/master/modules/text/samples/webcam_demo.cpp>
 */
@Namespace("cv::text") public static native void MSERsToERStats(@ByVal Mat image, @ByRef PointVectorVector contours,
                               @ByRef ERStatVectorVector regions);
@Namespace("cv::text") public static native void MSERsToERStats(@ByVal UMat image, @ByRef PointVectorVector contours,
                               @ByRef ERStatVectorVector regions);
@Namespace("cv::text") public static native void MSERsToERStats(@ByVal GpuMat image, @ByRef PointVectorVector contours,
                               @ByRef ERStatVectorVector regions);

// Utility funtion for scripting
@Namespace("cv::text") public static native void detectRegions(@ByVal Mat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef PointVectorVector regions);
@Namespace("cv::text") public static native void detectRegions(@ByVal UMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef PointVectorVector regions);
@Namespace("cv::text") public static native void detectRegions(@ByVal GpuMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef PointVectorVector regions);


/** \brief Extracts text regions from image.
<p>
@param image Source image where text blocks needs to be extracted from.  Should be CV_8UC3 (color).
@param er_filter1 Extremal Region Filter for the 1st stage classifier of N&M algorithm \cite Neumann12
@param er_filter2 Extremal Region Filter for the 2nd stage classifier of N&M algorithm \cite Neumann12
@param groups_rects Output list of rectangle blocks with text
@param method Grouping method (see text::erGrouping_Modes). Can be one of ERGROUPING_ORIENTATION_HORIZ, ERGROUPING_ORIENTATION_ANY.
@param filename The XML or YAML file with the classifier model (e.g. samples/trained_classifier_erGrouping.xml). Only to use when grouping method is ERGROUPING_ORIENTATION_ANY.
@param minProbability The minimum probability for accepting a group. Only to use when grouping method is ERGROUPING_ORIENTATION_ANY.
 <p>
 <p>
 */
@Namespace("cv::text") public static native void detectRegions(@ByVal Mat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str BytePointer filename/*=cv::String()*/,
                                           float minProbability/*=(float)0.5*/);
@Namespace("cv::text") public static native void detectRegions(@ByVal Mat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void detectRegions(@ByVal Mat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str String filename/*=cv::String()*/,
                                           float minProbability/*=(float)0.5*/);
@Namespace("cv::text") public static native void detectRegions(@ByVal UMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str String filename/*=cv::String()*/,
                                           float minProbability/*=(float)0.5*/);
@Namespace("cv::text") public static native void detectRegions(@ByVal UMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void detectRegions(@ByVal UMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str BytePointer filename/*=cv::String()*/,
                                           float minProbability/*=(float)0.5*/);
@Namespace("cv::text") public static native void detectRegions(@ByVal GpuMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str BytePointer filename/*=cv::String()*/,
                                           float minProbability/*=(float)0.5*/);
@Namespace("cv::text") public static native void detectRegions(@ByVal GpuMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects);
@Namespace("cv::text") public static native void detectRegions(@ByVal GpuMat image, @Ptr ERFilter er_filter1, @Ptr ERFilter er_filter2, @ByRef RectVector groups_rects,
                                           int method/*=cv::text::ERGROUPING_ORIENTATION_HORIZ*/,
                                           @Str String filename/*=cv::String()*/,
                                           float minProbability/*=(float)0.5*/);

/** \} */



// #endif // _OPENCV_TEXT_ERFILTER_HPP_


// Parsed from <opencv2/text/ocr.hpp>

/*M//////////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_TEXT_OCR_HPP__
// #define __OPENCV_TEXT_OCR_HPP__

// #include <opencv2/core.hpp>

// #include <vector>
// #include <string>

/** \addtogroup text_recognize
 *  \{ */

/** enum cv::text:: */
public static final int
    OCR_LEVEL_WORD = 0,
    OCR_LEVEL_TEXTLINE = 1;

/** Tesseract.PageSegMode Enumeration */
/** enum cv::text::page_seg_mode */
public static final int
    PSM_OSD_ONLY = 0,
    PSM_AUTO_OSD = 1,
    PSM_AUTO_ONLY = 2,
    PSM_AUTO = 3,
    PSM_SINGLE_COLUMN = 4,
    PSM_SINGLE_BLOCK_VERT_TEXT = 5,
    PSM_SINGLE_BLOCK = 6,
    PSM_SINGLE_LINE = 7,
    PSM_SINGLE_WORD = 8,
    PSM_CIRCLE_WORD = 9,
    PSM_SINGLE_CHAR = 10;

/** Tesseract.OcrEngineMode Enumeration */
/** enum cv::text::ocr_engine_mode */
public static final int
    OEM_TESSERACT_ONLY = 0,
    OEM_CUBE_ONLY = 1,
    OEM_TESSERACT_CUBE_COMBINED = 2,
    OEM_DEFAULT = 3;
// Targeting ..\opencv_text\BaseOCR.java


// Targeting ..\opencv_text\OCRTesseract.java




/* OCR HMM Decoder */

/** enum cv::text::decoder_mode */
public static final int
    OCR_DECODER_VITERBI = 0; // Other algorithms may be added

/* OCR classifier type*/
/** enum cv::text::classifier_type */
public static final int
    OCR_KNN_CLASSIFIER = 0,
    OCR_CNN_CLASSIFIER = 1;
// Targeting ..\opencv_text\OCRHMMDecoder.java



/** \brief Allow to implicitly load the default character classifier when creating an OCRHMMDecoder object.
<p>
@param filename The XML or YAML file with the classifier model (e.g. OCRHMM_knn_model_data.xml)
<p>
The KNN default classifier is based in the scene text recognition method proposed by Lukás Neumann &
Jiri Matas in [Neumann11b]. Basically, the region (contour) in the input image is normalized to a
fixed size, while retaining the centroid and aspect ratio, in order to extract a feature vector
based on gradient orientations along the chain-code of its perimeter. Then, the region is classified
using a KNN model trained with synthetic data of rendered characters with different standard font
types.
<p>
@deprecated loadOCRHMMClassifier instead
 */

@Namespace("cv::text") public static native @Ptr OCRHMMDecoder.ClassifierCallback loadOCRHMMClassifierNM(@Str BytePointer filename);
@Namespace("cv::text") public static native @Ptr OCRHMMDecoder.ClassifierCallback loadOCRHMMClassifierNM(@Str String filename);

/** \brief Allow to implicitly load the default character classifier when creating an OCRHMMDecoder object.
<p>
@param filename The XML or YAML file with the classifier model (e.g. OCRBeamSearch_CNN_model_data.xml.gz)
<p>
The CNN default classifier is based in the scene text recognition method proposed by Adam Coates &
Andrew NG in [Coates11a]. The character classifier consists in a Single Layer Convolutional Neural Network and
a linear classifier. It is applied to the input image in a sliding window fashion, providing a set of recognitions
at each window location.
<p>
@deprecated use loadOCRHMMClassifier instead
 */
@Namespace("cv::text") public static native @Ptr OCRHMMDecoder.ClassifierCallback loadOCRHMMClassifierCNN(@Str BytePointer filename);
@Namespace("cv::text") public static native @Ptr OCRHMMDecoder.ClassifierCallback loadOCRHMMClassifierCNN(@Str String filename);

/** \brief Allow to implicitly load the default character classifier when creating an OCRHMMDecoder object.
 <p>
 @param filename The XML or YAML file with the classifier model (e.g. OCRBeamSearch_CNN_model_data.xml.gz)
 <p>
 @param classifier Can be one of classifier_type enum values.
 <p>
 */
@Namespace("cv::text") public static native @Ptr OCRHMMDecoder.ClassifierCallback loadOCRHMMClassifier(@Str BytePointer filename, int classifier);
@Namespace("cv::text") public static native @Ptr OCRHMMDecoder.ClassifierCallback loadOCRHMMClassifier(@Str String filename, int classifier);
/** \}
<p>
/** \brief Utility function to create a tailored language model transitions table from a given list of words (lexicon).
 *
 * @param vocabulary The language vocabulary (chars when ASCII English text).
 *
 * @param lexicon The list of words that are expected to be found in a particular image.
 *
 * @param transition_probabilities_table Output table with transition probabilities between character pairs. cols == rows == vocabulary.size().
 *
 * The function calculate frequency statistics of character pairs from the given lexicon and fills the output transition_probabilities_table with them. The transition_probabilities_table can be used as input in the OCRHMMDecoder::create() and OCRBeamSearchDecoder::create() methods.
 * \note
 *    -   (C++) An alternative would be to load the default generic language transition table provided in the text module samples folder (created from ispell 42869 english words list) :
 *            <https://github.com/opencv/opencv_contrib/blob/master/modules/text/samples/OCRHMM_transitions_table.xml>
 **/
@Namespace("cv::text") public static native void createOCRHMMTransitionsTable(@StdString @ByRef BytePointer vocabulary, @ByRef StringVector lexicon, @ByVal Mat transition_probabilities_table);
@Namespace("cv::text") public static native void createOCRHMMTransitionsTable(@StdString @ByRef BytePointer vocabulary, @ByRef StringVector lexicon, @ByVal UMat transition_probabilities_table);
@Namespace("cv::text") public static native void createOCRHMMTransitionsTable(@StdString @ByRef BytePointer vocabulary, @ByRef StringVector lexicon, @ByVal GpuMat transition_probabilities_table);

@Namespace("cv::text") public static native @ByVal Mat createOCRHMMTransitionsTable(@Str BytePointer vocabulary, @ByRef StringVector lexicon);
@Namespace("cv::text") public static native @ByVal Mat createOCRHMMTransitionsTable(@Str String vocabulary, @ByRef StringVector lexicon);
// Targeting ..\opencv_text\OCRBeamSearchDecoder.java



/** \brief Allow to implicitly load the default character classifier when creating an OCRBeamSearchDecoder object.
<p>
@param filename The XML or YAML file with the classifier model (e.g. OCRBeamSearch_CNN_model_data.xml.gz)
<p>
The CNN default classifier is based in the scene text recognition method proposed by Adam Coates &
Andrew NG in [Coates11a]. The character classifier consists in a Single Layer Convolutional Neural Network and
a linear classifier. It is applied to the input image in a sliding window fashion, providing a set of recognitions
at each window location.
 */

@Namespace("cv::text") public static native @Ptr OCRBeamSearchDecoder.ClassifierCallback loadOCRBeamSearchClassifierCNN(@Str BytePointer filename);
@Namespace("cv::text") public static native @Ptr OCRBeamSearchDecoder.ClassifierCallback loadOCRBeamSearchClassifierCNN(@Str String filename);
// Targeting ..\opencv_text\OCRHolisticWordRecognizer.java



/** \} */

 // cv::text::


// #endif // _OPENCV_TEXT_OCR_HPP_


// Parsed from opencv2/text/textDetector.hpp

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

// #ifndef __OPENCV_TEXT_TEXTDETECTOR_HPP__
// #define __OPENCV_TEXT_TEXTDETECTOR_HPP__

// #include "ocr.hpp"
// Targeting ..\opencv_text\TextDetector.java


// Targeting ..\opencv_text\TextDetectorCNN.java



/** \} */
//namespace text
//namespace cv


// #endif // _OPENCV_TEXT_OCR_HPP_


}
