// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.global;

import org.bytedeco.opencv.opencv_ximgproc.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;
import org.bytedeco.opencv.opencv_video.*;
import static org.bytedeco.opencv.global.opencv_video.*;

public class opencv_ximgproc extends org.bytedeco.opencv.presets.opencv_ximgproc {
    static { Loader.load(); }

// Parsed from <opencv2/ximgproc.hpp>

/*
 *  By downloading, copying, installing or using the software you agree to this license.
 *  If you do not agree to this license, do not download, install,
 *  copy or use the software.
 *
 *
 *  License Agreement
 *  For Open Source Computer Vision Library
 *  (3 - clause BSD License)
 *
 *  Redistribution and use in source and binary forms, with or without modification,
 *  are permitted provided that the following conditions are met :
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and / or other materials provided with the distribution.
 *
 *  * Neither the names of the copyright holders nor the names of the contributors
 *  may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  This software is provided by the copyright holders and contributors "as is" and
 *  any express or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose are disclaimed.
 *  In no event shall copyright holders or contributors be liable for any direct,
 *  indirect, incidental, special, exemplary, or consequential damages
 *  (including, but not limited to, procurement of substitute goods or services;
 *  loss of use, data, or profits; or business interruption) however caused
 *  and on any theory of liability, whether in contract, strict liability,
 *  or tort(including negligence or otherwise) arising in any way out of
 *  the use of this software, even if advised of the possibility of such damage.
 */

// #ifndef __OPENCV_XIMGPROC_HPP__
// #define __OPENCV_XIMGPROC_HPP__

// #include "ximgproc/edge_filter.hpp"
// #include "ximgproc/disparity_filter.hpp"
// #include "ximgproc/sparse_match_interpolator.hpp"
// #include "ximgproc/structured_edge_detection.hpp"
// #include "ximgproc/edgeboxes.hpp"
// #include "ximgproc/seeds.hpp"
// #include "ximgproc/segmentation.hpp"
// #include "ximgproc/fast_hough_transform.hpp"
// #include "ximgproc/estimated_covariance.hpp"
// #include "ximgproc/weighted_median_filter.hpp"
// #include "ximgproc/slic.hpp"
// #include "ximgproc/lsc.hpp"
// #include "ximgproc/paillou_filter.hpp"
// #include "ximgproc/fast_line_detector.hpp"
// #include "ximgproc/deriche_filter.hpp"
// #include "ximgproc/peilin.hpp"
// #include "ximgproc/fourier_descriptors.hpp"
// #include "ximgproc/ridgefilter.hpp"
// #include "ximgproc/brightedges.hpp"
// #include "ximgproc/run_length_morphology.hpp"
// #include "ximgproc/edgepreserving_filter.hpp"
// #include "ximgproc/color_match.hpp"


/** \defgroup ximgproc Extended Image Processing
  \{
    \defgroup ximgproc_edge Structured forests for fast edge detection
<p>
This module contains implementations of modern structured edge detection algorithms,
i.e. algorithms which somehow takes into account pixel affinities in natural images.
    <p>
    \defgroup ximgproc_edgeboxes EdgeBoxes
    <p>
    \defgroup ximgproc_filters Filters
    <p>
    \defgroup ximgproc_superpixel Superpixels
    <p>
    \defgroup ximgproc_segmentation Image segmentation
    <p>
    \defgroup ximgproc_fast_line_detector Fast line detector
    <p>
    \defgroup ximgproc_fourier Fourier descriptors
    <p>
    \defgroup ximgproc_run_length_morphology Binary morphology on run-length encoded image
    <p>
    These functions support morphological operations on binary images. In order to be fast and space efficient binary images are encoded with a run-length representation.
    This representation groups continuous horizontal sequences of "on" pixels together in a "run". A run is charactarized by the column position of the first pixel in the run, the column
    position of the last pixel in the run and the row position. This representation is very compact for binary images which contain large continuous areas of "on" and "off" pixels. A checkerboard
    pattern would be a good example. The representation is not so suitable for binary images created from random noise images or other images where little correlation between neighboring pixels
    exists.
    <p>
    The morphological operations supported here are very similar to the operations supported in the imgproc module. In general they are fast. However on several occasions they are slower than the functions
    from imgproc. The structuring elements of cv::MORPH_RECT and cv::MORPH_CROSS have very good support from the imgproc module. Also small structuring elements are very fast in imgproc (presumably
    due to opencl support). Therefore the functions from this module are recommended for larger structuring elements (cv::MORPH_ELLIPSE or self defined structuring elements). A sample application
    (run_length_morphology_demo) is supplied which allows to compare the speed of some morphological operations for the functions using run-length encoding and the imgproc functions for a given image.
    <p>
    Run length encoded images are stored in standard opencv images. Images have a single column of cv::Point3i elements. The number of rows is the number of run + 1. The first row contains
    the size of the original (not encoded) image.  For the runs the following mapping is used (x: column begin, y: column end (last column), z: row).
    <p>
    The size of the original image is required for compatibility with the imgproc functions when the boundary handling requires that pixel outside the image boundary are
    "on".
    <p>
    \}
*/

/** enum cv::ximgproc::ThinningTypes */
public static final int
    THINNING_ZHANGSUEN    = 0, // Thinning technique of Zhang-Suen
    THINNING_GUOHALL      = 1;  // Thinning technique of Guo-Hall

/**
* \brief Specifies the binarization method to use in cv::ximgproc::niBlackThreshold
*/
/** enum cv::ximgproc::LocalBinarizationMethods */
public static final int
	/** Classic Niblack binarization. See \cite Niblack1985 . */
	BINARIZATION_NIBLACK = 0,
	/** Sauvola's technique. See \cite Sauvola1997 . */
	BINARIZATION_SAUVOLA = 1,
	/** Wolf's technique. See \cite Wolf2004 . */
	BINARIZATION_WOLF = 2,
	/** NICK technique. See \cite Khurshid2009 . */
	BINARIZATION_NICK = 3;

/** \addtogroup ximgproc
 *  \{
<p>
/** \brief Performs thresholding on input images using Niblack's technique or some of the
popular variations it inspired.
<p>
The function transforms a grayscale image to a binary image according to the formulae:
-   **THRESH_BINARY**
    <pre>{@code \[dst(x,y) =  \fork{\texttt{maxValue}}{if \(src(x,y) > T(x,y)\)}{0}{otherwise}\]}</pre>
-   **THRESH_BINARY_INV**
    <pre>{@code \[dst(x,y) =  \fork{0}{if \(src(x,y) > T(x,y)\)}{\texttt{maxValue}}{otherwise}\]}</pre>
where {@code T(x,y)} is a threshold calculated individually for each pixel.
<p>
The threshold value {@code T(x, y)} is determined based on the binarization method chosen. For
classic Niblack, it is the mean minus {@code  k } times standard deviation of
{@code \texttt{blockSize} \times\texttt{blockSize}} neighborhood of {@code (x, y)}.
<p>
The function can't process the image in-place.
<p>
@param _src Source 8-bit single-channel image.
@param _dst Destination image of the same size and the same type as src.
@param maxValue Non-zero value assigned to the pixels for which the condition is satisfied,
used with the THRESH_BINARY and THRESH_BINARY_INV thresholding types.
@param type Thresholding type, see cv::ThresholdTypes.
@param blockSize Size of a pixel neighborhood that is used to calculate a threshold value
for the pixel: 3, 5, 7, and so on.
@param k The user-adjustable parameter used by Niblack and inspired techniques. For Niblack, this is
normally a value between 0 and 1 that is multiplied with the standard deviation and subtracted from
the mean.
@param binarizationMethod Binarization method to use. By default, Niblack's technique is used.
Other techniques can be specified, see cv::ximgproc::LocalBinarizationMethods.
@param r The user-adjustable parameter used by Sauvola's technique. This is the dynamic range
of standard deviation.
@see  threshold, adaptiveThreshold
 */
@Namespace("cv::ximgproc") public static native void niBlackThreshold( @ByVal Mat _src, @ByVal Mat _dst,
                                    double maxValue, int type,
                                    int blockSize, double k, int binarizationMethod/*=cv::ximgproc::BINARIZATION_NIBLACK*/,
                                    double r/*=128*/ );
@Namespace("cv::ximgproc") public static native void niBlackThreshold( @ByVal Mat _src, @ByVal Mat _dst,
                                    double maxValue, int type,
                                    int blockSize, double k );
@Namespace("cv::ximgproc") public static native void niBlackThreshold( @ByVal UMat _src, @ByVal UMat _dst,
                                    double maxValue, int type,
                                    int blockSize, double k, int binarizationMethod/*=cv::ximgproc::BINARIZATION_NIBLACK*/,
                                    double r/*=128*/ );
@Namespace("cv::ximgproc") public static native void niBlackThreshold( @ByVal UMat _src, @ByVal UMat _dst,
                                    double maxValue, int type,
                                    int blockSize, double k );
@Namespace("cv::ximgproc") public static native void niBlackThreshold( @ByVal GpuMat _src, @ByVal GpuMat _dst,
                                    double maxValue, int type,
                                    int blockSize, double k, int binarizationMethod/*=cv::ximgproc::BINARIZATION_NIBLACK*/,
                                    double r/*=128*/ );
@Namespace("cv::ximgproc") public static native void niBlackThreshold( @ByVal GpuMat _src, @ByVal GpuMat _dst,
                                    double maxValue, int type,
                                    int blockSize, double k );

/** \brief Applies a binary blob thinning operation, to achieve a skeletization of the input image.
<p>
The function transforms a binary blob image into a skeletized form using the technique of Zhang-Suen.
<p>
@param src Source 8-bit single-channel image, containing binary blobs, with blobs having 255 pixel values.
@param dst Destination image of the same size and the same type as src. The function can work in-place.
@param thinningType Value that defines which thinning algorithm should be used. See cv::ximgproc::ThinningTypes
 */
@Namespace("cv::ximgproc") public static native void thinning( @ByVal Mat src, @ByVal Mat dst, int thinningType/*=cv::ximgproc::THINNING_ZHANGSUEN*/);
@Namespace("cv::ximgproc") public static native void thinning( @ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::ximgproc") public static native void thinning( @ByVal UMat src, @ByVal UMat dst, int thinningType/*=cv::ximgproc::THINNING_ZHANGSUEN*/);
@Namespace("cv::ximgproc") public static native void thinning( @ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::ximgproc") public static native void thinning( @ByVal GpuMat src, @ByVal GpuMat dst, int thinningType/*=cv::ximgproc::THINNING_ZHANGSUEN*/);
@Namespace("cv::ximgproc") public static native void thinning( @ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Performs anisotropic diffusion on an image.
 <p>
 The function applies Perona-Malik anisotropic diffusion to an image. This is the solution to the partial differential equation:
 <p>
 <pre>{@code \[{\frac  {\partial I}{\partial t}}={\mathrm  {div}}\left(c(x,y,t)\nabla I\right)=\nabla c\cdot \nabla I+c(x,y,t)\Delta I\]}</pre>
 <p>
 Suggested functions for c(x,y,t) are:
 <p>
 <pre>{@code \[c\left(\|\nabla I\|\right)=e^{{-\left(\|\nabla I\|/K\right)^{2}}}\]}</pre>
 <p>
 or
 <p>
 <pre>{@code \[ c\left(\|\nabla I\|\right)={\frac {1}{1+\left({\frac  {\|\nabla I\|}{K}}\right)^{2}}} \]}</pre>
 <p>
 @param src Source image with 3 channels.
 @param dst Destination image of the same size and the same number of channels as src .
 @param alpha The amount of time to step forward by on each iteration (normally, it's between 0 and 1).
 @param K sensitivity to the edges
 @param niters The number of iterations
*/
@Namespace("cv::ximgproc") public static native void anisotropicDiffusion(@ByVal Mat src, @ByVal Mat dst, float alpha, float K, int niters );
@Namespace("cv::ximgproc") public static native void anisotropicDiffusion(@ByVal UMat src, @ByVal UMat dst, float alpha, float K, int niters );
@Namespace("cv::ximgproc") public static native void anisotropicDiffusion(@ByVal GpuMat src, @ByVal GpuMat dst, float alpha, float K, int niters );

/** \} */




// #endif // __OPENCV_XIMGPROC_HPP__


// Parsed from opencv2/ximgproc/edge_filter.hpp

/*
 *  By downloading, copying, installing or using the software you agree to this license.
 *  If you do not agree to this license, do not download, install,
 *  copy or use the software.
 *
 *
 *  License Agreement
 *  For Open Source Computer Vision Library
 *  (3 - clause BSD License)
 *
 *  Redistribution and use in source and binary forms, with or without modification,
 *  are permitted provided that the following conditions are met :
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and / or other materials provided with the distribution.
 *
 *  * Neither the names of the copyright holders nor the names of the contributors
 *  may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  This software is provided by the copyright holders and contributors "as is" and
 *  any express or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose are disclaimed.
 *  In no event shall copyright holders or contributors be liable for any direct,
 *  indirect, incidental, special, exemplary, or consequential damages
 *  (including, but not limited to, procurement of substitute goods or services;
 *  loss of use, data, or profits; or business interruption) however caused
 *  and on any theory of liability, whether in contract, strict liability,
 *  or tort(including negligence or otherwise) arising in any way out of
 *  the use of this software, even if advised of the possibility of such damage.
 */

// #ifndef __OPENCV_EDGEFILTER_HPP__
// #define __OPENCV_EDGEFILTER_HPP__
// #ifdef __cplusplus

// #include <opencv2/core.hpp>

/** \addtogroup ximgproc_filters
 *  \{ */

/** enum cv::ximgproc::EdgeAwareFiltersList */
public static final int
    DTF_NC = 0,
    DTF_IC = 1,
    DTF_RF = 2,

    GUIDED_FILTER = 3,
    AM_FILTER = 4;
// Targeting ..\opencv_ximgproc\DTFilter.java



/** \brief Factory method, create instance of DTFilter and produce initialization routines.
<p>
@param guide guided image (used to build transformed distance, which describes edge structure of
guided image).
<p>
@param sigmaSpatial {@code {\sigma}_H} parameter in the original article, it's similar to the sigma in the
coordinate space into bilateralFilter.
<p>
@param sigmaColor {@code {\sigma}_r} parameter in the original article, it's similar to the sigma in the
color space into bilateralFilter.
<p>
@param mode one form three modes DTF_NC, DTF_RF and DTF_IC which corresponds to three modes for
filtering 2D signals in the article.
<p>
@param numIters optional number of iterations used for filtering, 3 is quite enough.
<p>
For more details about Domain Transform filter parameters, see the original article \cite Gastal11 and
[Domain Transform filter homepage](http://www.inf.ufrgs.br/~eslgastal/DomainTransform/).
 */
@Namespace("cv::ximgproc") public static native @Ptr DTFilter createDTFilter(@ByVal Mat guide, double sigmaSpatial, double sigmaColor, int mode/*=cv::ximgproc::DTF_NC*/, int numIters/*=3*/);
@Namespace("cv::ximgproc") public static native @Ptr DTFilter createDTFilter(@ByVal Mat guide, double sigmaSpatial, double sigmaColor);
@Namespace("cv::ximgproc") public static native @Ptr DTFilter createDTFilter(@ByVal UMat guide, double sigmaSpatial, double sigmaColor, int mode/*=cv::ximgproc::DTF_NC*/, int numIters/*=3*/);
@Namespace("cv::ximgproc") public static native @Ptr DTFilter createDTFilter(@ByVal UMat guide, double sigmaSpatial, double sigmaColor);
@Namespace("cv::ximgproc") public static native @Ptr DTFilter createDTFilter(@ByVal GpuMat guide, double sigmaSpatial, double sigmaColor, int mode/*=cv::ximgproc::DTF_NC*/, int numIters/*=3*/);
@Namespace("cv::ximgproc") public static native @Ptr DTFilter createDTFilter(@ByVal GpuMat guide, double sigmaSpatial, double sigmaColor);

/** \brief Simple one-line Domain Transform filter call. If you have multiple images to filter with the same
guided image then use DTFilter interface to avoid extra computations on initialization stage.
<p>
@param guide guided image (also called as joint image) with unsigned 8-bit or floating-point 32-bit
depth and up to 4 channels.
@param src filtering image with unsigned 8-bit or floating-point 32-bit depth and up to 4 channels.
@param dst destination image
@param sigmaSpatial {@code {\sigma}_H} parameter in the original article, it's similar to the sigma in the
coordinate space into bilateralFilter.
@param sigmaColor {@code {\sigma}_r} parameter in the original article, it's similar to the sigma in the
color space into bilateralFilter.
@param mode one form three modes DTF_NC, DTF_RF and DTF_IC which corresponds to three modes for
filtering 2D signals in the article.
@param numIters optional number of iterations used for filtering, 3 is quite enough.
@see bilateralFilter, guidedFilter, amFilter
 */
@Namespace("cv::ximgproc") public static native void dtFilter(@ByVal Mat guide, @ByVal Mat src, @ByVal Mat dst, double sigmaSpatial, double sigmaColor, int mode/*=cv::ximgproc::DTF_NC*/, int numIters/*=3*/);
@Namespace("cv::ximgproc") public static native void dtFilter(@ByVal Mat guide, @ByVal Mat src, @ByVal Mat dst, double sigmaSpatial, double sigmaColor);
@Namespace("cv::ximgproc") public static native void dtFilter(@ByVal UMat guide, @ByVal UMat src, @ByVal UMat dst, double sigmaSpatial, double sigmaColor, int mode/*=cv::ximgproc::DTF_NC*/, int numIters/*=3*/);
@Namespace("cv::ximgproc") public static native void dtFilter(@ByVal UMat guide, @ByVal UMat src, @ByVal UMat dst, double sigmaSpatial, double sigmaColor);
@Namespace("cv::ximgproc") public static native void dtFilter(@ByVal GpuMat guide, @ByVal GpuMat src, @ByVal GpuMat dst, double sigmaSpatial, double sigmaColor, int mode/*=cv::ximgproc::DTF_NC*/, int numIters/*=3*/);
@Namespace("cv::ximgproc") public static native void dtFilter(@ByVal GpuMat guide, @ByVal GpuMat src, @ByVal GpuMat dst, double sigmaSpatial, double sigmaColor);
// Targeting ..\opencv_ximgproc\GuidedFilter.java



/** \brief Factory method, create instance of GuidedFilter and produce initialization routines.
<p>
@param guide guided image (or array of images) with up to 3 channels, if it have more then 3
channels then only first 3 channels will be used.
<p>
@param radius radius of Guided Filter.
<p>
@param eps regularization term of Guided Filter. {@code {eps}^2} is similar to the sigma in the color
space into bilateralFilter.
<p>
For more details about Guided Filter parameters, see the original article \cite Kaiming10 .
 */
@Namespace("cv::ximgproc") public static native @Ptr GuidedFilter createGuidedFilter(@ByVal Mat guide, int radius, double eps);
@Namespace("cv::ximgproc") public static native @Ptr GuidedFilter createGuidedFilter(@ByVal UMat guide, int radius, double eps);
@Namespace("cv::ximgproc") public static native @Ptr GuidedFilter createGuidedFilter(@ByVal GpuMat guide, int radius, double eps);

/** \brief Simple one-line Guided Filter call.
<p>
If you have multiple images to filter with the same guided image then use GuidedFilter interface to
avoid extra computations on initialization stage.
<p>
@param guide guided image (or array of images) with up to 3 channels, if it have more then 3
channels then only first 3 channels will be used.
<p>
@param src filtering image with any numbers of channels.
<p>
@param dst output image.
<p>
@param radius radius of Guided Filter.
<p>
@param eps regularization term of Guided Filter. {@code {eps}^2} is similar to the sigma in the color
space into bilateralFilter.
<p>
@param dDepth optional depth of the output image.
<p>
@see bilateralFilter, dtFilter, amFilter */
@Namespace("cv::ximgproc") public static native void guidedFilter(@ByVal Mat guide, @ByVal Mat src, @ByVal Mat dst, int radius, double eps, int dDepth/*=-1*/);
@Namespace("cv::ximgproc") public static native void guidedFilter(@ByVal Mat guide, @ByVal Mat src, @ByVal Mat dst, int radius, double eps);
@Namespace("cv::ximgproc") public static native void guidedFilter(@ByVal UMat guide, @ByVal UMat src, @ByVal UMat dst, int radius, double eps, int dDepth/*=-1*/);
@Namespace("cv::ximgproc") public static native void guidedFilter(@ByVal UMat guide, @ByVal UMat src, @ByVal UMat dst, int radius, double eps);
@Namespace("cv::ximgproc") public static native void guidedFilter(@ByVal GpuMat guide, @ByVal GpuMat src, @ByVal GpuMat dst, int radius, double eps, int dDepth/*=-1*/);
@Namespace("cv::ximgproc") public static native void guidedFilter(@ByVal GpuMat guide, @ByVal GpuMat src, @ByVal GpuMat dst, int radius, double eps);
// Targeting ..\opencv_ximgproc\AdaptiveManifoldFilter.java



/** \brief Factory method, create instance of AdaptiveManifoldFilter and produce some initialization routines.
<p>
@param sigma_s spatial standard deviation.
<p>
@param sigma_r color space standard deviation, it is similar to the sigma in the color space into
bilateralFilter.
<p>
@param adjust_outliers optional, specify perform outliers adjust operation or not, (Eq. 9) in the
original paper.
<p>
For more details about Adaptive Manifold Filter parameters, see the original article \cite Gastal12 .
<p>
\note Joint images with CV_8U and CV_16U depth converted to images with CV_32F depth and [0; 1]
color range before processing. Hence color space sigma sigma_r must be in [0; 1] range, unlike same
sigmas in bilateralFilter and dtFilter functions.
*/
@Namespace("cv::ximgproc") public static native @Ptr AdaptiveManifoldFilter createAMFilter(double sigma_s, double sigma_r, @Cast("bool") boolean adjust_outliers/*=false*/);
@Namespace("cv::ximgproc") public static native @Ptr AdaptiveManifoldFilter createAMFilter(double sigma_s, double sigma_r);

/** \brief Simple one-line Adaptive Manifold Filter call.
<p>
@param joint joint (also called as guided) image or array of images with any numbers of channels.
<p>
@param src filtering image with any numbers of channels.
<p>
@param dst output image.
<p>
@param sigma_s spatial standard deviation.
<p>
@param sigma_r color space standard deviation, it is similar to the sigma in the color space into
bilateralFilter.
<p>
@param adjust_outliers optional, specify perform outliers adjust operation or not, (Eq. 9) in the
original paper.
<p>
\note Joint images with CV_8U and CV_16U depth converted to images with CV_32F depth and [0; 1]
color range before processing. Hence color space sigma sigma_r must be in [0; 1] range, unlike same
sigmas in bilateralFilter and dtFilter functions. @see bilateralFilter, dtFilter, guidedFilter
*/
@Namespace("cv::ximgproc") public static native void amFilter(@ByVal Mat joint, @ByVal Mat src, @ByVal Mat dst, double sigma_s, double sigma_r, @Cast("bool") boolean adjust_outliers/*=false*/);
@Namespace("cv::ximgproc") public static native void amFilter(@ByVal Mat joint, @ByVal Mat src, @ByVal Mat dst, double sigma_s, double sigma_r);
@Namespace("cv::ximgproc") public static native void amFilter(@ByVal UMat joint, @ByVal UMat src, @ByVal UMat dst, double sigma_s, double sigma_r, @Cast("bool") boolean adjust_outliers/*=false*/);
@Namespace("cv::ximgproc") public static native void amFilter(@ByVal UMat joint, @ByVal UMat src, @ByVal UMat dst, double sigma_s, double sigma_r);
@Namespace("cv::ximgproc") public static native void amFilter(@ByVal GpuMat joint, @ByVal GpuMat src, @ByVal GpuMat dst, double sigma_s, double sigma_r, @Cast("bool") boolean adjust_outliers/*=false*/);
@Namespace("cv::ximgproc") public static native void amFilter(@ByVal GpuMat joint, @ByVal GpuMat src, @ByVal GpuMat dst, double sigma_s, double sigma_r);

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

/** \brief Applies the joint bilateral filter to an image.
<p>
@param joint Joint 8-bit or floating-point, 1-channel or 3-channel image.
<p>
@param src Source 8-bit or floating-point, 1-channel or 3-channel image with the same depth as joint
image.
<p>
@param dst Destination image of the same size and type as src .
<p>
@param d Diameter of each pixel neighborhood that is used during filtering. If it is non-positive,
it is computed from sigmaSpace .
<p>
@param sigmaColor Filter sigma in the color space. A larger value of the parameter means that
farther colors within the pixel neighborhood (see sigmaSpace ) will be mixed together, resulting in
larger areas of semi-equal color.
<p>
@param sigmaSpace Filter sigma in the coordinate space. A larger value of the parameter means that
farther pixels will influence each other as long as their colors are close enough (see sigmaColor ).
When d\>0 , it specifies the neighborhood size regardless of sigmaSpace . Otherwise, d is
proportional to sigmaSpace .
<p>
@param borderType
<p>
\note bilateralFilter and jointBilateralFilter use L1 norm to compute difference between colors.
<p>
@see bilateralFilter, amFilter
*/
@Namespace("cv::ximgproc") public static native void jointBilateralFilter(@ByVal Mat joint, @ByVal Mat src, @ByVal Mat dst, int d, double sigmaColor, double sigmaSpace, int borderType/*=cv::BORDER_DEFAULT*/);
@Namespace("cv::ximgproc") public static native void jointBilateralFilter(@ByVal Mat joint, @ByVal Mat src, @ByVal Mat dst, int d, double sigmaColor, double sigmaSpace);
@Namespace("cv::ximgproc") public static native void jointBilateralFilter(@ByVal UMat joint, @ByVal UMat src, @ByVal UMat dst, int d, double sigmaColor, double sigmaSpace, int borderType/*=cv::BORDER_DEFAULT*/);
@Namespace("cv::ximgproc") public static native void jointBilateralFilter(@ByVal UMat joint, @ByVal UMat src, @ByVal UMat dst, int d, double sigmaColor, double sigmaSpace);
@Namespace("cv::ximgproc") public static native void jointBilateralFilter(@ByVal GpuMat joint, @ByVal GpuMat src, @ByVal GpuMat dst, int d, double sigmaColor, double sigmaSpace, int borderType/*=cv::BORDER_DEFAULT*/);
@Namespace("cv::ximgproc") public static native void jointBilateralFilter(@ByVal GpuMat joint, @ByVal GpuMat src, @ByVal GpuMat dst, int d, double sigmaColor, double sigmaSpace);

/** \brief Applies the bilateral texture filter to an image. It performs structure-preserving texture filter.
For more details about this filter see \cite Cho2014.
<p>
@param src Source image whose depth is 8-bit UINT or 32-bit FLOAT
<p>
@param dst Destination image of the same size and type as src.
<p>
@param fr Radius of kernel to be used for filtering. It should be positive integer
<p>
@param numIter Number of iterations of algorithm, It should be positive integer
<p>
@param sigmaAlpha Controls the sharpness of the weight transition from edges to smooth/texture regions, where
a bigger value means sharper transition. When the value is negative, it is automatically calculated.
<p>
@param sigmaAvg Range blur parameter for texture blurring. Larger value makes result to be more blurred. When the
value is negative, it is automatically calculated as described in the paper.
<p>
@see rollingGuidanceFilter, bilateralFilter
*/
@Namespace("cv::ximgproc") public static native void bilateralTextureFilter(@ByVal Mat src, @ByVal Mat dst, int fr/*=3*/, int numIter/*=1*/, double sigmaAlpha/*=-1.*/, double sigmaAvg/*=-1.*/);
@Namespace("cv::ximgproc") public static native void bilateralTextureFilter(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::ximgproc") public static native void bilateralTextureFilter(@ByVal UMat src, @ByVal UMat dst, int fr/*=3*/, int numIter/*=1*/, double sigmaAlpha/*=-1.*/, double sigmaAvg/*=-1.*/);
@Namespace("cv::ximgproc") public static native void bilateralTextureFilter(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::ximgproc") public static native void bilateralTextureFilter(@ByVal GpuMat src, @ByVal GpuMat dst, int fr/*=3*/, int numIter/*=1*/, double sigmaAlpha/*=-1.*/, double sigmaAvg/*=-1.*/);
@Namespace("cv::ximgproc") public static native void bilateralTextureFilter(@ByVal GpuMat src, @ByVal GpuMat dst);

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

/** \brief Applies the rolling guidance filter to an image.
<p>
For more details, please see \cite zhang2014rolling
<p>
@param src Source 8-bit or floating-point, 1-channel or 3-channel image.
<p>
@param dst Destination image of the same size and type as src.
<p>
@param d Diameter of each pixel neighborhood that is used during filtering. If it is non-positive,
it is computed from sigmaSpace .
<p>
@param sigmaColor Filter sigma in the color space. A larger value of the parameter means that
farther colors within the pixel neighborhood (see sigmaSpace ) will be mixed together, resulting in
larger areas of semi-equal color.
<p>
@param sigmaSpace Filter sigma in the coordinate space. A larger value of the parameter means that
farther pixels will influence each other as long as their colors are close enough (see sigmaColor ).
When d\>0 , it specifies the neighborhood size regardless of sigmaSpace . Otherwise, d is
proportional to sigmaSpace .
<p>
@param numOfIter Number of iterations of joint edge-preserving filtering applied on the source image.
<p>
@param borderType
<p>
\note  rollingGuidanceFilter uses jointBilateralFilter as the edge-preserving filter.
<p>
@see jointBilateralFilter, bilateralFilter, amFilter
*/
@Namespace("cv::ximgproc") public static native void rollingGuidanceFilter(@ByVal Mat src, @ByVal Mat dst, int d/*=-1*/, double sigmaColor/*=25*/, double sigmaSpace/*=3*/, int numOfIter/*=4*/, int borderType/*=cv::BORDER_DEFAULT*/);
@Namespace("cv::ximgproc") public static native void rollingGuidanceFilter(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::ximgproc") public static native void rollingGuidanceFilter(@ByVal UMat src, @ByVal UMat dst, int d/*=-1*/, double sigmaColor/*=25*/, double sigmaSpace/*=3*/, int numOfIter/*=4*/, int borderType/*=cv::BORDER_DEFAULT*/);
@Namespace("cv::ximgproc") public static native void rollingGuidanceFilter(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::ximgproc") public static native void rollingGuidanceFilter(@ByVal GpuMat src, @ByVal GpuMat dst, int d/*=-1*/, double sigmaColor/*=25*/, double sigmaSpace/*=3*/, int numOfIter/*=4*/, int borderType/*=cv::BORDER_DEFAULT*/);
@Namespace("cv::ximgproc") public static native void rollingGuidanceFilter(@ByVal GpuMat src, @ByVal GpuMat dst);
// Targeting ..\opencv_ximgproc\FastBilateralSolverFilter.java



/** \brief Factory method, create instance of FastBilateralSolverFilter and execute the initialization routines.
<p>
@param guide image serving as guide for filtering. It should have 8-bit depth and either 1 or 3 channels.
<p>
@param sigma_spatial parameter, that is similar to spatial space sigma (bandwidth) in bilateralFilter.
<p>
@param sigma_luma parameter, that is similar to luma space sigma (bandwidth) in bilateralFilter.
<p>
@param sigma_chroma parameter, that is similar to chroma space sigma (bandwidth) in bilateralFilter.
<p>
@param lambda smoothness strength parameter for solver.
<p>
@param num_iter number of iterations used for solver, 25 is usually enough.
<p>
@param max_tol convergence tolerance used for solver.
<p>
For more details about the Fast Bilateral Solver parameters, see the original paper \cite BarronPoole2016.
<p>
*/
@Namespace("cv::ximgproc") public static native @Ptr FastBilateralSolverFilter createFastBilateralSolverFilter(@ByVal Mat guide, double sigma_spatial, double sigma_luma, double sigma_chroma, double lambda/*=128.0*/, int num_iter/*=25*/, double max_tol/*=1e-5*/);
@Namespace("cv::ximgproc") public static native @Ptr FastBilateralSolverFilter createFastBilateralSolverFilter(@ByVal Mat guide, double sigma_spatial, double sigma_luma, double sigma_chroma);
@Namespace("cv::ximgproc") public static native @Ptr FastBilateralSolverFilter createFastBilateralSolverFilter(@ByVal UMat guide, double sigma_spatial, double sigma_luma, double sigma_chroma, double lambda/*=128.0*/, int num_iter/*=25*/, double max_tol/*=1e-5*/);
@Namespace("cv::ximgproc") public static native @Ptr FastBilateralSolverFilter createFastBilateralSolverFilter(@ByVal UMat guide, double sigma_spatial, double sigma_luma, double sigma_chroma);
@Namespace("cv::ximgproc") public static native @Ptr FastBilateralSolverFilter createFastBilateralSolverFilter(@ByVal GpuMat guide, double sigma_spatial, double sigma_luma, double sigma_chroma, double lambda/*=128.0*/, int num_iter/*=25*/, double max_tol/*=1e-5*/);
@Namespace("cv::ximgproc") public static native @Ptr FastBilateralSolverFilter createFastBilateralSolverFilter(@ByVal GpuMat guide, double sigma_spatial, double sigma_luma, double sigma_chroma);



/** \brief Simple one-line Fast Bilateral Solver filter call. If you have multiple images to filter with the same
guide then use FastBilateralSolverFilter interface to avoid extra computations.
<p>
@param guide image serving as guide for filtering. It should have 8-bit depth and either 1 or 3 channels.
<p>
@param src source image for filtering with unsigned 8-bit or signed 16-bit or floating-point 32-bit depth and up to 4 channels.
<p>
@param confidence confidence image with unsigned 8-bit or floating-point 32-bit confidence and 1 channel.
<p>
@param dst destination image.
<p>
@param sigma_spatial parameter, that is similar to spatial space sigma (bandwidth) in bilateralFilter.
<p>
@param sigma_luma parameter, that is similar to luma space sigma (bandwidth) in bilateralFilter.
<p>
@param sigma_chroma parameter, that is similar to chroma space sigma (bandwidth) in bilateralFilter.
<p>
@param lambda smoothness strength parameter for solver.
<p>
@param num_iter number of iterations used for solver, 25 is usually enough.
<p>
@param max_tol convergence tolerance used for solver.
<p>
For more details about the Fast Bilateral Solver parameters, see the original paper \cite BarronPoole2016.
<p>
\note Confidence images with CV_8U depth are expected to in [0, 255] and CV_32F in [0, 1] range.
*/
@Namespace("cv::ximgproc") public static native void fastBilateralSolverFilter(@ByVal Mat guide, @ByVal Mat src, @ByVal Mat confidence, @ByVal Mat dst, double sigma_spatial/*=8*/, double sigma_luma/*=8*/, double sigma_chroma/*=8*/, double lambda/*=128.0*/, int num_iter/*=25*/, double max_tol/*=1e-5*/);
@Namespace("cv::ximgproc") public static native void fastBilateralSolverFilter(@ByVal Mat guide, @ByVal Mat src, @ByVal Mat confidence, @ByVal Mat dst);
@Namespace("cv::ximgproc") public static native void fastBilateralSolverFilter(@ByVal UMat guide, @ByVal UMat src, @ByVal UMat confidence, @ByVal UMat dst, double sigma_spatial/*=8*/, double sigma_luma/*=8*/, double sigma_chroma/*=8*/, double lambda/*=128.0*/, int num_iter/*=25*/, double max_tol/*=1e-5*/);
@Namespace("cv::ximgproc") public static native void fastBilateralSolverFilter(@ByVal UMat guide, @ByVal UMat src, @ByVal UMat confidence, @ByVal UMat dst);
@Namespace("cv::ximgproc") public static native void fastBilateralSolverFilter(@ByVal GpuMat guide, @ByVal GpuMat src, @ByVal GpuMat confidence, @ByVal GpuMat dst, double sigma_spatial/*=8*/, double sigma_luma/*=8*/, double sigma_chroma/*=8*/, double lambda/*=128.0*/, int num_iter/*=25*/, double max_tol/*=1e-5*/);
@Namespace("cv::ximgproc") public static native void fastBilateralSolverFilter(@ByVal GpuMat guide, @ByVal GpuMat src, @ByVal GpuMat confidence, @ByVal GpuMat dst);
// Targeting ..\opencv_ximgproc\FastGlobalSmootherFilter.java



/** \brief Factory method, create instance of FastGlobalSmootherFilter and execute the initialization routines.
<p>
@param guide image serving as guide for filtering. It should have 8-bit depth and either 1 or 3 channels.
<p>
@param lambda parameter defining the amount of regularization
<p>
@param sigma_color parameter, that is similar to color space sigma in bilateralFilter.
<p>
@param lambda_attenuation internal parameter, defining how much lambda decreases after each iteration. Normally,
it should be 0.25. Setting it to 1.0 may lead to streaking artifacts.
<p>
@param num_iter number of iterations used for filtering, 3 is usually enough.
<p>
For more details about Fast Global Smoother parameters, see the original paper \cite Min2014. However, please note that
there are several differences. Lambda attenuation described in the paper is implemented a bit differently so do not
expect the results to be identical to those from the paper; sigma_color values from the paper should be multiplied by 255.0 to
achieve the same effect. Also, in case of image filtering where source and guide image are the same, authors
propose to dynamically update the guide image after each iteration. To maximize the performance this feature
was not implemented here.
*/
@Namespace("cv::ximgproc") public static native @Ptr FastGlobalSmootherFilter createFastGlobalSmootherFilter(@ByVal Mat guide, double lambda, double sigma_color, double lambda_attenuation/*=0.25*/, int num_iter/*=3*/);
@Namespace("cv::ximgproc") public static native @Ptr FastGlobalSmootherFilter createFastGlobalSmootherFilter(@ByVal Mat guide, double lambda, double sigma_color);
@Namespace("cv::ximgproc") public static native @Ptr FastGlobalSmootherFilter createFastGlobalSmootherFilter(@ByVal UMat guide, double lambda, double sigma_color, double lambda_attenuation/*=0.25*/, int num_iter/*=3*/);
@Namespace("cv::ximgproc") public static native @Ptr FastGlobalSmootherFilter createFastGlobalSmootherFilter(@ByVal UMat guide, double lambda, double sigma_color);
@Namespace("cv::ximgproc") public static native @Ptr FastGlobalSmootherFilter createFastGlobalSmootherFilter(@ByVal GpuMat guide, double lambda, double sigma_color, double lambda_attenuation/*=0.25*/, int num_iter/*=3*/);
@Namespace("cv::ximgproc") public static native @Ptr FastGlobalSmootherFilter createFastGlobalSmootherFilter(@ByVal GpuMat guide, double lambda, double sigma_color);

/** \brief Simple one-line Fast Global Smoother filter call. If you have multiple images to filter with the same
guide then use FastGlobalSmootherFilter interface to avoid extra computations.
<p>
@param guide image serving as guide for filtering. It should have 8-bit depth and either 1 or 3 channels.
<p>
@param src source image for filtering with unsigned 8-bit or signed 16-bit or floating-point 32-bit depth and up to 4 channels.
<p>
@param dst destination image.
<p>
@param lambda parameter defining the amount of regularization
<p>
@param sigma_color parameter, that is similar to color space sigma in bilateralFilter.
<p>
@param lambda_attenuation internal parameter, defining how much lambda decreases after each iteration. Normally,
it should be 0.25. Setting it to 1.0 may lead to streaking artifacts.
<p>
@param num_iter number of iterations used for filtering, 3 is usually enough.
*/
@Namespace("cv::ximgproc") public static native void fastGlobalSmootherFilter(@ByVal Mat guide, @ByVal Mat src, @ByVal Mat dst, double lambda, double sigma_color, double lambda_attenuation/*=0.25*/, int num_iter/*=3*/);
@Namespace("cv::ximgproc") public static native void fastGlobalSmootherFilter(@ByVal Mat guide, @ByVal Mat src, @ByVal Mat dst, double lambda, double sigma_color);
@Namespace("cv::ximgproc") public static native void fastGlobalSmootherFilter(@ByVal UMat guide, @ByVal UMat src, @ByVal UMat dst, double lambda, double sigma_color, double lambda_attenuation/*=0.25*/, int num_iter/*=3*/);
@Namespace("cv::ximgproc") public static native void fastGlobalSmootherFilter(@ByVal UMat guide, @ByVal UMat src, @ByVal UMat dst, double lambda, double sigma_color);
@Namespace("cv::ximgproc") public static native void fastGlobalSmootherFilter(@ByVal GpuMat guide, @ByVal GpuMat src, @ByVal GpuMat dst, double lambda, double sigma_color, double lambda_attenuation/*=0.25*/, int num_iter/*=3*/);
@Namespace("cv::ximgproc") public static native void fastGlobalSmootherFilter(@ByVal GpuMat guide, @ByVal GpuMat src, @ByVal GpuMat dst, double lambda, double sigma_color);

/** \brief Global image smoothing via L0 gradient minimization.
<p>
@param src source image for filtering with unsigned 8-bit or signed 16-bit or floating-point depth.
<p>
@param dst destination image.
<p>
@param lambda parameter defining the smooth term weight.
<p>
@param kappa parameter defining the increasing factor of the weight of the gradient data term.
<p>
For more details about L0 Smoother, see the original paper \cite xu2011image.
*/
@Namespace("cv::ximgproc") public static native void l0Smooth(@ByVal Mat src, @ByVal Mat dst, double lambda/*=0.02*/, double kappa/*=2.0*/);
@Namespace("cv::ximgproc") public static native void l0Smooth(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::ximgproc") public static native void l0Smooth(@ByVal UMat src, @ByVal UMat dst, double lambda/*=0.02*/, double kappa/*=2.0*/);
@Namespace("cv::ximgproc") public static native void l0Smooth(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::ximgproc") public static native void l0Smooth(@ByVal GpuMat src, @ByVal GpuMat dst, double lambda/*=0.02*/, double kappa/*=2.0*/);
@Namespace("cv::ximgproc") public static native void l0Smooth(@ByVal GpuMat src, @ByVal GpuMat dst);
/** \} */


// #endif
// #endif


// Parsed from opencv2/ximgproc/disparity_filter.hpp

/*
 *  By downloading, copying, installing or using the software you agree to this license.
 *  If you do not agree to this license, do not download, install,
 *  copy or use the software.
 *
 *
 *  License Agreement
 *  For Open Source Computer Vision Library
 *  (3 - clause BSD License)
 *
 *  Redistribution and use in source and binary forms, with or without modification,
 *  are permitted provided that the following conditions are met :
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and / or other materials provided with the distribution.
 *
 *  * Neither the names of the copyright holders nor the names of the contributors
 *  may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  This software is provided by the copyright holders and contributors "as is" and
 *  any express or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose are disclaimed.
 *  In no event shall copyright holders or contributors be liable for any direct,
 *  indirect, incidental, special, exemplary, or consequential damages
 *  (including, but not limited to, procurement of substitute goods or services;
 *  loss of use, data, or profits; or business interruption) however caused
 *  and on any theory of liability, whether in contract, strict liability,
 *  or tort(including negligence or otherwise) arising in any way out of
 *  the use of this software, even if advised of the possibility of such damage.
 */

// #ifndef __OPENCV_DISPARITYFILTER_HPP__
// #define __OPENCV_DISPARITYFILTER_HPP__
// #ifdef __cplusplus

// #include <opencv2/core.hpp>
// #include <opencv2/calib3d.hpp>
// Targeting ..\opencv_ximgproc\DisparityFilter.java


// Targeting ..\opencv_ximgproc\DisparityWLSFilter.java



/** \brief Convenience factory method that creates an instance of DisparityWLSFilter and sets up all the relevant
filter parameters automatically based on the matcher instance. Currently supports only StereoBM and StereoSGBM.
<p>
@param matcher_left stereo matcher instance that will be used with the filter
*/
@Namespace("cv::ximgproc") public static native @Ptr DisparityWLSFilter createDisparityWLSFilter(@Ptr StereoMatcher matcher_left);

/** \brief Convenience method to set up the matcher for computing the right-view disparity map
that is required in case of filtering with confidence.
<p>
@param matcher_left main stereo matcher instance that will be used with the filter
*/
@Namespace("cv::ximgproc") public static native @Ptr StereoMatcher createRightMatcher(@Ptr StereoMatcher matcher_left);

/** \brief More generic factory method, create instance of DisparityWLSFilter and execute basic
initialization routines. When using this method you will need to set-up the ROI, matchers and
other parameters by yourself.
<p>
@param use_confidence filtering with confidence requires two disparity maps (for the left and right views) and is
approximately two times slower. However, quality is typically significantly better.
*/
@Namespace("cv::ximgproc") public static native @Ptr DisparityWLSFilter createDisparityWLSFilterGeneric(@Cast("bool") boolean use_confidence);

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

/** \brief Function for reading ground truth disparity maps. Supports basic Middlebury
and MPI-Sintel formats. Note that the resulting disparity map is scaled by 16.
<p>
@param src_path path to the image, containing ground-truth disparity map
<p>
@param dst output disparity map, CV_16S depth
<p>
@return returns zero if successfully read the ground truth
 */
@Namespace("cv::ximgproc") public static native int readGT(@Str BytePointer src_path,@ByVal Mat dst);
@Namespace("cv::ximgproc") public static native int readGT(@Str String src_path,@ByVal Mat dst);
@Namespace("cv::ximgproc") public static native int readGT(@Str String src_path,@ByVal UMat dst);
@Namespace("cv::ximgproc") public static native int readGT(@Str BytePointer src_path,@ByVal UMat dst);
@Namespace("cv::ximgproc") public static native int readGT(@Str BytePointer src_path,@ByVal GpuMat dst);
@Namespace("cv::ximgproc") public static native int readGT(@Str String src_path,@ByVal GpuMat dst);

/** \brief Function for computing mean square error for disparity maps
<p>
@param GT ground truth disparity map
<p>
@param src disparity map to evaluate
<p>
@param ROI region of interest
<p>
@return returns mean square error between GT and src
 */
@Namespace("cv::ximgproc") public static native double computeMSE(@ByVal Mat GT, @ByVal Mat src, @ByVal Rect ROI);
@Namespace("cv::ximgproc") public static native double computeMSE(@ByVal UMat GT, @ByVal UMat src, @ByVal Rect ROI);
@Namespace("cv::ximgproc") public static native double computeMSE(@ByVal GpuMat GT, @ByVal GpuMat src, @ByVal Rect ROI);

/** \brief Function for computing the percent of "bad" pixels in the disparity map
(pixels where error is higher than a specified threshold)
<p>
@param GT ground truth disparity map
<p>
@param src disparity map to evaluate
<p>
@param ROI region of interest
<p>
@param thresh threshold used to determine "bad" pixels
<p>
@return returns mean square error between GT and src
 */
@Namespace("cv::ximgproc") public static native double computeBadPixelPercent(@ByVal Mat GT, @ByVal Mat src, @ByVal Rect ROI, int thresh/*=24*/);
@Namespace("cv::ximgproc") public static native double computeBadPixelPercent(@ByVal Mat GT, @ByVal Mat src, @ByVal Rect ROI);
@Namespace("cv::ximgproc") public static native double computeBadPixelPercent(@ByVal UMat GT, @ByVal UMat src, @ByVal Rect ROI, int thresh/*=24*/);
@Namespace("cv::ximgproc") public static native double computeBadPixelPercent(@ByVal UMat GT, @ByVal UMat src, @ByVal Rect ROI);
@Namespace("cv::ximgproc") public static native double computeBadPixelPercent(@ByVal GpuMat GT, @ByVal GpuMat src, @ByVal Rect ROI, int thresh/*=24*/);
@Namespace("cv::ximgproc") public static native double computeBadPixelPercent(@ByVal GpuMat GT, @ByVal GpuMat src, @ByVal Rect ROI);

/** \brief Function for creating a disparity map visualization (clamped CV_8U image)
<p>
@param src input disparity map (CV_16S depth)
<p>
@param dst output visualization
<p>
@param scale disparity map will be multiplied by this value for visualization
 */
@Namespace("cv::ximgproc") public static native void getDisparityVis(@ByVal Mat src,@ByVal Mat dst,double scale/*=1.0*/);
@Namespace("cv::ximgproc") public static native void getDisparityVis(@ByVal Mat src,@ByVal Mat dst);
@Namespace("cv::ximgproc") public static native void getDisparityVis(@ByVal UMat src,@ByVal UMat dst,double scale/*=1.0*/);
@Namespace("cv::ximgproc") public static native void getDisparityVis(@ByVal UMat src,@ByVal UMat dst);
@Namespace("cv::ximgproc") public static native void getDisparityVis(@ByVal GpuMat src,@ByVal GpuMat dst,double scale/*=1.0*/);
@Namespace("cv::ximgproc") public static native void getDisparityVis(@ByVal GpuMat src,@ByVal GpuMat dst);

/** \} */


// #endif
// #endif


// Parsed from opencv2/ximgproc/sparse_match_interpolator.hpp

/*
 *  By downloading, copying, installing or using the software you agree to this license.
 *  If you do not agree to this license, do not download, install,
 *  copy or use the software.
 *
 *
 *  License Agreement
 *  For Open Source Computer Vision Library
 *  (3 - clause BSD License)
 *
 *  Redistribution and use in source and binary forms, with or without modification,
 *  are permitted provided that the following conditions are met :
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and / or other materials provided with the distribution.
 *
 *  * Neither the names of the copyright holders nor the names of the contributors
 *  may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  This software is provided by the copyright holders and contributors "as is" and
 *  any express or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose are disclaimed.
 *  In no event shall copyright holders or contributors be liable for any direct,
 *  indirect, incidental, special, exemplary, or consequential damages
 *  (including, but not limited to, procurement of substitute goods or services;
 *  loss of use, data, or profits; or business interruption) however caused
 *  and on any theory of liability, whether in contract, strict liability,
 *  or tort(including negligence or otherwise) arising in any way out of
 *  the use of this software, even if advised of the possibility of such damage.
 */

// #ifndef __OPENCV_SPARSEMATCHINTERPOLATOR_HPP__
// #define __OPENCV_SPARSEMATCHINTERPOLATOR_HPP__
// #ifdef __cplusplus

// #include <opencv2/core.hpp>
// Targeting ..\opencv_ximgproc\SparseMatchInterpolator.java


// Targeting ..\opencv_ximgproc\EdgeAwareInterpolator.java



/** \brief Factory method that creates an instance of the
EdgeAwareInterpolator.
*/
@Namespace("cv::ximgproc") public static native @Ptr EdgeAwareInterpolator createEdgeAwareInterpolator();
// Targeting ..\opencv_ximgproc\RICInterpolator.java



/** \brief Factory method that creates an instance of the
RICInterpolator.
*/
@Namespace("cv::ximgproc") public static native @Ptr RICInterpolator createRICInterpolator();
/** \} */


// #endif
// #endif


// Parsed from opencv2/ximgproc/structured_edge_detection.hpp

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009-2011, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_STRUCTURED_EDGE_DETECTION_HPP__
// #define __OPENCV_STRUCTURED_EDGE_DETECTION_HPP__
// #ifdef __cplusplus

/** \file
\date Jun 17, 2014
@author Yury Gitman
 */

// #include <opencv2/core.hpp>
// Targeting ..\opencv_ximgproc\RFFeatureGetter.java



@Namespace("cv::ximgproc") public static native @Ptr RFFeatureGetter createRFFeatureGetter();
// Targeting ..\opencv_ximgproc\StructuredEdgeDetection.java



/**
* The only constructor
*
* @param model : name of the file where the model is stored
* @param howToGetFeatures : optional object inheriting from RFFeatureGetter.
*                           You need it only if you would like to train your
*                           own forest, pass NULL otherwise
*/
@Namespace("cv::ximgproc") public static native @Ptr StructuredEdgeDetection createStructuredEdgeDetection(@Str BytePointer model,
    @Const @Ptr RFFeatureGetter howToGetFeatures/*=cv::Ptr<cv::ximgproc::RFFeatureGetter>()*/);
@Namespace("cv::ximgproc") public static native @Ptr StructuredEdgeDetection createStructuredEdgeDetection(@Str BytePointer model);
@Namespace("cv::ximgproc") public static native @Ptr StructuredEdgeDetection createStructuredEdgeDetection(@Str String model,
    @Const @Ptr RFFeatureGetter howToGetFeatures/*=cv::Ptr<cv::ximgproc::RFFeatureGetter>()*/);
@Namespace("cv::ximgproc") public static native @Ptr StructuredEdgeDetection createStructuredEdgeDetection(@Str String model);

/** \} */



// #endif
// #endif /* __OPENCV_STRUCTURED_EDGE_DETECTION_HPP__ */


// Parsed from opencv2/ximgproc/edgeboxes.hpp

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009-2011, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_EDGEBOXES_HPP__
// #define __OPENCV_EDGEBOXES_HPP__

// #include <opencv2/core.hpp>
// Targeting ..\opencv_ximgproc\Box.java


// Targeting ..\opencv_ximgproc\EdgeBoxes.java



/** \brief Creates a Edgeboxes
<p>
@param alpha step size of sliding window search.
@param beta nms threshold for object proposals.
@param eta adaptation rate for nms threshold.
@param minScore min score of boxes to detect.
@param maxBoxes max number of boxes to detect.
@param edgeMinMag edge min magnitude. Increase to trade off accuracy for speed.
@param edgeMergeThr edge merge threshold. Increase to trade off accuracy for speed.
@param clusterMinMag cluster min magnitude. Increase to trade off accuracy for speed.
@param maxAspectRatio max aspect ratio of boxes.
@param minBoxArea minimum area of boxes.
@param gamma affinity sensitivity.
@param kappa scale sensitivity.
*/
@Namespace("cv::ximgproc") public static native @Ptr EdgeBoxes createEdgeBoxes(float alpha/*=0.65f*/,
                float beta/*=0.75f*/,
                float eta/*=1*/,
                float minScore/*=0.01f*/,
                int maxBoxes/*=10000*/,
                float edgeMinMag/*=0.1f*/,
                float edgeMergeThr/*=0.5f*/,
                float clusterMinMag/*=0.5f*/,
                float maxAspectRatio/*=3*/,
                float minBoxArea/*=1000*/,
                float gamma/*=2*/,
                float kappa/*=1.5f*/);
@Namespace("cv::ximgproc") public static native @Ptr EdgeBoxes createEdgeBoxes();

/** \} */




// #endif /* __OPENCV_EDGEBOXES_HPP__ */


// Parsed from opencv2/ximgproc/seeds.hpp

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2014, Beat Kueng (beat-kueng@gmx.net), Lukas Vogel, Morten Lysgaard
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_SEEDS_HPP__
// #define __OPENCV_SEEDS_HPP__
// #ifdef __cplusplus

// #include <opencv2/core.hpp>
// Targeting ..\opencv_ximgproc\SuperpixelSEEDS.java



/** \brief Initializes a SuperpixelSEEDS object.
<p>
@param image_width Image width.
@param image_height Image height.
@param image_channels Number of channels of the image.
@param num_superpixels Desired number of superpixels. Note that the actual number may be smaller
due to restrictions (depending on the image size and num_levels). Use getNumberOfSuperpixels() to
get the actual number.
@param num_levels Number of block levels. The more levels, the more accurate is the segmentation,
but needs more memory and CPU time.
@param prior enable 3x3 shape smoothing term if \>0. A larger value leads to smoother shapes. prior
must be in the range [0, 5].
@param histogram_bins Number of histogram bins.
@param double_step If true, iterate each block level twice for higher accuracy.
<p>
The function initializes a SuperpixelSEEDS object for the input image. It stores the parameters of
the image: image_width, image_height and image_channels. It also sets the parameters of the SEEDS
superpixel algorithm, which are: num_superpixels, num_levels, use_prior, histogram_bins and
double_step.
<p>
The number of levels in num_levels defines the amount of block levels that the algorithm use in the
optimization. The initialization is a grid, in which the superpixels are equally distributed through
the width and the height of the image. The larger blocks correspond to the superpixel size, and the
levels with smaller blocks are formed by dividing the larger blocks into 2 x 2 blocks of pixels,
recursively until the smaller block level. An example of initialization of 4 block levels is
illustrated in the following figure.
<p>
![image](pics/superpixels_blocks.png)
 */
@Namespace("cv::ximgproc") public static native @Ptr SuperpixelSEEDS createSuperpixelSEEDS(
    int image_width, int image_height, int image_channels,
    int num_superpixels, int num_levels, int prior/*=2*/,
    int histogram_bins/*=5*/, @Cast("bool") boolean double_step/*=false*/);
@Namespace("cv::ximgproc") public static native @Ptr SuperpixelSEEDS createSuperpixelSEEDS(
    int image_width, int image_height, int image_channels,
    int num_superpixels, int num_levels);

/** \} */



// #endif
// #endif


// Parsed from opencv2/ximgproc/segmentation.hpp

/*
By downloading, copying, installing or using the software you agree to this
license. If you do not agree to this license, do not download, install,
copy or use the software.
                          License Agreement
               For Open Source Computer Vision Library
                       (3-clause BSD License)
Copyright (C) 2013, OpenCV Foundation, all rights reserved.
Third party copyrights are property of their respective owners.
Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  * Neither the names of the copyright holders nor the names of the contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.
This software is provided by the copyright holders and contributors "as is" and
any express or implied warranties, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose are
disclaimed. In no event shall copyright holders or contributors be liable for
any direct, indirect, incidental, special, exemplary, or consequential damages
(including, but not limited to, procurement of substitute goods or services;
loss of use, data, or profits; or business interruption) however caused
and on any theory of liability, whether in contract, strict liability,
or tort (including negligence or otherwise) arising in any way out of
the use of this software, even if advised of the possibility of such damage.
*/

// #ifndef __OPENCV_XIMGPROC_SEGMENTATION_HPP__
// #define __OPENCV_XIMGPROC_SEGMENTATION_HPP__

// #include <opencv2/core.hpp>
// Targeting ..\opencv_ximgproc\GraphSegmentation.java



                    /** \brief Creates a graph based segmentor
                        @param sigma The sigma parameter, used to smooth image
                        @param k The k parameter of the algorythm
                        @param min_size The minimum size of segments
                     */
                    @Namespace("cv::ximgproc::segmentation") public static native @Ptr GraphSegmentation createGraphSegmentation(double sigma/*=0.5*/, float k/*=300*/, int min_size/*=100*/);
                    @Namespace("cv::ximgproc::segmentation") public static native @Ptr GraphSegmentation createGraphSegmentation();
// Targeting ..\opencv_ximgproc\SelectiveSearchSegmentationStrategy.java


// Targeting ..\opencv_ximgproc\SelectiveSearchSegmentationStrategyColor.java



                    /** \brief Create a new color-based strategy */
                    @Namespace("cv::ximgproc::segmentation") public static native @Ptr SelectiveSearchSegmentationStrategyColor createSelectiveSearchSegmentationStrategyColor();
// Targeting ..\opencv_ximgproc\SelectiveSearchSegmentationStrategySize.java



                    /** \brief Create a new size-based strategy */
                    @Namespace("cv::ximgproc::segmentation") public static native @Ptr SelectiveSearchSegmentationStrategySize createSelectiveSearchSegmentationStrategySize();
// Targeting ..\opencv_ximgproc\SelectiveSearchSegmentationStrategyTexture.java



                    /** \brief Create a new size-based strategy */
                    @Namespace("cv::ximgproc::segmentation") public static native @Ptr SelectiveSearchSegmentationStrategyTexture createSelectiveSearchSegmentationStrategyTexture();
// Targeting ..\opencv_ximgproc\SelectiveSearchSegmentationStrategyFill.java



                    /** \brief Create a new fill-based strategy */
                    @Namespace("cv::ximgproc::segmentation") public static native @Ptr SelectiveSearchSegmentationStrategyFill createSelectiveSearchSegmentationStrategyFill();
// Targeting ..\opencv_ximgproc\SelectiveSearchSegmentationStrategyMultiple.java



                    /** \brief Create a new multiple strategy */
                    @Namespace("cv::ximgproc::segmentation") public static native @Ptr SelectiveSearchSegmentationStrategyMultiple createSelectiveSearchSegmentationStrategyMultiple();

                    /** \brief Create a new multiple strategy and set one subtrategy
                        @param s1 The first strategy
                    */
                    @Namespace("cv::ximgproc::segmentation") public static native @Ptr SelectiveSearchSegmentationStrategyMultiple createSelectiveSearchSegmentationStrategyMultiple(@Ptr SelectiveSearchSegmentationStrategy s1);

                    /** \brief Create a new multiple strategy and set two subtrategies, with equal weights
                        @param s1 The first strategy
                        @param s2 The second strategy
                    */
                    @Namespace("cv::ximgproc::segmentation") public static native @Ptr SelectiveSearchSegmentationStrategyMultiple createSelectiveSearchSegmentationStrategyMultiple(@Ptr SelectiveSearchSegmentationStrategy s1, @Ptr SelectiveSearchSegmentationStrategy s2);


                    /** \brief Create a new multiple strategy and set three subtrategies, with equal weights
                        @param s1 The first strategy
                        @param s2 The second strategy
                        @param s3 The third strategy
                    */
                    @Namespace("cv::ximgproc::segmentation") public static native @Ptr SelectiveSearchSegmentationStrategyMultiple createSelectiveSearchSegmentationStrategyMultiple(@Ptr SelectiveSearchSegmentationStrategy s1, @Ptr SelectiveSearchSegmentationStrategy s2, @Ptr SelectiveSearchSegmentationStrategy s3);

                    /** \brief Create a new multiple strategy and set four subtrategies, with equal weights
                        @param s1 The first strategy
                        @param s2 The second strategy
                        @param s3 The third strategy
                        @param s4 The forth strategy
                    */
                    @Namespace("cv::ximgproc::segmentation") public static native @Ptr SelectiveSearchSegmentationStrategyMultiple createSelectiveSearchSegmentationStrategyMultiple(@Ptr SelectiveSearchSegmentationStrategy s1, @Ptr SelectiveSearchSegmentationStrategy s2, @Ptr SelectiveSearchSegmentationStrategy s3, @Ptr SelectiveSearchSegmentationStrategy s4);
// Targeting ..\opencv_ximgproc\SelectiveSearchSegmentation.java



                    /** \brief Create a new SelectiveSearchSegmentation class.
                     */
                    @Namespace("cv::ximgproc::segmentation") public static native @Ptr SelectiveSearchSegmentation createSelectiveSearchSegmentation();

            /** \} */

        
    


// #endif


// Parsed from opencv2/ximgproc/fast_hough_transform.hpp

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2015, Smart Engines Ltd, all rights reserved.
// Copyright (C) 2015, Institute for Information Transmission Problems of the Russian Academy of Sciences (Kharkevich Institute), all rights reserved.
// Copyright (C) 2015, Dmitry Nikolaev, Simon Karpenko, Michail Aliev, Elena Kuznetsova, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_FAST_HOUGH_TRANSFORM_HPP__
// #define __OPENCV_FAST_HOUGH_TRANSFORM_HPP__
// #ifdef __cplusplus

// #include "opencv2/core.hpp"

/**
* \brief   Specifies the part of Hough space to calculate
* \details The enum specifies the part of Hough space to calculate. Each
* member specifies primarily direction of lines (horizontal or vertical)
* and the direction of angle changes.
* Direction of angle changes is from multiples of 90 to odd multiples of 45.
* The image considered to be written top-down and left-to-right.
* Angles are started from vertical line and go clockwise.
* Separate quarters and halves are written in orientation they should be in
* full Hough space.
*/
/** enum cv::ximgproc::AngleRangeOption */
public static final int
  ARO_0_45    = 0, //< Vertical primarily direction and clockwise angle changes
  ARO_45_90   = 1, //< Horizontal primarily direction and counterclockwise angle changes
  ARO_90_135  = 2, //< Horizontal primarily direction and clockwise angle changes
  ARO_315_0   = 3, //< Vertical primarily direction and counterclockwise angle changes
  ARO_315_45  = 4, //< Vertical primarily direction
  ARO_45_135  = 5, //< Horizontal primarily direction
  ARO_315_135 = 6, //< Full set of directions
  ARO_CTR_HOR = 7, //< 90 +/- atan(0.5), interval approximately from 64.5 to 116.5 degrees.
                   //< It is used for calculating Fast Hough Transform for images skewed by atan(0.5).
  ARO_CTR_VER = 8;  //< +/- atan(0.5), interval approximately from 333.5(-26.5) to 26.5 degrees
                   //< It is used for calculating Fast Hough Transform for images skewed by atan(0.5).

/**
 * \brief   Specifies binary operations.
 * \details The enum specifies binary operations, that is such ones which involve
 *          two operands. Formally, a binary operation {@code  f } on a set {@code  S }
 *          is a binary relation that maps elements of the Cartesian product
 *          {@code  S \times S } to {@code  S }:
*           <pre>{@code \[ f: S \times S \to S \]}</pre>
 * \ingroup MinUtils_MathOper
 */
/** enum cv::ximgproc::HoughOp */
public static final int
  FHT_MIN = 0,  //< Binary minimum operation. The constant specifies the binary minimum operation
                //< @f$ f @f$ that is defined as follows: @f[ f(x, y) = \min(x, y) @f]
  FHT_MAX = 1,  //< Binary maximum operation. The constant specifies the binary maximum operation
                //< @f$ f @f$ that is defined as follows: @f[ f(x, y) = \max(x, y) @f]
  FHT_ADD = 2,  //< Binary addition operation. The constant specifies the binary addition operation
                //< @f$ f @f$ that is defined as follows: @f[ f(x, y) = x + y @f]
  FHT_AVE = 3;   //< Binary average operation. The constant specifies the binary average operation
                //< @f$ f @f$ that is defined as follows: @f[ f(x, y) = \frac{x + y}{2} @f]

/**
* \brief   Specifies to do or not to do skewing of Hough transform image
* \details The enum specifies to do or not to do skewing of Hough transform image
* so it would be no cycling in Hough transform image through borders of image.
*/
/** enum cv::ximgproc::HoughDeskewOption */
public static final int
  HDO_RAW    = 0, //< Use raw cyclic image
  HDO_DESKEW = 1;  //< Prepare deskewed image

/**
 * \brief   Specifies the degree of rules validation.
 * \details The enum specifies the degree of rules validation. This can be used,
 *          for example, to choose a proper way of input arguments validation.
 */
/** enum cv::ximgproc::RulesOption */
public static final int
  /** Validate each rule in a proper way. */
  RO_STRICT          = 0x00,
  /** Skip validations of image borders. */
  RO_IGNORE_BORDERS  = 0x01;

/**
* \brief   Calculates 2D Fast Hough transform of an image.
* @param   dst         The destination image, result of transformation.
* @param   src         The source (input) image.
* @param   dstMatDepth The depth of destination image
* @param   op          The operation to be applied, see cv::HoughOp
* @param   angleRange  The part of Hough space to calculate, see cv::AngleRangeOption
* @param   makeSkew    Specifies to do or not to do image skewing, see cv::HoughDeskewOption
*
* The function calculates the fast Hough transform for full, half or quarter
* range of angles.
*/
@Namespace("cv::ximgproc") public static native void FastHoughTransform( @ByVal Mat src,
                                      @ByVal Mat dst,
                                      int dstMatDepth,
                                      int angleRange/*=cv::ximgproc::ARO_315_135*/,
                                      int op/*=cv::ximgproc::FHT_ADD*/,
                                      int makeSkew/*=cv::ximgproc::HDO_DESKEW*/ );
@Namespace("cv::ximgproc") public static native void FastHoughTransform( @ByVal Mat src,
                                      @ByVal Mat dst,
                                      int dstMatDepth );
@Namespace("cv::ximgproc") public static native void FastHoughTransform( @ByVal UMat src,
                                      @ByVal UMat dst,
                                      int dstMatDepth,
                                      int angleRange/*=cv::ximgproc::ARO_315_135*/,
                                      int op/*=cv::ximgproc::FHT_ADD*/,
                                      int makeSkew/*=cv::ximgproc::HDO_DESKEW*/ );
@Namespace("cv::ximgproc") public static native void FastHoughTransform( @ByVal UMat src,
                                      @ByVal UMat dst,
                                      int dstMatDepth );
@Namespace("cv::ximgproc") public static native void FastHoughTransform( @ByVal GpuMat src,
                                      @ByVal GpuMat dst,
                                      int dstMatDepth,
                                      int angleRange/*=cv::ximgproc::ARO_315_135*/,
                                      int op/*=cv::ximgproc::FHT_ADD*/,
                                      int makeSkew/*=cv::ximgproc::HDO_DESKEW*/ );
@Namespace("cv::ximgproc") public static native void FastHoughTransform( @ByVal GpuMat src,
                                      @ByVal GpuMat dst,
                                      int dstMatDepth );

/**
* \brief   Calculates coordinates of line segment corresponded by point in Hough space.
* @param   houghPoint  Point in Hough space.
* @param   srcImgInfo The source (input) image of Hough transform.
* @param   angleRange  The part of Hough space where point is situated, see cv::AngleRangeOption
* @param   makeSkew    Specifies to do or not to do image skewing, see cv::HoughDeskewOption
* @param   rules       Specifies strictness of line segment calculating, see cv::RulesOption
* \retval  [Vec4i]     Coordinates of line segment corresponded by point in Hough space.
* \remarks If rules parameter set to RO_STRICT
           then returned line cut along the border of source image.
* \remarks If rules parameter set to RO_WEAK then in case of point, which belongs
           the incorrect part of Hough image, returned line will not intersect source image.
*
* The function calculates coordinates of line segment corresponded by point in Hough space.
*/
@Namespace("cv::ximgproc") public static native @ByVal @Cast("cv::Vec4i*") Scalar4i HoughPoint2Line(@Const @ByRef Point houghPoint,
                                   @ByVal Mat srcImgInfo,
                                   int angleRange/*=cv::ximgproc::ARO_315_135*/,
                                   int makeSkew/*=cv::ximgproc::HDO_DESKEW*/,
                                   int rules/*=cv::ximgproc::RO_IGNORE_BORDERS*/ );
@Namespace("cv::ximgproc") public static native @ByVal @Cast("cv::Vec4i*") Scalar4i HoughPoint2Line(@Const @ByRef Point houghPoint,
                                   @ByVal Mat srcImgInfo );
@Namespace("cv::ximgproc") public static native @ByVal @Cast("cv::Vec4i*") Scalar4i HoughPoint2Line(@Const @ByRef Point houghPoint,
                                   @ByVal UMat srcImgInfo,
                                   int angleRange/*=cv::ximgproc::ARO_315_135*/,
                                   int makeSkew/*=cv::ximgproc::HDO_DESKEW*/,
                                   int rules/*=cv::ximgproc::RO_IGNORE_BORDERS*/ );
@Namespace("cv::ximgproc") public static native @ByVal @Cast("cv::Vec4i*") Scalar4i HoughPoint2Line(@Const @ByRef Point houghPoint,
                                   @ByVal UMat srcImgInfo );
@Namespace("cv::ximgproc") public static native @ByVal @Cast("cv::Vec4i*") Scalar4i HoughPoint2Line(@Const @ByRef Point houghPoint,
                                   @ByVal GpuMat srcImgInfo,
                                   int angleRange/*=cv::ximgproc::ARO_315_135*/,
                                   int makeSkew/*=cv::ximgproc::HDO_DESKEW*/,
                                   int rules/*=cv::ximgproc::RO_IGNORE_BORDERS*/ );
@Namespace("cv::ximgproc") public static native @ByVal @Cast("cv::Vec4i*") Scalar4i HoughPoint2Line(@Const @ByRef Point houghPoint,
                                   @ByVal GpuMat srcImgInfo );

 // namespace cv::ximgproc

// #endif //__cplusplus
// #endif //__OPENCV_FAST_HOUGH_TRANSFORM_HPP__


// Parsed from opencv2/ximgproc/estimated_covariance.hpp

/*
By downloading, copying, installing or using the software you agree to this license.
If you do not agree to this license, do not download, install,
copy or use the software.


                          License Agreement
               For Open Source Computer Vision Library
                       (3-clause BSD License)

Copyright (C) 2000-2015, Intel Corporation, all rights reserved.
Copyright (C) 2009-2011, Willow Garage Inc., all rights reserved.
Copyright (C) 2009-2015, NVIDIA Corporation, all rights reserved.
Copyright (C) 2010-2013, Advanced Micro Devices, Inc., all rights reserved.
Copyright (C) 2015, OpenCV Foundation, all rights reserved.
Copyright (C) 2015, Itseez Inc., all rights reserved.
Third party copyrights are property of their respective owners.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

  * Neither the names of the copyright holders nor the names of the contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

This software is provided by the copyright holders and contributors "as is" and
any express or implied warranties, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose are disclaimed.
In no event shall copyright holders or contributors be liable for any direct,
indirect, incidental, special, exemplary, or consequential damages
(including, but not limited to, procurement of substitute goods or services;
loss of use, data, or profits; or business interruption) however caused
and on any theory of liability, whether in contract, strict liability,
or tort (including negligence or otherwise) arising in any way out of
the use of this software, even if advised of the possibility of such damage.

Algorithmic details of this algorithm can be found at:
 * O. Green, Y. Birk, "A Computationally Efficient Algorithm for the 2D Covariance Method", ACM/IEEE International Conference on High Performance Computing, Networking, Storage and Analysis, Denver, Colorado, 2013
A previous and less efficient version of the algorithm can be found:
 * O. Green, L. David, A. Galperin, Y. Birk, "Efficient parallel computation of the estimated covariance matrix", arXiv, 2013


*/
// #ifndef __OPENCV_ESTIMATECOVARIANCE_HPP__
// #define __OPENCV_ESTIMATECOVARIANCE_HPP__
// #ifdef __cplusplus

// #include <opencv2/core.hpp>

/** \brief Computes the estimated covariance matrix of an image using the sliding
window forumlation.
<p>
@param src The source image. Input image must be of a complex type.
@param dst The destination estimated covariance matrix. Output matrix will be size (windowRows*windowCols, windowRows*windowCols).
@param windowRows The number of rows in the window.
@param windowCols The number of cols in the window.
The window size parameters control the accuracy of the estimation.
The sliding window moves over the entire image from the top-left corner
to the bottom right corner. Each location of the window represents a sample.
If the window is the size of the image, then this gives the exact covariance matrix.
For all other cases, the sizes of the window will impact the number of samples
and the number of elements in the estimated covariance matrix.
*/

@Namespace("cv::ximgproc") public static native void covarianceEstimation(@ByVal Mat src, @ByVal Mat dst, int windowRows, int windowCols);
@Namespace("cv::ximgproc") public static native void covarianceEstimation(@ByVal UMat src, @ByVal UMat dst, int windowRows, int windowCols);
@Namespace("cv::ximgproc") public static native void covarianceEstimation(@ByVal GpuMat src, @ByVal GpuMat dst, int windowRows, int windowCols);



// #endif
// #endif


// Parsed from opencv2/ximgproc/weighted_median_filter.hpp

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2015, The Chinese University of Hong Kong, all rights reserved.
//
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef  __OPENCV_WEIGHTED_MEDIAN_FILTER_HPP__
// #define  __OPENCV_WEIGHTED_MEDIAN_FILTER_HPP__
// #ifdef __cplusplus

/**
* \file
* \date Sept 9, 2015
* @author Zhou Chao
*/

// #include <opencv2/core.hpp>
// #include <string>

/**
* \brief Specifies weight types of weighted median filter.
*/
/** enum cv::ximgproc::WMFWeightType */
public static final int
    /** {@code exp(-|I1-I2|^2/(2*sigma^2))} */
    WMF_EXP = 1,
    /** {@code (|I1-I2|+sigma)^-1} */
    WMF_IV1 = 1 << 1,
    /** {@code (|I1-I2|^2+sigma^2)^-1} */
    WMF_IV2 = 1 << 2,
    /** {@code dot(I1,I2)/(|I1|*|I2|)} */
    WMF_COS = 1 << 3,
    /** {@code (min(r1,r2)+min(g1,g2)+min(b1,b2))/(max(r1,r2)+max(g1,g2)+max(b1,b2))} */
    WMF_JAC = 1 << 4,
    /** unweighted */
    WMF_OFF = 1 << 5;

/**
* \brief   Applies weighted median filter to an image.
*
* For more details about this implementation, please see \cite zhang2014100+
*
* @param   joint       Joint 8-bit, 1-channel or 3-channel image.
* @param   src         Source 8-bit or floating-point, 1-channel or 3-channel image.
* @param   dst         Destination image.
* @param   r           Radius of filtering kernel, should be a positive integer.
* @param   sigma       Filter range standard deviation for the joint image.
* @param   weightType  weightType The type of weight definition, see WMFWeightType
* @param   mask        A 0-1 mask that has the same size with I. This mask is used to ignore the effect of some pixels. If the pixel value on mask is 0,
*                           the pixel will be ignored when maintaining the joint-histogram. This is useful for applications like optical flow occlusion handling.
*
* @see medianBlur, jointBilateralFilter
*/
@Namespace("cv::ximgproc") public static native void weightedMedianFilter(@ByVal Mat joint, @ByVal Mat src, @ByVal Mat dst,
                                       int r, double sigma/*=25.5*/, int weightType/*=cv::ximgproc::WMF_EXP*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv::ximgproc") public static native void weightedMedianFilter(@ByVal Mat joint, @ByVal Mat src, @ByVal Mat dst,
                                       int r);
@Namespace("cv::ximgproc") public static native void weightedMedianFilter(@ByVal UMat joint, @ByVal UMat src, @ByVal UMat dst,
                                       int r, double sigma/*=25.5*/, int weightType/*=cv::ximgproc::WMF_EXP*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv::ximgproc") public static native void weightedMedianFilter(@ByVal UMat joint, @ByVal UMat src, @ByVal UMat dst,
                                       int r);
@Namespace("cv::ximgproc") public static native void weightedMedianFilter(@ByVal GpuMat joint, @ByVal GpuMat src, @ByVal GpuMat dst,
                                       int r, double sigma/*=25.5*/, int weightType/*=cv::ximgproc::WMF_EXP*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv::ximgproc") public static native void weightedMedianFilter(@ByVal GpuMat joint, @ByVal GpuMat src, @ByVal GpuMat dst,
                                       int r);



// #endif
// #endif


// Parsed from opencv2/ximgproc/slic.hpp

/*********************************************************************
 * Software License Agreement (BSD License)
 *
 * Copyright (c) 2013
 * Radhakrishna Achanta
 * email : Radhakrishna [dot] Achanta [at] epfl [dot] ch
 * web : http://ivrl.epfl.ch/people/achanta
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.
 *   * Neither the name of the copyright holders nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *********************************************************************/

/*
 "SLIC Superpixels Compared to State-of-the-art Superpixel Methods"
 Radhakrishna Achanta, Appu Shaji, Kevin Smith, Aurelien Lucchi, Pascal Fua,
 and Sabine Susstrunk, IEEE TPAMI, Volume 34, Issue 11, Pages 2274-2282,
 November 2012.

 "SLIC Superpixels" Radhakrishna Achanta, Appu Shaji, Kevin Smith,
 Aurelien Lucchi, Pascal Fua, and Sabine Süsstrunk, EPFL Technical
 Report no. 149300, June 2010.

 OpenCV port by: Cristian Balint <cristian dot balint at gmail dot com>
 */

// #ifndef __OPENCV_SLIC_HPP__
// #define __OPENCV_SLIC_HPP__
// #ifdef __cplusplus

// #include <opencv2/core.hpp>

/** \addtogroup ximgproc_superpixel
 *  \{ */

    /** enum cv::ximgproc::SLICType */
    public static final int SLIC = 100, SLICO = 101, MSLIC = 102;
// Targeting ..\opencv_ximgproc\SuperpixelSLIC.java



/** \brief Initialize a SuperpixelSLIC object
<p>
@param image Image to segment
@param algorithm Chooses the algorithm variant to use:
SLIC segments image using a desired region_size, and in addition SLICO will optimize using adaptive compactness factor,
while MSLIC will optimize using manifold methods resulting in more content-sensitive superpixels.
@param region_size Chooses an average superpixel size measured in pixels
@param ruler Chooses the enforcement of superpixel smoothness factor of superpixel
<p>
The function initializes a SuperpixelSLIC object for the input image. It sets the parameters of choosed
superpixel algorithm, which are: region_size and ruler. It preallocate some buffers for future
computing iterations over the given image. For enanched results it is recommended for color images to
preprocess image with little gaussian blur using a small 3 x 3 kernel and additional conversion into
CieLAB color space. An example of SLIC versus SLICO and MSLIC is ilustrated in the following picture.
<p>
![image](pics/superpixels_slic.png)
 <p>
 */

    @Namespace("cv::ximgproc") public static native @Ptr SuperpixelSLIC createSuperpixelSLIC( @ByVal Mat image, int algorithm/*=cv::ximgproc::SLICO*/,
                                                               int region_size/*=10*/, float ruler/*=10.0f*/ );
    @Namespace("cv::ximgproc") public static native @Ptr SuperpixelSLIC createSuperpixelSLIC( @ByVal Mat image );
    @Namespace("cv::ximgproc") public static native @Ptr SuperpixelSLIC createSuperpixelSLIC( @ByVal UMat image, int algorithm/*=cv::ximgproc::SLICO*/,
                                                               int region_size/*=10*/, float ruler/*=10.0f*/ );
    @Namespace("cv::ximgproc") public static native @Ptr SuperpixelSLIC createSuperpixelSLIC( @ByVal UMat image );
    @Namespace("cv::ximgproc") public static native @Ptr SuperpixelSLIC createSuperpixelSLIC( @ByVal GpuMat image, int algorithm/*=cv::ximgproc::SLICO*/,
                                                               int region_size/*=10*/, float ruler/*=10.0f*/ );
    @Namespace("cv::ximgproc") public static native @Ptr SuperpixelSLIC createSuperpixelSLIC( @ByVal GpuMat image );

/** \} */



// #endif
// #endif


// Parsed from opencv2/ximgproc/lsc.hpp

/*********************************************************************
 * Software License Agreement (BSD License)
 *
 * Copyright (c) 2014, 2015
 * Zhengqin Li <li-zq12 at mails dot tsinghua dot edu dot cn>
 * Jiansheng Chen <jschenthu at mail dot tsinghua dot edu dot cn>
 * Tsinghua University
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.
 *   * Neither the name of the copyright holders nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *********************************************************************/

/*

 "Superpixel Segmentation using Linear Spectral Clustering"
 Zhengqin Li, Jiansheng Chen, IEEE Conference on Computer Vision and Pattern
 Recognition (CVPR), Jun. 2015

 OpenCV port by: Cristian Balint <cristian dot balint at gmail dot com>
 */

// #ifndef __OPENCV_LSC_HPP__
// #define __OPENCV_LSC_HPP__
// #ifdef __cplusplus

// #include <opencv2/core.hpp>
// Targeting ..\opencv_ximgproc\SuperpixelLSC.java



/** \brief Class implementing the LSC (Linear Spectral Clustering) superpixels
<p>
@param image Image to segment
@param region_size Chooses an average superpixel size measured in pixels
@param ratio Chooses the enforcement of superpixel compactness factor of superpixel
<p>
The function initializes a SuperpixelLSC object for the input image. It sets the parameters of
superpixel algorithm, which are: region_size and ruler. It preallocate some buffers for future
computing iterations over the given image. An example of LSC is ilustrated in the following picture.
For enanched results it is recommended for color images to preprocess image with little gaussian blur
with a small 3 x 3 kernel and additional conversion into CieLAB color space.
<p>
![image](pics/superpixels_lsc.png)
 <p>
 */

    @Namespace("cv::ximgproc") public static native @Ptr SuperpixelLSC createSuperpixelLSC( @ByVal Mat image, int region_size/*=10*/, float ratio/*=0.075f*/ );
    @Namespace("cv::ximgproc") public static native @Ptr SuperpixelLSC createSuperpixelLSC( @ByVal Mat image );
    @Namespace("cv::ximgproc") public static native @Ptr SuperpixelLSC createSuperpixelLSC( @ByVal UMat image, int region_size/*=10*/, float ratio/*=0.075f*/ );
    @Namespace("cv::ximgproc") public static native @Ptr SuperpixelLSC createSuperpixelLSC( @ByVal UMat image );
    @Namespace("cv::ximgproc") public static native @Ptr SuperpixelLSC createSuperpixelLSC( @ByVal GpuMat image, int region_size/*=10*/, float ratio/*=0.075f*/ );
    @Namespace("cv::ximgproc") public static native @Ptr SuperpixelLSC createSuperpixelLSC( @ByVal GpuMat image );

/** \} */



// #endif
// #endif


// Parsed from opencv2/ximgproc/paillou_filter.hpp

/*
 *  By downloading, copying, installing or using the software you agree to this license.
 *  If you do not agree to this license, do not download, install,
 *  copy or use the software.
 *
 *
 *  License Agreement
 *  For Open Source Computer Vision Library
 *  (3 - clause BSD License)
 *
 *  Redistribution and use in source and binary forms, with or without modification,
 *  are permitted provided that the following conditions are met :
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and / or other materials provided with the distribution.
 *
 *  * Neither the names of the copyright holders nor the names of the contributors
 *  may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  This software is provided by the copyright holders and contributors "as is" and
 *  any express or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose are disclaimed.
 *  In no event shall copyright holders or contributors be liable for any direct,
 *  indirect, incidental, special, exemplary, or consequential damages
 *  (including, but not limited to, procurement of substitute goods or services;
 *  loss of use, data, or profits; or business interruption) however caused
 *  and on any theory of liability, whether in contract, strict liability,
 *  or tort(including negligence or otherwise) arising in any way out of
 *  the use of this software, even if advised of the possibility of such damage.
 */

// #ifndef __OPENCV_PAILLOUFILTER_HPP__
// #define __OPENCV_PAILLOUFILTER_HPP__
// #ifdef __cplusplus

// #include <opencv2/core.hpp>

/** \addtogroup ximgproc_filters
 *  \{
<p>
/**
* \brief   Applies Paillou filter to an image.
*
* For more details about this implementation, please see \cite paillou1997detecting
*
* @param   op          Source CV_8U(S) or CV_16U(S), 1-channel or 3-channels image.
* @param   _dst        result CV_32F image with same number of channel than op.
* @param   omega double see paper
* @param   alpha double see paper
*
* @see GradientPaillouX, GradientPaillouY
*/
@Namespace("cv::ximgproc") public static native void GradientPaillouY(@ByVal Mat op, @ByVal Mat _dst, double alpha, double omega);
@Namespace("cv::ximgproc") public static native void GradientPaillouY(@ByVal UMat op, @ByVal UMat _dst, double alpha, double omega);
@Namespace("cv::ximgproc") public static native void GradientPaillouY(@ByVal GpuMat op, @ByVal GpuMat _dst, double alpha, double omega);
@Namespace("cv::ximgproc") public static native void GradientPaillouX(@ByVal Mat op, @ByVal Mat _dst, double alpha, double omega);
@Namespace("cv::ximgproc") public static native void GradientPaillouX(@ByVal UMat op, @ByVal UMat _dst, double alpha, double omega);
@Namespace("cv::ximgproc") public static native void GradientPaillouX(@ByVal GpuMat op, @ByVal GpuMat _dst, double alpha, double omega);



// #endif
// #endif


// Parsed from opencv2/ximgproc/fast_line_detector.hpp

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

// #ifndef __OPENCV_FAST_LINE_DETECTOR_HPP__
// #define __OPENCV_FAST_LINE_DETECTOR_HPP__

// #include <opencv2/core.hpp>
// Targeting ..\opencv_ximgproc\FastLineDetector.java



/** \brief Creates a smart pointer to a FastLineDetector object and initializes it
<p>
@param _length_threshold    10         - Segment shorter than this will be discarded
@param _distance_threshold  1.41421356 - A point placed from a hypothesis line
                                         segment farther than this will be
                                         regarded as an outlier
@param _canny_th1           50         - First threshold for
                                         hysteresis procedure in Canny()
@param _canny_th2           50         - Second threshold for
                                         hysteresis procedure in Canny()
@param _canny_aperture_size 3          - Aperturesize for the sobel operator in Canny().
                                         If zero, Canny() is not applied and the input
                                         image is taken as an edge image.
@param _do_merge            false      - If true, incremental merging of segments
                                         will be perfomred
*/
@Namespace("cv::ximgproc") public static native @Ptr FastLineDetector createFastLineDetector(
        int _length_threshold/*=10*/, float _distance_threshold/*=1.414213562f*/,
        double _canny_th1/*=50.0*/, double _canny_th2/*=50.0*/, int _canny_aperture_size/*=3*/,
        @Cast("bool") boolean _do_merge/*=false*/);
@Namespace("cv::ximgproc") public static native @Ptr FastLineDetector createFastLineDetector();

/** \} ximgproc_fast_line_detector */


// #endif


// Parsed from opencv2/ximgproc/deriche_filter.hpp

/*
 *  By downloading, copying, installing or using the software you agree to this license.
 *  If you do not agree to this license, do not download, install,
 *  copy or use the software.
 *
 *
 *  License Agreement
 *  For Open Source Computer Vision Library
 *  (3 - clause BSD License)
 *
 *  Redistribution and use in source and binary forms, with or without modification,
 *  are permitted provided that the following conditions are met :
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and / or other materials provided with the distribution.
 *
 *  * Neither the names of the copyright holders nor the names of the contributors
 *  may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  This software is provided by the copyright holders and contributors "as is" and
 *  any express or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose are disclaimed.
 *  In no event shall copyright holders or contributors be liable for any direct,
 *  indirect, incidental, special, exemplary, or consequential damages
 *  (including, but not limited to, procurement of substitute goods or services;
 *  loss of use, data, or profits; or business interruption) however caused
 *  and on any theory of liability, whether in contract, strict liability,
 *  or tort(including negligence or otherwise) arising in any way out of
 *  the use of this software, even if advised of the possibility of such damage.
 */

// #ifndef __OPENCV_DERICHEFILTER_HPP__
// #define __OPENCV_DERICHEFILTER_HPP__
// #ifdef __cplusplus

// #include <opencv2/core.hpp>

/** \addtogroup ximgproc_filters
 *  \{
<p>
/**
* \brief   Applies Y Deriche filter to an image.
*
* For more details about this implementation, please see http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.476.5736&rep=rep1&type=pdf
*
* @param   op         Source 8-bit or 16bit image, 1-channel or 3-channel image.
* @param   dst        result CV_32FC image with same number of channel than _op.
* @param   alpha double see paper
* @param   omega   double see paper
*
*/
@Namespace("cv::ximgproc") public static native void GradientDericheY(@ByVal Mat op, @ByVal Mat dst, double alpha,double omega);
@Namespace("cv::ximgproc") public static native void GradientDericheY(@ByVal UMat op, @ByVal UMat dst, double alpha,double omega);
@Namespace("cv::ximgproc") public static native void GradientDericheY(@ByVal GpuMat op, @ByVal GpuMat dst, double alpha,double omega);
/**
* \brief   Applies X Deriche filter to an image.
*
* For more details about this implementation, please see http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.476.5736&rep=rep1&type=pdf
*
* @param   op         Source 8-bit or 16bit image, 1-channel or 3-channel image.
* @param   dst        result CV_32FC image with same number of channel than _op.
* @param   alpha double see paper
* @param   omega   double see paper
*
*/
@Namespace("cv::ximgproc") public static native void GradientDericheX(@ByVal Mat op, @ByVal Mat dst, double alpha,double omega);
@Namespace("cv::ximgproc") public static native void GradientDericheX(@ByVal UMat op, @ByVal UMat dst, double alpha,double omega);
@Namespace("cv::ximgproc") public static native void GradientDericheX(@ByVal GpuMat op, @ByVal GpuMat dst, double alpha,double omega);



// #endif
// #endif


// Parsed from opencv2/ximgproc/peilin.hpp

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

// #ifndef __OPENCV_PEILIN_HPP__
// #define __OPENCV_PEILIN_HPP__

// #include <opencv2/core.hpp>

    /** \addtogroup ximgproc
     *  \{
    <p>
    /**
    * \brief   Calculates an affine transformation that normalize given image using Pei&Lin Normalization.
    *
    * Assume given image {@code I=T(\bar{I})} where {@code \bar{I}} is a normalized image and {@code T} is an affine transformation distorting this image by translation, rotation, scaling and skew.
    * The function returns an affine transformation matrix corresponding to the transformation {@code T^{-1}} described in [PeiLin95].
    * For more details about this implementation, please see
    * [PeiLin95] Soo-Chang Pei and Chao-Nan Lin. Image normalization for pattern recognition. Image and Vision Computing, Vol. 13, N.10, pp. 711-723, 1995.
    *
    * @param I Given transformed image.
    * @return Transformation matrix corresponding to inversed image transformation
    */
    @Namespace("cv::ximgproc") public static native @ByVal @Cast("cv::Matx23d*") DoublePointer PeiLinNormalization( @ByVal Mat I );
    @Namespace("cv::ximgproc") public static native @ByVal @Cast("cv::Matx23d*") DoublePointer PeiLinNormalization( @ByVal UMat I );
    @Namespace("cv::ximgproc") public static native @ByVal @Cast("cv::Matx23d*") DoublePointer PeiLinNormalization( @ByVal GpuMat I );
    /** \overload */
    @Namespace("cv::ximgproc") public static native void PeiLinNormalization( @ByVal Mat I, @ByVal Mat T );
    @Namespace("cv::ximgproc") public static native void PeiLinNormalization( @ByVal UMat I, @ByVal UMat T );
    @Namespace("cv::ximgproc") public static native void PeiLinNormalization( @ByVal GpuMat I, @ByVal GpuMat T );

 // namespace

// #endif


// Parsed from opencv2/ximgproc/fourier_descriptors.hpp

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

// #ifndef __OPENCV_FOURIERDESCRIPTORS_HPP__
// #define __OPENCV_FOURIERDESCRIPTORS_HPP__

// #include <opencv2/core.hpp>
// Targeting ..\opencv_ximgproc\ContourFitting.java


    /**
    * \brief   Fourier descriptors for planed closed curves
    *
    * For more details about this implementation, please see \cite PersoonFu1977
    *
    * @param   src   contour type vector<Point> , vector<Point2f>  or vector<Point2d>
    * @param   dst   Mat of type CV_64FC2 and nbElt rows A VERIFIER
    * @param   nbElt number of rows in dst or getOptimalDFTSize rows if nbElt=-1
    * @param   nbFD number of FD return in dst dst = [FD(1...nbFD/2) FD(nbFD/2-nbElt+1...:nbElt)]
    *
    */
    @Namespace("cv::ximgproc") public static native void fourierDescriptor(@ByVal Mat src, @ByVal Mat dst, int nbElt/*=-1*/,int nbFD/*=-1*/);
    @Namespace("cv::ximgproc") public static native void fourierDescriptor(@ByVal Mat src, @ByVal Mat dst);
    @Namespace("cv::ximgproc") public static native void fourierDescriptor(@ByVal UMat src, @ByVal UMat dst, int nbElt/*=-1*/,int nbFD/*=-1*/);
    @Namespace("cv::ximgproc") public static native void fourierDescriptor(@ByVal UMat src, @ByVal UMat dst);
    @Namespace("cv::ximgproc") public static native void fourierDescriptor(@ByVal GpuMat src, @ByVal GpuMat dst, int nbElt/*=-1*/,int nbFD/*=-1*/);
    @Namespace("cv::ximgproc") public static native void fourierDescriptor(@ByVal GpuMat src, @ByVal GpuMat dst);
    /**
    * \brief   transform a contour
    *
    * @param   src   contour or Fourier Descriptors if fd is true
    * @param   t   transform Mat given by estimateTransformation
    * @param   dst   Mat of type CV_64FC2 and nbElt rows
    * @param   fdContour true src are Fourier Descriptors. fdContour false src is a contour
    *
    */
    @Namespace("cv::ximgproc") public static native void transformFD(@ByVal Mat src, @ByVal Mat t,@ByVal Mat dst, @Cast("bool") boolean fdContour/*=true*/);
    @Namespace("cv::ximgproc") public static native void transformFD(@ByVal Mat src, @ByVal Mat t,@ByVal Mat dst);
    @Namespace("cv::ximgproc") public static native void transformFD(@ByVal UMat src, @ByVal UMat t,@ByVal UMat dst, @Cast("bool") boolean fdContour/*=true*/);
    @Namespace("cv::ximgproc") public static native void transformFD(@ByVal UMat src, @ByVal UMat t,@ByVal UMat dst);
    @Namespace("cv::ximgproc") public static native void transformFD(@ByVal GpuMat src, @ByVal GpuMat t,@ByVal GpuMat dst, @Cast("bool") boolean fdContour/*=true*/);
    @Namespace("cv::ximgproc") public static native void transformFD(@ByVal GpuMat src, @ByVal GpuMat t,@ByVal GpuMat dst);
    /**
    * \brief   Contour sampling .
    *
    * @param   src   contour type vector<Point> , vector<Point2f>  or vector<Point2d>
    * @param   out   Mat of type CV_64FC2 and nbElt rows
    * @param   nbElt number of points in out contour
    *
    */
    @Namespace("cv::ximgproc") public static native void contourSampling(@ByVal Mat src, @ByVal Mat out, int nbElt);
    @Namespace("cv::ximgproc") public static native void contourSampling(@ByVal UMat src, @ByVal UMat out, int nbElt);
    @Namespace("cv::ximgproc") public static native void contourSampling(@ByVal GpuMat src, @ByVal GpuMat out, int nbElt);

    /**
    * \brief create ContourFitting algorithm object
    *
    * @param ctr number of Fourier descriptors equal to number of contour points after resampling.
    * @param fd Contour defining second shape (Target).
    */
    @Namespace("cv::ximgproc") public static native @Ptr ContourFitting createContourFitting(int ctr/*=1024*/, int fd/*=16*/);
    @Namespace("cv::ximgproc") public static native @Ptr ContourFitting createContourFitting();

    /** \} ximgproc_fourier */


// #endif


// Parsed from opencv2/ximgproc/ridgefilter.hpp

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

/*
Ridge Detection Filter.
OpenCV port by : Kushal Vyas (@kushalvyas), Venkatesh Vijaykumar(@venkateshvijaykumar)
Adapted from Niki Estner's explanation of RidgeFilter.
*/

// #ifndef __OPENCV_XIMGPROC_RIDGEFILTER_HPP__
// #define __OPENCV_XIMGPROC_RIDGEFILTER_HPP__

// #include <opencv2/core.hpp>
// Targeting ..\opencv_ximgproc\RidgeDetectionFilter.java



/** \} */
 // namespace
// #endif


// Parsed from opencv2/ximgproc/brightedges.hpp

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2017, IBM Corporation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// @Authors
//      Marc Fiammante marc.fiammante@fr.ibm.com
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of OpenCV Foundation or contributors may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the OpenCV Foundation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/
// #ifndef __OPENCV_BRIGHTEDGES_HPP__
// #define __OPENCV_BRIGHTEDGES_HPP__

// #include "opencv2/core.hpp"
        @Namespace("cv::ximgproc") public static native void BrightEdges(@ByRef Mat _original, @ByRef Mat _edgeview, int contrast/*=1*/, int shortrange/*=3*/, int longrange/*=9*/);
        @Namespace("cv::ximgproc") public static native void BrightEdges(@ByRef Mat _original, @ByRef Mat _edgeview);
    

// #endif


// Parsed from opencv2/ximgproc/run_length_morphology.hpp

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

// #ifndef __OPENCV_RUN_LENGTH_MORPHOLOGY_HPP__
// #define __OPENCV_RUN_LENGTH_MORPHOLOGY_HPP__

// #include <opencv2/core.hpp>


/** \addtogroup ximgproc_run_length_morphology
 *  \{
<p>
/**
* \brief   Applies a fixed-level threshold to each array element.
*
*
* @param   src         input array (single-channel).
* @param   rlDest      resulting run length encoded image.
* @param   thresh      threshold value.
* @param   type        thresholding type (only cv::THRESH_BINARY and cv::THRESH_BINARY_INV are supported)
*
*/
@Namespace("cv::ximgproc::rl") public static native void threshold(@ByVal Mat src, @ByVal Mat rlDest, double thresh, int type);
@Namespace("cv::ximgproc::rl") public static native void threshold(@ByVal UMat src, @ByVal UMat rlDest, double thresh, int type);
@Namespace("cv::ximgproc::rl") public static native void threshold(@ByVal GpuMat src, @ByVal GpuMat rlDest, double thresh, int type);


/**
* \brief   Dilates an run-length encoded binary image by using a specific structuring element.
*
*
* @param   rlSrc       input image
* @param   rlDest      result
* @param   rlKernel    kernel
* @param   anchor      position of the anchor within the element; default value (0, 0)
*                      is usually the element center.
*
*/
@Namespace("cv::ximgproc::rl") public static native void dilate(@ByVal Mat rlSrc, @ByVal Mat rlDest, @ByVal Mat rlKernel, @ByVal(nullValue = "cv::Point(0, 0)") Point anchor);
@Namespace("cv::ximgproc::rl") public static native void dilate(@ByVal Mat rlSrc, @ByVal Mat rlDest, @ByVal Mat rlKernel);
@Namespace("cv::ximgproc::rl") public static native void dilate(@ByVal UMat rlSrc, @ByVal UMat rlDest, @ByVal UMat rlKernel, @ByVal(nullValue = "cv::Point(0, 0)") Point anchor);
@Namespace("cv::ximgproc::rl") public static native void dilate(@ByVal UMat rlSrc, @ByVal UMat rlDest, @ByVal UMat rlKernel);
@Namespace("cv::ximgproc::rl") public static native void dilate(@ByVal GpuMat rlSrc, @ByVal GpuMat rlDest, @ByVal GpuMat rlKernel, @ByVal(nullValue = "cv::Point(0, 0)") Point anchor);
@Namespace("cv::ximgproc::rl") public static native void dilate(@ByVal GpuMat rlSrc, @ByVal GpuMat rlDest, @ByVal GpuMat rlKernel);

/**
* \brief   Erodes an run-length encoded binary image by using a specific structuring element.
*
*
* @param   rlSrc       input image
* @param   rlDest      result
* @param   rlKernel    kernel
* @param   bBoundaryOn indicates whether pixel outside the image boundary are assumed to be on
            (True: works in the same way as the default of cv::erode, False: is a little faster)
* @param   anchor      position of the anchor within the element; default value (0, 0)
*                      is usually the element center.
*
*/
@Namespace("cv::ximgproc::rl") public static native void erode(@ByVal Mat rlSrc, @ByVal Mat rlDest, @ByVal Mat rlKernel,
    @Cast("bool") boolean bBoundaryOn/*=true*/, @ByVal(nullValue = "cv::Point(0, 0)") Point anchor);
@Namespace("cv::ximgproc::rl") public static native void erode(@ByVal Mat rlSrc, @ByVal Mat rlDest, @ByVal Mat rlKernel);
@Namespace("cv::ximgproc::rl") public static native void erode(@ByVal UMat rlSrc, @ByVal UMat rlDest, @ByVal UMat rlKernel,
    @Cast("bool") boolean bBoundaryOn/*=true*/, @ByVal(nullValue = "cv::Point(0, 0)") Point anchor);
@Namespace("cv::ximgproc::rl") public static native void erode(@ByVal UMat rlSrc, @ByVal UMat rlDest, @ByVal UMat rlKernel);
@Namespace("cv::ximgproc::rl") public static native void erode(@ByVal GpuMat rlSrc, @ByVal GpuMat rlDest, @ByVal GpuMat rlKernel,
    @Cast("bool") boolean bBoundaryOn/*=true*/, @ByVal(nullValue = "cv::Point(0, 0)") Point anchor);
@Namespace("cv::ximgproc::rl") public static native void erode(@ByVal GpuMat rlSrc, @ByVal GpuMat rlDest, @ByVal GpuMat rlKernel);

/**
* \brief   Returns a run length encoded structuring element of the specified size and shape.
*
*
* @param   shape	Element shape that can be one of cv::MorphShapes
* @param   ksize	Size of the structuring element.
*
*/
@Namespace("cv::ximgproc::rl") public static native @ByVal Mat getStructuringElement(int shape, @ByVal Size ksize);

/**
* \brief   Paint run length encoded binary image into an image.
*
*
* @param   image       image to paint into (currently only single channel images).
* @param   rlSrc       run length encoded image
* @param   value      all foreground pixel of the binary image are set to this value
*
*/
@Namespace("cv::ximgproc::rl") public static native void paint(@ByVal Mat image, @ByVal Mat rlSrc, @Const @ByRef Scalar value);
@Namespace("cv::ximgproc::rl") public static native void paint(@ByVal UMat image, @ByVal UMat rlSrc, @Const @ByRef Scalar value);
@Namespace("cv::ximgproc::rl") public static native void paint(@ByVal GpuMat image, @ByVal GpuMat rlSrc, @Const @ByRef Scalar value);

/**
* \brief   Check whether a custom made structuring element can be used with run length morphological operations.
*          (It must consist of a continuous array of single runs per row)
*
* @param   rlStructuringElement   mask to be tested
*/
@Namespace("cv::ximgproc::rl") public static native @Cast("bool") boolean isRLMorphologyPossible(@ByVal Mat rlStructuringElement);
@Namespace("cv::ximgproc::rl") public static native @Cast("bool") boolean isRLMorphologyPossible(@ByVal UMat rlStructuringElement);
@Namespace("cv::ximgproc::rl") public static native @Cast("bool") boolean isRLMorphologyPossible(@ByVal GpuMat rlStructuringElement);

/**
* \brief   Creates a run-length encoded image from a vector of runs (column begin, column end, row)
*
* @param   runs   vector of runs
* @param   res    result
* @param   size   image size (to be used if an "on" boundary should be used in erosion, using the default
*                  means that the size is computed from the extension of the input)
*/
@Namespace("cv::ximgproc::rl") public static native void createRLEImage(@Cast("std::vector<cv::Point3i>*") @ByRef Point3iVector runs, @ByVal Mat res, @ByVal(nullValue = "cv::Size(0, 0)") Size size);
@Namespace("cv::ximgproc::rl") public static native void createRLEImage(@Cast("std::vector<cv::Point3i>*") @ByRef Point3iVector runs, @ByVal Mat res);
@Namespace("cv::ximgproc::rl") public static native void createRLEImage(@Cast("std::vector<cv::Point3i>*") @ByRef Point3iVector runs, @ByVal UMat res, @ByVal(nullValue = "cv::Size(0, 0)") Size size);
@Namespace("cv::ximgproc::rl") public static native void createRLEImage(@Cast("std::vector<cv::Point3i>*") @ByRef Point3iVector runs, @ByVal UMat res);
@Namespace("cv::ximgproc::rl") public static native void createRLEImage(@Cast("std::vector<cv::Point3i>*") @ByRef Point3iVector runs, @ByVal GpuMat res, @ByVal(nullValue = "cv::Size(0, 0)") Size size);
@Namespace("cv::ximgproc::rl") public static native void createRLEImage(@Cast("std::vector<cv::Point3i>*") @ByRef Point3iVector runs, @ByVal GpuMat res);

/**
* \brief   Applies a morphological operation to a run-length encoded binary image.
*
*
* @param   rlSrc       input image
* @param   rlDest      result
* @param   op          all operations supported by cv::morphologyEx (except cv::MORPH_HITMISS)
* @param   rlKernel    kernel
* @param   bBoundaryOnForErosion indicates whether pixel outside the image boundary are assumed
*          to be on for erosion operations (True: works in the same way as the default of cv::erode,
*          False: is a little faster)
* @param   anchor      position of the anchor within the element; default value (0, 0) is usually the element center.
*
*/
@Namespace("cv::ximgproc::rl") public static native void morphologyEx(@ByVal Mat rlSrc, @ByVal Mat rlDest, int op, @ByVal Mat rlKernel,
    @Cast("bool") boolean bBoundaryOnForErosion/*=true*/, @ByVal(nullValue = "cv::Point(0,0)") Point anchor);
@Namespace("cv::ximgproc::rl") public static native void morphologyEx(@ByVal Mat rlSrc, @ByVal Mat rlDest, int op, @ByVal Mat rlKernel);
@Namespace("cv::ximgproc::rl") public static native void morphologyEx(@ByVal UMat rlSrc, @ByVal UMat rlDest, int op, @ByVal UMat rlKernel,
    @Cast("bool") boolean bBoundaryOnForErosion/*=true*/, @ByVal(nullValue = "cv::Point(0,0)") Point anchor);
@Namespace("cv::ximgproc::rl") public static native void morphologyEx(@ByVal UMat rlSrc, @ByVal UMat rlDest, int op, @ByVal UMat rlKernel);
@Namespace("cv::ximgproc::rl") public static native void morphologyEx(@ByVal GpuMat rlSrc, @ByVal GpuMat rlDest, int op, @ByVal GpuMat rlKernel,
    @Cast("bool") boolean bBoundaryOnForErosion/*=true*/, @ByVal(nullValue = "cv::Point(0,0)") Point anchor);
@Namespace("cv::ximgproc::rl") public static native void morphologyEx(@ByVal GpuMat rlSrc, @ByVal GpuMat rlDest, int op, @ByVal GpuMat rlKernel);




// #endif


// Parsed from opencv2/ximgproc/edgepreserving_filter.hpp

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

// #ifndef __OPENCV_EDGEPRESERVINGFILTER_HPP__
// #define __OPENCV_EDGEPRESERVINGFILTER_HPP__

// #include <opencv2/core.hpp>

/** \addtogroup ximgproc
 *  \{
    <p>
    /**
    * \brief Smoothes an image using the Edge-Preserving filter.
    *
    * The function smoothes Gaussian noise as well as salt & pepper noise.
    * For more details about this implementation, please see
    * [ReiWoe18]  Reich, S. and Wörgötter, F. and Dellen, B. (2018). A Real-Time Edge-Preserving Denoising Filter. Proceedings of the 13th International Joint Conference on Computer Vision, Imaging and Computer Graphics Theory and Applications (VISIGRAPP): Visapp, 85-94, 4. DOI: 10.5220/0006509000850094.
    *
    * @param src Source 8-bit 3-channel image.
    * @param dst Destination image of the same size and type as src.
    * @param d Diameter of each pixel neighborhood that is used during filtering. Must be greater or equal 3.
    * @param threshold Threshold, which distinguishes between noise, outliers, and data.
    */
    @Namespace("cv::ximgproc") public static native void edgePreservingFilter( @ByVal Mat src, @ByVal Mat dst, int d, double threshold );
    @Namespace("cv::ximgproc") public static native void edgePreservingFilter( @ByVal UMat src, @ByVal UMat dst, int d, double threshold );
    @Namespace("cv::ximgproc") public static native void edgePreservingFilter( @ByVal GpuMat src, @ByVal GpuMat dst, int d, double threshold );

 // namespace

/** \} */

// #endif


// Parsed from opencv2/ximgproc/color_match.hpp

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

// #ifndef __OPENCV_COLOR_MATCH_HPP__
// #define __OPENCV_COLOR_MATCH_HPP__

// #include <opencv2/core.hpp>

/** \addtogroup ximgproc_filters
 *  \{
<p>
/**
* \brief   creates a quaternion image.
*
* @param   img         Source 8-bit, 32-bit or 64-bit image, with 3-channel image.
* @param   qimg        result CV_64FC4 a quaternion image( 4 chanels zero channel and B,G,R).
*/
@Namespace("cv::ximgproc") public static native void createQuaternionImage(@ByVal Mat img, @ByVal Mat qimg);
@Namespace("cv::ximgproc") public static native void createQuaternionImage(@ByVal UMat img, @ByVal UMat qimg);
@Namespace("cv::ximgproc") public static native void createQuaternionImage(@ByVal GpuMat img, @ByVal GpuMat qimg);

/**
* \brief   calculates conjugate of a quaternion image.
*
* @param   qimg         quaternion image.
* @param   qcimg        conjugate of qimg
*/
@Namespace("cv::ximgproc") public static native void qconj(@ByVal Mat qimg, @ByVal Mat qcimg);
@Namespace("cv::ximgproc") public static native void qconj(@ByVal UMat qimg, @ByVal UMat qcimg);
@Namespace("cv::ximgproc") public static native void qconj(@ByVal GpuMat qimg, @ByVal GpuMat qcimg);
/**
* \brief   divides each element by its modulus.
*
* @param   qimg         quaternion image.
* @param   qnimg        conjugate of qimg
*/
@Namespace("cv::ximgproc") public static native void qunitary(@ByVal Mat qimg, @ByVal Mat qnimg);
@Namespace("cv::ximgproc") public static native void qunitary(@ByVal UMat qimg, @ByVal UMat qnimg);
@Namespace("cv::ximgproc") public static native void qunitary(@ByVal GpuMat qimg, @ByVal GpuMat qnimg);
/**
* \brief   Calculates the per-element quaternion product of two arrays
*
* @param   src1         quaternion image.
* @param   src2         quaternion image.
* @param   dst        product dst(I)=src1(I) . src2(I)
*/
@Namespace("cv::ximgproc") public static native void qmultiply(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv::ximgproc") public static native void qmultiply(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv::ximgproc") public static native void qmultiply(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);
/**
* \brief    Performs a forward or inverse Discrete quaternion Fourier transform of a 2D quaternion array.
*
* @param   img        quaternion image.
* @param   qimg       quaternion image in dual space.
* @param   flags      quaternion image in dual space. only DFT_INVERSE flags is supported
* @param   sideLeft   true the hypercomplex exponential is to be multiplied on the left (false on the right ).
*/
@Namespace("cv::ximgproc") public static native void qdft(@ByVal Mat img, @ByVal Mat qimg, int flags, @Cast("bool") boolean sideLeft);
@Namespace("cv::ximgproc") public static native void qdft(@ByVal UMat img, @ByVal UMat qimg, int flags, @Cast("bool") boolean sideLeft);
@Namespace("cv::ximgproc") public static native void qdft(@ByVal GpuMat img, @ByVal GpuMat qimg, int flags, @Cast("bool") boolean sideLeft);
/**
* \brief    Compares a color template against overlapped color image regions.
*
* @param   img        Image where the search is running. It must be 3 channels image
* @param   templ       Searched template. It must be not greater than the source image and have 3 channels
* @param   result     Map of comparison results. It must be single-channel 64-bit floating-point
*/
@Namespace("cv::ximgproc") public static native void colorMatchTemplate(@ByVal Mat img, @ByVal Mat templ, @ByVal Mat result);
@Namespace("cv::ximgproc") public static native void colorMatchTemplate(@ByVal UMat img, @ByVal UMat templ, @ByVal UMat result);
@Namespace("cv::ximgproc") public static native void colorMatchTemplate(@ByVal GpuMat img, @ByVal GpuMat templ, @ByVal GpuMat result);



// #endif


}
