// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_core;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.opencv.global.opencv_core.*;


/** \addtogroup core_async
<p>
\{
*/


/** \brief Returns result of asynchronous operations
<p>
Object has attached asynchronous state.
Assignment operator doesn't clone asynchronous state (it is shared between all instances).
<p>
Result can be fetched via get() method only once.
<p>
*/
@Namespace("cv") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_core.class)
public class AsyncArray extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AsyncArray(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AsyncArray(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public AsyncArray position(long position) {
        return (AsyncArray)super.position(position);
    }
    @Override public AsyncArray getPointer(long i) {
        return new AsyncArray((Pointer)this).position(position + i);
    }

    public AsyncArray() { super((Pointer)null); allocate(); }
    @NoException private native void allocate();
    public AsyncArray(@Const @ByRef AsyncArray o) { super((Pointer)null); allocate(o); }
    @NoException private native void allocate(@Const @ByRef AsyncArray o);
    public native @ByRef @Name("operator =") @NoException AsyncArray put(@Const @ByRef AsyncArray o);
    public native @NoException void release();

    /** Fetch the result.
    @param dst [out] destination array
    <p>
    Waits for result until container has valid result.
    Throws exception if exception was stored as a result.
    <p>
    Throws exception on invalid container state.
    <p>
    \note Result or stored exception can be fetched only once.
    */
    public native void get(@ByVal Mat dst);
    public native void get(@ByVal UMat dst);
    public native void get(@ByVal GpuMat dst);

    /** Retrieving the result with timeout
    @param dst [out] destination array
    @param timeoutNs [in] timeout in nanoseconds, -1 for infinite wait
    <p>
    @return true if result is ready, false if the timeout has expired
    <p>
    \note Result or stored exception can be fetched only once.
    */
    public native @Cast("bool") boolean get(@ByVal Mat dst, @Cast("int64") long timeoutNs);
    public native @Cast("bool") boolean get(@ByVal UMat dst, @Cast("int64") long timeoutNs);
    public native @Cast("bool") boolean get(@ByVal GpuMat dst, @Cast("int64") long timeoutNs);

    public native @Cast("bool") boolean get(@ByVal Mat dst, double timeoutNs);
    public native @Cast("bool") boolean get(@ByVal UMat dst, double timeoutNs);
    public native @Cast("bool") boolean get(@ByVal GpuMat dst, double timeoutNs);

    public native @Cast("bool") boolean wait_for(@Cast("int64") long timeoutNs);

    public native @Cast("bool") boolean wait_for(double timeoutNs);

    public native @Cast("bool") @NoException boolean valid();

// #ifdef CV_CXX11
// #endif


    // PImpl
    public native @NoException Pointer _getImpl();
}
