// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.global;

import org.bytedeco.opencv.opencv_calib3d.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;

public class opencv_calib3d extends org.bytedeco.opencv.presets.opencv_calib3d {
    static { Loader.load(); }

// Parsed from <opencv2/calib3d/calib3d_c.h>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CALIB3D_C_H
// #define OPENCV_CALIB3D_C_H

// #include "opencv2/core/types_c.h"

// #ifdef __cplusplus
// #endif

/* Calculates fundamental matrix given a set of corresponding points */
public static final int CV_FM_7POINT = 1;
public static final int CV_FM_8POINT = 2;

public static final int CV_LMEDS = 4;
public static final int CV_RANSAC = 8;

public static final int CV_FM_LMEDS_ONLY =  CV_LMEDS;
public static final int CV_FM_RANSAC_ONLY = CV_RANSAC;
public static final int CV_FM_LMEDS = CV_LMEDS;
public static final int CV_FM_RANSAC = CV_RANSAC;

/** enum  */
public static final int
    CV_ITERATIVE = 0,
    CV_EPNP = 1, // F.Moreno-Noguer, V.Lepetit and P.Fua "EPnP: Efficient Perspective-n-Point Camera Pose Estimation"
    CV_P3P = 2, // X.S. Gao, X.-R. Hou, J. Tang, H.-F. Chang; "Complete Solution Classification for the Perspective-Three-Point Problem"
    CV_DLS = 3; // Joel A. Hesch and Stergios I. Roumeliotis. "A Direct Least-Squares (DLS) Method for PnP"

public static final int CV_CALIB_CB_ADAPTIVE_THRESH =  1;
public static final int CV_CALIB_CB_NORMALIZE_IMAGE =  2;
public static final int CV_CALIB_CB_FILTER_QUADS =     4;
public static final int CV_CALIB_CB_FAST_CHECK =       8;

public static final int CV_CALIB_USE_INTRINSIC_GUESS =  1;
public static final int CV_CALIB_FIX_ASPECT_RATIO =     2;
public static final int CV_CALIB_FIX_PRINCIPAL_POINT =  4;
public static final int CV_CALIB_ZERO_TANGENT_DIST =    8;
public static final int CV_CALIB_FIX_FOCAL_LENGTH = 16;
public static final int CV_CALIB_FIX_K1 =  32;
public static final int CV_CALIB_FIX_K2 =  64;
public static final int CV_CALIB_FIX_K3 =  128;
public static final int CV_CALIB_FIX_K4 =  2048;
public static final int CV_CALIB_FIX_K5 =  4096;
public static final int CV_CALIB_FIX_K6 =  8192;
public static final int CV_CALIB_RATIONAL_MODEL = 16384;
public static final int CV_CALIB_THIN_PRISM_MODEL = 32768;
public static final int CV_CALIB_FIX_S1_S2_S3_S4 =  65536;
public static final int CV_CALIB_TILTED_MODEL =  262144;
public static final int CV_CALIB_FIX_TAUX_TAUY =  524288;
public static final int CV_CALIB_FIX_TANGENT_DIST = 2097152;

public static final int CV_CALIB_NINTRINSIC = 18;

public static final int CV_CALIB_FIX_INTRINSIC =  256;
public static final int CV_CALIB_SAME_FOCAL_LENGTH = 512;

public static final int CV_CALIB_ZERO_DISPARITY = 1024;

/* stereo correspondence parameters and functions */
public static final int CV_STEREO_BM_NORMALIZED_RESPONSE =  0;
public static final int CV_STEREO_BM_XSOBEL =               1;

// #ifdef __cplusplus
// Targeting ../opencv_calib3d/CvLevMarq.java



// #endif

// #endif /* OPENCV_CALIB3D_C_H */


// Parsed from <opencv2/calib3d.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CALIB3D_HPP
// #define OPENCV_CALIB3D_HPP

// #include "opencv2/core.hpp"
// #include "opencv2/features2d.hpp"
// #include "opencv2/core/affine.hpp"

/**
  \defgroup calib3d Camera Calibration and 3D Reconstruction
<p>
The functions in this section use a so-called pinhole camera model. The view of a scene
is obtained by projecting a scene's 3D point {@code P_w} into the image plane using a perspective
transformation which forms the corresponding pixel {@code p}. Both {@code P_w} and {@code p} are
represented in homogeneous coordinates, i.e. as 3D and 2D homogeneous vector respectively. You will
find a brief introduction to projective geometry, homogeneous vectors and homogeneous
transformations at the end of this section's introduction. For more succinct notation, we often drop
the 'homogeneous' and say vector instead of homogeneous vector.
<p>
The distortion-free projective transformation given by a  pinhole camera model is shown below.
<p>
<pre>{@code \[s \; p = A \begin{bmatrix} R|t \end{bmatrix} P_w,\]}</pre>
<p>
where {@code P_w} is a 3D point expressed with respect to the world coordinate system,
{@code p} is a 2D pixel in the image plane, {@code A} is the camera intrinsic matrix,
{@code R} and {@code t} are the rotation and translation that describe the change of coordinates from
world to camera coordinate systems (or camera frame) and {@code s} is the projective transformation's
arbitrary scaling and not part of the camera model.
<p>
The camera intrinsic matrix {@code A} (notation used as in \cite Zhang2000 and also generally notated
as {@code K}) projects 3D points given in the camera coordinate system to 2D pixel coordinates, i.e.
<p>
<pre>{@code \[p = A P_c.\]}</pre>
<p>
The camera intrinsic matrix {@code A} is composed of the focal lengths {@code f_x} and {@code f_y}, which are
expressed in pixel units, and the principal point {@code (c_x, c_y)}, that is usually close to the
image center:
<p>
<pre>{@code \[A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1},\]}</pre>
<p>
and thus
<p>
<pre>{@code \[s \vecthree{u}{v}{1} = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1} \vecthree{X_c}{Y_c}{Z_c}.\]}</pre>
<p>
The matrix of intrinsic parameters does not depend on the scene viewed. So, once estimated, it can
be re-used as long as the focal length is fixed (in case of a zoom lens). Thus, if an image from the
camera is scaled by a factor, all of these parameters need to be scaled (multiplied/divided,
respectively) by the same factor.
<p>
The joint rotation-translation matrix {@code [R|t]} is the matrix product of a projective
transformation and a homogeneous transformation. The 3-by-4 projective transformation maps 3D points
represented in camera coordinates to 2D points in the image plane and represented in normalized
camera coordinates {@code x' = X_c / Z_c} and {@code y' = Y_c / Z_c}:
<p>
<pre>{@code \[Z_c \begin{bmatrix}
x' \\
y' \\
1
\end{bmatrix} = \begin{bmatrix}
1 & 0 & 0 & 0 \\
0 & 1 & 0 & 0 \\
0 & 0 & 1 & 0
\end{bmatrix}
\begin{bmatrix}
X_c \\
Y_c \\
Z_c \\
1
\end{bmatrix}.\]}</pre>
<p>
The homogeneous transformation is encoded by the extrinsic parameters {@code R} and {@code t} and
represents the change of basis from world coordinate system {@code w} to the camera coordinate sytem
{@code c}. Thus, given the representation of the point {@code P} in world coordinates, {@code P_w}, we
obtain {@code P}'s representation in the camera coordinate system, {@code P_c}, by
<p>
<pre>{@code \[P_c = \begin{bmatrix}
R & t \\
0 & 1
\end{bmatrix} P_w,\]}</pre>
<p>
This homogeneous transformation is composed out of {@code R}, a 3-by-3 rotation matrix, and {@code t}, a
3-by-1 translation vector:
<p>
<pre>{@code \[\begin{bmatrix}
R & t \\
0 & 1
\end{bmatrix} = \begin{bmatrix}
r_{11} & r_{12} & r_{13} & t_x \\
r_{21} & r_{22} & r_{23} & t_y \\
r_{31} & r_{32} & r_{33} & t_z \\
0 & 0 & 0 & 1
\end{bmatrix},
\]}</pre>
<p>
and therefore
<p>
<pre>{@code \[\begin{bmatrix}
X_c \\
Y_c \\
Z_c \\
1
\end{bmatrix} = \begin{bmatrix}
r_{11} & r_{12} & r_{13} & t_x \\
r_{21} & r_{22} & r_{23} & t_y \\
r_{31} & r_{32} & r_{33} & t_z \\
0 & 0 & 0 & 1
\end{bmatrix}
\begin{bmatrix}
X_w \\
Y_w \\
Z_w \\
1
\end{bmatrix}.\]}</pre>
<p>
Combining the projective transformation and the homogeneous transformation, we obtain the projective
transformation that maps 3D points in world coordinates into 2D points in the image plane and in
normalized camera coordinates:
<p>
<pre>{@code \[Z_c \begin{bmatrix}
x' \\
y' \\
1
\end{bmatrix} = \begin{bmatrix} R|t \end{bmatrix} \begin{bmatrix}
X_w \\
Y_w \\
Z_w \\
1
\end{bmatrix} = \begin{bmatrix}
r_{11} & r_{12} & r_{13} & t_x \\
r_{21} & r_{22} & r_{23} & t_y \\
r_{31} & r_{32} & r_{33} & t_z
\end{bmatrix}
\begin{bmatrix}
X_w \\
Y_w \\
Z_w \\
1
\end{bmatrix},\]}</pre>
<p>
with {@code x' = X_c / Z_c} and {@code y' = Y_c / Z_c}. Putting the equations for instrincs and extrinsics together, we can write out
{@code s \; p = A \begin{bmatrix} R|t \end{bmatrix} P_w} as
<p>
<pre>{@code \[s \vecthree{u}{v}{1} = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}
\begin{bmatrix}
r_{11} & r_{12} & r_{13} & t_x \\
r_{21} & r_{22} & r_{23} & t_y \\
r_{31} & r_{32} & r_{33} & t_z
\end{bmatrix}
\begin{bmatrix}
X_w \\
Y_w \\
Z_w \\
1
\end{bmatrix}.\]}</pre>
<p>
If {@code Z_c \ne 0}, the transformation above is equivalent to the following,
<p>
<pre>{@code \[\begin{bmatrix}
u \\
v
\end{bmatrix} = \begin{bmatrix}
f_x X_c/Z_c + c_x \\
f_y Y_c/Z_c + c_y
\end{bmatrix}\]}</pre>
<p>
with
<p>
<pre>{@code \[\vecthree{X_c}{Y_c}{Z_c} = \begin{bmatrix}
R|t
\end{bmatrix} \begin{bmatrix}
X_w \\
Y_w \\
Z_w \\
1
\end{bmatrix}.\]}</pre>
<p>
The following figure illustrates the pinhole camera model.
<p>
![Pinhole camera model](pics/pinhole_camera_model.png)
<p>
Real lenses usually have some distortion, mostly radial distortion, and slight tangential distortion.
So, the above model is extended as:
<p>
<pre>{@code \[\begin{bmatrix}
u \\
v
\end{bmatrix} = \begin{bmatrix}
f_x x'' + c_x \\
f_y y'' + c_y
\end{bmatrix}\]}</pre>
<p>
where
<p>
<pre>{@code \[\begin{bmatrix}
x'' \\
y''
\end{bmatrix} = \begin{bmatrix}
x' \frac{1 + k_1 r^2 + k_2 r^4 + k_3 r^6}{1 + k_4 r^2 + k_5 r^4 + k_6 r^6} + 2 p_1 x' y' + p_2(r^2 + 2 x'^2) + s_1 r^2 + s_2 r^4 \\
y' \frac{1 + k_1 r^2 + k_2 r^4 + k_3 r^6}{1 + k_4 r^2 + k_5 r^4 + k_6 r^6} + p_1 (r^2 + 2 y'^2) + 2 p_2 x' y' + s_3 r^2 + s_4 r^4 \\
\end{bmatrix}\]}</pre>
<p>
with
<p>
<pre>{@code \[r^2 = x'^2 + y'^2\]}</pre>
<p>
and
<p>
<pre>{@code \[\begin{bmatrix}
x'\\
y'
\end{bmatrix} = \begin{bmatrix}
X_c/Z_c \\
Y_c/Z_c
\end{bmatrix},\]}</pre>
<p>
if {@code Z_c \ne 0}.
<p>
The distortion parameters are the radial coefficients {@code k_1}, {@code k_2}, {@code k_3}, {@code k_4}, {@code k_5}, and {@code k_6}
,{@code p_1} and {@code p_2} are the tangential distortion coefficients, and {@code s_1}, {@code s_2}, {@code s_3}, and {@code s_4},
are the thin prism distortion coefficients. Higher-order coefficients are not considered in OpenCV.
<p>
The next figures show two common types of radial distortion: barrel distortion
({@code  1 + k_1 r^2 + k_2 r^4 + k_3 r^6 } monotonically decreasing)
and pincushion distortion ({@code  1 + k_1 r^2 + k_2 r^4 + k_3 r^6 } monotonically increasing).
Radial distortion is always monotonic for real lenses,
and if the estimator produces a non-monotonic result,
this should be considered a calibration failure.
More generally, radial distortion must be monotonic and the distortion function must be bijective.
A failed estimation result may look deceptively good near the image center
but will work poorly in e.g. AR/SFM applications.
The optimization method used in OpenCV camera calibration does not include these constraints as
the framework does not support the required integer programming and polynomial inequalities.
See [issue #15992](https://github.com/opencv/opencv/issues/15992) for additional information.
<p>
![](pics/distortion_examples.png)
![](pics/distortion_examples2.png)
<p>
In some cases, the image sensor may be tilted in order to focus an oblique plane in front of the
camera (Scheimpflug principle). This can be useful for particle image velocimetry (PIV) or
triangulation with a laser fan. The tilt causes a perspective distortion of {@code x''} and
{@code y''}. This distortion can be modeled in the following way, see e.g. \cite Louhichi07.
<p>
<pre>{@code \[\begin{bmatrix}
u \\
v
\end{bmatrix} = \begin{bmatrix}
f_x x''' + c_x \\
f_y y''' + c_y
\end{bmatrix},\]}</pre>
<p>
where
<p>
<pre>{@code \[s\vecthree{x'''}{y'''}{1} =
\vecthreethree{R_{33}(\tau_x, \tau_y)}{0}{-R_{13}(\tau_x, \tau_y)}
{0}{R_{33}(\tau_x, \tau_y)}{-R_{23}(\tau_x, \tau_y)}
{0}{0}{1} R(\tau_x, \tau_y) \vecthree{x''}{y''}{1}\]}</pre>
<p>
and the matrix {@code R(\tau_x, \tau_y)} is defined by two rotations with angular parameter
{@code \tau_x} and {@code \tau_y}, respectively,
<p>
<pre>{@code \[
R(\tau_x, \tau_y) =
\vecthreethree{\cos(\tau_y)}{0}{-\sin(\tau_y)}{0}{1}{0}{\sin(\tau_y)}{0}{\cos(\tau_y)}
\vecthreethree{1}{0}{0}{0}{\cos(\tau_x)}{\sin(\tau_x)}{0}{-\sin(\tau_x)}{\cos(\tau_x)} =
\vecthreethree{\cos(\tau_y)}{\sin(\tau_y)\sin(\tau_x)}{-\sin(\tau_y)\cos(\tau_x)}
{0}{\cos(\tau_x)}{\sin(\tau_x)}
{\sin(\tau_y)}{-\cos(\tau_y)\sin(\tau_x)}{\cos(\tau_y)\cos(\tau_x)}.
\]}</pre>
<p>
In the functions below the coefficients are passed or returned as
<p>
<pre>{@code \[(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6 [, s_1, s_2, s_3, s_4[, \tau_x, \tau_y]]]])\]}</pre>
<p>
vector. That is, if the vector contains four elements, it means that {@code k_3=0} . The distortion
coefficients do not depend on the scene viewed. Thus, they also belong to the intrinsic camera
parameters. And they remain the same regardless of the captured image resolution. If, for example, a
camera has been calibrated on images of 320 x 240 resolution, absolutely the same distortion
coefficients can be used for 640 x 480 images from the same camera while {@code f_x}, {@code f_y},
{@code c_x}, and {@code c_y} need to be scaled appropriately.
<p>
The functions below use the above model to do the following:
<p>
-   Project 3D points to the image plane given intrinsic and extrinsic parameters.
-   Compute extrinsic parameters given intrinsic parameters, a few 3D points, and their
projections.
-   Estimate intrinsic and extrinsic camera parameters from several views of a known calibration
pattern (every view is described by several 3D-2D point correspondences).
-   Estimate the relative position and orientation of the stereo camera "heads" and compute the
*rectification* transformation that makes the camera optical axes parallel.
<p>
<B> Homogeneous Coordinates </B><br>
Homogeneous Coordinates are a system of coordinates that are used in projective geometry. Their use
allows to represent points at infinity by finite coordinates and simplifies formulas when compared
to the cartesian counterparts, e.g. they have the advantage that affine transformations can be
expressed as linear homogeneous transformation.
<p>
One obtains the homogeneous vector {@code P_h} by appending a 1 along an n-dimensional cartesian
vector {@code P} e.g. for a 3D cartesian vector the mapping {@code P \rightarrow P_h} is:
<p>
<pre>{@code \[\begin{bmatrix}
X \\
Y \\
Z
\end{bmatrix} \rightarrow \begin{bmatrix}
X \\
Y \\
Z \\
1
\end{bmatrix}.\]}</pre>
<p>
For the inverse mapping {@code P_h \rightarrow P}, one divides all elements of the homogeneous vector
by its last element, e.g. for a 3D homogeneous vector one gets its 2D cartesian counterpart by:
<p>
<pre>{@code \[\begin{bmatrix}
X \\
Y \\
W
\end{bmatrix} \rightarrow \begin{bmatrix}
X / W \\
Y / W
\end{bmatrix},\]}</pre>
<p>
if {@code W \ne 0}.
<p>
Due to this mapping, all multiples {@code k P_h}, for {@code k \ne 0}, of a homogeneous point represent
the same point {@code P_h}. An intuitive understanding of this property is that under a projective
transformation, all multiples of {@code P_h} are mapped to the same point. This is the physical
observation one does for pinhole cameras, as all points along a ray through the camera's pinhole are
projected to the same image point, e.g. all points along the red ray in the image of the pinhole
camera model above would be mapped to the same image coordinate. This property is also the source
for the scale ambiguity s in the equation of the pinhole camera model.
<p>
As mentioned, by using homogeneous coordinates we can express any change of basis parameterized by
{@code R} and {@code t} as a linear transformation, e.g. for the change of basis from coordinate system
0 to coordinate system 1 becomes:
<p>
<pre>{@code \[P_1 = R P_0 + t \rightarrow P_{h_1} = \begin{bmatrix}
R & t \\
0 & 1
\end{bmatrix} P_{h_0}.\]}</pre>
<p>
\note
    -   Many functions in this module take a camera intrinsic matrix as an input parameter. Although all
        functions assume the same structure of this parameter, they may name it differently. The
        parameter's description, however, will be clear in that a camera intrinsic matrix with the structure
        shown above is required.
    -   A calibration sample for 3 cameras in a horizontal position can be found at
        opencv_source_code/samples/cpp/3calibration.cpp
    -   A calibration sample based on a sequence of images can be found at
        opencv_source_code/samples/cpp/calibration.cpp
    -   A calibration sample in order to do 3D reconstruction can be found at
        opencv_source_code/samples/cpp/build3dmodel.cpp
    -   A calibration example on stereo calibration can be found at
        opencv_source_code/samples/cpp/stereo_calib.cpp
    -   A calibration example on stereo matching can be found at
        opencv_source_code/samples/cpp/stereo_match.cpp
    -   (Python) A camera calibration sample can be found at
        opencv_source_code/samples/python/calibrate.py
  <p>
  \{
    \defgroup calib3d_fisheye Fisheye camera model
    <p>
    Definitions: Let P be a point in 3D of coordinates X in the world reference frame (stored in the
    matrix X) The coordinate vector of P in the camera reference frame is:
    <p>
    <pre>{@code \[Xc = R X + T\]}</pre>
    <p>
    where R is the rotation matrix corresponding to the rotation vector om: R = rodrigues(om); call x, y
    and z the 3 coordinates of Xc:
    <p>
    <pre>{@code \[x = Xc_1 \\ y = Xc_2 \\ z = Xc_3\]}</pre>
    <p>
    The pinhole projection coordinates of P is [a; b] where
    <p>
    <pre>{@code \[a = x / z \ and \ b = y / z \\ r^2 = a^2 + b^2 \\ \theta = atan(r)\]}</pre>
    <p>
    Fisheye distortion:
    <p>
    <pre>{@code \[\theta_d = \theta (1 + k_1 \theta^2 + k_2 \theta^4 + k_3 \theta^6 + k_4 \theta^8)\]}</pre>
    <p>
    The distorted point coordinates are [x'; y'] where
    <p>
    <pre>{@code \[x' = (\theta_d / r) a \\ y' = (\theta_d / r) b \]}</pre>
    <p>
    Finally, conversion into pixel coordinates: The final pixel coordinates vector [u; v] where:
    <p>
    <pre>{@code \[u = f_x (x' + \alpha y') + c_x \\
    v = f_y y' + c_y\]}</pre>
    <p>
    \defgroup calib3d_c C API
  <p>
  \}
 */

/** \addtogroup calib3d
 *  \{
 <p>
 *  type of the robust estimation algorithm */
/** enum cv:: */
public static final int /** least-median of squares algorithm */
 LMEDS  = 4,
       /** RANSAC algorithm */
       RANSAC = 8,
       /** RHO algorithm */
       RHO    = 16,
       /** USAC algorithm, default settings */
       USAC_DEFAULT  = 32,
       /** USAC, parallel version */
       USAC_PARALLEL = 33,
       /** USAC, fundamental matrix 8 points */
       USAC_FM_8PTS = 34,
       /** USAC, fast settings */
       USAC_FAST = 35,
       /** USAC, accurate settings */
       USAC_ACCURATE = 36,
       /** USAC, sorted points, runs PROSAC */
       USAC_PROSAC = 37,
       /** USAC, runs MAGSAC++ */
       USAC_MAGSAC = 38;

/** enum cv::SolvePnPMethod */
public static final int
    SOLVEPNP_ITERATIVE   = 0,
    /** EPnP: Efficient Perspective-n-Point Camera Pose Estimation \cite lepetit2009epnp */
    SOLVEPNP_EPNP        = 1,
    /** Complete Solution Classification for the Perspective-Three-Point Problem \cite gao2003complete */
    SOLVEPNP_P3P         = 2,
    /** **Broken implementation. Using this flag will fallback to EPnP.** \n
 *  A Direct Least-Squares (DLS) Method for PnP \cite hesch2011direct */
    SOLVEPNP_DLS         = 3,
    /** **Broken implementation. Using this flag will fallback to EPnP.** \n
 *  Exhaustive Linearization for Robust Camera Pose and Focal Length Estimation \cite penate2013exhaustive */
    SOLVEPNP_UPNP        = 4,
    /** An Efficient Algebraic Solution to the Perspective-Three-Point Problem \cite Ke17 */
    SOLVEPNP_AP3P        = 5,
    /** Infinitesimal Plane-Based Pose Estimation \cite Collins14 \n
 *  Object points must be coplanar. */
    SOLVEPNP_IPPE        = 6,
    /** Infinitesimal Plane-Based Pose Estimation \cite Collins14 \n
 *  This is a special case suitable for marker pose estimation.\n
 *  4 coplanar object points must be defined in the following order:
 *    - point 0: [-squareLength / 2,  squareLength / 2, 0]
 *    - point 1: [ squareLength / 2,  squareLength / 2, 0]
 *    - point 2: [ squareLength / 2, -squareLength / 2, 0]
 *    - point 3: [-squareLength / 2, -squareLength / 2, 0] */
    SOLVEPNP_IPPE_SQUARE = 7,
    /** SQPnP: A Consistently Fast and Globally OptimalSolution to the Perspective-n-Point Problem \cite Terzakis20 */
    SOLVEPNP_SQPNP       = 8,
// #ifndef CV_DOXYGEN
    /** Used for count */
    SOLVEPNP_MAX_COUNT = 9;
// #endif

/** enum cv:: */
public static final int CALIB_CB_ADAPTIVE_THRESH = 1,
       CALIB_CB_NORMALIZE_IMAGE = 2,
       CALIB_CB_FILTER_QUADS    = 4,
       CALIB_CB_FAST_CHECK      = 8,
       CALIB_CB_EXHAUSTIVE      = 16,
       CALIB_CB_ACCURACY        = 32,
       CALIB_CB_LARGER          = 64,
       CALIB_CB_MARKER          = 128;

/** enum cv:: */
public static final int CALIB_CB_SYMMETRIC_GRID  = 1,
       CALIB_CB_ASYMMETRIC_GRID = 2,
       CALIB_CB_CLUSTERING      = 4;

/** enum cv:: */
public static final int CALIB_NINTRINSIC          = 18,
       CALIB_USE_INTRINSIC_GUESS = 0x00001,
       CALIB_FIX_ASPECT_RATIO    = 0x00002,
       CALIB_FIX_PRINCIPAL_POINT = 0x00004,
       CALIB_ZERO_TANGENT_DIST   = 0x00008,
       CALIB_FIX_FOCAL_LENGTH    = 0x00010,
       CALIB_FIX_K1              = 0x00020,
       CALIB_FIX_K2              = 0x00040,
       CALIB_FIX_K3              = 0x00080,
       CALIB_FIX_K4              = 0x00800,
       CALIB_FIX_K5              = 0x01000,
       CALIB_FIX_K6              = 0x02000,
       CALIB_RATIONAL_MODEL      = 0x04000,
       CALIB_THIN_PRISM_MODEL    = 0x08000,
       CALIB_FIX_S1_S2_S3_S4     = 0x10000,
       CALIB_TILTED_MODEL        = 0x40000,
       CALIB_FIX_TAUX_TAUY       = 0x80000,
       /** use QR instead of SVD decomposition for solving. Faster but potentially less precise */
       CALIB_USE_QR              = 0x100000,
       CALIB_FIX_TANGENT_DIST    = 0x200000,
       // only for stereo
       CALIB_FIX_INTRINSIC       = 0x00100,
       CALIB_SAME_FOCAL_LENGTH   = 0x00200,
       // for stereo rectification
       CALIB_ZERO_DISPARITY      = 0x00400,
       /** use LU instead of SVD decomposition for solving. much faster but potentially less precise */
       CALIB_USE_LU              = (1 << 17),
       /** for stereoCalibrate */
       CALIB_USE_EXTRINSIC_GUESS = (1 << 22);

/** the algorithm for finding fundamental matrix */
/** enum cv:: */
public static final int /** 7-point algorithm */
 FM_7POINT = 1,
       /** 8-point algorithm */
       FM_8POINT = 2,
       /** least-median algorithm. 7-point algorithm is used. */
       FM_LMEDS  = 4,
       /** RANSAC algorithm. It needs at least 15 points. 7-point algorithm is used. */
       FM_RANSAC = 8;

/** enum cv::HandEyeCalibrationMethod */
public static final int
    /** A New Technique for Fully Autonomous and Efficient 3D Robotics Hand/Eye Calibration \cite Tsai89 */
    CALIB_HAND_EYE_TSAI         = 0,
    /** Robot Sensor Calibration: Solving AX = XB on the Euclidean Group \cite Park94 */
    CALIB_HAND_EYE_PARK         = 1,
    /** Hand-eye Calibration \cite Horaud95 */
    CALIB_HAND_EYE_HORAUD       = 2,
    /** On-line Hand-Eye Calibration \cite Andreff99 */
    CALIB_HAND_EYE_ANDREFF      = 3,
    /** Hand-Eye Calibration Using Dual Quaternions \cite Daniilidis98 */
    CALIB_HAND_EYE_DANIILIDIS   = 4;

/** enum cv::RobotWorldHandEyeCalibrationMethod */
public static final int
    /** Solving the robot-world/hand-eye calibration problem using the kronecker product \cite Shah2013SolvingTR */
    CALIB_ROBOT_WORLD_HAND_EYE_SHAH = 0,
    /** Simultaneous robot-world and hand-eye calibration using dual-quaternions and kronecker product \cite Li2010SimultaneousRA */
    CALIB_ROBOT_WORLD_HAND_EYE_LI   = 1;

/** enum cv::SamplingMethod */
public static final int SAMPLING_UNIFORM = 0, SAMPLING_PROGRESSIVE_NAPSAC = 1, SAMPLING_NAPSAC = 2,
        SAMPLING_PROSAC = 3;
/** enum cv::LocalOptimMethod */
public static final int LOCAL_OPTIM_NULL = 0, LOCAL_OPTIM_INNER_LO = 1, LOCAL_OPTIM_INNER_AND_ITER_LO = 2,
        LOCAL_OPTIM_GC = 3, LOCAL_OPTIM_SIGMA = 4;
/** enum cv::ScoreMethod */
public static final int SCORE_METHOD_RANSAC = 0, SCORE_METHOD_MSAC = 1, SCORE_METHOD_MAGSAC = 2, SCORE_METHOD_LMEDS = 3;
/** enum cv::NeighborSearchMethod */
public static final int NEIGH_FLANN_KNN = 0, NEIGH_GRID = 1, NEIGH_FLANN_RADIUS = 2;
// Targeting ../opencv_calib3d/UsacParams.java



/** \brief Converts a rotation matrix to a rotation vector or vice versa.
<p>
@param src Input rotation vector (3x1 or 1x3) or rotation matrix (3x3).
@param dst Output rotation matrix (3x3) or rotation vector (3x1 or 1x3), respectively.
@param jacobian Optional output Jacobian matrix, 3x9 or 9x3, which is a matrix of partial
derivatives of the output array components with respect to the input array components.
<p>
<pre>{@code \[\begin{array}{l} \theta \leftarrow norm(r) \\ r  \leftarrow r/ \theta \\ R =  \cos(\theta) I + (1- \cos{\theta} ) r r^T +  \sin(\theta) \vecthreethree{0}{-r_z}{r_y}{r_z}{0}{-r_x}{-r_y}{r_x}{0} \end{array}\]}</pre>
<p>
Inverse transformation can be also done easily, since
<p>
<pre>{@code \[\sin ( \theta ) \vecthreethree{0}{-r_z}{r_y}{r_z}{0}{-r_x}{-r_y}{r_x}{0} = \frac{R - R^T}{2}\]}</pre>
<p>
A rotation vector is a convenient and most compact representation of a rotation matrix (since any
rotation matrix has just 3 degrees of freedom). The representation is used in the global 3D geometry
optimization procedures like \ref calibrateCamera, \ref stereoCalibrate, or \ref solvePnP .
<p>
\note More information about the computation of the derivative of a 3D rotation matrix with respect to its exponential coordinate
can be found in:
    - A Compact Formula for the Derivative of a 3-D Rotation in Exponential Coordinates, Guillermo Gallego, Anthony J. Yezzi \cite Gallego2014ACF
<p>
\note Useful information on SE(3) and Lie Groups can be found in:
    - A tutorial on SE(3) transformation parameterizations and on-manifold optimization, Jose-Luis Blanco \cite blanco2010tutorial
    - Lie Groups for 2D and 3D Transformation, Ethan Eade \cite Eade17
    - A micro Lie theory for state estimation in robotics, Joan Solà, Jérémie Deray, Dinesh Atchuthan \cite Sol2018AML
 */
@Namespace("cv") public static native void Rodrigues( @ByVal Mat src, @ByVal Mat dst, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat jacobian );
@Namespace("cv") public static native void Rodrigues( @ByVal Mat src, @ByVal Mat dst );
@Namespace("cv") public static native void Rodrigues( @ByVal UMat src, @ByVal UMat dst, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat jacobian );
@Namespace("cv") public static native void Rodrigues( @ByVal UMat src, @ByVal UMat dst );
@Namespace("cv") public static native void Rodrigues( @ByVal GpuMat src, @ByVal GpuMat dst, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat jacobian );
@Namespace("cv") public static native void Rodrigues( @ByVal GpuMat src, @ByVal GpuMat dst );
// Targeting ../opencv_calib3d/LMSolver.java





/** \example samples/cpp/tutorial_code/features2D/Homography/pose_from_homography.cpp
An example program about pose estimation from coplanar points
<p>
Check \ref tutorial_homography "the corresponding tutorial" for more details
*/

/** \brief Finds a perspective transformation between two planes.
<p>
@param srcPoints Coordinates of the points in the original plane, a matrix of the type CV_32FC2
or vector\<Point2f\> .
@param dstPoints Coordinates of the points in the target plane, a matrix of the type CV_32FC2 or
a vector\<Point2f\> .
@param method Method used to compute a homography matrix. The following methods are possible:
-   **0** - a regular method using all the points, i.e., the least squares method
-   \ref RANSAC - RANSAC-based robust method
-   \ref LMEDS - Least-Median robust method
-   \ref RHO - PROSAC-based robust method
@param ransacReprojThreshold Maximum allowed reprojection error to treat a point pair as an inlier
(used in the RANSAC and RHO methods only). That is, if
<pre>{@code \[\| \texttt{dstPoints} _i -  \texttt{convertPointsHomogeneous} ( \texttt{H} * \texttt{srcPoints} _i) \|_2  >  \texttt{ransacReprojThreshold}\]}</pre>
then the point {@code i} is considered as an outlier. If srcPoints and dstPoints are measured in pixels,
it usually makes sense to set this parameter somewhere in the range of 1 to 10.
@param mask Optional output mask set by a robust method ( RANSAC or LMeDS ). Note that the input
mask values are ignored.
@param maxIters The maximum number of RANSAC iterations.
@param confidence Confidence level, between 0 and 1.
<p>
The function finds and returns the perspective transformation {@code H} between the source and the
destination planes:
<p>
<pre>{@code \[s_i  \vecthree{x'_i}{y'_i}{1} \sim H  \vecthree{x_i}{y_i}{1}\]}</pre>
<p>
so that the back-projection error
<p>
<pre>{@code \[\sum _i \left ( x'_i- \frac{h_{11} x_i + h_{12} y_i + h_{13}}{h_{31} x_i + h_{32} y_i + h_{33}} \right )^2+ \left ( y'_i- \frac{h_{21} x_i + h_{22} y_i + h_{23}}{h_{31} x_i + h_{32} y_i + h_{33}} \right )^2\]}</pre>
<p>
is minimized. If the parameter method is set to the default value 0, the function uses all the point
pairs to compute an initial homography estimate with a simple least-squares scheme.
<p>
However, if not all of the point pairs ( {@code srcPoints_i}, {@code dstPoints_i} ) fit the rigid perspective
transformation (that is, there are some outliers), this initial estimate will be poor. In this case,
you can use one of the three robust methods. The methods RANSAC, LMeDS and RHO try many different
random subsets of the corresponding point pairs (of four pairs each, collinear pairs are discarded), estimate the homography matrix
using this subset and a simple least-squares algorithm, and then compute the quality/goodness of the
computed homography (which is the number of inliers for RANSAC or the least median re-projection error for
LMeDS). The best subset is then used to produce the initial estimate of the homography matrix and
the mask of inliers/outliers.
<p>
Regardless of the method, robust or not, the computed homography matrix is refined further (using
inliers only in case of a robust method) with the Levenberg-Marquardt method to reduce the
re-projection error even more.
<p>
The methods RANSAC and RHO can handle practically any ratio of outliers but need a threshold to
distinguish inliers from outliers. The method LMeDS does not need any threshold but it works
correctly only when there are more than 50% of inliers. Finally, if there are no outliers and the
noise is rather small, use the default method (method=0).
<p>
The function is used to find initial intrinsic and extrinsic matrices. Homography matrix is
determined up to a scale. Thus, it is normalized so that {@code h_{33}=1}. Note that whenever an {@code H} matrix
cannot be estimated, an empty one will be returned.
<p>
@see
getAffineTransform, estimateAffine2D, estimateAffinePartial2D, getPerspectiveTransform, warpPerspective,
perspectiveTransform
 */
@Namespace("cv") public static native @ByVal Mat findHomography( @ByVal Mat srcPoints, @ByVal Mat dstPoints,
                                 int method/*=0*/, double ransacReprojThreshold/*=3*/,
                                 @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat mask, int maxIters/*=2000*/,
                                 double confidence/*=0.995*/);
@Namespace("cv") public static native @ByVal Mat findHomography( @ByVal Mat srcPoints, @ByVal Mat dstPoints);
@Namespace("cv") public static native @ByVal Mat findHomography( @ByVal UMat srcPoints, @ByVal UMat dstPoints,
                                 int method/*=0*/, double ransacReprojThreshold/*=3*/,
                                 @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat mask, int maxIters/*=2000*/,
                                 double confidence/*=0.995*/);
@Namespace("cv") public static native @ByVal Mat findHomography( @ByVal UMat srcPoints, @ByVal UMat dstPoints);
@Namespace("cv") public static native @ByVal Mat findHomography( @ByVal GpuMat srcPoints, @ByVal GpuMat dstPoints,
                                 int method/*=0*/, double ransacReprojThreshold/*=3*/,
                                 @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat mask, int maxIters/*=2000*/,
                                 double confidence/*=0.995*/);
@Namespace("cv") public static native @ByVal Mat findHomography( @ByVal GpuMat srcPoints, @ByVal GpuMat dstPoints);

/** \overload */
@Namespace("cv") public static native @ByVal Mat findHomography( @ByVal Mat srcPoints, @ByVal Mat dstPoints,
                               @ByVal Mat mask, int method/*=0*/, double ransacReprojThreshold/*=3*/ );
@Namespace("cv") public static native @ByVal Mat findHomography( @ByVal Mat srcPoints, @ByVal Mat dstPoints,
                               @ByVal Mat mask );
@Namespace("cv") public static native @ByVal Mat findHomography( @ByVal UMat srcPoints, @ByVal UMat dstPoints,
                               @ByVal UMat mask, int method/*=0*/, double ransacReprojThreshold/*=3*/ );
@Namespace("cv") public static native @ByVal Mat findHomography( @ByVal UMat srcPoints, @ByVal UMat dstPoints,
                               @ByVal UMat mask );
@Namespace("cv") public static native @ByVal Mat findHomography( @ByVal GpuMat srcPoints, @ByVal GpuMat dstPoints,
                               @ByVal GpuMat mask, int method/*=0*/, double ransacReprojThreshold/*=3*/ );
@Namespace("cv") public static native @ByVal Mat findHomography( @ByVal GpuMat srcPoints, @ByVal GpuMat dstPoints,
                               @ByVal GpuMat mask );


@Namespace("cv") public static native @ByVal Mat findHomography(@ByVal Mat srcPoints, @ByVal Mat dstPoints, @ByVal Mat mask,
                   @Const @ByRef UsacParams params);
@Namespace("cv") public static native @ByVal Mat findHomography(@ByVal UMat srcPoints, @ByVal UMat dstPoints, @ByVal UMat mask,
                   @Const @ByRef UsacParams params);
@Namespace("cv") public static native @ByVal Mat findHomography(@ByVal GpuMat srcPoints, @ByVal GpuMat dstPoints, @ByVal GpuMat mask,
                   @Const @ByRef UsacParams params);

/** \brief Computes an RQ decomposition of 3x3 matrices.
<p>
@param src 3x3 input matrix.
@param mtxR Output 3x3 upper-triangular matrix.
@param mtxQ Output 3x3 orthogonal matrix.
@param Qx Optional output 3x3 rotation matrix around x-axis.
@param Qy Optional output 3x3 rotation matrix around y-axis.
@param Qz Optional output 3x3 rotation matrix around z-axis.
<p>
The function computes a RQ decomposition using the given rotations. This function is used in
#decomposeProjectionMatrix to decompose the left 3x3 submatrix of a projection matrix into a camera
and a rotation matrix.
<p>
It optionally returns three rotation matrices, one for each axis, and the three Euler angles in
degrees (as the return value) that could be used in OpenGL. Note, there is always more than one
sequence of rotations about the three principal axes that results in the same orientation of an
object, e.g. see \cite Slabaugh . Returned tree rotation matrices and corresponding three Euler angles
are only one of the possible solutions.
 */
@Namespace("cv") public static native @ByVal @Cast("cv::Vec3d*") Point3d RQDecomp3x3( @ByVal Mat src, @ByVal Mat mtxR, @ByVal Mat mtxQ,
                                @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat Qx,
                                @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat Qy,
                                @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat Qz);
@Namespace("cv") public static native @ByVal @Cast("cv::Vec3d*") Point3d RQDecomp3x3( @ByVal Mat src, @ByVal Mat mtxR, @ByVal Mat mtxQ);
@Namespace("cv") public static native @ByVal @Cast("cv::Vec3d*") Point3d RQDecomp3x3( @ByVal UMat src, @ByVal UMat mtxR, @ByVal UMat mtxQ,
                                @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat Qx,
                                @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat Qy,
                                @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat Qz);
@Namespace("cv") public static native @ByVal @Cast("cv::Vec3d*") Point3d RQDecomp3x3( @ByVal UMat src, @ByVal UMat mtxR, @ByVal UMat mtxQ);
@Namespace("cv") public static native @ByVal @Cast("cv::Vec3d*") Point3d RQDecomp3x3( @ByVal GpuMat src, @ByVal GpuMat mtxR, @ByVal GpuMat mtxQ,
                                @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat Qx,
                                @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat Qy,
                                @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat Qz);
@Namespace("cv") public static native @ByVal @Cast("cv::Vec3d*") Point3d RQDecomp3x3( @ByVal GpuMat src, @ByVal GpuMat mtxR, @ByVal GpuMat mtxQ);

/** \brief Decomposes a projection matrix into a rotation matrix and a camera intrinsic matrix.
<p>
@param projMatrix 3x4 input projection matrix P.
@param cameraMatrix Output 3x3 camera intrinsic matrix {@code \cameramatrix{A}}.
@param rotMatrix Output 3x3 external rotation matrix R.
@param transVect Output 4x1 translation vector T.
@param rotMatrixX Optional 3x3 rotation matrix around x-axis.
@param rotMatrixY Optional 3x3 rotation matrix around y-axis.
@param rotMatrixZ Optional 3x3 rotation matrix around z-axis.
@param eulerAngles Optional three-element vector containing three Euler angles of rotation in
degrees.
<p>
The function computes a decomposition of a projection matrix into a calibration and a rotation
matrix and the position of a camera.
<p>
It optionally returns three rotation matrices, one for each axis, and three Euler angles that could
be used in OpenGL. Note, there is always more than one sequence of rotations about the three
principal axes that results in the same orientation of an object, e.g. see \cite Slabaugh . Returned
tree rotation matrices and corresponding three Euler angles are only one of the possible solutions.
<p>
The function is based on RQDecomp3x3 .
 */
@Namespace("cv") public static native void decomposeProjectionMatrix( @ByVal Mat projMatrix, @ByVal Mat cameraMatrix,
                                             @ByVal Mat rotMatrix, @ByVal Mat transVect,
                                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat rotMatrixX,
                                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat rotMatrixY,
                                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat rotMatrixZ,
                                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat eulerAngles );
@Namespace("cv") public static native void decomposeProjectionMatrix( @ByVal Mat projMatrix, @ByVal Mat cameraMatrix,
                                             @ByVal Mat rotMatrix, @ByVal Mat transVect );
@Namespace("cv") public static native void decomposeProjectionMatrix( @ByVal UMat projMatrix, @ByVal UMat cameraMatrix,
                                             @ByVal UMat rotMatrix, @ByVal UMat transVect,
                                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat rotMatrixX,
                                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat rotMatrixY,
                                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat rotMatrixZ,
                                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat eulerAngles );
@Namespace("cv") public static native void decomposeProjectionMatrix( @ByVal UMat projMatrix, @ByVal UMat cameraMatrix,
                                             @ByVal UMat rotMatrix, @ByVal UMat transVect );
@Namespace("cv") public static native void decomposeProjectionMatrix( @ByVal GpuMat projMatrix, @ByVal GpuMat cameraMatrix,
                                             @ByVal GpuMat rotMatrix, @ByVal GpuMat transVect,
                                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat rotMatrixX,
                                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat rotMatrixY,
                                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat rotMatrixZ,
                                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat eulerAngles );
@Namespace("cv") public static native void decomposeProjectionMatrix( @ByVal GpuMat projMatrix, @ByVal GpuMat cameraMatrix,
                                             @ByVal GpuMat rotMatrix, @ByVal GpuMat transVect );

/** \brief Computes partial derivatives of the matrix product for each multiplied matrix.
<p>
@param A First multiplied matrix.
@param B Second multiplied matrix.
@param dABdA First output derivative matrix d(A\*B)/dA of size
{@code \texttt{A.rows*B.cols} \times {A.rows*A.cols}} .
@param dABdB Second output derivative matrix d(A\*B)/dB of size
{@code \texttt{A.rows*B.cols} \times {B.rows*B.cols}} .
<p>
The function computes partial derivatives of the elements of the matrix product {@code A*B} with regard to
the elements of each of the two input matrices. The function is used to compute the Jacobian
matrices in #stereoCalibrate but can also be used in any other similar optimization function.
 */
@Namespace("cv") public static native void matMulDeriv( @ByVal Mat A, @ByVal Mat B, @ByVal Mat dABdA, @ByVal Mat dABdB );
@Namespace("cv") public static native void matMulDeriv( @ByVal UMat A, @ByVal UMat B, @ByVal UMat dABdA, @ByVal UMat dABdB );
@Namespace("cv") public static native void matMulDeriv( @ByVal GpuMat A, @ByVal GpuMat B, @ByVal GpuMat dABdA, @ByVal GpuMat dABdB );

/** \brief Combines two rotation-and-shift transformations.
<p>
@param rvec1 First rotation vector.
@param tvec1 First translation vector.
@param rvec2 Second rotation vector.
@param tvec2 Second translation vector.
@param rvec3 Output rotation vector of the superposition.
@param tvec3 Output translation vector of the superposition.
@param dr3dr1 Optional output derivative of rvec3 with regard to rvec1
@param dr3dt1 Optional output derivative of rvec3 with regard to tvec1
@param dr3dr2 Optional output derivative of rvec3 with regard to rvec2
@param dr3dt2 Optional output derivative of rvec3 with regard to tvec2
@param dt3dr1 Optional output derivative of tvec3 with regard to rvec1
@param dt3dt1 Optional output derivative of tvec3 with regard to tvec1
@param dt3dr2 Optional output derivative of tvec3 with regard to rvec2
@param dt3dt2 Optional output derivative of tvec3 with regard to tvec2
<p>
The functions compute:
<p>
<pre>{@code \[\begin{array}{l} \texttt{rvec3} =  \mathrm{rodrigues} ^{-1} \left ( \mathrm{rodrigues} ( \texttt{rvec2} )  \cdot \mathrm{rodrigues} ( \texttt{rvec1} ) \right )  \\ \texttt{tvec3} =  \mathrm{rodrigues} ( \texttt{rvec2} )  \cdot \texttt{tvec1} +  \texttt{tvec2} \end{array} ,\]}</pre>
<p>
where {@code \mathrm{rodrigues}} denotes a rotation vector to a rotation matrix transformation, and
{@code \mathrm{rodrigues}^{-1}} denotes the inverse transformation. See Rodrigues for details.
<p>
Also, the functions can compute the derivatives of the output vectors with regards to the input
vectors (see matMulDeriv ). The functions are used inside #stereoCalibrate but can also be used in
your own code where Levenberg-Marquardt or another gradient-based solver is used to optimize a
function that contains a matrix multiplication.
 */
@Namespace("cv") public static native void composeRT( @ByVal Mat rvec1, @ByVal Mat tvec1,
                             @ByVal Mat rvec2, @ByVal Mat tvec2,
                             @ByVal Mat rvec3, @ByVal Mat tvec3,
                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat dr3dr1, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat dr3dt1,
                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat dr3dr2, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat dr3dt2,
                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat dt3dr1, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat dt3dt1,
                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat dt3dr2, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat dt3dt2 );
@Namespace("cv") public static native void composeRT( @ByVal Mat rvec1, @ByVal Mat tvec1,
                             @ByVal Mat rvec2, @ByVal Mat tvec2,
                             @ByVal Mat rvec3, @ByVal Mat tvec3 );
@Namespace("cv") public static native void composeRT( @ByVal UMat rvec1, @ByVal UMat tvec1,
                             @ByVal UMat rvec2, @ByVal UMat tvec2,
                             @ByVal UMat rvec3, @ByVal UMat tvec3,
                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat dr3dr1, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat dr3dt1,
                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat dr3dr2, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat dr3dt2,
                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat dt3dr1, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat dt3dt1,
                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat dt3dr2, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat dt3dt2 );
@Namespace("cv") public static native void composeRT( @ByVal UMat rvec1, @ByVal UMat tvec1,
                             @ByVal UMat rvec2, @ByVal UMat tvec2,
                             @ByVal UMat rvec3, @ByVal UMat tvec3 );
@Namespace("cv") public static native void composeRT( @ByVal GpuMat rvec1, @ByVal GpuMat tvec1,
                             @ByVal GpuMat rvec2, @ByVal GpuMat tvec2,
                             @ByVal GpuMat rvec3, @ByVal GpuMat tvec3,
                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat dr3dr1, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat dr3dt1,
                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat dr3dr2, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat dr3dt2,
                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat dt3dr1, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat dt3dt1,
                             @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat dt3dr2, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat dt3dt2 );
@Namespace("cv") public static native void composeRT( @ByVal GpuMat rvec1, @ByVal GpuMat tvec1,
                             @ByVal GpuMat rvec2, @ByVal GpuMat tvec2,
                             @ByVal GpuMat rvec3, @ByVal GpuMat tvec3 );

/** \brief Projects 3D points to an image plane.
<p>
@param objectPoints Array of object points expressed wrt. the world coordinate frame. A 3xN/Nx3
1-channel or 1xN/Nx1 3-channel (or vector\<Point3f\> ), where N is the number of points in the view.
@param rvec The rotation vector (\ref Rodrigues) that, together with tvec, performs a change of
basis from world to camera coordinate system, see \ref calibrateCamera for details.
@param tvec The translation vector, see parameter description above.
@param cameraMatrix Camera intrinsic matrix {@code \cameramatrix{A}} .
@param distCoeffs Input vector of distortion coefficients
{@code \distcoeffs} . If the vector is empty, the zero distortion coefficients are assumed.
@param imagePoints Output array of image points, 1xN/Nx1 2-channel, or
vector\<Point2f\> .
@param jacobian Optional output 2Nx(10+\<numDistCoeffs\>) jacobian matrix of derivatives of image
points with respect to components of the rotation vector, translation vector, focal lengths,
coordinates of the principal point and the distortion coefficients. In the old interface different
components of the jacobian are returned via different output parameters.
@param aspectRatio Optional "fixed aspect ratio" parameter. If the parameter is not 0, the
function assumes that the aspect ratio ({@code f_x / f_y}) is fixed and correspondingly adjusts the
jacobian matrix.
<p>
The function computes the 2D projections of 3D points to the image plane, given intrinsic and
extrinsic camera parameters. Optionally, the function computes Jacobians -matrices of partial
derivatives of image points coordinates (as functions of all the input parameters) with respect to
the particular parameters, intrinsic and/or extrinsic. The Jacobians are used during the global
optimization in \ref calibrateCamera, \ref solvePnP, and \ref stereoCalibrate. The function itself
can also be used to compute a re-projection error, given the current intrinsic and extrinsic
parameters.
<p>
\note By setting rvec = tvec = {@code [0, 0, 0]}, or by setting cameraMatrix to a 3x3 identity matrix,
or by passing zero distortion coefficients, one can get various useful partial cases of the
function. This means, one can compute the distorted coordinates for a sparse set of points or apply
a perspective transformation (and also compute the derivatives) in the ideal zero-distortion setup.
 */
@Namespace("cv") public static native void projectPoints( @ByVal Mat objectPoints,
                                 @ByVal Mat rvec, @ByVal Mat tvec,
                                 @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                 @ByVal Mat imagePoints,
                                 @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat jacobian,
                                 double aspectRatio/*=0*/ );
@Namespace("cv") public static native void projectPoints( @ByVal Mat objectPoints,
                                 @ByVal Mat rvec, @ByVal Mat tvec,
                                 @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                 @ByVal Mat imagePoints );
@Namespace("cv") public static native void projectPoints( @ByVal UMat objectPoints,
                                 @ByVal UMat rvec, @ByVal UMat tvec,
                                 @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                 @ByVal UMat imagePoints,
                                 @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat jacobian,
                                 double aspectRatio/*=0*/ );
@Namespace("cv") public static native void projectPoints( @ByVal UMat objectPoints,
                                 @ByVal UMat rvec, @ByVal UMat tvec,
                                 @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                 @ByVal UMat imagePoints );
@Namespace("cv") public static native void projectPoints( @ByVal GpuMat objectPoints,
                                 @ByVal GpuMat rvec, @ByVal GpuMat tvec,
                                 @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                 @ByVal GpuMat imagePoints,
                                 @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat jacobian,
                                 double aspectRatio/*=0*/ );
@Namespace("cv") public static native void projectPoints( @ByVal GpuMat objectPoints,
                                 @ByVal GpuMat rvec, @ByVal GpuMat tvec,
                                 @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                 @ByVal GpuMat imagePoints );

/** \example samples/cpp/tutorial_code/features2D/Homography/homography_from_camera_displacement.cpp
An example program about homography from the camera displacement
<p>
Check \ref tutorial_homography "the corresponding tutorial" for more details
*/

/** \brief Finds an object pose from 3D-2D point correspondences.
This function returns the rotation and the translation vectors that transform a 3D point expressed in the object
coordinate frame to the camera coordinate frame, using different methods:
- P3P methods (\ref SOLVEPNP_P3P, \ref SOLVEPNP_AP3P): need 4 input points to return a unique solution.
- \ref SOLVEPNP_IPPE Input points must be >= 4 and object points must be coplanar.
- \ref SOLVEPNP_IPPE_SQUARE Special case suitable for marker pose estimation.
Number of input points must be 4. Object points must be defined in the following order:
  - point 0: [-squareLength / 2,  squareLength / 2, 0]
  - point 1: [ squareLength / 2,  squareLength / 2, 0]
  - point 2: [ squareLength / 2, -squareLength / 2, 0]
  - point 3: [-squareLength / 2, -squareLength / 2, 0]
- for all the other flags, number of input points must be >= 4 and object points can be in any configuration.
<p>
@param objectPoints Array of object points in the object coordinate space, Nx3 1-channel or
1xN/Nx1 3-channel, where N is the number of points. vector\<Point3d\> can be also passed here.
@param imagePoints Array of corresponding image points, Nx2 1-channel or 1xN/Nx1 2-channel,
where N is the number of points. vector\<Point2d\> can be also passed here.
@param cameraMatrix Input camera intrinsic matrix {@code \cameramatrix{A}} .
@param distCoeffs Input vector of distortion coefficients
{@code \distcoeffs}. If the vector is NULL/empty, the zero distortion coefficients are
assumed.
@param rvec Output rotation vector (see \ref Rodrigues ) that, together with tvec, brings points from
the model coordinate system to the camera coordinate system.
@param tvec Output translation vector.
@param useExtrinsicGuess Parameter used for #SOLVEPNP_ITERATIVE. If true (1), the function uses
the provided rvec and tvec values as initial approximations of the rotation and translation
vectors, respectively, and further optimizes them.
@param flags Method for solving a PnP problem:
-   \ref SOLVEPNP_ITERATIVE Iterative method is based on a Levenberg-Marquardt optimization. In
this case the function finds such a pose that minimizes reprojection error, that is the sum
of squared distances between the observed projections imagePoints and the projected (using
\ref projectPoints ) objectPoints .
-   \ref SOLVEPNP_P3P Method is based on the paper of X.S. Gao, X.-R. Hou, J. Tang, H.-F. Chang
"Complete Solution Classification for the Perspective-Three-Point Problem" (\cite gao2003complete).
In this case the function requires exactly four object and image points.
-   \ref SOLVEPNP_AP3P Method is based on the paper of T. Ke, S. Roumeliotis
"An Efficient Algebraic Solution to the Perspective-Three-Point Problem" (\cite Ke17).
In this case the function requires exactly four object and image points.
-   \ref SOLVEPNP_EPNP Method has been introduced by F. Moreno-Noguer, V. Lepetit and P. Fua in the
paper "EPnP: Efficient Perspective-n-Point Camera Pose Estimation" (\cite lepetit2009epnp).
-   \ref SOLVEPNP_DLS **Broken implementation. Using this flag will fallback to EPnP.** \n
Method is based on the paper of J. Hesch and S. Roumeliotis.
"A Direct Least-Squares (DLS) Method for PnP" (\cite hesch2011direct).
-   \ref SOLVEPNP_UPNP **Broken implementation. Using this flag will fallback to EPnP.** \n
Method is based on the paper of A. Penate-Sanchez, J. Andrade-Cetto,
F. Moreno-Noguer. "Exhaustive Linearization for Robust Camera Pose and Focal Length
Estimation" (\cite penate2013exhaustive). In this case the function also estimates the parameters {@code f_x} and {@code f_y}
assuming that both have the same value. Then the cameraMatrix is updated with the estimated
focal length.
-   \ref SOLVEPNP_IPPE Method is based on the paper of T. Collins and A. Bartoli.
"Infinitesimal Plane-Based Pose Estimation" (\cite Collins14). This method requires coplanar object points.
-   \ref SOLVEPNP_IPPE_SQUARE Method is based on the paper of Toby Collins and Adrien Bartoli.
"Infinitesimal Plane-Based Pose Estimation" (\cite Collins14). This method is suitable for marker pose estimation.
It requires 4 coplanar object points defined in the following order:
  - point 0: [-squareLength / 2,  squareLength / 2, 0]
  - point 1: [ squareLength / 2,  squareLength / 2, 0]
  - point 2: [ squareLength / 2, -squareLength / 2, 0]
  - point 3: [-squareLength / 2, -squareLength / 2, 0]
-   \ref SOLVEPNP_SQPNP Method is based on the paper "A Consistently Fast and Globally Optimal Solution to the
Perspective-n-Point Problem" by G. Terzakis and M.Lourakis (\cite Terzakis20). It requires 3 or more points.
<p>
<p>
The function estimates the object pose given a set of object points, their corresponding image
projections, as well as the camera intrinsic matrix and the distortion coefficients, see the figure below
(more precisely, the X-axis of the camera frame is pointing to the right, the Y-axis downward
and the Z-axis forward).
<p>
![](pnp.jpg)
<p>
Points expressed in the world frame {@code  \bf{X}_w } are projected into the image plane {@code  \left[ u, v \right] }
using the perspective projection model {@code  \Pi } and the camera intrinsic parameters matrix {@code  \bf{A} }:
<p>
<pre>{@code \[
  \begin{align*}
  \begin{bmatrix}
  u \\
  v \\
  1
  \end{bmatrix} &=
  \bf{A} \hspace{0.1em} \Pi \hspace{0.2em} ^{c}\bf{T}_w
  \begin{bmatrix}
  X_{w} \\
  Y_{w} \\
  Z_{w} \\
  1
  \end{bmatrix} \\
  \begin{bmatrix}
  u \\
  v \\
  1
  \end{bmatrix} &=
  \begin{bmatrix}
  f_x & 0 & c_x \\
  0 & f_y & c_y \\
  0 & 0 & 1
  \end{bmatrix}
  \begin{bmatrix}
  1 & 0 & 0 & 0 \\
  0 & 1 & 0 & 0 \\
  0 & 0 & 1 & 0
  \end{bmatrix}
  \begin{bmatrix}
  r_{11} & r_{12} & r_{13} & t_x \\
  r_{21} & r_{22} & r_{23} & t_y \\
  r_{31} & r_{32} & r_{33} & t_z \\
  0 & 0 & 0 & 1
  \end{bmatrix}
  \begin{bmatrix}
  X_{w} \\
  Y_{w} \\
  Z_{w} \\
  1
  \end{bmatrix}
  \end{align*}
\]}</pre>
<p>
The estimated pose is thus the rotation ({@code rvec}) and the translation ({@code tvec}) vectors that allow transforming
a 3D point expressed in the world frame into the camera frame:
<p>
<pre>{@code \[
  \begin{align*}
  \begin{bmatrix}
  X_c \\
  Y_c \\
  Z_c \\
  1
  \end{bmatrix} &=
  \hspace{0.2em} ^{c}\bf{T}_w
  \begin{bmatrix}
  X_{w} \\
  Y_{w} \\
  Z_{w} \\
  1
  \end{bmatrix} \\
  \begin{bmatrix}
  X_c \\
  Y_c \\
  Z_c \\
  1
  \end{bmatrix} &=
  \begin{bmatrix}
  r_{11} & r_{12} & r_{13} & t_x \\
  r_{21} & r_{22} & r_{23} & t_y \\
  r_{31} & r_{32} & r_{33} & t_z \\
  0 & 0 & 0 & 1
  \end{bmatrix}
  \begin{bmatrix}
  X_{w} \\
  Y_{w} \\
  Z_{w} \\
  1
  \end{bmatrix}
  \end{align*}
\]}</pre>
<p>
\note
   -   An example of how to use solvePnP for planar augmented reality can be found at
        opencv_source_code/samples/python/plane_ar.py
   -   If you are using Python:
        - Numpy array slices won't work as input because solvePnP requires contiguous
        arrays (enforced by the assertion using cv::Mat::checkVector() around line 55 of
        modules/calib3d/src/solvepnp.cpp version 2.4.9)
        - The P3P algorithm requires image points to be in an array of shape (N,1,2) due
        to its calling of #undistortPoints (around line 75 of modules/calib3d/src/solvepnp.cpp version 2.4.9)
        which requires 2-channel information.
        - Thus, given some data D = np.array(...) where D.shape = (N,M), in order to use a subset of
        it as, e.g., imagePoints, one must effectively copy it into a new array: imagePoints =
        np.ascontiguousarray(D[:,:2]).reshape((N,1,2))
   -   The methods \ref SOLVEPNP_DLS and \ref SOLVEPNP_UPNP cannot be used as the current implementations are
       unstable and sometimes give completely wrong results. If you pass one of these two
       flags, \ref SOLVEPNP_EPNP method will be used instead.
   -   The minimum number of points is 4 in the general case. In the case of \ref SOLVEPNP_P3P and \ref SOLVEPNP_AP3P
       methods, it is required to use exactly 4 points (the first 3 points are used to estimate all the solutions
       of the P3P problem, the last one is used to retain the best solution that minimizes the reprojection error).
   -   With \ref SOLVEPNP_ITERATIVE method and {@code useExtrinsicGuess=true}, the minimum number of points is 3 (3 points
       are sufficient to compute a pose but there are up to 4 solutions). The initial solution should be close to the
       global solution to converge.
   -   With \ref SOLVEPNP_IPPE input points must be >= 4 and object points must be coplanar.
   -   With \ref SOLVEPNP_IPPE_SQUARE this is a special case suitable for marker pose estimation.
       Number of input points must be 4. Object points must be defined in the following order:
         - point 0: [-squareLength / 2,  squareLength / 2, 0]
         - point 1: [ squareLength / 2,  squareLength / 2, 0]
         - point 2: [ squareLength / 2, -squareLength / 2, 0]
         - point 3: [-squareLength / 2, -squareLength / 2, 0]
    -  With \ref SOLVEPNP_SQPNP input points must be >= 3
 */
@Namespace("cv") public static native @Cast("bool") boolean solvePnP( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                            @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                            @ByVal Mat rvec, @ByVal Mat tvec,
                            @Cast("bool") boolean useExtrinsicGuess/*=false*/, int flags/*=cv::SOLVEPNP_ITERATIVE*/ );
@Namespace("cv") public static native @Cast("bool") boolean solvePnP( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                            @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                            @ByVal Mat rvec, @ByVal Mat tvec );
@Namespace("cv") public static native @Cast("bool") boolean solvePnP( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                            @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                            @ByVal UMat rvec, @ByVal UMat tvec,
                            @Cast("bool") boolean useExtrinsicGuess/*=false*/, int flags/*=cv::SOLVEPNP_ITERATIVE*/ );
@Namespace("cv") public static native @Cast("bool") boolean solvePnP( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                            @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                            @ByVal UMat rvec, @ByVal UMat tvec );
@Namespace("cv") public static native @Cast("bool") boolean solvePnP( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                            @ByVal GpuMat rvec, @ByVal GpuMat tvec,
                            @Cast("bool") boolean useExtrinsicGuess/*=false*/, int flags/*=cv::SOLVEPNP_ITERATIVE*/ );
@Namespace("cv") public static native @Cast("bool") boolean solvePnP( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                            @ByVal GpuMat rvec, @ByVal GpuMat tvec );

/** \brief Finds an object pose from 3D-2D point correspondences using the RANSAC scheme.
<p>
@param objectPoints Array of object points in the object coordinate space, Nx3 1-channel or
1xN/Nx1 3-channel, where N is the number of points. vector\<Point3d\> can be also passed here.
@param imagePoints Array of corresponding image points, Nx2 1-channel or 1xN/Nx1 2-channel,
where N is the number of points. vector\<Point2d\> can be also passed here.
@param cameraMatrix Input camera intrinsic matrix {@code \cameramatrix{A}} .
@param distCoeffs Input vector of distortion coefficients
{@code \distcoeffs}. If the vector is NULL/empty, the zero distortion coefficients are
assumed.
@param rvec Output rotation vector (see \ref Rodrigues ) that, together with tvec, brings points from
the model coordinate system to the camera coordinate system.
@param tvec Output translation vector.
@param useExtrinsicGuess Parameter used for \ref SOLVEPNP_ITERATIVE. If true (1), the function uses
the provided rvec and tvec values as initial approximations of the rotation and translation
vectors, respectively, and further optimizes them.
@param iterationsCount Number of iterations.
@param reprojectionError Inlier threshold value used by the RANSAC procedure. The parameter value
is the maximum allowed distance between the observed and computed point projections to consider it
an inlier.
@param confidence The probability that the algorithm produces a useful result.
@param inliers Output vector that contains indices of inliers in objectPoints and imagePoints .
@param flags Method for solving a PnP problem (see \ref solvePnP ).
<p>
The function estimates an object pose given a set of object points, their corresponding image
projections, as well as the camera intrinsic matrix and the distortion coefficients. This function finds such
a pose that minimizes reprojection error, that is, the sum of squared distances between the observed
projections imagePoints and the projected (using \ref projectPoints ) objectPoints. The use of RANSAC
makes the function resistant to outliers.
<p>
\note
   -   An example of how to use solvePNPRansac for object detection can be found at
        opencv_source_code/samples/cpp/tutorial_code/calib3d/real_time_pose_estimation/
   -   The default method used to estimate the camera pose for the Minimal Sample Sets step
       is #SOLVEPNP_EPNP. Exceptions are:
         - if you choose #SOLVEPNP_P3P or #SOLVEPNP_AP3P, these methods will be used.
         - if the number of input points is equal to 4, #SOLVEPNP_P3P is used.
   -   The method used to estimate the camera pose using all the inliers is defined by the
       flags parameters unless it is equal to #SOLVEPNP_P3P or #SOLVEPNP_AP3P. In this case,
       the method #SOLVEPNP_EPNP will be used instead.
 */
@Namespace("cv") public static native @Cast("bool") boolean solvePnPRansac( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                                  @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                  @ByVal Mat rvec, @ByVal Mat tvec,
                                  @Cast("bool") boolean useExtrinsicGuess/*=false*/, int iterationsCount/*=100*/,
                                  float reprojectionError/*=8.0*/, double confidence/*=0.99*/,
                                  @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat inliers, int flags/*=cv::SOLVEPNP_ITERATIVE*/ );
@Namespace("cv") public static native @Cast("bool") boolean solvePnPRansac( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                                  @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                  @ByVal Mat rvec, @ByVal Mat tvec );
@Namespace("cv") public static native @Cast("bool") boolean solvePnPRansac( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                                  @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                  @ByVal UMat rvec, @ByVal UMat tvec,
                                  @Cast("bool") boolean useExtrinsicGuess/*=false*/, int iterationsCount/*=100*/,
                                  float reprojectionError/*=8.0*/, double confidence/*=0.99*/,
                                  @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat inliers, int flags/*=cv::SOLVEPNP_ITERATIVE*/ );
@Namespace("cv") public static native @Cast("bool") boolean solvePnPRansac( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                                  @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                  @ByVal UMat rvec, @ByVal UMat tvec );
@Namespace("cv") public static native @Cast("bool") boolean solvePnPRansac( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                                  @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                  @ByVal GpuMat rvec, @ByVal GpuMat tvec,
                                  @Cast("bool") boolean useExtrinsicGuess/*=false*/, int iterationsCount/*=100*/,
                                  float reprojectionError/*=8.0*/, double confidence/*=0.99*/,
                                  @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat inliers, int flags/*=cv::SOLVEPNP_ITERATIVE*/ );
@Namespace("cv") public static native @Cast("bool") boolean solvePnPRansac( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                                  @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                  @ByVal GpuMat rvec, @ByVal GpuMat tvec );


/*
Finds rotation and translation vector.
If cameraMatrix is given then run P3P. Otherwise run linear P6P and output cameraMatrix too.
*/
@Namespace("cv") public static native @Cast("bool") boolean solvePnPRansac( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                     @ByVal Mat rvec, @ByVal Mat tvec, @ByVal Mat inliers,
                     @Const @ByRef(nullValue = "cv::UsacParams()") UsacParams params);
@Namespace("cv") public static native @Cast("bool") boolean solvePnPRansac( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                     @ByVal Mat rvec, @ByVal Mat tvec, @ByVal Mat inliers);
@Namespace("cv") public static native @Cast("bool") boolean solvePnPRansac( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                     @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                     @ByVal UMat rvec, @ByVal UMat tvec, @ByVal UMat inliers,
                     @Const @ByRef(nullValue = "cv::UsacParams()") UsacParams params);
@Namespace("cv") public static native @Cast("bool") boolean solvePnPRansac( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                     @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                     @ByVal UMat rvec, @ByVal UMat tvec, @ByVal UMat inliers);
@Namespace("cv") public static native @Cast("bool") boolean solvePnPRansac( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                     @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                     @ByVal GpuMat rvec, @ByVal GpuMat tvec, @ByVal GpuMat inliers,
                     @Const @ByRef(nullValue = "cv::UsacParams()") UsacParams params);
@Namespace("cv") public static native @Cast("bool") boolean solvePnPRansac( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                     @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                     @ByVal GpuMat rvec, @ByVal GpuMat tvec, @ByVal GpuMat inliers);

/** \brief Finds an object pose from 3 3D-2D point correspondences.
<p>
@param objectPoints Array of object points in the object coordinate space, 3x3 1-channel or
1x3/3x1 3-channel. vector\<Point3f\> can be also passed here.
@param imagePoints Array of corresponding image points, 3x2 1-channel or 1x3/3x1 2-channel.
 vector\<Point2f\> can be also passed here.
@param cameraMatrix Input camera intrinsic matrix {@code \cameramatrix{A}} .
@param distCoeffs Input vector of distortion coefficients
{@code \distcoeffs}. If the vector is NULL/empty, the zero distortion coefficients are
assumed.
@param rvecs Output rotation vectors (see \ref Rodrigues ) that, together with tvecs, brings points from
the model coordinate system to the camera coordinate system. A P3P problem has up to 4 solutions.
@param tvecs Output translation vectors.
@param flags Method for solving a P3P problem:
-   \ref SOLVEPNP_P3P Method is based on the paper of X.S. Gao, X.-R. Hou, J. Tang, H.-F. Chang
"Complete Solution Classification for the Perspective-Three-Point Problem" (\cite gao2003complete).
-   \ref SOLVEPNP_AP3P Method is based on the paper of T. Ke and S. Roumeliotis.
"An Efficient Algebraic Solution to the Perspective-Three-Point Problem" (\cite Ke17).
<p>
The function estimates the object pose given 3 object points, their corresponding image
projections, as well as the camera intrinsic matrix and the distortion coefficients.
<p>
\note
The solutions are sorted by reprojection errors (lowest to highest).
 */
@Namespace("cv") public static native int solveP3P( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                           @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                           @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                           int flags );
@Namespace("cv") public static native int solveP3P( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                           @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                           @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
                           int flags );
@Namespace("cv") public static native int solveP3P( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                           @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                           @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
                           int flags );
@Namespace("cv") public static native int solveP3P( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                           @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                           @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                           int flags );
@Namespace("cv") public static native int solveP3P( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                           @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                           @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
                           int flags );
@Namespace("cv") public static native int solveP3P( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                           @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                           @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
                           int flags );
@Namespace("cv") public static native int solveP3P( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                           @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                           @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                           int flags );
@Namespace("cv") public static native int solveP3P( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                           @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                           @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
                           int flags );
@Namespace("cv") public static native int solveP3P( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                           @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                           @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
                           int flags );

/** \brief Refine a pose (the translation and the rotation that transform a 3D point expressed in the object coordinate frame
to the camera coordinate frame) from a 3D-2D point correspondences and starting from an initial solution.
<p>
@param objectPoints Array of object points in the object coordinate space, Nx3 1-channel or 1xN/Nx1 3-channel,
where N is the number of points. vector\<Point3d\> can also be passed here.
@param imagePoints Array of corresponding image points, Nx2 1-channel or 1xN/Nx1 2-channel,
where N is the number of points. vector\<Point2d\> can also be passed here.
@param cameraMatrix Input camera intrinsic matrix {@code \cameramatrix{A}} .
@param distCoeffs Input vector of distortion coefficients
{@code \distcoeffs}. If the vector is NULL/empty, the zero distortion coefficients are
assumed.
@param rvec Input/Output rotation vector (see \ref Rodrigues ) that, together with tvec, brings points from
the model coordinate system to the camera coordinate system. Input values are used as an initial solution.
@param tvec Input/Output translation vector. Input values are used as an initial solution.
@param criteria Criteria when to stop the Levenberg-Marquard iterative algorithm.
<p>
The function refines the object pose given at least 3 object points, their corresponding image
projections, an initial solution for the rotation and translation vector,
as well as the camera intrinsic matrix and the distortion coefficients.
The function minimizes the projection error with respect to the rotation and the translation vectors, according
to a Levenberg-Marquardt iterative minimization \cite Madsen04 \cite Eade13 process.
 */
@Namespace("cv") public static native void solvePnPRefineLM( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                                    @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                    @ByVal Mat rvec, @ByVal Mat tvec,
                                    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::EPS + cv::TermCriteria::COUNT, 20, FLT_EPSILON)") TermCriteria criteria);
@Namespace("cv") public static native void solvePnPRefineLM( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                                    @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                    @ByVal Mat rvec, @ByVal Mat tvec);
@Namespace("cv") public static native void solvePnPRefineLM( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                                    @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                    @ByVal UMat rvec, @ByVal UMat tvec,
                                    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::EPS + cv::TermCriteria::COUNT, 20, FLT_EPSILON)") TermCriteria criteria);
@Namespace("cv") public static native void solvePnPRefineLM( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                                    @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                    @ByVal UMat rvec, @ByVal UMat tvec);
@Namespace("cv") public static native void solvePnPRefineLM( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                                    @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                    @ByVal GpuMat rvec, @ByVal GpuMat tvec,
                                    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::EPS + cv::TermCriteria::COUNT, 20, FLT_EPSILON)") TermCriteria criteria);
@Namespace("cv") public static native void solvePnPRefineLM( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                                    @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                    @ByVal GpuMat rvec, @ByVal GpuMat tvec);

/** \brief Refine a pose (the translation and the rotation that transform a 3D point expressed in the object coordinate frame
to the camera coordinate frame) from a 3D-2D point correspondences and starting from an initial solution.
<p>
@param objectPoints Array of object points in the object coordinate space, Nx3 1-channel or 1xN/Nx1 3-channel,
where N is the number of points. vector\<Point3d\> can also be passed here.
@param imagePoints Array of corresponding image points, Nx2 1-channel or 1xN/Nx1 2-channel,
where N is the number of points. vector\<Point2d\> can also be passed here.
@param cameraMatrix Input camera intrinsic matrix {@code \cameramatrix{A}} .
@param distCoeffs Input vector of distortion coefficients
{@code \distcoeffs}. If the vector is NULL/empty, the zero distortion coefficients are
assumed.
@param rvec Input/Output rotation vector (see \ref Rodrigues ) that, together with tvec, brings points from
the model coordinate system to the camera coordinate system. Input values are used as an initial solution.
@param tvec Input/Output translation vector. Input values are used as an initial solution.
@param criteria Criteria when to stop the Levenberg-Marquard iterative algorithm.
@param VVSlambda Gain for the virtual visual servoing control law, equivalent to the {@code \alpha}
gain in the Damped Gauss-Newton formulation.
<p>
The function refines the object pose given at least 3 object points, their corresponding image
projections, an initial solution for the rotation and translation vector,
as well as the camera intrinsic matrix and the distortion coefficients.
The function minimizes the projection error with respect to the rotation and the translation vectors, using a
virtual visual servoing (VVS) \cite Chaumette06 \cite Marchand16 scheme.
 */
@Namespace("cv") public static native void solvePnPRefineVVS( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                     @ByVal Mat rvec, @ByVal Mat tvec,
                                     @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::EPS + cv::TermCriteria::COUNT, 20, FLT_EPSILON)") TermCriteria criteria,
                                     double VVSlambda/*=1*/);
@Namespace("cv") public static native void solvePnPRefineVVS( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                     @ByVal Mat rvec, @ByVal Mat tvec);
@Namespace("cv") public static native void solvePnPRefineVVS( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                                     @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                     @ByVal UMat rvec, @ByVal UMat tvec,
                                     @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::EPS + cv::TermCriteria::COUNT, 20, FLT_EPSILON)") TermCriteria criteria,
                                     double VVSlambda/*=1*/);
@Namespace("cv") public static native void solvePnPRefineVVS( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                                     @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                     @ByVal UMat rvec, @ByVal UMat tvec);
@Namespace("cv") public static native void solvePnPRefineVVS( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                                     @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                     @ByVal GpuMat rvec, @ByVal GpuMat tvec,
                                     @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::EPS + cv::TermCriteria::COUNT, 20, FLT_EPSILON)") TermCriteria criteria,
                                     double VVSlambda/*=1*/);
@Namespace("cv") public static native void solvePnPRefineVVS( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                                     @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                     @ByVal GpuMat rvec, @ByVal GpuMat tvec);

/** \brief Finds an object pose from 3D-2D point correspondences.
This function returns a list of all the possible solutions (a solution is a <rotation vector, translation vector>
couple), depending on the number of input points and the chosen method:
- P3P methods (\ref SOLVEPNP_P3P, \ref SOLVEPNP_AP3P): 3 or 4 input points. Number of returned solutions can be between 0 and 4 with 3 input points.
- \ref SOLVEPNP_IPPE Input points must be >= 4 and object points must be coplanar. Returns 2 solutions.
- \ref SOLVEPNP_IPPE_SQUARE Special case suitable for marker pose estimation.
Number of input points must be 4 and 2 solutions are returned. Object points must be defined in the following order:
  - point 0: [-squareLength / 2,  squareLength / 2, 0]
  - point 1: [ squareLength / 2,  squareLength / 2, 0]
  - point 2: [ squareLength / 2, -squareLength / 2, 0]
  - point 3: [-squareLength / 2, -squareLength / 2, 0]
- for all the other flags, number of input points must be >= 4 and object points can be in any configuration.
Only 1 solution is returned.
<p>
@param objectPoints Array of object points in the object coordinate space, Nx3 1-channel or
1xN/Nx1 3-channel, where N is the number of points. vector\<Point3d\> can be also passed here.
@param imagePoints Array of corresponding image points, Nx2 1-channel or 1xN/Nx1 2-channel,
where N is the number of points. vector\<Point2d\> can be also passed here.
@param cameraMatrix Input camera intrinsic matrix {@code \cameramatrix{A}} .
@param distCoeffs Input vector of distortion coefficients
{@code \distcoeffs}. If the vector is NULL/empty, the zero distortion coefficients are
assumed.
@param rvecs Vector of output rotation vectors (see \ref Rodrigues ) that, together with tvecs, brings points from
the model coordinate system to the camera coordinate system.
@param tvecs Vector of output translation vectors.
@param useExtrinsicGuess Parameter used for #SOLVEPNP_ITERATIVE. If true (1), the function uses
the provided rvec and tvec values as initial approximations of the rotation and translation
vectors, respectively, and further optimizes them.
@param flags Method for solving a PnP problem:
-   \ref SOLVEPNP_ITERATIVE Iterative method is based on a Levenberg-Marquardt optimization. In
this case the function finds such a pose that minimizes reprojection error, that is the sum
of squared distances between the observed projections imagePoints and the projected (using
 #projectPoints ) objectPoints .
-   \ref SOLVEPNP_P3P Method is based on the paper of X.S. Gao, X.-R. Hou, J. Tang, H.-F. Chang
"Complete Solution Classification for the Perspective-Three-Point Problem" (\cite gao2003complete).
In this case the function requires exactly four object and image points.
-   \ref SOLVEPNP_AP3P Method is based on the paper of T. Ke, S. Roumeliotis
"An Efficient Algebraic Solution to the Perspective-Three-Point Problem" (\cite Ke17).
In this case the function requires exactly four object and image points.
-   \ref SOLVEPNP_EPNP Method has been introduced by F.Moreno-Noguer, V.Lepetit and P.Fua in the
paper "EPnP: Efficient Perspective-n-Point Camera Pose Estimation" (\cite lepetit2009epnp).
-   \ref SOLVEPNP_DLS **Broken implementation. Using this flag will fallback to EPnP.** \n
Method is based on the paper of Joel A. Hesch and Stergios I. Roumeliotis.
"A Direct Least-Squares (DLS) Method for PnP" (\cite hesch2011direct).
-   \ref SOLVEPNP_UPNP **Broken implementation. Using this flag will fallback to EPnP.** \n
Method is based on the paper of A.Penate-Sanchez, J.Andrade-Cetto,
F.Moreno-Noguer. "Exhaustive Linearization for Robust Camera Pose and Focal Length
Estimation" (\cite penate2013exhaustive). In this case the function also estimates the parameters {@code f_x} and {@code f_y}
assuming that both have the same value. Then the cameraMatrix is updated with the estimated
focal length.
-   \ref SOLVEPNP_IPPE Method is based on the paper of T. Collins and A. Bartoli.
"Infinitesimal Plane-Based Pose Estimation" (\cite Collins14). This method requires coplanar object points.
-   \ref SOLVEPNP_IPPE_SQUARE Method is based on the paper of Toby Collins and Adrien Bartoli.
"Infinitesimal Plane-Based Pose Estimation" (\cite Collins14). This method is suitable for marker pose estimation.
It requires 4 coplanar object points defined in the following order:
  - point 0: [-squareLength / 2,  squareLength / 2, 0]
  - point 1: [ squareLength / 2,  squareLength / 2, 0]
  - point 2: [ squareLength / 2, -squareLength / 2, 0]
  - point 3: [-squareLength / 2, -squareLength / 2, 0]
@param rvec Rotation vector used to initialize an iterative PnP refinement algorithm, when flag is \ref SOLVEPNP_ITERATIVE
and useExtrinsicGuess is set to true.
@param tvec Translation vector used to initialize an iterative PnP refinement algorithm, when flag is \ref SOLVEPNP_ITERATIVE
and useExtrinsicGuess is set to true.
@param reprojectionError Optional vector of reprojection error, that is the RMS error
({@code  \text{RMSE} = \sqrt{\frac{\sum_{i}^{N} \left ( \hat{y_i} - y_i \right )^2}{N}} }) between the input image points
and the 3D object points projected with the estimated pose.
<p>
The function estimates the object pose given a set of object points, their corresponding image
projections, as well as the camera intrinsic matrix and the distortion coefficients, see the figure below
(more precisely, the X-axis of the camera frame is pointing to the right, the Y-axis downward
and the Z-axis forward).
<p>
![](pnp.jpg)
<p>
Points expressed in the world frame {@code  \bf{X}_w } are projected into the image plane {@code  \left[ u, v \right] }
using the perspective projection model {@code  \Pi } and the camera intrinsic parameters matrix {@code  \bf{A} }:
<p>
<pre>{@code \[
  \begin{align*}
  \begin{bmatrix}
  u \\
  v \\
  1
  \end{bmatrix} &=
  \bf{A} \hspace{0.1em} \Pi \hspace{0.2em} ^{c}\bf{T}_w
  \begin{bmatrix}
  X_{w} \\
  Y_{w} \\
  Z_{w} \\
  1
  \end{bmatrix} \\
  \begin{bmatrix}
  u \\
  v \\
  1
  \end{bmatrix} &=
  \begin{bmatrix}
  f_x & 0 & c_x \\
  0 & f_y & c_y \\
  0 & 0 & 1
  \end{bmatrix}
  \begin{bmatrix}
  1 & 0 & 0 & 0 \\
  0 & 1 & 0 & 0 \\
  0 & 0 & 1 & 0
  \end{bmatrix}
  \begin{bmatrix}
  r_{11} & r_{12} & r_{13} & t_x \\
  r_{21} & r_{22} & r_{23} & t_y \\
  r_{31} & r_{32} & r_{33} & t_z \\
  0 & 0 & 0 & 1
  \end{bmatrix}
  \begin{bmatrix}
  X_{w} \\
  Y_{w} \\
  Z_{w} \\
  1
  \end{bmatrix}
  \end{align*}
\]}</pre>
<p>
The estimated pose is thus the rotation ({@code rvec}) and the translation ({@code tvec}) vectors that allow transforming
a 3D point expressed in the world frame into the camera frame:
<p>
<pre>{@code \[
  \begin{align*}
  \begin{bmatrix}
  X_c \\
  Y_c \\
  Z_c \\
  1
  \end{bmatrix} &=
  \hspace{0.2em} ^{c}\bf{T}_w
  \begin{bmatrix}
  X_{w} \\
  Y_{w} \\
  Z_{w} \\
  1
  \end{bmatrix} \\
  \begin{bmatrix}
  X_c \\
  Y_c \\
  Z_c \\
  1
  \end{bmatrix} &=
  \begin{bmatrix}
  r_{11} & r_{12} & r_{13} & t_x \\
  r_{21} & r_{22} & r_{23} & t_y \\
  r_{31} & r_{32} & r_{33} & t_z \\
  0 & 0 & 0 & 1
  \end{bmatrix}
  \begin{bmatrix}
  X_{w} \\
  Y_{w} \\
  Z_{w} \\
  1
  \end{bmatrix}
  \end{align*}
\]}</pre>
<p>
\note
   -   An example of how to use solvePnP for planar augmented reality can be found at
        opencv_source_code/samples/python/plane_ar.py
   -   If you are using Python:
        - Numpy array slices won't work as input because solvePnP requires contiguous
        arrays (enforced by the assertion using cv::Mat::checkVector() around line 55 of
        modules/calib3d/src/solvepnp.cpp version 2.4.9)
        - The P3P algorithm requires image points to be in an array of shape (N,1,2) due
        to its calling of #undistortPoints (around line 75 of modules/calib3d/src/solvepnp.cpp version 2.4.9)
        which requires 2-channel information.
        - Thus, given some data D = np.array(...) where D.shape = (N,M), in order to use a subset of
        it as, e.g., imagePoints, one must effectively copy it into a new array: imagePoints =
        np.ascontiguousarray(D[:,:2]).reshape((N,1,2))
   -   The methods \ref SOLVEPNP_DLS and \ref SOLVEPNP_UPNP cannot be used as the current implementations are
       unstable and sometimes give completely wrong results. If you pass one of these two
       flags, \ref SOLVEPNP_EPNP method will be used instead.
   -   The minimum number of points is 4 in the general case. In the case of \ref SOLVEPNP_P3P and \ref SOLVEPNP_AP3P
       methods, it is required to use exactly 4 points (the first 3 points are used to estimate all the solutions
       of the P3P problem, the last one is used to retain the best solution that minimizes the reprojection error).
   -   With \ref SOLVEPNP_ITERATIVE method and {@code useExtrinsicGuess=true}, the minimum number of points is 3 (3 points
       are sufficient to compute a pose but there are up to 4 solutions). The initial solution should be close to the
       global solution to converge.
   -   With \ref SOLVEPNP_IPPE input points must be >= 4 and object points must be coplanar.
   -   With \ref SOLVEPNP_IPPE_SQUARE this is a special case suitable for marker pose estimation.
       Number of input points must be 4. Object points must be defined in the following order:
         - point 0: [-squareLength / 2,  squareLength / 2, 0]
         - point 1: [ squareLength / 2,  squareLength / 2, 0]
         - point 2: [ squareLength / 2, -squareLength / 2, 0]
         - point 3: [-squareLength / 2, -squareLength / 2, 0]
 */
@Namespace("cv") public static native int solvePnPGeneric( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                                  @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                  @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                                  @Cast("bool") boolean useExtrinsicGuess/*=false*/, @Cast("cv::SolvePnPMethod") int flags/*=cv::SOLVEPNP_ITERATIVE*/,
                                  @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat rvec, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat tvec,
                                  @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat reprojectionError );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                                  @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                  @ByVal MatVector rvecs, @ByVal MatVector tvecs );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                                  @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                  @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
                                  @Cast("bool") boolean useExtrinsicGuess/*=false*/, @Cast("cv::SolvePnPMethod") int flags/*=cv::SOLVEPNP_ITERATIVE*/,
                                  @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat rvec, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat tvec,
                                  @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat reprojectionError );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                                  @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                  @ByVal UMatVector rvecs, @ByVal UMatVector tvecs );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                                  @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                  @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
                                  @Cast("bool") boolean useExtrinsicGuess/*=false*/, @Cast("cv::SolvePnPMethod") int flags/*=cv::SOLVEPNP_ITERATIVE*/,
                                  @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat rvec, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat tvec,
                                  @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat reprojectionError );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal Mat objectPoints, @ByVal Mat imagePoints,
                                  @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                  @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                                  @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                  @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                                  @Cast("bool") boolean useExtrinsicGuess/*=false*/, @Cast("cv::SolvePnPMethod") int flags/*=cv::SOLVEPNP_ITERATIVE*/,
                                  @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat rvec, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat tvec,
                                  @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat reprojectionError );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                                  @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                  @ByVal MatVector rvecs, @ByVal MatVector tvecs );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                                  @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                  @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
                                  @Cast("bool") boolean useExtrinsicGuess/*=false*/, @Cast("cv::SolvePnPMethod") int flags/*=cv::SOLVEPNP_ITERATIVE*/,
                                  @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat rvec, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat tvec,
                                  @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat reprojectionError );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                                  @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                  @ByVal UMatVector rvecs, @ByVal UMatVector tvecs );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                                  @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                  @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
                                  @Cast("bool") boolean useExtrinsicGuess/*=false*/, @Cast("cv::SolvePnPMethod") int flags/*=cv::SOLVEPNP_ITERATIVE*/,
                                  @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat rvec, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat tvec,
                                  @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat reprojectionError );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal UMat objectPoints, @ByVal UMat imagePoints,
                                  @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                  @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                                  @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                  @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                                  @Cast("bool") boolean useExtrinsicGuess/*=false*/, @Cast("cv::SolvePnPMethod") int flags/*=cv::SOLVEPNP_ITERATIVE*/,
                                  @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat rvec, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat tvec,
                                  @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat reprojectionError );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                                  @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                  @ByVal MatVector rvecs, @ByVal MatVector tvecs );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                                  @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                  @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
                                  @Cast("bool") boolean useExtrinsicGuess/*=false*/, @Cast("cv::SolvePnPMethod") int flags/*=cv::SOLVEPNP_ITERATIVE*/,
                                  @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat rvec, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat tvec,
                                  @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat reprojectionError );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                                  @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                  @ByVal UMatVector rvecs, @ByVal UMatVector tvecs );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                                  @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                  @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
                                  @Cast("bool") boolean useExtrinsicGuess/*=false*/, @Cast("cv::SolvePnPMethod") int flags/*=cv::SOLVEPNP_ITERATIVE*/,
                                  @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat rvec, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat tvec,
                                  @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat reprojectionError );
@Namespace("cv") public static native int solvePnPGeneric( @ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints,
                                  @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                  @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs );

/** \brief Finds an initial camera intrinsic matrix from 3D-2D point correspondences.
<p>
@param objectPoints Vector of vectors of the calibration pattern points in the calibration pattern
coordinate space. In the old interface all the per-view vectors are concatenated. See
#calibrateCamera for details.
@param imagePoints Vector of vectors of the projections of the calibration pattern points. In the
old interface all the per-view vectors are concatenated.
@param imageSize Image size in pixels used to initialize the principal point.
@param aspectRatio If it is zero or negative, both {@code f_x} and {@code f_y} are estimated independently.
Otherwise, {@code f_x = f_y * \texttt{aspectRatio}} .
<p>
The function estimates and returns an initial camera intrinsic matrix for the camera calibration process.
Currently, the function only supports planar calibration patterns, which are patterns where each
object point has z-coordinate =0.
 */
@Namespace("cv") public static native @ByVal Mat initCameraMatrix2D( @ByVal Point3fVectorVector objectPoints,
                                     @ByVal Point2fVectorVector imagePoints,
                                     @ByVal Size imageSize, double aspectRatio/*=1.0*/ );
@Namespace("cv") public static native @ByVal Mat initCameraMatrix2D( @ByVal Point3fVectorVector objectPoints,
                                     @ByVal Point2fVectorVector imagePoints,
                                     @ByVal Size imageSize );

/** \brief Finds the positions of internal corners of the chessboard.
<p>
@param image Source chessboard view. It must be an 8-bit grayscale or color image.
@param patternSize Number of inner corners per a chessboard row and column
( patternSize = cv::Size(points_per_row,points_per_colum) = cv::Size(columns,rows) ).
@param corners Output array of detected corners.
@param flags Various operation flags that can be zero or a combination of the following values:
-   \ref CALIB_CB_ADAPTIVE_THRESH Use adaptive thresholding to convert the image to black
and white, rather than a fixed threshold level (computed from the average image brightness).
-   \ref CALIB_CB_NORMALIZE_IMAGE Normalize the image gamma with equalizeHist before
applying fixed or adaptive thresholding.
-   \ref CALIB_CB_FILTER_QUADS Use additional criteria (like contour area, perimeter,
square-like shape) to filter out false quads extracted at the contour retrieval stage.
-   \ref CALIB_CB_FAST_CHECK Run a fast check on the image that looks for chessboard corners,
and shortcut the call if none is found. This can drastically speed up the call in the
degenerate condition when no chessboard is observed.
<p>
The function attempts to determine whether the input image is a view of the chessboard pattern and
locate the internal chessboard corners. The function returns a non-zero value if all of the corners
are found and they are placed in a certain order (row by row, left to right in every row).
Otherwise, if the function fails to find all the corners or reorder them, it returns 0. For example,
a regular chessboard has 8 x 8 squares and 7 x 7 internal corners, that is, points where the black
squares touch each other. The detected coordinates are approximate, and to determine their positions
more accurately, the function calls cornerSubPix. You also may use the function cornerSubPix with
different parameters if returned coordinates are not accurate enough.
<p>
Sample usage of detecting and drawing chessboard corners: :
<pre>{@code
    Size patternsize(8,6); //interior number of corners
    Mat gray = ....; //source image
    vector<Point2f> corners; //this will be filled by the detected corners

    //CALIB_CB_FAST_CHECK saves a lot of time on images
    //that do not contain any chessboard corners
    bool patternfound = findChessboardCorners(gray, patternsize, corners,
            CALIB_CB_ADAPTIVE_THRESH + CALIB_CB_NORMALIZE_IMAGE
            + CALIB_CB_FAST_CHECK);

    if(patternfound)
      cornerSubPix(gray, corners, Size(11, 11), Size(-1, -1),
        TermCriteria(CV_TERMCRIT_EPS + CV_TERMCRIT_ITER, 30, 0.1));

    drawChessboardCorners(img, patternsize, Mat(corners), patternfound);
}</pre>
\note The function requires white space (like a square-thick border, the wider the better) around
the board to make the detection more robust in various environments. Otherwise, if there is no
border and the background is dark, the outer black squares cannot be segmented properly and so the
square grouping and ordering algorithm fails.
 */
@Namespace("cv") public static native @Cast("bool") boolean findChessboardCorners( @ByVal Mat image, @ByVal Size patternSize, @ByVal Mat corners,
                                         int flags/*=cv::CALIB_CB_ADAPTIVE_THRESH + cv::CALIB_CB_NORMALIZE_IMAGE*/ );
@Namespace("cv") public static native @Cast("bool") boolean findChessboardCorners( @ByVal Mat image, @ByVal Size patternSize, @ByVal Mat corners );
@Namespace("cv") public static native @Cast("bool") boolean findChessboardCorners( @ByVal UMat image, @ByVal Size patternSize, @ByVal UMat corners,
                                         int flags/*=cv::CALIB_CB_ADAPTIVE_THRESH + cv::CALIB_CB_NORMALIZE_IMAGE*/ );
@Namespace("cv") public static native @Cast("bool") boolean findChessboardCorners( @ByVal UMat image, @ByVal Size patternSize, @ByVal UMat corners );
@Namespace("cv") public static native @Cast("bool") boolean findChessboardCorners( @ByVal GpuMat image, @ByVal Size patternSize, @ByVal GpuMat corners,
                                         int flags/*=cv::CALIB_CB_ADAPTIVE_THRESH + cv::CALIB_CB_NORMALIZE_IMAGE*/ );
@Namespace("cv") public static native @Cast("bool") boolean findChessboardCorners( @ByVal GpuMat image, @ByVal Size patternSize, @ByVal GpuMat corners );

/*
   Checks whether the image contains chessboard of the specific size or not.
   If yes, nonzero value is returned.
*/
@Namespace("cv") public static native @Cast("bool") boolean checkChessboard(@ByVal Mat img, @ByVal Size size);
@Namespace("cv") public static native @Cast("bool") boolean checkChessboard(@ByVal UMat img, @ByVal Size size);
@Namespace("cv") public static native @Cast("bool") boolean checkChessboard(@ByVal GpuMat img, @ByVal Size size);

/** \brief Finds the positions of internal corners of the chessboard using a sector based approach.
<p>
@param image Source chessboard view. It must be an 8-bit grayscale or color image.
@param patternSize Number of inner corners per a chessboard row and column
( patternSize = cv::Size(points_per_row,points_per_colum) = cv::Size(columns,rows) ).
@param corners Output array of detected corners.
@param flags Various operation flags that can be zero or a combination of the following values:
-   \ref CALIB_CB_NORMALIZE_IMAGE Normalize the image gamma with equalizeHist before detection.
-   \ref CALIB_CB_EXHAUSTIVE Run an exhaustive search to improve detection rate.
-   \ref CALIB_CB_ACCURACY Up sample input image to improve sub-pixel accuracy due to aliasing effects.
-   \ref CALIB_CB_LARGER The detected pattern is allowed to be larger than patternSize (see description).
-   \ref CALIB_CB_MARKER The detected pattern must have a marker (see description).
This should be used if an accurate camera calibration is required.
@param meta Optional output arrray of detected corners (CV_8UC1 and size = cv::Size(columns,rows)).
Each entry stands for one corner of the pattern and can have one of the following values:
-   0 = no meta data attached
-   1 = left-top corner of a black cell
-   2 = left-top corner of a white cell
-   3 = left-top corner of a black cell with a white marker dot
-   4 = left-top corner of a white cell with a black marker dot (pattern origin in case of markers otherwise first corner)
<p>
The function is analog to #findChessboardCorners but uses a localized radon
transformation approximated by box filters being more robust to all sort of
noise, faster on larger images and is able to directly return the sub-pixel
position of the internal chessboard corners. The Method is based on the paper
\cite duda2018 "Accurate Detection and Localization of Checkerboard Corners for
Calibration" demonstrating that the returned sub-pixel positions are more
accurate than the one returned by cornerSubPix allowing a precise camera
calibration for demanding applications.
<p>
In the case, the flags \ref CALIB_CB_LARGER or \ref CALIB_CB_MARKER are given,
the result can be recovered from the optional meta array. Both flags are
helpful to use calibration patterns exceeding the field of view of the camera.
These oversized patterns allow more accurate calibrations as corners can be
utilized, which are as close as possible to the image borders.  For a
consistent coordinate system across all images, the optional marker (see image
below) can be used to move the origin of the board to the location where the
black circle is located.
<p>
\note The function requires a white boarder with roughly the same width as one
of the checkerboard fields around the whole board to improve the detection in
various environments. In addition, because of the localized radon
transformation it is beneficial to use round corners for the field corners
which are located on the outside of the board. The following figure illustrates
a sample checkerboard optimized for the detection. However, any other checkerboard
can be used as well.
![Checkerboard](pics/checkerboard_radon.png)
 */
@Namespace("cv") public static native @Cast("bool") @Name("findChessboardCornersSB") boolean findChessboardCornersSBWithMeta(@ByVal Mat image,@ByVal Size patternSize, @ByVal Mat corners,
                             int flags,@ByVal Mat meta);
@Namespace("cv") public static native @Cast("bool") @Name("findChessboardCornersSB") boolean findChessboardCornersSBWithMeta(@ByVal UMat image,@ByVal Size patternSize, @ByVal UMat corners,
                             int flags,@ByVal UMat meta);
@Namespace("cv") public static native @Cast("bool") @Name("findChessboardCornersSB") boolean findChessboardCornersSBWithMeta(@ByVal GpuMat image,@ByVal Size patternSize, @ByVal GpuMat corners,
                             int flags,@ByVal GpuMat meta);
/** \overload */
@Namespace("cv") public static native @Cast("bool") boolean findChessboardCornersSB(@ByVal Mat image, @ByVal Size patternSize, @ByVal Mat corners,
                             int flags/*=0*/);
@Namespace("cv") public static native @Cast("bool") boolean findChessboardCornersSB(@ByVal Mat image, @ByVal Size patternSize, @ByVal Mat corners);
@Namespace("cv") public static native @Cast("bool") boolean findChessboardCornersSB(@ByVal UMat image, @ByVal Size patternSize, @ByVal UMat corners,
                             int flags/*=0*/);
@Namespace("cv") public static native @Cast("bool") boolean findChessboardCornersSB(@ByVal UMat image, @ByVal Size patternSize, @ByVal UMat corners);
@Namespace("cv") public static native @Cast("bool") boolean findChessboardCornersSB(@ByVal GpuMat image, @ByVal Size patternSize, @ByVal GpuMat corners,
                             int flags/*=0*/);
@Namespace("cv") public static native @Cast("bool") boolean findChessboardCornersSB(@ByVal GpuMat image, @ByVal Size patternSize, @ByVal GpuMat corners);

/** \brief Estimates the sharpness of a detected chessboard.
<p>
Image sharpness, as well as brightness, are a critical parameter for accuracte
camera calibration. For accessing these parameters for filtering out
problematic calibraiton images, this method calculates edge profiles by traveling from
black to white chessboard cell centers. Based on this, the number of pixels is
calculated required to transit from black to white. This width of the
transition area is a good indication of how sharp the chessboard is imaged
and should be below ~3.0 pixels.
<p>
@param image Gray image used to find chessboard corners
@param patternSize Size of a found chessboard pattern
@param corners Corners found by #findChessboardCornersSB
@param rise_distance Rise distance 0.8 means 10% ... 90% of the final signal strength
@param vertical By default edge responses for horizontal lines are calculated
@param sharpness Optional output array with a sharpness value for calculated edge responses (see description)
<p>
The optional sharpness array is of type CV_32FC1 and has for each calculated
profile one row with the following five entries:
* 0 = x coordinate of the underlying edge in the image
* 1 = y coordinate of the underlying edge in the image
* 2 = width of the transition area (sharpness)
* 3 = signal strength in the black cell (min brightness)
* 4 = signal strength in the white cell (max brightness)
<p>
@return Scalar(average sharpness, average min brightness, average max brightness,0)
*/
@Namespace("cv") public static native @ByVal Scalar estimateChessboardSharpness(@ByVal Mat image, @ByVal Size patternSize, @ByVal Mat corners,
                                                float rise_distance/*=0.8F*/,@Cast("bool") boolean vertical/*=false*/,
                                                @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat sharpness);
@Namespace("cv") public static native @ByVal Scalar estimateChessboardSharpness(@ByVal Mat image, @ByVal Size patternSize, @ByVal Mat corners);
@Namespace("cv") public static native @ByVal Scalar estimateChessboardSharpness(@ByVal UMat image, @ByVal Size patternSize, @ByVal UMat corners,
                                                float rise_distance/*=0.8F*/,@Cast("bool") boolean vertical/*=false*/,
                                                @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat sharpness);
@Namespace("cv") public static native @ByVal Scalar estimateChessboardSharpness(@ByVal UMat image, @ByVal Size patternSize, @ByVal UMat corners);
@Namespace("cv") public static native @ByVal Scalar estimateChessboardSharpness(@ByVal GpuMat image, @ByVal Size patternSize, @ByVal GpuMat corners,
                                                float rise_distance/*=0.8F*/,@Cast("bool") boolean vertical/*=false*/,
                                                @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat sharpness);
@Namespace("cv") public static native @ByVal Scalar estimateChessboardSharpness(@ByVal GpuMat image, @ByVal Size patternSize, @ByVal GpuMat corners);


/** finds subpixel-accurate positions of the chessboard corners */
@Namespace("cv") public static native @Cast("bool") boolean find4QuadCornerSubpix( @ByVal Mat img, @ByVal Mat corners, @ByVal Size region_size );
@Namespace("cv") public static native @Cast("bool") boolean find4QuadCornerSubpix( @ByVal UMat img, @ByVal UMat corners, @ByVal Size region_size );
@Namespace("cv") public static native @Cast("bool") boolean find4QuadCornerSubpix( @ByVal GpuMat img, @ByVal GpuMat corners, @ByVal Size region_size );

/** \brief Renders the detected chessboard corners.
<p>
@param image Destination image. It must be an 8-bit color image.
@param patternSize Number of inner corners per a chessboard row and column
(patternSize = cv::Size(points_per_row,points_per_column)).
@param corners Array of detected corners, the output of #findChessboardCorners.
@param patternWasFound Parameter indicating whether the complete board was found or not. The
return value of #findChessboardCorners should be passed here.
<p>
The function draws individual chessboard corners detected either as red circles if the board was not
found, or as colored corners connected with lines if the board was found.
 */
@Namespace("cv") public static native void drawChessboardCorners( @ByVal Mat image, @ByVal Size patternSize,
                                         @ByVal Mat corners, @Cast("bool") boolean patternWasFound );
@Namespace("cv") public static native void drawChessboardCorners( @ByVal UMat image, @ByVal Size patternSize,
                                         @ByVal UMat corners, @Cast("bool") boolean patternWasFound );
@Namespace("cv") public static native void drawChessboardCorners( @ByVal GpuMat image, @ByVal Size patternSize,
                                         @ByVal GpuMat corners, @Cast("bool") boolean patternWasFound );

/** \brief Draw axes of the world/object coordinate system from pose estimation. @see solvePnP
<p>
@param image Input/output image. It must have 1 or 3 channels. The number of channels is not altered.
@param cameraMatrix Input 3x3 floating-point matrix of camera intrinsic parameters.
{@code \cameramatrix{A}}
@param distCoeffs Input vector of distortion coefficients
{@code \distcoeffs}. If the vector is empty, the zero distortion coefficients are assumed.
@param rvec Rotation vector (see \ref Rodrigues ) that, together with tvec, brings points from
the model coordinate system to the camera coordinate system.
@param tvec Translation vector.
@param length Length of the painted axes in the same unit than tvec (usually in meters).
@param thickness Line thickness of the painted axes.
<p>
This function draws the axes of the world/object coordinate system w.r.t. to the camera frame.
OX is drawn in red, OY in green and OZ in blue.
 */
@Namespace("cv") public static native void drawFrameAxes(@ByVal Mat image, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                @ByVal Mat rvec, @ByVal Mat tvec, float length, int thickness/*=3*/);
@Namespace("cv") public static native void drawFrameAxes(@ByVal Mat image, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                @ByVal Mat rvec, @ByVal Mat tvec, float length);
@Namespace("cv") public static native void drawFrameAxes(@ByVal UMat image, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                @ByVal UMat rvec, @ByVal UMat tvec, float length, int thickness/*=3*/);
@Namespace("cv") public static native void drawFrameAxes(@ByVal UMat image, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                @ByVal UMat rvec, @ByVal UMat tvec, float length);
@Namespace("cv") public static native void drawFrameAxes(@ByVal GpuMat image, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                @ByVal GpuMat rvec, @ByVal GpuMat tvec, float length, int thickness/*=3*/);
@Namespace("cv") public static native void drawFrameAxes(@ByVal GpuMat image, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                @ByVal GpuMat rvec, @ByVal GpuMat tvec, float length);
// Targeting ../opencv_calib3d/CirclesGridFinderParameters.java



// #ifndef DISABLE_OPENCV_3_COMPATIBILITY
// #endif

/** \brief Finds centers in the grid of circles.
<p>
@param image grid view of input circles; it must be an 8-bit grayscale or color image.
@param patternSize number of circles per row and column
( patternSize = Size(points_per_row, points_per_colum) ).
@param centers output array of detected centers.
@param flags various operation flags that can be one of the following values:
-   \ref CALIB_CB_SYMMETRIC_GRID uses symmetric pattern of circles.
-   \ref CALIB_CB_ASYMMETRIC_GRID uses asymmetric pattern of circles.
-   \ref CALIB_CB_CLUSTERING uses a special algorithm for grid detection. It is more robust to
perspective distortions but much more sensitive to background clutter.
@param blobDetector feature detector that finds blobs like dark circles on light background.
                    If {@code blobDetector} is NULL then {@code image} represents Point2f array of candidates.
@param parameters struct for finding circles in a grid pattern.
<p>
The function attempts to determine whether the input image contains a grid of circles. If it is, the
function locates centers of the circles. The function returns a non-zero value if all of the centers
have been found and they have been placed in a certain order (row by row, left to right in every
row). Otherwise, if the function fails to find all the corners or reorder them, it returns 0.
<p>
Sample usage of detecting and drawing the centers of circles: :
<pre>{@code
    Size patternsize(7,7); //number of centers
    Mat gray = ...; //source image
    vector<Point2f> centers; //this will be filled by the detected centers

    bool patternfound = findCirclesGrid(gray, patternsize, centers);

    drawChessboardCorners(img, patternsize, Mat(centers), patternfound);
}</pre>
\note The function requires white space (like a square-thick border, the wider the better) around
the board to make the detection more robust in various environments.
 */
@Namespace("cv") public static native @Cast("bool") boolean findCirclesGrid( @ByVal Mat image, @ByVal Size patternSize,
                                   @ByVal Mat centers, int flags,
                                   @Cast("cv::FeatureDetector*") @Ptr Feature2D blobDetector,
                                   @Const @ByRef CirclesGridFinderParameters parameters);
@Namespace("cv") public static native @Cast("bool") boolean findCirclesGrid( @ByVal UMat image, @ByVal Size patternSize,
                                   @ByVal UMat centers, int flags,
                                   @Cast("cv::FeatureDetector*") @Ptr Feature2D blobDetector,
                                   @Const @ByRef CirclesGridFinderParameters parameters);
@Namespace("cv") public static native @Cast("bool") boolean findCirclesGrid( @ByVal GpuMat image, @ByVal Size patternSize,
                                   @ByVal GpuMat centers, int flags,
                                   @Cast("cv::FeatureDetector*") @Ptr Feature2D blobDetector,
                                   @Const @ByRef CirclesGridFinderParameters parameters);

/** \overload */
@Namespace("cv") public static native @Cast("bool") boolean findCirclesGrid( @ByVal Mat image, @ByVal Size patternSize,
                                   @ByVal Mat centers, int flags/*=cv::CALIB_CB_SYMMETRIC_GRID*/,
                                   @Cast("cv::FeatureDetector*") @Ptr Feature2D blobDetector/*=cv::SimpleBlobDetector::create()*/);
@Namespace("cv") public static native @Cast("bool") boolean findCirclesGrid( @ByVal Mat image, @ByVal Size patternSize,
                                   @ByVal Mat centers);
@Namespace("cv") public static native @Cast("bool") boolean findCirclesGrid( @ByVal UMat image, @ByVal Size patternSize,
                                   @ByVal UMat centers, int flags/*=cv::CALIB_CB_SYMMETRIC_GRID*/,
                                   @Cast("cv::FeatureDetector*") @Ptr Feature2D blobDetector/*=cv::SimpleBlobDetector::create()*/);
@Namespace("cv") public static native @Cast("bool") boolean findCirclesGrid( @ByVal UMat image, @ByVal Size patternSize,
                                   @ByVal UMat centers);
@Namespace("cv") public static native @Cast("bool") boolean findCirclesGrid( @ByVal GpuMat image, @ByVal Size patternSize,
                                   @ByVal GpuMat centers, int flags/*=cv::CALIB_CB_SYMMETRIC_GRID*/,
                                   @Cast("cv::FeatureDetector*") @Ptr Feature2D blobDetector/*=cv::SimpleBlobDetector::create()*/);
@Namespace("cv") public static native @Cast("bool") boolean findCirclesGrid( @ByVal GpuMat image, @ByVal Size patternSize,
                                   @ByVal GpuMat centers);

/** \brief Finds the camera intrinsic and extrinsic parameters from several views of a calibration
pattern.
<p>
@param objectPoints In the new interface it is a vector of vectors of calibration pattern points in
the calibration pattern coordinate space (e.g. std::vector<std::vector<cv::Vec3f>>). The outer
vector contains as many elements as the number of pattern views. If the same calibration pattern
is shown in each view and it is fully visible, all the vectors will be the same. Although, it is
possible to use partially occluded patterns or even different patterns in different views. Then,
the vectors will be different. Although the points are 3D, they all lie in the calibration pattern's
XY coordinate plane (thus 0 in the Z-coordinate), if the used calibration pattern is a planar rig.
In the old interface all the vectors of object points from different views are concatenated
together.
@param imagePoints In the new interface it is a vector of vectors of the projections of calibration
pattern points (e.g. std::vector<std::vector<cv::Vec2f>>). imagePoints.size() and
objectPoints.size(), and imagePoints[i].size() and objectPoints[i].size() for each i, must be equal,
respectively. In the old interface all the vectors of object points from different views are
concatenated together.
@param imageSize Size of the image used only to initialize the camera intrinsic matrix.
@param cameraMatrix Input/output 3x3 floating-point camera intrinsic matrix
{@code \cameramatrix{A}} . If \ref CALIB_USE_INTRINSIC_GUESS
and/or \ref CALIB_FIX_ASPECT_RATIO, \ref CALIB_FIX_PRINCIPAL_POINT or \ref CALIB_FIX_FOCAL_LENGTH
are specified, some or all of fx, fy, cx, cy must be initialized before calling the function.
@param distCoeffs Input/output vector of distortion coefficients
{@code \distcoeffs}.
@param rvecs Output vector of rotation vectors (\ref Rodrigues ) estimated for each pattern view
(e.g. std::vector<cv::Mat>>). That is, each i-th rotation vector together with the corresponding
i-th translation vector (see the next output parameter description) brings the calibration pattern
from the object coordinate space (in which object points are specified) to the camera coordinate
space. In more technical terms, the tuple of the i-th rotation and translation vector performs
a change of basis from object coordinate space to camera coordinate space. Due to its duality, this
tuple is equivalent to the position of the calibration pattern with respect to the camera coordinate
space.
@param tvecs Output vector of translation vectors estimated for each pattern view, see parameter
describtion above.
@param stdDeviationsIntrinsics Output vector of standard deviations estimated for intrinsic
parameters. Order of deviations values:
{@code (f_x, f_y, c_x, c_y, k_1, k_2, p_1, p_2, k_3, k_4, k_5, k_6 , s_1, s_2, s_3,
 s_4, \tau_x, \tau_y)} If one of parameters is not estimated, it's deviation is equals to zero.
@param stdDeviationsExtrinsics Output vector of standard deviations estimated for extrinsic
parameters. Order of deviations values: {@code (R_0, T_0, \dotsc , R_{M - 1}, T_{M - 1})} where M is
the number of pattern views. {@code R_i, T_i} are concatenated 1x3 vectors.
 @param perViewErrors Output vector of the RMS re-projection error estimated for each pattern view.
@param flags Different flags that may be zero or a combination of the following values:
-   \ref CALIB_USE_INTRINSIC_GUESS cameraMatrix contains valid initial values of
fx, fy, cx, cy that are optimized further. Otherwise, (cx, cy) is initially set to the image
center ( imageSize is used), and focal distances are computed in a least-squares fashion.
Note, that if intrinsic parameters are known, there is no need to use this function just to
estimate extrinsic parameters. Use \ref solvePnP instead.
-   \ref CALIB_FIX_PRINCIPAL_POINT The principal point is not changed during the global
optimization. It stays at the center or at a different location specified when
 \ref CALIB_USE_INTRINSIC_GUESS is set too.
-   \ref CALIB_FIX_ASPECT_RATIO The functions consider only fy as a free parameter. The
ratio fx/fy stays the same as in the input cameraMatrix . When
 \ref CALIB_USE_INTRINSIC_GUESS is not set, the actual input values of fx and fy are
ignored, only their ratio is computed and used further.
-   \ref CALIB_ZERO_TANGENT_DIST Tangential distortion coefficients {@code (p_1, p_2)} are set
to zeros and stay zero.
-   \ref CALIB_FIX_FOCAL_LENGTH The focal length is not changed during the global optimization if
 \ref CALIB_USE_INTRINSIC_GUESS is set.
-   \ref CALIB_FIX_K1,..., \ref CALIB_FIX_K6 The corresponding radial distortion
coefficient is not changed during the optimization. If \ref CALIB_USE_INTRINSIC_GUESS is
set, the coefficient from the supplied distCoeffs matrix is used. Otherwise, it is set to 0.
-   \ref CALIB_RATIONAL_MODEL Coefficients k4, k5, and k6 are enabled. To provide the
backward compatibility, this extra flag should be explicitly specified to make the
calibration function use the rational model and return 8 coefficients or more.
-   \ref CALIB_THIN_PRISM_MODEL Coefficients s1, s2, s3 and s4 are enabled. To provide the
backward compatibility, this extra flag should be explicitly specified to make the
calibration function use the thin prism model and return 12 coefficients or more.
-   \ref CALIB_FIX_S1_S2_S3_S4 The thin prism distortion coefficients are not changed during
the optimization. If \ref CALIB_USE_INTRINSIC_GUESS is set, the coefficient from the
supplied distCoeffs matrix is used. Otherwise, it is set to 0.
-   \ref CALIB_TILTED_MODEL Coefficients tauX and tauY are enabled. To provide the
backward compatibility, this extra flag should be explicitly specified to make the
calibration function use the tilted sensor model and return 14 coefficients.
-   \ref CALIB_FIX_TAUX_TAUY The coefficients of the tilted sensor model are not changed during
the optimization. If \ref CALIB_USE_INTRINSIC_GUESS is set, the coefficient from the
supplied distCoeffs matrix is used. Otherwise, it is set to 0.
@param criteria Termination criteria for the iterative optimization algorithm.
<p>
@return the overall RMS re-projection error.
<p>
The function estimates the intrinsic camera parameters and extrinsic parameters for each of the
views. The algorithm is based on \cite Zhang2000 and \cite BouguetMCT . The coordinates of 3D object
points and their corresponding 2D projections in each view must be specified. That may be achieved
by using an object with known geometry and easily detectable feature points. Such an object is
called a calibration rig or calibration pattern, and OpenCV has built-in support for a chessboard as
a calibration rig (see \ref findChessboardCorners). Currently, initialization of intrinsic
parameters (when \ref CALIB_USE_INTRINSIC_GUESS is not set) is only implemented for planar calibration
patterns (where Z-coordinates of the object points must be all zeros). 3D calibration rigs can also
be used as long as initial cameraMatrix is provided.
<p>
The algorithm performs the following steps:
<p>
-   Compute the initial intrinsic parameters (the option only available for planar calibration
    patterns) or read them from the input parameters. The distortion coefficients are all set to
    zeros initially unless some of CALIB_FIX_K? are specified.
<p>
-   Estimate the initial camera pose as if the intrinsic parameters have been already known. This is
    done using \ref solvePnP .
<p>
-   Run the global Levenberg-Marquardt optimization algorithm to minimize the reprojection error,
    that is, the total sum of squared distances between the observed feature points imagePoints and
    the projected (using the current estimates for camera parameters and the poses) object points
    objectPoints. See \ref projectPoints for details.
<p>
\note
    If you use a non-square (i.e. non-N-by-N) grid and \ref findChessboardCorners for calibration,
    and \ref calibrateCamera returns bad values (zero distortion coefficients, {@code c_x} and
    {@code c_y} very far from the image center, and/or large differences between {@code f_x} and
    {@code f_y} (ratios of 10:1 or more)), then you are probably using patternSize=cvSize(rows,cols)
    instead of using patternSize=cvSize(cols,rows) in \ref findChessboardCorners.
<p>
@see
   calibrateCameraRO, findChessboardCorners, solvePnP, initCameraMatrix2D, stereoCalibrate,
   undistort
 */
@Namespace("cv") public static native @Name("calibrateCamera") double calibrateCameraExtended( @ByVal Point3fVectorVector objectPoints,
                                     @ByVal Point2fVectorVector imagePoints, @ByVal Size imageSize,
                                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                     @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                                     @ByVal Mat stdDeviationsIntrinsics,
                                     @ByVal Mat stdDeviationsExtrinsics,
                                     @ByVal Mat perViewErrors,
                                     int flags/*=0*/, @ByVal(nullValue = "cv::TermCriteria("
                                         + "cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria );
@Namespace("cv") public static native @Name("calibrateCamera") double calibrateCameraExtended( @ByVal Point3fVectorVector objectPoints,
                                     @ByVal Point2fVectorVector imagePoints, @ByVal Size imageSize,
                                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                     @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                                     @ByVal Mat stdDeviationsIntrinsics,
                                     @ByVal Mat stdDeviationsExtrinsics,
                                     @ByVal Mat perViewErrors );
@Namespace("cv") public static native double calibrateCamera( @ByVal Point3fVectorVector objectPoints,
                                     @ByVal Point2fVectorVector imagePoints, @ByVal Size imageSize,
                                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                     @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                                     int flags/*=0*/, @ByVal(nullValue = "cv::TermCriteria("
                                         + "cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria );
@Namespace("cv") public static native double calibrateCamera( @ByVal Point3fVectorVector objectPoints,
                                     @ByVal Point2fVectorVector imagePoints, @ByVal Size imageSize,
                                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                     @ByVal MatVector rvecs, @ByVal MatVector tvecs );

/** \overload */

/** \brief Finds the camera intrinsic and extrinsic parameters from several views of a calibration pattern.
<p>
This function is an extension of #calibrateCamera with the method of releasing object which was
proposed in \cite strobl2011iccv. In many common cases with inaccurate, unmeasured, roughly planar
targets (calibration plates), this method can dramatically improve the precision of the estimated
camera parameters. Both the object-releasing method and standard method are supported by this
function. Use the parameter **iFixedPoint** for method selection. In the internal implementation,
#calibrateCamera is a wrapper for this function.
<p>
@param objectPoints Vector of vectors of calibration pattern points in the calibration pattern
coordinate space. See #calibrateCamera for details. If the method of releasing object to be used,
the identical calibration board must be used in each view and it must be fully visible, and all
objectPoints[i] must be the same and all points should be roughly close to a plane. **The calibration
target has to be rigid, or at least static if the camera (rather than the calibration target) is
shifted for grabbing images.**
@param imagePoints Vector of vectors of the projections of calibration pattern points. See
#calibrateCamera for details.
@param imageSize Size of the image used only to initialize the intrinsic camera matrix.
@param iFixedPoint The index of the 3D object point in objectPoints[0] to be fixed. It also acts as
a switch for calibration method selection. If object-releasing method to be used, pass in the
parameter in the range of [1, objectPoints[0].size()-2], otherwise a value out of this range will
make standard calibration method selected. Usually the top-right corner point of the calibration
board grid is recommended to be fixed when object-releasing method being utilized. According to
\cite strobl2011iccv, two other points are also fixed. In this implementation, objectPoints[0].front
and objectPoints[0].back.z are used. With object-releasing method, accurate rvecs, tvecs and
newObjPoints are only possible if coordinates of these three fixed points are accurate enough.
@param cameraMatrix Output 3x3 floating-point camera matrix. See #calibrateCamera for details.
@param distCoeffs Output vector of distortion coefficients. See #calibrateCamera for details.
@param rvecs Output vector of rotation vectors estimated for each pattern view. See #calibrateCamera
for details.
@param tvecs Output vector of translation vectors estimated for each pattern view.
@param newObjPoints The updated output vector of calibration pattern points. The coordinates might
be scaled based on three fixed points. The returned coordinates are accurate only if the above
mentioned three fixed points are accurate. If not needed, noArray() can be passed in. This parameter
is ignored with standard calibration method.
@param stdDeviationsIntrinsics Output vector of standard deviations estimated for intrinsic parameters.
See #calibrateCamera for details.
@param stdDeviationsExtrinsics Output vector of standard deviations estimated for extrinsic parameters.
See #calibrateCamera for details.
@param stdDeviationsObjPoints Output vector of standard deviations estimated for refined coordinates
of calibration pattern points. It has the same size and order as objectPoints[0] vector. This
parameter is ignored with standard calibration method.
 @param perViewErrors Output vector of the RMS re-projection error estimated for each pattern view.
@param flags Different flags that may be zero or a combination of some predefined values. See
#calibrateCamera for details. If the method of releasing object is used, the calibration time may
be much longer. CALIB_USE_QR or CALIB_USE_LU could be used for faster calibration with potentially
less precise and less stable in some rare cases.
@param criteria Termination criteria for the iterative optimization algorithm.
<p>
@return the overall RMS re-projection error.
<p>
The function estimates the intrinsic camera parameters and extrinsic parameters for each of the
views. The algorithm is based on \cite Zhang2000, \cite BouguetMCT and \cite strobl2011iccv. See
#calibrateCamera for other detailed explanations.
@see
   calibrateCamera, findChessboardCorners, solvePnP, initCameraMatrix2D, stereoCalibrate, undistort
 */
@Namespace("cv") public static native @Name("calibrateCameraRO") double calibrateCameraROExtended( @ByVal Point3fVectorVector objectPoints,
                                     @ByVal Point2fVectorVector imagePoints, @ByVal Size imageSize, int iFixedPoint,
                                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                     @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                                     @ByVal Mat newObjPoints,
                                     @ByVal Mat stdDeviationsIntrinsics,
                                     @ByVal Mat stdDeviationsExtrinsics,
                                     @ByVal Mat stdDeviationsObjPoints,
                                     @ByVal Mat perViewErrors,
                                     int flags/*=0*/, @ByVal(nullValue = "cv::TermCriteria("
                                         + "cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria );
@Namespace("cv") public static native @Name("calibrateCameraRO") double calibrateCameraROExtended( @ByVal Point3fVectorVector objectPoints,
                                     @ByVal Point2fVectorVector imagePoints, @ByVal Size imageSize, int iFixedPoint,
                                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                     @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                                     @ByVal Mat newObjPoints,
                                     @ByVal Mat stdDeviationsIntrinsics,
                                     @ByVal Mat stdDeviationsExtrinsics,
                                     @ByVal Mat stdDeviationsObjPoints,
                                     @ByVal Mat perViewErrors );@Namespace("cv") public static native double calibrateCameraRO( @ByVal Point3fVectorVector objectPoints,
                                     @ByVal Point2fVectorVector imagePoints, @ByVal Size imageSize, int iFixedPoint,
                                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                     @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                                     @ByVal Mat newObjPoints,
                                     int flags/*=0*/, @ByVal(nullValue = "cv::TermCriteria("
                                         + "cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria );
@Namespace("cv") public static native double calibrateCameraRO( @ByVal Point3fVectorVector objectPoints,
                                     @ByVal Point2fVectorVector imagePoints, @ByVal Size imageSize, int iFixedPoint,
                                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                     @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                                     @ByVal Mat newObjPoints );

/** \overload */

/** \brief Computes useful camera characteristics from the camera intrinsic matrix.
<p>
@param cameraMatrix Input camera intrinsic matrix that can be estimated by #calibrateCamera or
#stereoCalibrate .
@param imageSize Input image size in pixels.
@param apertureWidth Physical width in mm of the sensor.
@param apertureHeight Physical height in mm of the sensor.
@param fovx Output field of view in degrees along the horizontal sensor axis.
@param fovy Output field of view in degrees along the vertical sensor axis.
@param focalLength Focal length of the lens in mm.
@param principalPoint Principal point in mm.
@param aspectRatio {@code f_y/f_x}
<p>
The function computes various useful camera characteristics from the previously estimated camera
matrix.
<p>
\note
   Do keep in mind that the unity measure 'mm' stands for whatever unit of measure one chooses for
    the chessboard pitch (it can thus be any value).
 */
@Namespace("cv") public static native void calibrationMatrixValues( @ByVal Mat cameraMatrix, @ByVal Size imageSize,
                                           double apertureWidth, double apertureHeight,
                                           @ByRef DoublePointer fovx, @ByRef DoublePointer fovy,
                                           @ByRef DoublePointer focalLength, @ByRef Point2d principalPoint,
                                           @ByRef DoublePointer aspectRatio );
@Namespace("cv") public static native void calibrationMatrixValues( @ByVal Mat cameraMatrix, @ByVal Size imageSize,
                                           double apertureWidth, double apertureHeight,
                                           @ByRef DoubleBuffer fovx, @ByRef DoubleBuffer fovy,
                                           @ByRef DoubleBuffer focalLength, @ByRef Point2d principalPoint,
                                           @ByRef DoubleBuffer aspectRatio );
@Namespace("cv") public static native void calibrationMatrixValues( @ByVal Mat cameraMatrix, @ByVal Size imageSize,
                                           double apertureWidth, double apertureHeight,
                                           @ByRef double[] fovx, @ByRef double[] fovy,
                                           @ByRef double[] focalLength, @ByRef Point2d principalPoint,
                                           @ByRef double[] aspectRatio );
@Namespace("cv") public static native void calibrationMatrixValues( @ByVal UMat cameraMatrix, @ByVal Size imageSize,
                                           double apertureWidth, double apertureHeight,
                                           @ByRef DoublePointer fovx, @ByRef DoublePointer fovy,
                                           @ByRef DoublePointer focalLength, @ByRef Point2d principalPoint,
                                           @ByRef DoublePointer aspectRatio );
@Namespace("cv") public static native void calibrationMatrixValues( @ByVal UMat cameraMatrix, @ByVal Size imageSize,
                                           double apertureWidth, double apertureHeight,
                                           @ByRef DoubleBuffer fovx, @ByRef DoubleBuffer fovy,
                                           @ByRef DoubleBuffer focalLength, @ByRef Point2d principalPoint,
                                           @ByRef DoubleBuffer aspectRatio );
@Namespace("cv") public static native void calibrationMatrixValues( @ByVal UMat cameraMatrix, @ByVal Size imageSize,
                                           double apertureWidth, double apertureHeight,
                                           @ByRef double[] fovx, @ByRef double[] fovy,
                                           @ByRef double[] focalLength, @ByRef Point2d principalPoint,
                                           @ByRef double[] aspectRatio );
@Namespace("cv") public static native void calibrationMatrixValues( @ByVal GpuMat cameraMatrix, @ByVal Size imageSize,
                                           double apertureWidth, double apertureHeight,
                                           @ByRef DoublePointer fovx, @ByRef DoublePointer fovy,
                                           @ByRef DoublePointer focalLength, @ByRef Point2d principalPoint,
                                           @ByRef DoublePointer aspectRatio );
@Namespace("cv") public static native void calibrationMatrixValues( @ByVal GpuMat cameraMatrix, @ByVal Size imageSize,
                                           double apertureWidth, double apertureHeight,
                                           @ByRef DoubleBuffer fovx, @ByRef DoubleBuffer fovy,
                                           @ByRef DoubleBuffer focalLength, @ByRef Point2d principalPoint,
                                           @ByRef DoubleBuffer aspectRatio );
@Namespace("cv") public static native void calibrationMatrixValues( @ByVal GpuMat cameraMatrix, @ByVal Size imageSize,
                                           double apertureWidth, double apertureHeight,
                                           @ByRef double[] fovx, @ByRef double[] fovy,
                                           @ByRef double[] focalLength, @ByRef Point2d principalPoint,
                                           @ByRef double[] aspectRatio );

/** \brief Calibrates a stereo camera set up. This function finds the intrinsic parameters
for each of the two cameras and the extrinsic parameters between the two cameras.
<p>
@param objectPoints Vector of vectors of the calibration pattern points. The same structure as
in \ref calibrateCamera. For each pattern view, both cameras need to see the same object
points. Therefore, objectPoints.size(), imagePoints1.size(), and imagePoints2.size() need to be
equal as well as objectPoints[i].size(), imagePoints1[i].size(), and imagePoints2[i].size() need to
be equal for each i.
@param imagePoints1 Vector of vectors of the projections of the calibration pattern points,
observed by the first camera. The same structure as in \ref calibrateCamera.
@param imagePoints2 Vector of vectors of the projections of the calibration pattern points,
observed by the second camera. The same structure as in \ref calibrateCamera.
@param cameraMatrix1 Input/output camera intrinsic matrix for the first camera, the same as in
\ref calibrateCamera. Furthermore, for the stereo case, additional flags may be used, see below.
@param distCoeffs1 Input/output vector of distortion coefficients, the same as in
\ref calibrateCamera.
@param cameraMatrix2 Input/output second camera intrinsic matrix for the second camera. See description for
cameraMatrix1.
@param distCoeffs2 Input/output lens distortion coefficients for the second camera. See
description for distCoeffs1.
@param imageSize Size of the image used only to initialize the camera intrinsic matrices.
@param R Output rotation matrix. Together with the translation vector T, this matrix brings
points given in the first camera's coordinate system to points in the second camera's
coordinate system. In more technical terms, the tuple of R and T performs a change of basis
from the first camera's coordinate system to the second camera's coordinate system. Due to its
duality, this tuple is equivalent to the position of the first camera with respect to the
second camera coordinate system.
@param T Output translation vector, see description above.
@param E Output essential matrix.
@param F Output fundamental matrix.
@param perViewErrors Output vector of the RMS re-projection error estimated for each pattern view.
@param flags Different flags that may be zero or a combination of the following values:
-   \ref CALIB_FIX_INTRINSIC Fix cameraMatrix? and distCoeffs? so that only R, T, E, and F
matrices are estimated.
-   \ref CALIB_USE_INTRINSIC_GUESS Optimize some or all of the intrinsic parameters
according to the specified flags. Initial values are provided by the user.
-   \ref CALIB_USE_EXTRINSIC_GUESS R and T contain valid initial values that are optimized further.
Otherwise R and T are initialized to the median value of the pattern views (each dimension separately).
-   \ref CALIB_FIX_PRINCIPAL_POINT Fix the principal points during the optimization.
-   \ref CALIB_FIX_FOCAL_LENGTH Fix {@code f^{(j)}_x} and {@code f^{(j)}_y} .
-   \ref CALIB_FIX_ASPECT_RATIO Optimize {@code f^{(j)}_y} . Fix the ratio {@code f^{(j)}_x/f^{(j)}_y}
.
-   \ref CALIB_SAME_FOCAL_LENGTH Enforce {@code f^{(0)}_x=f^{(1)}_x} and {@code f^{(0)}_y=f^{(1)}_y} .
-   \ref CALIB_ZERO_TANGENT_DIST Set tangential distortion coefficients for each camera to
zeros and fix there.
-   \ref CALIB_FIX_K1,..., \ref CALIB_FIX_K6 Do not change the corresponding radial
distortion coefficient during the optimization. If \ref CALIB_USE_INTRINSIC_GUESS is set,
the coefficient from the supplied distCoeffs matrix is used. Otherwise, it is set to 0.
-   \ref CALIB_RATIONAL_MODEL Enable coefficients k4, k5, and k6. To provide the backward
compatibility, this extra flag should be explicitly specified to make the calibration
function use the rational model and return 8 coefficients. If the flag is not set, the
function computes and returns only 5 distortion coefficients.
-   \ref CALIB_THIN_PRISM_MODEL Coefficients s1, s2, s3 and s4 are enabled. To provide the
backward compatibility, this extra flag should be explicitly specified to make the
calibration function use the thin prism model and return 12 coefficients. If the flag is not
set, the function computes and returns only 5 distortion coefficients.
-   \ref CALIB_FIX_S1_S2_S3_S4 The thin prism distortion coefficients are not changed during
the optimization. If \ref CALIB_USE_INTRINSIC_GUESS is set, the coefficient from the
supplied distCoeffs matrix is used. Otherwise, it is set to 0.
-   \ref CALIB_TILTED_MODEL Coefficients tauX and tauY are enabled. To provide the
backward compatibility, this extra flag should be explicitly specified to make the
calibration function use the tilted sensor model and return 14 coefficients. If the flag is not
set, the function computes and returns only 5 distortion coefficients.
-   \ref CALIB_FIX_TAUX_TAUY The coefficients of the tilted sensor model are not changed during
the optimization. If \ref CALIB_USE_INTRINSIC_GUESS is set, the coefficient from the
supplied distCoeffs matrix is used. Otherwise, it is set to 0.
@param criteria Termination criteria for the iterative optimization algorithm.
<p>
The function estimates the transformation between two cameras making a stereo pair. If one computes
the poses of an object relative to the first camera and to the second camera,
( {@code R_1},{@code T_1} ) and ({@code R_2},{@code T_2}), respectively, for a stereo camera where the
relative position and orientation between the two cameras are fixed, then those poses definitely
relate to each other. This means, if the relative position and orientation ({@code R},{@code T}) of the
two cameras is known, it is possible to compute ({@code R_2},{@code T_2}) when ({@code R_1},{@code T_1}) is
given. This is what the described function does. It computes ({@code R},{@code T}) such that:
<p>
<pre>{@code \[R_2=R R_1\]}</pre>
<pre>{@code \[T_2=R T_1 + T.\]}</pre>
<p>
Therefore, one can compute the coordinate representation of a 3D point for the second camera's
coordinate system when given the point's coordinate representation in the first camera's coordinate
system:
<p>
<pre>{@code \[\begin{bmatrix}
X_2 \\
Y_2 \\
Z_2 \\
1
\end{bmatrix} = \begin{bmatrix}
R & T \\
0 & 1
\end{bmatrix} \begin{bmatrix}
X_1 \\
Y_1 \\
Z_1 \\
1
\end{bmatrix}.\]}</pre>
<p>
<p>
Optionally, it computes the essential matrix E:
<p>
<pre>{@code \[E= \vecthreethree{0}{-T_2}{T_1}{T_2}{0}{-T_0}{-T_1}{T_0}{0} R\]}</pre>
<p>
where {@code T_i} are components of the translation vector {@code T} : {@code T=[T_0, T_1, T_2]^T} .
And the function can also compute the fundamental matrix F:
<p>
<pre>{@code \[F = cameraMatrix2^{-T}\cdot E \cdot cameraMatrix1^{-1}\]}</pre>
<p>
Besides the stereo-related information, the function can also perform a full calibration of each of
the two cameras. However, due to the high dimensionality of the parameter space and noise in the
input data, the function can diverge from the correct solution. If the intrinsic parameters can be
estimated with high accuracy for each of the cameras individually (for example, using
#calibrateCamera ), you are recommended to do so and then pass \ref CALIB_FIX_INTRINSIC flag to the
function along with the computed intrinsic parameters. Otherwise, if all the parameters are
estimated at once, it makes sense to restrict some parameters, for example, pass
 \ref CALIB_SAME_FOCAL_LENGTH and \ref CALIB_ZERO_TANGENT_DIST flags, which is usually a
reasonable assumption.
<p>
Similarly to #calibrateCamera, the function minimizes the total re-projection error for all the
points in all the available views from both cameras. The function returns the final value of the
re-projection error.
 */
@Namespace("cv") public static native @Name("stereoCalibrate") double stereoCalibrateExtended( @ByVal Point3fVectorVector objectPoints,
                                     @ByVal Point2fVectorVector imagePoints1, @ByVal Point2fVectorVector imagePoints2,
                                     @ByVal Mat cameraMatrix1, @ByVal Mat distCoeffs1,
                                     @ByVal Mat cameraMatrix2, @ByVal Mat distCoeffs2,
                                     @ByVal Size imageSize, @ByVal Mat R,@ByVal Mat T, @ByVal Mat E, @ByVal Mat F,
                                     @ByVal Mat perViewErrors, int flags/*=cv::CALIB_FIX_INTRINSIC*/,
                                     @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 30, 1e-6)") TermCriteria criteria );
@Namespace("cv") public static native @Name("stereoCalibrate") double stereoCalibrateExtended( @ByVal Point3fVectorVector objectPoints,
                                     @ByVal Point2fVectorVector imagePoints1, @ByVal Point2fVectorVector imagePoints2,
                                     @ByVal Mat cameraMatrix1, @ByVal Mat distCoeffs1,
                                     @ByVal Mat cameraMatrix2, @ByVal Mat distCoeffs2,
                                     @ByVal Size imageSize, @ByVal Mat R,@ByVal Mat T, @ByVal Mat E, @ByVal Mat F,
                                     @ByVal Mat perViewErrors );
@Namespace("cv") public static native double stereoCalibrate( @ByVal Point3fVectorVector objectPoints,
                                     @ByVal Point2fVectorVector imagePoints1, @ByVal Point2fVectorVector imagePoints2,
                                     @ByVal Mat cameraMatrix1, @ByVal Mat distCoeffs1,
                                     @ByVal Mat cameraMatrix2, @ByVal Mat distCoeffs2,
                                     @ByVal Size imageSize, @ByVal Mat R,@ByVal Mat T, @ByVal Mat E, @ByVal Mat F,
                                     int flags/*=cv::CALIB_FIX_INTRINSIC*/,
                                     @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 30, 1e-6)") TermCriteria criteria );
@Namespace("cv") public static native double stereoCalibrate( @ByVal Point3fVectorVector objectPoints,
                                     @ByVal Point2fVectorVector imagePoints1, @ByVal Point2fVectorVector imagePoints2,
                                     @ByVal Mat cameraMatrix1, @ByVal Mat distCoeffs1,
                                     @ByVal Mat cameraMatrix2, @ByVal Mat distCoeffs2,
                                     @ByVal Size imageSize, @ByVal Mat R,@ByVal Mat T, @ByVal Mat E, @ByVal Mat F );

/** \overload */

/** \brief Computes rectification transforms for each head of a calibrated stereo camera.
<p>
@param cameraMatrix1 First camera intrinsic matrix.
@param distCoeffs1 First camera distortion parameters.
@param cameraMatrix2 Second camera intrinsic matrix.
@param distCoeffs2 Second camera distortion parameters.
@param imageSize Size of the image used for stereo calibration.
@param R Rotation matrix from the coordinate system of the first camera to the second camera,
see \ref stereoCalibrate.
@param T Translation vector from the coordinate system of the first camera to the second camera,
see \ref stereoCalibrate.
@param R1 Output 3x3 rectification transform (rotation matrix) for the first camera. This matrix
brings points given in the unrectified first camera's coordinate system to points in the rectified
first camera's coordinate system. In more technical terms, it performs a change of basis from the
unrectified first camera's coordinate system to the rectified first camera's coordinate system.
@param R2 Output 3x3 rectification transform (rotation matrix) for the second camera. This matrix
brings points given in the unrectified second camera's coordinate system to points in the rectified
second camera's coordinate system. In more technical terms, it performs a change of basis from the
unrectified second camera's coordinate system to the rectified second camera's coordinate system.
@param P1 Output 3x4 projection matrix in the new (rectified) coordinate systems for the first
camera, i.e. it projects points given in the rectified first camera coordinate system into the
rectified first camera's image.
@param P2 Output 3x4 projection matrix in the new (rectified) coordinate systems for the second
camera, i.e. it projects points given in the rectified first camera coordinate system into the
rectified second camera's image.
@param Q Output {@code 4 \times 4} disparity-to-depth mapping matrix (see \ref reprojectImageTo3D).
@param flags Operation flags that may be zero or \ref CALIB_ZERO_DISPARITY . If the flag is set,
the function makes the principal points of each camera have the same pixel coordinates in the
rectified views. And if the flag is not set, the function may still shift the images in the
horizontal or vertical direction (depending on the orientation of epipolar lines) to maximize the
useful image area.
@param alpha Free scaling parameter. If it is -1 or absent, the function performs the default
scaling. Otherwise, the parameter should be between 0 and 1. alpha=0 means that the rectified
images are zoomed and shifted so that only valid pixels are visible (no black areas after
rectification). alpha=1 means that the rectified image is decimated and shifted so that all the
pixels from the original images from the cameras are retained in the rectified images (no source
image pixels are lost). Any intermediate value yields an intermediate result between
those two extreme cases.
@param newImageSize New image resolution after rectification. The same size should be passed to
#initUndistortRectifyMap (see the stereo_calib.cpp sample in OpenCV samples directory). When (0,0)
is passed (default), it is set to the original imageSize . Setting it to a larger value can help you
preserve details in the original image, especially when there is a big radial distortion.
@param validPixROI1 Optional output rectangles inside the rectified images where all the pixels
are valid. If alpha=0 , the ROIs cover the whole images. Otherwise, they are likely to be smaller
(see the picture below).
@param validPixROI2 Optional output rectangles inside the rectified images where all the pixels
are valid. If alpha=0 , the ROIs cover the whole images. Otherwise, they are likely to be smaller
(see the picture below).
<p>
The function computes the rotation matrices for each camera that (virtually) make both camera image
planes the same plane. Consequently, this makes all the epipolar lines parallel and thus simplifies
the dense stereo correspondence problem. The function takes the matrices computed by #stereoCalibrate
as input. As output, it provides two rotation matrices and also two projection matrices in the new
coordinates. The function distinguishes the following two cases:
<p>
-   **Horizontal stereo**: the first and the second camera views are shifted relative to each other
    mainly along the x-axis (with possible small vertical shift). In the rectified images, the
    corresponding epipolar lines in the left and right cameras are horizontal and have the same
    y-coordinate. P1 and P2 look like:
    <p>
    <pre>{@code \[\texttt{P1} = \begin{bmatrix}
                        f & 0 & cx_1 & 0 \\
                        0 & f & cy & 0 \\
                        0 & 0 & 1 & 0
                     \end{bmatrix}\]}</pre>
    <p>
    <pre>{@code \[\texttt{P2} = \begin{bmatrix}
                        f & 0 & cx_2 & T_x*f \\
                        0 & f & cy & 0 \\
                        0 & 0 & 1 & 0
                     \end{bmatrix} ,\]}</pre>
    <p>
    where {@code T_x} is a horizontal shift between the cameras and {@code cx_1=cx_2} if
    \ref CALIB_ZERO_DISPARITY is set.
<p>
-   **Vertical stereo**: the first and the second camera views are shifted relative to each other
    mainly in the vertical direction (and probably a bit in the horizontal direction too). The epipolar
    lines in the rectified images are vertical and have the same x-coordinate. P1 and P2 look like:
    <p>
    <pre>{@code \[\texttt{P1} = \begin{bmatrix}
                        f & 0 & cx & 0 \\
                        0 & f & cy_1 & 0 \\
                        0 & 0 & 1 & 0
                     \end{bmatrix}\]}</pre>
    <p>
    <pre>{@code \[\texttt{P2} = \begin{bmatrix}
                        f & 0 & cx & 0 \\
                        0 & f & cy_2 & T_y*f \\
                        0 & 0 & 1 & 0
                     \end{bmatrix},\]}</pre>
    <p>
    where {@code T_y} is a vertical shift between the cameras and {@code cy_1=cy_2} if
    \ref CALIB_ZERO_DISPARITY is set.
<p>
As you can see, the first three columns of P1 and P2 will effectively be the new "rectified" camera
matrices. The matrices, together with R1 and R2 , can then be passed to #initUndistortRectifyMap to
initialize the rectification map for each camera.
<p>
See below the screenshot from the stereo_calib.cpp sample. Some red horizontal lines pass through
the corresponding image regions. This means that the images are well rectified, which is what most
stereo correspondence algorithms rely on. The green rectangles are roi1 and roi2 . You see that
their interiors are all valid pixels.
<p>
![image](pics/stereo_undistort.jpg)
 */
@Namespace("cv") public static native void stereoRectify( @ByVal Mat cameraMatrix1, @ByVal Mat distCoeffs1,
                                 @ByVal Mat cameraMatrix2, @ByVal Mat distCoeffs2,
                                 @ByVal Size imageSize, @ByVal Mat R, @ByVal Mat T,
                                 @ByVal Mat R1, @ByVal Mat R2,
                                 @ByVal Mat P1, @ByVal Mat P2,
                                 @ByVal Mat Q, int flags/*=cv::CALIB_ZERO_DISPARITY*/,
                                 double alpha/*=-1*/, @ByVal(nullValue = "cv::Size()") Size newImageSize,
                                 Rect validPixROI1/*=0*/, Rect validPixROI2/*=0*/ );
@Namespace("cv") public static native void stereoRectify( @ByVal Mat cameraMatrix1, @ByVal Mat distCoeffs1,
                                 @ByVal Mat cameraMatrix2, @ByVal Mat distCoeffs2,
                                 @ByVal Size imageSize, @ByVal Mat R, @ByVal Mat T,
                                 @ByVal Mat R1, @ByVal Mat R2,
                                 @ByVal Mat P1, @ByVal Mat P2,
                                 @ByVal Mat Q );
@Namespace("cv") public static native void stereoRectify( @ByVal UMat cameraMatrix1, @ByVal UMat distCoeffs1,
                                 @ByVal UMat cameraMatrix2, @ByVal UMat distCoeffs2,
                                 @ByVal Size imageSize, @ByVal UMat R, @ByVal UMat T,
                                 @ByVal UMat R1, @ByVal UMat R2,
                                 @ByVal UMat P1, @ByVal UMat P2,
                                 @ByVal UMat Q, int flags/*=cv::CALIB_ZERO_DISPARITY*/,
                                 double alpha/*=-1*/, @ByVal(nullValue = "cv::Size()") Size newImageSize,
                                 Rect validPixROI1/*=0*/, Rect validPixROI2/*=0*/ );
@Namespace("cv") public static native void stereoRectify( @ByVal UMat cameraMatrix1, @ByVal UMat distCoeffs1,
                                 @ByVal UMat cameraMatrix2, @ByVal UMat distCoeffs2,
                                 @ByVal Size imageSize, @ByVal UMat R, @ByVal UMat T,
                                 @ByVal UMat R1, @ByVal UMat R2,
                                 @ByVal UMat P1, @ByVal UMat P2,
                                 @ByVal UMat Q );
@Namespace("cv") public static native void stereoRectify( @ByVal GpuMat cameraMatrix1, @ByVal GpuMat distCoeffs1,
                                 @ByVal GpuMat cameraMatrix2, @ByVal GpuMat distCoeffs2,
                                 @ByVal Size imageSize, @ByVal GpuMat R, @ByVal GpuMat T,
                                 @ByVal GpuMat R1, @ByVal GpuMat R2,
                                 @ByVal GpuMat P1, @ByVal GpuMat P2,
                                 @ByVal GpuMat Q, int flags/*=cv::CALIB_ZERO_DISPARITY*/,
                                 double alpha/*=-1*/, @ByVal(nullValue = "cv::Size()") Size newImageSize,
                                 Rect validPixROI1/*=0*/, Rect validPixROI2/*=0*/ );
@Namespace("cv") public static native void stereoRectify( @ByVal GpuMat cameraMatrix1, @ByVal GpuMat distCoeffs1,
                                 @ByVal GpuMat cameraMatrix2, @ByVal GpuMat distCoeffs2,
                                 @ByVal Size imageSize, @ByVal GpuMat R, @ByVal GpuMat T,
                                 @ByVal GpuMat R1, @ByVal GpuMat R2,
                                 @ByVal GpuMat P1, @ByVal GpuMat P2,
                                 @ByVal GpuMat Q );

/** \brief Computes a rectification transform for an uncalibrated stereo camera.
<p>
@param points1 Array of feature points in the first image.
@param points2 The corresponding points in the second image. The same formats as in
#findFundamentalMat are supported.
@param F Input fundamental matrix. It can be computed from the same set of point pairs using
#findFundamentalMat .
@param imgSize Size of the image.
@param H1 Output rectification homography matrix for the first image.
@param H2 Output rectification homography matrix for the second image.
@param threshold Optional threshold used to filter out the outliers. If the parameter is greater
than zero, all the point pairs that do not comply with the epipolar geometry (that is, the points
for which {@code |\texttt{points2[i]}^T*\texttt{F}*\texttt{points1[i]}|>\texttt{threshold}} ) are
rejected prior to computing the homographies. Otherwise, all the points are considered inliers.
<p>
The function computes the rectification transformations without knowing intrinsic parameters of the
cameras and their relative position in the space, which explains the suffix "uncalibrated". Another
related difference from #stereoRectify is that the function outputs not the rectification
transformations in the object (3D) space, but the planar perspective transformations encoded by the
homography matrices H1 and H2 . The function implements the algorithm \cite Hartley99 .
<p>
\note
   While the algorithm does not need to know the intrinsic parameters of the cameras, it heavily
    depends on the epipolar geometry. Therefore, if the camera lenses have a significant distortion,
    it would be better to correct it before computing the fundamental matrix and calling this
    function. For example, distortion coefficients can be estimated for each head of stereo camera
    separately by using #calibrateCamera . Then, the images can be corrected using #undistort , or
    just the point coordinates can be corrected with #undistortPoints .
 */
@Namespace("cv") public static native @Cast("bool") boolean stereoRectifyUncalibrated( @ByVal Mat points1, @ByVal Mat points2,
                                             @ByVal Mat F, @ByVal Size imgSize,
                                             @ByVal Mat H1, @ByVal Mat H2,
                                             double threshold/*=5*/ );
@Namespace("cv") public static native @Cast("bool") boolean stereoRectifyUncalibrated( @ByVal Mat points1, @ByVal Mat points2,
                                             @ByVal Mat F, @ByVal Size imgSize,
                                             @ByVal Mat H1, @ByVal Mat H2 );
@Namespace("cv") public static native @Cast("bool") boolean stereoRectifyUncalibrated( @ByVal UMat points1, @ByVal UMat points2,
                                             @ByVal UMat F, @ByVal Size imgSize,
                                             @ByVal UMat H1, @ByVal UMat H2,
                                             double threshold/*=5*/ );
@Namespace("cv") public static native @Cast("bool") boolean stereoRectifyUncalibrated( @ByVal UMat points1, @ByVal UMat points2,
                                             @ByVal UMat F, @ByVal Size imgSize,
                                             @ByVal UMat H1, @ByVal UMat H2 );
@Namespace("cv") public static native @Cast("bool") boolean stereoRectifyUncalibrated( @ByVal GpuMat points1, @ByVal GpuMat points2,
                                             @ByVal GpuMat F, @ByVal Size imgSize,
                                             @ByVal GpuMat H1, @ByVal GpuMat H2,
                                             double threshold/*=5*/ );
@Namespace("cv") public static native @Cast("bool") boolean stereoRectifyUncalibrated( @ByVal GpuMat points1, @ByVal GpuMat points2,
                                             @ByVal GpuMat F, @ByVal Size imgSize,
                                             @ByVal GpuMat H1, @ByVal GpuMat H2 );

/** computes the rectification transformations for 3-head camera, where all the heads are on the same line. */
@Namespace("cv") public static native float rectify3Collinear( @ByVal Mat cameraMatrix1, @ByVal Mat distCoeffs1,
                                      @ByVal Mat cameraMatrix2, @ByVal Mat distCoeffs2,
                                      @ByVal Mat cameraMatrix3, @ByVal Mat distCoeffs3,
                                      @ByVal MatVector imgpt1, @ByVal MatVector imgpt3,
                                      @ByVal Size imageSize, @ByVal Mat R12, @ByVal Mat T12,
                                      @ByVal Mat R13, @ByVal Mat T13,
                                      @ByVal Mat R1, @ByVal Mat R2, @ByVal Mat R3,
                                      @ByVal Mat P1, @ByVal Mat P2, @ByVal Mat P3,
                                      @ByVal Mat Q, double alpha, @ByVal Size newImgSize,
                                      Rect roi1, Rect roi2, int flags );
@Namespace("cv") public static native float rectify3Collinear( @ByVal Mat cameraMatrix1, @ByVal Mat distCoeffs1,
                                      @ByVal Mat cameraMatrix2, @ByVal Mat distCoeffs2,
                                      @ByVal Mat cameraMatrix3, @ByVal Mat distCoeffs3,
                                      @ByVal UMatVector imgpt1, @ByVal UMatVector imgpt3,
                                      @ByVal Size imageSize, @ByVal Mat R12, @ByVal Mat T12,
                                      @ByVal Mat R13, @ByVal Mat T13,
                                      @ByVal Mat R1, @ByVal Mat R2, @ByVal Mat R3,
                                      @ByVal Mat P1, @ByVal Mat P2, @ByVal Mat P3,
                                      @ByVal Mat Q, double alpha, @ByVal Size newImgSize,
                                      Rect roi1, Rect roi2, int flags );
@Namespace("cv") public static native float rectify3Collinear( @ByVal Mat cameraMatrix1, @ByVal Mat distCoeffs1,
                                      @ByVal Mat cameraMatrix2, @ByVal Mat distCoeffs2,
                                      @ByVal Mat cameraMatrix3, @ByVal Mat distCoeffs3,
                                      @ByVal GpuMatVector imgpt1, @ByVal GpuMatVector imgpt3,
                                      @ByVal Size imageSize, @ByVal Mat R12, @ByVal Mat T12,
                                      @ByVal Mat R13, @ByVal Mat T13,
                                      @ByVal Mat R1, @ByVal Mat R2, @ByVal Mat R3,
                                      @ByVal Mat P1, @ByVal Mat P2, @ByVal Mat P3,
                                      @ByVal Mat Q, double alpha, @ByVal Size newImgSize,
                                      Rect roi1, Rect roi2, int flags );
@Namespace("cv") public static native float rectify3Collinear( @ByVal UMat cameraMatrix1, @ByVal UMat distCoeffs1,
                                      @ByVal UMat cameraMatrix2, @ByVal UMat distCoeffs2,
                                      @ByVal UMat cameraMatrix3, @ByVal UMat distCoeffs3,
                                      @ByVal MatVector imgpt1, @ByVal MatVector imgpt3,
                                      @ByVal Size imageSize, @ByVal UMat R12, @ByVal UMat T12,
                                      @ByVal UMat R13, @ByVal UMat T13,
                                      @ByVal UMat R1, @ByVal UMat R2, @ByVal UMat R3,
                                      @ByVal UMat P1, @ByVal UMat P2, @ByVal UMat P3,
                                      @ByVal UMat Q, double alpha, @ByVal Size newImgSize,
                                      Rect roi1, Rect roi2, int flags );
@Namespace("cv") public static native float rectify3Collinear( @ByVal UMat cameraMatrix1, @ByVal UMat distCoeffs1,
                                      @ByVal UMat cameraMatrix2, @ByVal UMat distCoeffs2,
                                      @ByVal UMat cameraMatrix3, @ByVal UMat distCoeffs3,
                                      @ByVal UMatVector imgpt1, @ByVal UMatVector imgpt3,
                                      @ByVal Size imageSize, @ByVal UMat R12, @ByVal UMat T12,
                                      @ByVal UMat R13, @ByVal UMat T13,
                                      @ByVal UMat R1, @ByVal UMat R2, @ByVal UMat R3,
                                      @ByVal UMat P1, @ByVal UMat P2, @ByVal UMat P3,
                                      @ByVal UMat Q, double alpha, @ByVal Size newImgSize,
                                      Rect roi1, Rect roi2, int flags );
@Namespace("cv") public static native float rectify3Collinear( @ByVal UMat cameraMatrix1, @ByVal UMat distCoeffs1,
                                      @ByVal UMat cameraMatrix2, @ByVal UMat distCoeffs2,
                                      @ByVal UMat cameraMatrix3, @ByVal UMat distCoeffs3,
                                      @ByVal GpuMatVector imgpt1, @ByVal GpuMatVector imgpt3,
                                      @ByVal Size imageSize, @ByVal UMat R12, @ByVal UMat T12,
                                      @ByVal UMat R13, @ByVal UMat T13,
                                      @ByVal UMat R1, @ByVal UMat R2, @ByVal UMat R3,
                                      @ByVal UMat P1, @ByVal UMat P2, @ByVal UMat P3,
                                      @ByVal UMat Q, double alpha, @ByVal Size newImgSize,
                                      Rect roi1, Rect roi2, int flags );
@Namespace("cv") public static native float rectify3Collinear( @ByVal GpuMat cameraMatrix1, @ByVal GpuMat distCoeffs1,
                                      @ByVal GpuMat cameraMatrix2, @ByVal GpuMat distCoeffs2,
                                      @ByVal GpuMat cameraMatrix3, @ByVal GpuMat distCoeffs3,
                                      @ByVal MatVector imgpt1, @ByVal MatVector imgpt3,
                                      @ByVal Size imageSize, @ByVal GpuMat R12, @ByVal GpuMat T12,
                                      @ByVal GpuMat R13, @ByVal GpuMat T13,
                                      @ByVal GpuMat R1, @ByVal GpuMat R2, @ByVal GpuMat R3,
                                      @ByVal GpuMat P1, @ByVal GpuMat P2, @ByVal GpuMat P3,
                                      @ByVal GpuMat Q, double alpha, @ByVal Size newImgSize,
                                      Rect roi1, Rect roi2, int flags );
@Namespace("cv") public static native float rectify3Collinear( @ByVal GpuMat cameraMatrix1, @ByVal GpuMat distCoeffs1,
                                      @ByVal GpuMat cameraMatrix2, @ByVal GpuMat distCoeffs2,
                                      @ByVal GpuMat cameraMatrix3, @ByVal GpuMat distCoeffs3,
                                      @ByVal UMatVector imgpt1, @ByVal UMatVector imgpt3,
                                      @ByVal Size imageSize, @ByVal GpuMat R12, @ByVal GpuMat T12,
                                      @ByVal GpuMat R13, @ByVal GpuMat T13,
                                      @ByVal GpuMat R1, @ByVal GpuMat R2, @ByVal GpuMat R3,
                                      @ByVal GpuMat P1, @ByVal GpuMat P2, @ByVal GpuMat P3,
                                      @ByVal GpuMat Q, double alpha, @ByVal Size newImgSize,
                                      Rect roi1, Rect roi2, int flags );
@Namespace("cv") public static native float rectify3Collinear( @ByVal GpuMat cameraMatrix1, @ByVal GpuMat distCoeffs1,
                                      @ByVal GpuMat cameraMatrix2, @ByVal GpuMat distCoeffs2,
                                      @ByVal GpuMat cameraMatrix3, @ByVal GpuMat distCoeffs3,
                                      @ByVal GpuMatVector imgpt1, @ByVal GpuMatVector imgpt3,
                                      @ByVal Size imageSize, @ByVal GpuMat R12, @ByVal GpuMat T12,
                                      @ByVal GpuMat R13, @ByVal GpuMat T13,
                                      @ByVal GpuMat R1, @ByVal GpuMat R2, @ByVal GpuMat R3,
                                      @ByVal GpuMat P1, @ByVal GpuMat P2, @ByVal GpuMat P3,
                                      @ByVal GpuMat Q, double alpha, @ByVal Size newImgSize,
                                      Rect roi1, Rect roi2, int flags );

/** \brief Returns the new camera intrinsic matrix based on the free scaling parameter.
<p>
@param cameraMatrix Input camera intrinsic matrix.
@param distCoeffs Input vector of distortion coefficients
{@code \distcoeffs}. If the vector is NULL/empty, the zero distortion coefficients are
assumed.
@param imageSize Original image size.
@param alpha Free scaling parameter between 0 (when all the pixels in the undistorted image are
valid) and 1 (when all the source image pixels are retained in the undistorted image). See
#stereoRectify for details.
@param newImgSize Image size after rectification. By default, it is set to imageSize .
@param validPixROI Optional output rectangle that outlines all-good-pixels region in the
undistorted image. See roi1, roi2 description in #stereoRectify .
@param centerPrincipalPoint Optional flag that indicates whether in the new camera intrinsic matrix the
principal point should be at the image center or not. By default, the principal point is chosen to
best fit a subset of the source image (determined by alpha) to the corrected image.
@return new_camera_matrix Output new camera intrinsic matrix.
<p>
The function computes and returns the optimal new camera intrinsic matrix based on the free scaling parameter.
By varying this parameter, you may retrieve only sensible pixels alpha=0 , keep all the original
image pixels if there is valuable information in the corners alpha=1 , or get something in between.
When alpha\>0 , the undistorted result is likely to have some black pixels corresponding to
"virtual" pixels outside of the captured distorted image. The original camera intrinsic matrix, distortion
coefficients, the computed new camera intrinsic matrix, and newImageSize should be passed to
#initUndistortRectifyMap to produce the maps for #remap .
 */
@Namespace("cv") public static native @ByVal Mat getOptimalNewCameraMatrix( @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                            @ByVal Size imageSize, double alpha, @ByVal(nullValue = "cv::Size()") Size newImgSize,
                                            Rect validPixROI/*=0*/,
                                            @Cast("bool") boolean centerPrincipalPoint/*=false*/);
@Namespace("cv") public static native @ByVal Mat getOptimalNewCameraMatrix( @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                            @ByVal Size imageSize, double alpha);
@Namespace("cv") public static native @ByVal Mat getOptimalNewCameraMatrix( @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                            @ByVal Size imageSize, double alpha, @ByVal(nullValue = "cv::Size()") Size newImgSize,
                                            Rect validPixROI/*=0*/,
                                            @Cast("bool") boolean centerPrincipalPoint/*=false*/);
@Namespace("cv") public static native @ByVal Mat getOptimalNewCameraMatrix( @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                            @ByVal Size imageSize, double alpha);
@Namespace("cv") public static native @ByVal Mat getOptimalNewCameraMatrix( @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                            @ByVal Size imageSize, double alpha, @ByVal(nullValue = "cv::Size()") Size newImgSize,
                                            Rect validPixROI/*=0*/,
                                            @Cast("bool") boolean centerPrincipalPoint/*=false*/);
@Namespace("cv") public static native @ByVal Mat getOptimalNewCameraMatrix( @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                            @ByVal Size imageSize, double alpha);

/** \brief Computes Hand-Eye calibration: {@code _{}^{g}\textrm{T}_c}
<p>
@param R_gripper [in] 2base Rotation part extracted from the homogeneous matrix that transforms a point
expressed in the gripper frame to the robot base frame ({@code _{}^{b}\textrm{T}_g}).
This is a vector ({@code vector<Mat>}) that contains the rotation, {@code (3x3)} rotation matrices or {@code (3x1)} rotation vectors,
for all the transformations from gripper frame to robot base frame.
@param t_gripper [in] 2base Translation part extracted from the homogeneous matrix that transforms a point
expressed in the gripper frame to the robot base frame ({@code _{}^{b}\textrm{T}_g}).
This is a vector ({@code vector<Mat>}) that contains the {@code (3x1)} translation vectors for all the transformations
from gripper frame to robot base frame.
@param R_target [in] 2cam Rotation part extracted from the homogeneous matrix that transforms a point
expressed in the target frame to the camera frame ({@code _{}^{c}\textrm{T}_t}).
This is a vector ({@code vector<Mat>}) that contains the rotation, {@code (3x3)} rotation matrices or {@code (3x1)} rotation vectors,
for all the transformations from calibration target frame to camera frame.
@param t_target [in] 2cam Rotation part extracted from the homogeneous matrix that transforms a point
expressed in the target frame to the camera frame ({@code _{}^{c}\textrm{T}_t}).
This is a vector ({@code vector<Mat>}) that contains the {@code (3x1)} translation vectors for all the transformations
from calibration target frame to camera frame.
@param R_cam [out] 2gripper Estimated {@code (3x3)} rotation part extracted from the homogeneous matrix that transforms a point
expressed in the camera frame to the gripper frame ({@code _{}^{g}\textrm{T}_c}).
@param t_cam [out] 2gripper Estimated {@code (3x1)} translation part extracted from the homogeneous matrix that transforms a point
expressed in the camera frame to the gripper frame ({@code _{}^{g}\textrm{T}_c}).
@param method [in] One of the implemented Hand-Eye calibration method, see cv::HandEyeCalibrationMethod
<p>
The function performs the Hand-Eye calibration using various methods. One approach consists in estimating the
rotation then the translation (separable solutions) and the following methods are implemented:
  - R. Tsai, R. Lenz A New Technique for Fully Autonomous and Efficient 3D Robotics Hand/EyeCalibration \cite Tsai89
  - F. Park, B. Martin Robot Sensor Calibration: Solving AX = XB on the Euclidean Group \cite Park94
  - R. Horaud, F. Dornaika Hand-Eye Calibration \cite Horaud95
<p>
Another approach consists in estimating simultaneously the rotation and the translation (simultaneous solutions),
with the following implemented methods:
  - N. Andreff, R. Horaud, B. Espiau On-line Hand-Eye Calibration \cite Andreff99
  - K. Daniilidis Hand-Eye Calibration Using Dual Quaternions \cite Daniilidis98
<p>
The following picture describes the Hand-Eye calibration problem where the transformation between a camera ("eye")
mounted on a robot gripper ("hand") has to be estimated. This configuration is called eye-in-hand.
<p>
The eye-to-hand configuration consists in a static camera observing a calibration pattern mounted on the robot
end-effector. The transformation from the camera to the robot base frame can then be estimated by inputting
the suitable transformations to the function, see below.
<p>
![](pics/hand-eye_figure.png)
<p>
The calibration procedure is the following:
  - a static calibration pattern is used to estimate the transformation between the target frame
  and the camera frame
  - the robot gripper is moved in order to acquire several poses
  - for each pose, the homogeneous transformation between the gripper frame and the robot base frame is recorded using for
  instance the robot kinematics
<pre>{@code \[
    \begin{bmatrix}
    X_b\\
    Y_b\\
    Z_b\\
    1
    \end{bmatrix}
    =
    \begin{bmatrix}
    _{}^{b}\textrm{R}_g & _{}^{b}\textrm{t}_g \\
    0_{1 \times 3} & 1
    \end{bmatrix}
    \begin{bmatrix}
    X_g\\
    Y_g\\
    Z_g\\
    1
    \end{bmatrix}
\]}</pre>
  - for each pose, the homogeneous transformation between the calibration target frame and the camera frame is recorded using
  for instance a pose estimation method (PnP) from 2D-3D point correspondences
<pre>{@code \[
    \begin{bmatrix}
    X_c\\
    Y_c\\
    Z_c\\
    1
    \end{bmatrix}
    =
    \begin{bmatrix}
    _{}^{c}\textrm{R}_t & _{}^{c}\textrm{t}_t \\
    0_{1 \times 3} & 1
    \end{bmatrix}
    \begin{bmatrix}
    X_t\\
    Y_t\\
    Z_t\\
    1
    \end{bmatrix}
\]}</pre>
<p>
The Hand-Eye calibration procedure returns the following homogeneous transformation
<pre>{@code \[
    \begin{bmatrix}
    X_g\\
    Y_g\\
    Z_g\\
    1
    \end{bmatrix}
    =
    \begin{bmatrix}
    _{}^{g}\textrm{R}_c & _{}^{g}\textrm{t}_c \\
    0_{1 \times 3} & 1
    \end{bmatrix}
    \begin{bmatrix}
    X_c\\
    Y_c\\
    Z_c\\
    1
    \end{bmatrix}
\]}</pre>
<p>
This problem is also known as solving the {@code \mathbf{A}\mathbf{X}=\mathbf{X}\mathbf{B}} equation:
  - for an eye-in-hand configuration
<pre>{@code \[
    \begin{align*}
    ^{b}{\textrm{T}_g}^{(1)} \hspace{0.2em} ^{g}\textrm{T}_c \hspace{0.2em} ^{c}{\textrm{T}_t}^{(1)} &=
    \hspace{0.1em} ^{b}{\textrm{T}_g}^{(2)} \hspace{0.2em} ^{g}\textrm{T}_c \hspace{0.2em} ^{c}{\textrm{T}_t}^{(2)} \\

    (^{b}{\textrm{T}_g}^{(2)})^{-1} \hspace{0.2em} ^{b}{\textrm{T}_g}^{(1)} \hspace{0.2em} ^{g}\textrm{T}_c &=
    \hspace{0.1em} ^{g}\textrm{T}_c \hspace{0.2em} ^{c}{\textrm{T}_t}^{(2)} (^{c}{\textrm{T}_t}^{(1)})^{-1} \\

    \textrm{A}_i \textrm{X} &= \textrm{X} \textrm{B}_i \\
    \end{align*}
\]}</pre>
  <p>
  - for an eye-to-hand configuration
<pre>{@code \[
    \begin{align*}
    ^{g}{\textrm{T}_b}^{(1)} \hspace{0.2em} ^{b}\textrm{T}_c \hspace{0.2em} ^{c}{\textrm{T}_t}^{(1)} &=
    \hspace{0.1em} ^{g}{\textrm{T}_b}^{(2)} \hspace{0.2em} ^{b}\textrm{T}_c \hspace{0.2em} ^{c}{\textrm{T}_t}^{(2)} \\

    (^{g}{\textrm{T}_b}^{(2)})^{-1} \hspace{0.2em} ^{g}{\textrm{T}_b}^{(1)} \hspace{0.2em} ^{b}\textrm{T}_c &=
    \hspace{0.1em} ^{b}\textrm{T}_c \hspace{0.2em} ^{c}{\textrm{T}_t}^{(2)} (^{c}{\textrm{T}_t}^{(1)})^{-1} \\

    \textrm{A}_i \textrm{X} &= \textrm{X} \textrm{B}_i \\
    \end{align*}
\]}</pre>
<p>
\note
Additional information can be found on this [website](http://campar.in.tum.de/Chair/HandEyeCalibration).
\note
A minimum of 2 motions with non parallel rotation axes are necessary to determine the hand-eye transformation.
So at least 3 different poses are required, but it is strongly recommended to use many more poses.
 <p>
 */
@Namespace("cv") public static native void calibrateHandEye( @ByVal MatVector R_gripper2base, @ByVal MatVector t_gripper2base,
                                    @ByVal MatVector R_target2cam, @ByVal MatVector t_target2cam,
                                    @ByVal Mat R_cam2gripper, @ByVal Mat t_cam2gripper,
                                    @Cast("cv::HandEyeCalibrationMethod") int method/*=cv::CALIB_HAND_EYE_TSAI*/ );
@Namespace("cv") public static native void calibrateHandEye( @ByVal MatVector R_gripper2base, @ByVal MatVector t_gripper2base,
                                    @ByVal MatVector R_target2cam, @ByVal MatVector t_target2cam,
                                    @ByVal Mat R_cam2gripper, @ByVal Mat t_cam2gripper );
@Namespace("cv") public static native void calibrateHandEye( @ByVal UMatVector R_gripper2base, @ByVal UMatVector t_gripper2base,
                                    @ByVal UMatVector R_target2cam, @ByVal UMatVector t_target2cam,
                                    @ByVal Mat R_cam2gripper, @ByVal Mat t_cam2gripper,
                                    @Cast("cv::HandEyeCalibrationMethod") int method/*=cv::CALIB_HAND_EYE_TSAI*/ );
@Namespace("cv") public static native void calibrateHandEye( @ByVal UMatVector R_gripper2base, @ByVal UMatVector t_gripper2base,
                                    @ByVal UMatVector R_target2cam, @ByVal UMatVector t_target2cam,
                                    @ByVal Mat R_cam2gripper, @ByVal Mat t_cam2gripper );
@Namespace("cv") public static native void calibrateHandEye( @ByVal GpuMatVector R_gripper2base, @ByVal GpuMatVector t_gripper2base,
                                    @ByVal GpuMatVector R_target2cam, @ByVal GpuMatVector t_target2cam,
                                    @ByVal Mat R_cam2gripper, @ByVal Mat t_cam2gripper,
                                    @Cast("cv::HandEyeCalibrationMethod") int method/*=cv::CALIB_HAND_EYE_TSAI*/ );
@Namespace("cv") public static native void calibrateHandEye( @ByVal GpuMatVector R_gripper2base, @ByVal GpuMatVector t_gripper2base,
                                    @ByVal GpuMatVector R_target2cam, @ByVal GpuMatVector t_target2cam,
                                    @ByVal Mat R_cam2gripper, @ByVal Mat t_cam2gripper );
@Namespace("cv") public static native void calibrateHandEye( @ByVal MatVector R_gripper2base, @ByVal MatVector t_gripper2base,
                                    @ByVal MatVector R_target2cam, @ByVal MatVector t_target2cam,
                                    @ByVal UMat R_cam2gripper, @ByVal UMat t_cam2gripper,
                                    @Cast("cv::HandEyeCalibrationMethod") int method/*=cv::CALIB_HAND_EYE_TSAI*/ );
@Namespace("cv") public static native void calibrateHandEye( @ByVal MatVector R_gripper2base, @ByVal MatVector t_gripper2base,
                                    @ByVal MatVector R_target2cam, @ByVal MatVector t_target2cam,
                                    @ByVal UMat R_cam2gripper, @ByVal UMat t_cam2gripper );
@Namespace("cv") public static native void calibrateHandEye( @ByVal UMatVector R_gripper2base, @ByVal UMatVector t_gripper2base,
                                    @ByVal UMatVector R_target2cam, @ByVal UMatVector t_target2cam,
                                    @ByVal UMat R_cam2gripper, @ByVal UMat t_cam2gripper,
                                    @Cast("cv::HandEyeCalibrationMethod") int method/*=cv::CALIB_HAND_EYE_TSAI*/ );
@Namespace("cv") public static native void calibrateHandEye( @ByVal UMatVector R_gripper2base, @ByVal UMatVector t_gripper2base,
                                    @ByVal UMatVector R_target2cam, @ByVal UMatVector t_target2cam,
                                    @ByVal UMat R_cam2gripper, @ByVal UMat t_cam2gripper );
@Namespace("cv") public static native void calibrateHandEye( @ByVal GpuMatVector R_gripper2base, @ByVal GpuMatVector t_gripper2base,
                                    @ByVal GpuMatVector R_target2cam, @ByVal GpuMatVector t_target2cam,
                                    @ByVal UMat R_cam2gripper, @ByVal UMat t_cam2gripper,
                                    @Cast("cv::HandEyeCalibrationMethod") int method/*=cv::CALIB_HAND_EYE_TSAI*/ );
@Namespace("cv") public static native void calibrateHandEye( @ByVal GpuMatVector R_gripper2base, @ByVal GpuMatVector t_gripper2base,
                                    @ByVal GpuMatVector R_target2cam, @ByVal GpuMatVector t_target2cam,
                                    @ByVal UMat R_cam2gripper, @ByVal UMat t_cam2gripper );
@Namespace("cv") public static native void calibrateHandEye( @ByVal MatVector R_gripper2base, @ByVal MatVector t_gripper2base,
                                    @ByVal MatVector R_target2cam, @ByVal MatVector t_target2cam,
                                    @ByVal GpuMat R_cam2gripper, @ByVal GpuMat t_cam2gripper,
                                    @Cast("cv::HandEyeCalibrationMethod") int method/*=cv::CALIB_HAND_EYE_TSAI*/ );
@Namespace("cv") public static native void calibrateHandEye( @ByVal MatVector R_gripper2base, @ByVal MatVector t_gripper2base,
                                    @ByVal MatVector R_target2cam, @ByVal MatVector t_target2cam,
                                    @ByVal GpuMat R_cam2gripper, @ByVal GpuMat t_cam2gripper );
@Namespace("cv") public static native void calibrateHandEye( @ByVal UMatVector R_gripper2base, @ByVal UMatVector t_gripper2base,
                                    @ByVal UMatVector R_target2cam, @ByVal UMatVector t_target2cam,
                                    @ByVal GpuMat R_cam2gripper, @ByVal GpuMat t_cam2gripper,
                                    @Cast("cv::HandEyeCalibrationMethod") int method/*=cv::CALIB_HAND_EYE_TSAI*/ );
@Namespace("cv") public static native void calibrateHandEye( @ByVal UMatVector R_gripper2base, @ByVal UMatVector t_gripper2base,
                                    @ByVal UMatVector R_target2cam, @ByVal UMatVector t_target2cam,
                                    @ByVal GpuMat R_cam2gripper, @ByVal GpuMat t_cam2gripper );
@Namespace("cv") public static native void calibrateHandEye( @ByVal GpuMatVector R_gripper2base, @ByVal GpuMatVector t_gripper2base,
                                    @ByVal GpuMatVector R_target2cam, @ByVal GpuMatVector t_target2cam,
                                    @ByVal GpuMat R_cam2gripper, @ByVal GpuMat t_cam2gripper,
                                    @Cast("cv::HandEyeCalibrationMethod") int method/*=cv::CALIB_HAND_EYE_TSAI*/ );
@Namespace("cv") public static native void calibrateHandEye( @ByVal GpuMatVector R_gripper2base, @ByVal GpuMatVector t_gripper2base,
                                    @ByVal GpuMatVector R_target2cam, @ByVal GpuMatVector t_target2cam,
                                    @ByVal GpuMat R_cam2gripper, @ByVal GpuMat t_cam2gripper );

/** \brief Computes Robot-World/Hand-Eye calibration: {@code _{}^{w}\textrm{T}_b} and {@code _{}^{c}\textrm{T}_g}
<p>
@param R_world [in] 2cam Rotation part extracted from the homogeneous matrix that transforms a point
expressed in the world frame to the camera frame ({@code _{}^{c}\textrm{T}_w}).
This is a vector ({@code vector<Mat>}) that contains the rotation, {@code (3x3)} rotation matrices or {@code (3x1)} rotation vectors,
for all the transformations from world frame to the camera frame.
@param t_world [in] 2cam Translation part extracted from the homogeneous matrix that transforms a point
expressed in the world frame to the camera frame ({@code _{}^{c}\textrm{T}_w}).
This is a vector ({@code vector<Mat>}) that contains the {@code (3x1)} translation vectors for all the transformations
from world frame to the camera frame.
@param R_base [in] 2gripper Rotation part extracted from the homogeneous matrix that transforms a point
expressed in the robot base frame to the gripper frame ({@code _{}^{g}\textrm{T}_b}).
This is a vector ({@code vector<Mat>}) that contains the rotation, {@code (3x3)} rotation matrices or {@code (3x1)} rotation vectors,
for all the transformations from robot base frame to the gripper frame.
@param t_base [in] 2gripper Rotation part extracted from the homogeneous matrix that transforms a point
expressed in the robot base frame to the gripper frame ({@code _{}^{g}\textrm{T}_b}).
This is a vector ({@code vector<Mat>}) that contains the {@code (3x1)} translation vectors for all the transformations
from robot base frame to the gripper frame.
@param R_base [out] 2world Estimated {@code (3x3)} rotation part extracted from the homogeneous matrix that transforms a point
expressed in the robot base frame to the world frame ({@code _{}^{w}\textrm{T}_b}).
@param t_base [out] 2world Estimated {@code (3x1)} translation part extracted from the homogeneous matrix that transforms a point
expressed in the robot base frame to the world frame ({@code _{}^{w}\textrm{T}_b}).
@param R_gripper [out] 2cam Estimated {@code (3x3)} rotation part extracted from the homogeneous matrix that transforms a point
expressed in the gripper frame to the camera frame ({@code _{}^{c}\textrm{T}_g}).
@param t_gripper [out] 2cam Estimated {@code (3x1)} translation part extracted from the homogeneous matrix that transforms a point
expressed in the gripper frame to the camera frame ({@code _{}^{c}\textrm{T}_g}).
@param method [in] One of the implemented Robot-World/Hand-Eye calibration method, see cv::RobotWorldHandEyeCalibrationMethod
<p>
The function performs the Robot-World/Hand-Eye calibration using various methods. One approach consists in estimating the
rotation then the translation (separable solutions):
  - M. Shah, Solving the robot-world/hand-eye calibration problem using the kronecker product \cite Shah2013SolvingTR
<p>
Another approach consists in estimating simultaneously the rotation and the translation (simultaneous solutions),
with the following implemented method:
  - A. Li, L. Wang, and D. Wu, Simultaneous robot-world and hand-eye calibration using dual-quaternions and kronecker product \cite Li2010SimultaneousRA
<p>
The following picture describes the Robot-World/Hand-Eye calibration problem where the transformations between a robot and a world frame
and between a robot gripper ("hand") and a camera ("eye") mounted at the robot end-effector have to be estimated.
<p>
![](pics/robot-world_hand-eye_figure.png)
<p>
The calibration procedure is the following:
  - a static calibration pattern is used to estimate the transformation between the target frame
  and the camera frame
  - the robot gripper is moved in order to acquire several poses
  - for each pose, the homogeneous transformation between the gripper frame and the robot base frame is recorded using for
  instance the robot kinematics
<pre>{@code \[
    \begin{bmatrix}
    X_g\\
    Y_g\\
    Z_g\\
    1
    \end{bmatrix}
    =
    \begin{bmatrix}
    _{}^{g}\textrm{R}_b & _{}^{g}\textrm{t}_b \\
    0_{1 \times 3} & 1
    \end{bmatrix}
    \begin{bmatrix}
    X_b\\
    Y_b\\
    Z_b\\
    1
    \end{bmatrix}
\]}</pre>
  - for each pose, the homogeneous transformation between the calibration target frame (the world frame) and the camera frame is recorded using
  for instance a pose estimation method (PnP) from 2D-3D point correspondences
<pre>{@code \[
    \begin{bmatrix}
    X_c\\
    Y_c\\
    Z_c\\
    1
    \end{bmatrix}
    =
    \begin{bmatrix}
    _{}^{c}\textrm{R}_w & _{}^{c}\textrm{t}_w \\
    0_{1 \times 3} & 1
    \end{bmatrix}
    \begin{bmatrix}
    X_w\\
    Y_w\\
    Z_w\\
    1
    \end{bmatrix}
\]}</pre>
<p>
The Robot-World/Hand-Eye calibration procedure returns the following homogeneous transformations
<pre>{@code \[
    \begin{bmatrix}
    X_w\\
    Y_w\\
    Z_w\\
    1
    \end{bmatrix}
    =
    \begin{bmatrix}
    _{}^{w}\textrm{R}_b & _{}^{w}\textrm{t}_b \\
    0_{1 \times 3} & 1
    \end{bmatrix}
    \begin{bmatrix}
    X_b\\
    Y_b\\
    Z_b\\
    1
    \end{bmatrix}
\]}</pre>
<pre>{@code \[
    \begin{bmatrix}
    X_c\\
    Y_c\\
    Z_c\\
    1
    \end{bmatrix}
    =
    \begin{bmatrix}
    _{}^{c}\textrm{R}_g & _{}^{c}\textrm{t}_g \\
    0_{1 \times 3} & 1
    \end{bmatrix}
    \begin{bmatrix}
    X_g\\
    Y_g\\
    Z_g\\
    1
    \end{bmatrix}
\]}</pre>
<p>
This problem is also known as solving the {@code \mathbf{A}\mathbf{X}=\mathbf{Z}\mathbf{B}} equation, with:
  - {@code \mathbf{A} \Leftrightarrow \hspace{0.1em} _{}^{c}\textrm{T}_w}
  - {@code \mathbf{X} \Leftrightarrow \hspace{0.1em} _{}^{w}\textrm{T}_b}
  - {@code \mathbf{Z} \Leftrightarrow \hspace{0.1em} _{}^{c}\textrm{T}_g}
  - {@code \mathbf{B} \Leftrightarrow \hspace{0.1em} _{}^{g}\textrm{T}_b}
<p>
\note
At least 3 measurements are required (input vectors size must be greater or equal to 3).
 <p>
 */
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal MatVector R_world2cam, @ByVal MatVector t_world2cam,
                                              @ByVal MatVector R_base2gripper, @ByVal MatVector t_base2gripper,
                                              @ByVal Mat R_base2world, @ByVal Mat t_base2world,
                                              @ByVal Mat R_gripper2cam, @ByVal Mat t_gripper2cam,
                                              @Cast("cv::RobotWorldHandEyeCalibrationMethod") int method/*=cv::CALIB_ROBOT_WORLD_HAND_EYE_SHAH*/ );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal MatVector R_world2cam, @ByVal MatVector t_world2cam,
                                              @ByVal MatVector R_base2gripper, @ByVal MatVector t_base2gripper,
                                              @ByVal Mat R_base2world, @ByVal Mat t_base2world,
                                              @ByVal Mat R_gripper2cam, @ByVal Mat t_gripper2cam );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal UMatVector R_world2cam, @ByVal UMatVector t_world2cam,
                                              @ByVal UMatVector R_base2gripper, @ByVal UMatVector t_base2gripper,
                                              @ByVal Mat R_base2world, @ByVal Mat t_base2world,
                                              @ByVal Mat R_gripper2cam, @ByVal Mat t_gripper2cam,
                                              @Cast("cv::RobotWorldHandEyeCalibrationMethod") int method/*=cv::CALIB_ROBOT_WORLD_HAND_EYE_SHAH*/ );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal UMatVector R_world2cam, @ByVal UMatVector t_world2cam,
                                              @ByVal UMatVector R_base2gripper, @ByVal UMatVector t_base2gripper,
                                              @ByVal Mat R_base2world, @ByVal Mat t_base2world,
                                              @ByVal Mat R_gripper2cam, @ByVal Mat t_gripper2cam );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal GpuMatVector R_world2cam, @ByVal GpuMatVector t_world2cam,
                                              @ByVal GpuMatVector R_base2gripper, @ByVal GpuMatVector t_base2gripper,
                                              @ByVal Mat R_base2world, @ByVal Mat t_base2world,
                                              @ByVal Mat R_gripper2cam, @ByVal Mat t_gripper2cam,
                                              @Cast("cv::RobotWorldHandEyeCalibrationMethod") int method/*=cv::CALIB_ROBOT_WORLD_HAND_EYE_SHAH*/ );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal GpuMatVector R_world2cam, @ByVal GpuMatVector t_world2cam,
                                              @ByVal GpuMatVector R_base2gripper, @ByVal GpuMatVector t_base2gripper,
                                              @ByVal Mat R_base2world, @ByVal Mat t_base2world,
                                              @ByVal Mat R_gripper2cam, @ByVal Mat t_gripper2cam );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal MatVector R_world2cam, @ByVal MatVector t_world2cam,
                                              @ByVal MatVector R_base2gripper, @ByVal MatVector t_base2gripper,
                                              @ByVal UMat R_base2world, @ByVal UMat t_base2world,
                                              @ByVal UMat R_gripper2cam, @ByVal UMat t_gripper2cam,
                                              @Cast("cv::RobotWorldHandEyeCalibrationMethod") int method/*=cv::CALIB_ROBOT_WORLD_HAND_EYE_SHAH*/ );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal MatVector R_world2cam, @ByVal MatVector t_world2cam,
                                              @ByVal MatVector R_base2gripper, @ByVal MatVector t_base2gripper,
                                              @ByVal UMat R_base2world, @ByVal UMat t_base2world,
                                              @ByVal UMat R_gripper2cam, @ByVal UMat t_gripper2cam );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal UMatVector R_world2cam, @ByVal UMatVector t_world2cam,
                                              @ByVal UMatVector R_base2gripper, @ByVal UMatVector t_base2gripper,
                                              @ByVal UMat R_base2world, @ByVal UMat t_base2world,
                                              @ByVal UMat R_gripper2cam, @ByVal UMat t_gripper2cam,
                                              @Cast("cv::RobotWorldHandEyeCalibrationMethod") int method/*=cv::CALIB_ROBOT_WORLD_HAND_EYE_SHAH*/ );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal UMatVector R_world2cam, @ByVal UMatVector t_world2cam,
                                              @ByVal UMatVector R_base2gripper, @ByVal UMatVector t_base2gripper,
                                              @ByVal UMat R_base2world, @ByVal UMat t_base2world,
                                              @ByVal UMat R_gripper2cam, @ByVal UMat t_gripper2cam );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal GpuMatVector R_world2cam, @ByVal GpuMatVector t_world2cam,
                                              @ByVal GpuMatVector R_base2gripper, @ByVal GpuMatVector t_base2gripper,
                                              @ByVal UMat R_base2world, @ByVal UMat t_base2world,
                                              @ByVal UMat R_gripper2cam, @ByVal UMat t_gripper2cam,
                                              @Cast("cv::RobotWorldHandEyeCalibrationMethod") int method/*=cv::CALIB_ROBOT_WORLD_HAND_EYE_SHAH*/ );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal GpuMatVector R_world2cam, @ByVal GpuMatVector t_world2cam,
                                              @ByVal GpuMatVector R_base2gripper, @ByVal GpuMatVector t_base2gripper,
                                              @ByVal UMat R_base2world, @ByVal UMat t_base2world,
                                              @ByVal UMat R_gripper2cam, @ByVal UMat t_gripper2cam );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal MatVector R_world2cam, @ByVal MatVector t_world2cam,
                                              @ByVal MatVector R_base2gripper, @ByVal MatVector t_base2gripper,
                                              @ByVal GpuMat R_base2world, @ByVal GpuMat t_base2world,
                                              @ByVal GpuMat R_gripper2cam, @ByVal GpuMat t_gripper2cam,
                                              @Cast("cv::RobotWorldHandEyeCalibrationMethod") int method/*=cv::CALIB_ROBOT_WORLD_HAND_EYE_SHAH*/ );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal MatVector R_world2cam, @ByVal MatVector t_world2cam,
                                              @ByVal MatVector R_base2gripper, @ByVal MatVector t_base2gripper,
                                              @ByVal GpuMat R_base2world, @ByVal GpuMat t_base2world,
                                              @ByVal GpuMat R_gripper2cam, @ByVal GpuMat t_gripper2cam );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal UMatVector R_world2cam, @ByVal UMatVector t_world2cam,
                                              @ByVal UMatVector R_base2gripper, @ByVal UMatVector t_base2gripper,
                                              @ByVal GpuMat R_base2world, @ByVal GpuMat t_base2world,
                                              @ByVal GpuMat R_gripper2cam, @ByVal GpuMat t_gripper2cam,
                                              @Cast("cv::RobotWorldHandEyeCalibrationMethod") int method/*=cv::CALIB_ROBOT_WORLD_HAND_EYE_SHAH*/ );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal UMatVector R_world2cam, @ByVal UMatVector t_world2cam,
                                              @ByVal UMatVector R_base2gripper, @ByVal UMatVector t_base2gripper,
                                              @ByVal GpuMat R_base2world, @ByVal GpuMat t_base2world,
                                              @ByVal GpuMat R_gripper2cam, @ByVal GpuMat t_gripper2cam );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal GpuMatVector R_world2cam, @ByVal GpuMatVector t_world2cam,
                                              @ByVal GpuMatVector R_base2gripper, @ByVal GpuMatVector t_base2gripper,
                                              @ByVal GpuMat R_base2world, @ByVal GpuMat t_base2world,
                                              @ByVal GpuMat R_gripper2cam, @ByVal GpuMat t_gripper2cam,
                                              @Cast("cv::RobotWorldHandEyeCalibrationMethod") int method/*=cv::CALIB_ROBOT_WORLD_HAND_EYE_SHAH*/ );
@Namespace("cv") public static native void calibrateRobotWorldHandEye( @ByVal GpuMatVector R_world2cam, @ByVal GpuMatVector t_world2cam,
                                              @ByVal GpuMatVector R_base2gripper, @ByVal GpuMatVector t_base2gripper,
                                              @ByVal GpuMat R_base2world, @ByVal GpuMat t_base2world,
                                              @ByVal GpuMat R_gripper2cam, @ByVal GpuMat t_gripper2cam );

/** \brief Converts points from Euclidean to homogeneous space.
<p>
@param src Input vector of N-dimensional points.
@param dst Output vector of N+1-dimensional points.
<p>
The function converts points from Euclidean to homogeneous space by appending 1's to the tuple of
point coordinates. That is, each point (x1, x2, ..., xn) is converted to (x1, x2, ..., xn, 1).
 */
@Namespace("cv") public static native void convertPointsToHomogeneous( @ByVal Mat src, @ByVal Mat dst );
@Namespace("cv") public static native void convertPointsToHomogeneous( @ByVal UMat src, @ByVal UMat dst );
@Namespace("cv") public static native void convertPointsToHomogeneous( @ByVal GpuMat src, @ByVal GpuMat dst );

/** \brief Converts points from homogeneous to Euclidean space.
<p>
@param src Input vector of N-dimensional points.
@param dst Output vector of N-1-dimensional points.
<p>
The function converts points homogeneous to Euclidean space using perspective projection. That is,
each point (x1, x2, ... x(n-1), xn) is converted to (x1/xn, x2/xn, ..., x(n-1)/xn). When xn=0, the
output point coordinates will be (0,0,0,...).
 */
@Namespace("cv") public static native void convertPointsFromHomogeneous( @ByVal Mat src, @ByVal Mat dst );
@Namespace("cv") public static native void convertPointsFromHomogeneous( @ByVal UMat src, @ByVal UMat dst );
@Namespace("cv") public static native void convertPointsFromHomogeneous( @ByVal GpuMat src, @ByVal GpuMat dst );

/** \brief Converts points to/from homogeneous coordinates.
<p>
@param src Input array or vector of 2D, 3D, or 4D points.
@param dst Output vector of 2D, 3D, or 4D points.
<p>
The function converts 2D or 3D points from/to homogeneous coordinates by calling either
#convertPointsToHomogeneous or #convertPointsFromHomogeneous.
<p>
\note The function is obsolete. Use one of the previous two functions instead.
 */
@Namespace("cv") public static native void convertPointsHomogeneous( @ByVal Mat src, @ByVal Mat dst );
@Namespace("cv") public static native void convertPointsHomogeneous( @ByVal UMat src, @ByVal UMat dst );
@Namespace("cv") public static native void convertPointsHomogeneous( @ByVal GpuMat src, @ByVal GpuMat dst );

/** \brief Calculates a fundamental matrix from the corresponding points in two images.
<p>
@param points1 Array of N points from the first image. The point coordinates should be
floating-point (single or double precision).
@param points2 Array of the second image points of the same size and format as points1 .
@param method Method for computing a fundamental matrix.
-   \ref FM_7POINT for a 7-point algorithm. {@code N = 7}
-   \ref FM_8POINT for an 8-point algorithm. {@code N \ge 8}
-   \ref FM_RANSAC for the RANSAC algorithm. {@code N \ge 8}
-   \ref FM_LMEDS for the LMedS algorithm. {@code N \ge 8}
@param ransacReprojThreshold Parameter used only for RANSAC. It is the maximum distance from a point to an epipolar
line in pixels, beyond which the point is considered an outlier and is not used for computing the
final fundamental matrix. It can be set to something like 1-3, depending on the accuracy of the
point localization, image resolution, and the image noise.
@param confidence Parameter used for the RANSAC and LMedS methods only. It specifies a desirable level
of confidence (probability) that the estimated matrix is correct.
@param mask [out] optional output mask
@param maxIters The maximum number of robust method iterations.
<p>
The epipolar geometry is described by the following equation:
<p>
<pre>{@code \[[p_2; 1]^T F [p_1; 1] = 0\]}</pre>
<p>
where {@code F} is a fundamental matrix, {@code p_1} and {@code p_2} are corresponding points in the first and the
second images, respectively.
<p>
The function calculates the fundamental matrix using one of four methods listed above and returns
the found fundamental matrix. Normally just one matrix is found. But in case of the 7-point
algorithm, the function may return up to 3 solutions ( {@code 9 \times 3} matrix that stores all 3
matrices sequentially).
<p>
The calculated fundamental matrix may be passed further to computeCorrespondEpilines that finds the
epipolar lines corresponding to the specified points. It can also be passed to
#stereoRectifyUncalibrated to compute the rectification transformation. :
<pre>{@code
    // Example. Estimation of fundamental matrix using the RANSAC algorithm
    int point_count = 100;
    vector<Point2f> points1(point_count);
    vector<Point2f> points2(point_count);

    // initialize the points here ...
    for( int i = 0; i < point_count; i++ )
    {
        points1[i] = ...;
        points2[i] = ...;
    }

    Mat fundamental_matrix =
     findFundamentalMat(points1, points2, FM_RANSAC, 3, 0.99);
}</pre>
 */
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal Mat points1, @ByVal Mat points2,
                                     int method, double ransacReprojThreshold, double confidence,
                                     int maxIters, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat mask );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal Mat points1, @ByVal Mat points2,
                                     int method, double ransacReprojThreshold, double confidence,
                                     int maxIters );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal UMat points1, @ByVal UMat points2,
                                     int method, double ransacReprojThreshold, double confidence,
                                     int maxIters, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat mask );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal UMat points1, @ByVal UMat points2,
                                     int method, double ransacReprojThreshold, double confidence,
                                     int maxIters );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal GpuMat points1, @ByVal GpuMat points2,
                                     int method, double ransacReprojThreshold, double confidence,
                                     int maxIters, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat mask );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal GpuMat points1, @ByVal GpuMat points2,
                                     int method, double ransacReprojThreshold, double confidence,
                                     int maxIters );

/** \overload */
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal Mat points1, @ByVal Mat points2,
                                     int method/*=cv::FM_RANSAC*/,
                                     double ransacReprojThreshold/*=3.*/, double confidence/*=0.99*/,
                                     @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat mask );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal Mat points1, @ByVal Mat points2 );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal UMat points1, @ByVal UMat points2,
                                     int method/*=cv::FM_RANSAC*/,
                                     double ransacReprojThreshold/*=3.*/, double confidence/*=0.99*/,
                                     @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat mask );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal UMat points1, @ByVal UMat points2 );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal GpuMat points1, @ByVal GpuMat points2,
                                     int method/*=cv::FM_RANSAC*/,
                                     double ransacReprojThreshold/*=3.*/, double confidence/*=0.99*/,
                                     @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat mask );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal GpuMat points1, @ByVal GpuMat points2 );

/** \overload */
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal Mat points1, @ByVal Mat points2,
                                   @ByVal Mat mask, int method/*=cv::FM_RANSAC*/,
                                   double ransacReprojThreshold/*=3.*/, double confidence/*=0.99*/ );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal Mat points1, @ByVal Mat points2,
                                   @ByVal Mat mask );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal UMat points1, @ByVal UMat points2,
                                   @ByVal UMat mask, int method/*=cv::FM_RANSAC*/,
                                   double ransacReprojThreshold/*=3.*/, double confidence/*=0.99*/ );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal UMat points1, @ByVal UMat points2,
                                   @ByVal UMat mask );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal GpuMat points1, @ByVal GpuMat points2,
                                   @ByVal GpuMat mask, int method/*=cv::FM_RANSAC*/,
                                   double ransacReprojThreshold/*=3.*/, double confidence/*=0.99*/ );
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal GpuMat points1, @ByVal GpuMat points2,
                                   @ByVal GpuMat mask );


@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal Mat points1, @ByVal Mat points2,
                        @ByVal Mat mask, @Const @ByRef UsacParams params);
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal UMat points1, @ByVal UMat points2,
                        @ByVal UMat mask, @Const @ByRef UsacParams params);
@Namespace("cv") public static native @ByVal Mat findFundamentalMat( @ByVal GpuMat points1, @ByVal GpuMat points2,
                        @ByVal GpuMat mask, @Const @ByRef UsacParams params);

/** \brief Calculates an essential matrix from the corresponding points in two images.
<p>
@param points1 Array of N (N \>= 5) 2D points from the first image. The point coordinates should
be floating-point (single or double precision).
@param points2 Array of the second image points of the same size and format as points1 .
@param cameraMatrix Camera intrinsic matrix {@code \cameramatrix{A}} .
Note that this function assumes that points1 and points2 are feature points from cameras with the
same camera intrinsic matrix. If this assumption does not hold for your use case, use
#undistortPoints with {@code P = cv::NoArray()} for both cameras to transform image points
to normalized image coordinates, which are valid for the identity camera intrinsic matrix. When
passing these coordinates, pass the identity matrix for this parameter.
@param method Method for computing an essential matrix.
-   \ref RANSAC for the RANSAC algorithm.
-   \ref LMEDS for the LMedS algorithm.
@param prob Parameter used for the RANSAC or LMedS methods only. It specifies a desirable level of
confidence (probability) that the estimated matrix is correct.
@param threshold Parameter used for RANSAC. It is the maximum distance from a point to an epipolar
line in pixels, beyond which the point is considered an outlier and is not used for computing the
final fundamental matrix. It can be set to something like 1-3, depending on the accuracy of the
point localization, image resolution, and the image noise.
@param mask Output array of N elements, every element of which is set to 0 for outliers and to 1
for the other points. The array is computed only in the RANSAC and LMedS methods.
@param maxIters The maximum number of robust method iterations.
<p>
This function estimates essential matrix based on the five-point algorithm solver in \cite Nister03 .
\cite SteweniusCFS is also a related. The epipolar geometry is described by the following equation:
<p>
<pre>{@code \[[p_2; 1]^T K^{-T} E K^{-1} [p_1; 1] = 0\]}</pre>
<p>
where {@code E} is an essential matrix, {@code p_1} and {@code p_2} are corresponding points in the first and the
second images, respectively. The result of this function may be passed further to
#decomposeEssentialMat or  #recoverPose to recover the relative pose between cameras.
 */
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal Mat points1, @ByVal Mat points2,
    @ByVal Mat cameraMatrix, int method/*=cv::RANSAC*/,
    double prob/*=0.999*/, double threshold/*=1.0*/,
    int maxIters/*=1000*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat mask
);
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal Mat points1, @ByVal Mat points2,
    @ByVal Mat cameraMatrix
);
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal UMat points1, @ByVal UMat points2,
    @ByVal UMat cameraMatrix, int method/*=cv::RANSAC*/,
    double prob/*=0.999*/, double threshold/*=1.0*/,
    int maxIters/*=1000*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat mask
);
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal UMat points1, @ByVal UMat points2,
    @ByVal UMat cameraMatrix
);
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal GpuMat points1, @ByVal GpuMat points2,
    @ByVal GpuMat cameraMatrix, int method/*=cv::RANSAC*/,
    double prob/*=0.999*/, double threshold/*=1.0*/,
    int maxIters/*=1000*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat mask
);
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal GpuMat points1, @ByVal GpuMat points2,
    @ByVal GpuMat cameraMatrix
);

/** \overload */
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal Mat points1, @ByVal Mat points2,
    @ByVal Mat cameraMatrix, int method,
    double prob, double threshold,
    @ByVal Mat mask
);
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal UMat points1, @ByVal UMat points2,
    @ByVal UMat cameraMatrix, int method,
    double prob, double threshold,
    @ByVal UMat mask
);
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal GpuMat points1, @ByVal GpuMat points2,
    @ByVal GpuMat cameraMatrix, int method,
    double prob, double threshold,
    @ByVal GpuMat mask
);  // TODO remove from OpenCV 5.0

/** \overload
@param points1 Array of N (N \>= 5) 2D points from the first image. The point coordinates should
be floating-point (single or double precision).
@param points2 Array of the second image points of the same size and format as points1 .
@param focal focal length of the camera. Note that this function assumes that points1 and points2
are feature points from cameras with same focal length and principal point.
@param pp principal point of the camera.
@param method Method for computing a fundamental matrix.
-   \ref RANSAC for the RANSAC algorithm.
-   \ref LMEDS for the LMedS algorithm.
@param threshold Parameter used for RANSAC. It is the maximum distance from a point to an epipolar
line in pixels, beyond which the point is considered an outlier and is not used for computing the
final fundamental matrix. It can be set to something like 1-3, depending on the accuracy of the
point localization, image resolution, and the image noise.
@param prob Parameter used for the RANSAC or LMedS methods only. It specifies a desirable level of
confidence (probability) that the estimated matrix is correct.
@param mask Output array of N elements, every element of which is set to 0 for outliers and to 1
for the other points. The array is computed only in the RANSAC and LMedS methods.
@param maxIters The maximum number of robust method iterations.
<p>
This function differs from the one above that it computes camera intrinsic matrix from focal length and
principal point:
<p>
<pre>{@code \[A =
\begin{bmatrix}
f & 0 & x_{pp}  \\
0 & f & y_{pp}  \\
0 & 0 & 1
\end{bmatrix}\]}</pre>
 */
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal Mat points1, @ByVal Mat points2,
    double focal/*=1.0*/, @ByVal(nullValue = "cv::Point2d(0, 0)") Point2d pp,
    int method/*=cv::RANSAC*/, double prob/*=0.999*/,
    double threshold/*=1.0*/, int maxIters/*=1000*/,
    @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat mask
);
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal Mat points1, @ByVal Mat points2
);
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal UMat points1, @ByVal UMat points2,
    double focal/*=1.0*/, @ByVal(nullValue = "cv::Point2d(0, 0)") Point2d pp,
    int method/*=cv::RANSAC*/, double prob/*=0.999*/,
    double threshold/*=1.0*/, int maxIters/*=1000*/,
    @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat mask
);
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal UMat points1, @ByVal UMat points2
);
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal GpuMat points1, @ByVal GpuMat points2,
    double focal/*=1.0*/, @ByVal(nullValue = "cv::Point2d(0, 0)") Point2d pp,
    int method/*=cv::RANSAC*/, double prob/*=0.999*/,
    double threshold/*=1.0*/, int maxIters/*=1000*/,
    @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat mask
);
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal GpuMat points1, @ByVal GpuMat points2
);

/** \overload */
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal Mat points1, @ByVal Mat points2,
    double focal, @ByVal Point2d pp,
    int method, double prob,
    double threshold, @ByVal Mat mask
);
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal UMat points1, @ByVal UMat points2,
    double focal, @ByVal Point2d pp,
    int method, double prob,
    double threshold, @ByVal UMat mask
);
@Namespace("cv") public static native @ByVal Mat findEssentialMat(
    @ByVal GpuMat points1, @ByVal GpuMat points2,
    double focal, @ByVal Point2d pp,
    int method, double prob,
    double threshold, @ByVal GpuMat mask
);  // TODO remove from OpenCV 5.0

/** \brief Calculates an essential matrix from the corresponding points in two images from potentially two different cameras.
<p>
@param points1 Array of N (N \>= 5) 2D points from the first image. The point coordinates should
be floating-point (single or double precision).
@param points2 Array of the second image points of the same size and format as points1 .
@param cameraMatrix1 Camera matrix {@code K = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}} .
Note that this function assumes that points1 and points2 are feature points from cameras with the
same camera matrix. If this assumption does not hold for your use case, use
#undistortPoints with {@code P = cv::NoArray()} for both cameras to transform image points
to normalized image coordinates, which are valid for the identity camera matrix. When
passing these coordinates, pass the identity matrix for this parameter.
@param cameraMatrix2 Camera matrix {@code K = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}} .
Note that this function assumes that points1 and points2 are feature points from cameras with the
same camera matrix. If this assumption does not hold for your use case, use
#undistortPoints with {@code P = cv::NoArray()} for both cameras to transform image points
to normalized image coordinates, which are valid for the identity camera matrix. When
passing these coordinates, pass the identity matrix for this parameter.
@param distCoeffs1 Input vector of distortion coefficients
{@code (k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \tau_x, \tau_y]]]])}
of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.
@param distCoeffs2 Input vector of distortion coefficients
{@code (k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \tau_x, \tau_y]]]])}
of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.
@param method Method for computing an essential matrix.
-   \ref RANSAC for the RANSAC algorithm.
-   \ref LMEDS for the LMedS algorithm.
@param prob Parameter used for the RANSAC or LMedS methods only. It specifies a desirable level of
confidence (probability) that the estimated matrix is correct.
@param threshold Parameter used for RANSAC. It is the maximum distance from a point to an epipolar
line in pixels, beyond which the point is considered an outlier and is not used for computing the
final fundamental matrix. It can be set to something like 1-3, depending on the accuracy of the
point localization, image resolution, and the image noise.
@param mask Output array of N elements, every element of which is set to 0 for outliers and to 1
for the other points. The array is computed only in the RANSAC and LMedS methods.
<p>
This function estimates essential matrix based on the five-point algorithm solver in \cite Nister03 .
\cite SteweniusCFS is also a related. The epipolar geometry is described by the following equation:
<p>
<pre>{@code \[[p_2; 1]^T K^{-T} E K^{-1} [p_1; 1] = 0\]}</pre>
<p>
where {@code E} is an essential matrix, {@code p_1} and {@code p_2} are corresponding points in the first and the
second images, respectively. The result of this function may be passed further to
#decomposeEssentialMat or  #recoverPose to recover the relative pose between cameras.
 */
@Namespace("cv") public static native @ByVal Mat findEssentialMat( @ByVal Mat points1, @ByVal Mat points2,
                                 @ByVal Mat cameraMatrix1, @ByVal Mat distCoeffs1,
                                 @ByVal Mat cameraMatrix2, @ByVal Mat distCoeffs2,
                                 int method/*=cv::RANSAC*/,
                                 double prob/*=0.999*/, double threshold/*=1.0*/,
                                 @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat mask );
@Namespace("cv") public static native @ByVal Mat findEssentialMat( @ByVal Mat points1, @ByVal Mat points2,
                                 @ByVal Mat cameraMatrix1, @ByVal Mat distCoeffs1,
                                 @ByVal Mat cameraMatrix2, @ByVal Mat distCoeffs2 );
@Namespace("cv") public static native @ByVal Mat findEssentialMat( @ByVal UMat points1, @ByVal UMat points2,
                                 @ByVal UMat cameraMatrix1, @ByVal UMat distCoeffs1,
                                 @ByVal UMat cameraMatrix2, @ByVal UMat distCoeffs2,
                                 int method/*=cv::RANSAC*/,
                                 double prob/*=0.999*/, double threshold/*=1.0*/,
                                 @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat mask );
@Namespace("cv") public static native @ByVal Mat findEssentialMat( @ByVal UMat points1, @ByVal UMat points2,
                                 @ByVal UMat cameraMatrix1, @ByVal UMat distCoeffs1,
                                 @ByVal UMat cameraMatrix2, @ByVal UMat distCoeffs2 );
@Namespace("cv") public static native @ByVal Mat findEssentialMat( @ByVal GpuMat points1, @ByVal GpuMat points2,
                                 @ByVal GpuMat cameraMatrix1, @ByVal GpuMat distCoeffs1,
                                 @ByVal GpuMat cameraMatrix2, @ByVal GpuMat distCoeffs2,
                                 int method/*=cv::RANSAC*/,
                                 double prob/*=0.999*/, double threshold/*=1.0*/,
                                 @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat mask );
@Namespace("cv") public static native @ByVal Mat findEssentialMat( @ByVal GpuMat points1, @ByVal GpuMat points2,
                                 @ByVal GpuMat cameraMatrix1, @ByVal GpuMat distCoeffs1,
                                 @ByVal GpuMat cameraMatrix2, @ByVal GpuMat distCoeffs2 );


@Namespace("cv") public static native @ByVal Mat findEssentialMat( @ByVal Mat points1, @ByVal Mat points2,
                      @ByVal Mat cameraMatrix1, @ByVal Mat cameraMatrix2,
                      @ByVal Mat dist_coeff1, @ByVal Mat dist_coeff2, @ByVal Mat mask,
                      @Const @ByRef UsacParams params);
@Namespace("cv") public static native @ByVal Mat findEssentialMat( @ByVal UMat points1, @ByVal UMat points2,
                      @ByVal UMat cameraMatrix1, @ByVal UMat cameraMatrix2,
                      @ByVal UMat dist_coeff1, @ByVal UMat dist_coeff2, @ByVal UMat mask,
                      @Const @ByRef UsacParams params);
@Namespace("cv") public static native @ByVal Mat findEssentialMat( @ByVal GpuMat points1, @ByVal GpuMat points2,
                      @ByVal GpuMat cameraMatrix1, @ByVal GpuMat cameraMatrix2,
                      @ByVal GpuMat dist_coeff1, @ByVal GpuMat dist_coeff2, @ByVal GpuMat mask,
                      @Const @ByRef UsacParams params);

/** \brief Decompose an essential matrix to possible rotations and translation.
<p>
@param E The input essential matrix.
@param R1 One possible rotation matrix.
@param R2 Another possible rotation matrix.
@param t One possible translation.
<p>
This function decomposes the essential matrix E using svd decomposition \cite HartleyZ00. In
general, four possible poses exist for the decomposition of E. They are {@code [R_1, t]},
{@code [R_1, -t]}, {@code [R_2, t]}, {@code [R_2, -t]}.
<p>
If E gives the epipolar constraint {@code [p_2; 1]^T A^{-T} E A^{-1} [p_1; 1] = 0} between the image
points {@code p_1} in the first image and {@code p_2} in second image, then any of the tuples
{@code [R_1, t]}, {@code [R_1, -t]}, {@code [R_2, t]}, {@code [R_2, -t]} is a change of basis from the first
camera's coordinate system to the second camera's coordinate system. However, by decomposing E, one
can only get the direction of the translation. For this reason, the translation t is returned with
unit length.
 */
@Namespace("cv") public static native void decomposeEssentialMat( @ByVal Mat E, @ByVal Mat R1, @ByVal Mat R2, @ByVal Mat t );
@Namespace("cv") public static native void decomposeEssentialMat( @ByVal UMat E, @ByVal UMat R1, @ByVal UMat R2, @ByVal UMat t );
@Namespace("cv") public static native void decomposeEssentialMat( @ByVal GpuMat E, @ByVal GpuMat R1, @ByVal GpuMat R2, @ByVal GpuMat t );

/** \brief Recovers the relative camera rotation and the translation from an estimated essential
matrix and the corresponding points in two images, using cheirality check. Returns the number of
inliers that pass the check.
<p>
@param E The input essential matrix.
@param points1 Array of N 2D points from the first image. The point coordinates should be
floating-point (single or double precision).
@param points2 Array of the second image points of the same size and format as points1 .
@param cameraMatrix Camera intrinsic matrix {@code \cameramatrix{A}} .
Note that this function assumes that points1 and points2 are feature points from cameras with the
same camera intrinsic matrix.
@param R Output rotation matrix. Together with the translation vector, this matrix makes up a tuple
that performs a change of basis from the first camera's coordinate system to the second camera's
coordinate system. Note that, in general, t can not be used for this tuple, see the parameter
described below.
@param t Output translation vector. This vector is obtained by \ref decomposeEssentialMat and
therefore is only known up to scale, i.e. t is the direction of the translation vector and has unit
length.
@param mask Input/output mask for inliers in points1 and points2. If it is not empty, then it marks
inliers in points1 and points2 for then given essential matrix E. Only these inliers will be used to
recover pose. In the output mask only inliers which pass the cheirality check.
<p>
This function decomposes an essential matrix using \ref decomposeEssentialMat and then verifies
possible pose hypotheses by doing cheirality check. The cheirality check means that the
triangulated 3D points should have positive depth. Some details can be found in \cite Nister03.
<p>
This function can be used to process the output E and mask from \ref findEssentialMat. In this
scenario, points1 and points2 are the same input for #findEssentialMat :
<pre>{@code
    // Example. Estimation of fundamental matrix using the RANSAC algorithm
    int point_count = 100;
    vector<Point2f> points1(point_count);
    vector<Point2f> points2(point_count);

    // initialize the points here ...
    for( int i = 0; i < point_count; i++ )
    {
        points1[i] = ...;
        points2[i] = ...;
    }

    // cametra matrix with both focal lengths = 1, and principal point = (0, 0)
    Mat cameraMatrix = Mat::eye(3, 3, CV_64F);

    Mat E, R, t, mask;

    E = findEssentialMat(points1, points2, cameraMatrix, RANSAC, 0.999, 1.0, mask);
    recoverPose(E, points1, points2, cameraMatrix, R, t, mask);
}</pre>
 */
@Namespace("cv") public static native int recoverPose( @ByVal Mat E, @ByVal Mat points1, @ByVal Mat points2,
                            @ByVal Mat cameraMatrix, @ByVal Mat R, @ByVal Mat t,
                            @ByVal(nullValue = "cv::InputOutputArray(cv::noArray())") Mat mask );
@Namespace("cv") public static native int recoverPose( @ByVal Mat E, @ByVal Mat points1, @ByVal Mat points2,
                            @ByVal Mat cameraMatrix, @ByVal Mat R, @ByVal Mat t );
@Namespace("cv") public static native int recoverPose( @ByVal UMat E, @ByVal UMat points1, @ByVal UMat points2,
                            @ByVal UMat cameraMatrix, @ByVal UMat R, @ByVal UMat t,
                            @ByVal(nullValue = "cv::InputOutputArray(cv::noArray())") UMat mask );
@Namespace("cv") public static native int recoverPose( @ByVal UMat E, @ByVal UMat points1, @ByVal UMat points2,
                            @ByVal UMat cameraMatrix, @ByVal UMat R, @ByVal UMat t );
@Namespace("cv") public static native int recoverPose( @ByVal GpuMat E, @ByVal GpuMat points1, @ByVal GpuMat points2,
                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat R, @ByVal GpuMat t,
                            @ByVal(nullValue = "cv::InputOutputArray(cv::noArray())") GpuMat mask );
@Namespace("cv") public static native int recoverPose( @ByVal GpuMat E, @ByVal GpuMat points1, @ByVal GpuMat points2,
                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat R, @ByVal GpuMat t );

/** \overload
@param E The input essential matrix.
@param points1 Array of N 2D points from the first image. The point coordinates should be
floating-point (single or double precision).
@param points2 Array of the second image points of the same size and format as points1 .
@param R Output rotation matrix. Together with the translation vector, this matrix makes up a tuple
that performs a change of basis from the first camera's coordinate system to the second camera's
coordinate system. Note that, in general, t can not be used for this tuple, see the parameter
description below.
@param t Output translation vector. This vector is obtained by \ref decomposeEssentialMat and
therefore is only known up to scale, i.e. t is the direction of the translation vector and has unit
length.
@param focal Focal length of the camera. Note that this function assumes that points1 and points2
are feature points from cameras with same focal length and principal point.
@param pp principal point of the camera.
@param mask Input/output mask for inliers in points1 and points2. If it is not empty, then it marks
inliers in points1 and points2 for then given essential matrix E. Only these inliers will be used to
recover pose. In the output mask only inliers which pass the cheirality check.
<p>
This function differs from the one above that it computes camera intrinsic matrix from focal length and
principal point:
<p>
<pre>{@code \[A =
\begin{bmatrix}
f & 0 & x_{pp}  \\
0 & f & y_{pp}  \\
0 & 0 & 1
\end{bmatrix}\]}</pre>
 */
@Namespace("cv") public static native int recoverPose( @ByVal Mat E, @ByVal Mat points1, @ByVal Mat points2,
                            @ByVal Mat R, @ByVal Mat t,
                            double focal/*=1.0*/, @ByVal(nullValue = "cv::Point2d(0, 0)") Point2d pp,
                            @ByVal(nullValue = "cv::InputOutputArray(cv::noArray())") Mat mask );
@Namespace("cv") public static native int recoverPose( @ByVal Mat E, @ByVal Mat points1, @ByVal Mat points2,
                            @ByVal Mat R, @ByVal Mat t );
@Namespace("cv") public static native int recoverPose( @ByVal UMat E, @ByVal UMat points1, @ByVal UMat points2,
                            @ByVal UMat R, @ByVal UMat t,
                            double focal/*=1.0*/, @ByVal(nullValue = "cv::Point2d(0, 0)") Point2d pp,
                            @ByVal(nullValue = "cv::InputOutputArray(cv::noArray())") UMat mask );
@Namespace("cv") public static native int recoverPose( @ByVal UMat E, @ByVal UMat points1, @ByVal UMat points2,
                            @ByVal UMat R, @ByVal UMat t );
@Namespace("cv") public static native int recoverPose( @ByVal GpuMat E, @ByVal GpuMat points1, @ByVal GpuMat points2,
                            @ByVal GpuMat R, @ByVal GpuMat t,
                            double focal/*=1.0*/, @ByVal(nullValue = "cv::Point2d(0, 0)") Point2d pp,
                            @ByVal(nullValue = "cv::InputOutputArray(cv::noArray())") GpuMat mask );
@Namespace("cv") public static native int recoverPose( @ByVal GpuMat E, @ByVal GpuMat points1, @ByVal GpuMat points2,
                            @ByVal GpuMat R, @ByVal GpuMat t );

/** \overload
@param E The input essential matrix.
@param points1 Array of N 2D points from the first image. The point coordinates should be
floating-point (single or double precision).
@param points2 Array of the second image points of the same size and format as points1.
@param cameraMatrix Camera intrinsic matrix {@code \cameramatrix{A}} .
Note that this function assumes that points1 and points2 are feature points from cameras with the
same camera intrinsic matrix.
@param R Output rotation matrix. Together with the translation vector, this matrix makes up a tuple
that performs a change of basis from the first camera's coordinate system to the second camera's
coordinate system. Note that, in general, t can not be used for this tuple, see the parameter
description below.
@param t Output translation vector. This vector is obtained by \ref decomposeEssentialMat and
therefore is only known up to scale, i.e. t is the direction of the translation vector and has unit
length.
@param distanceThresh threshold distance which is used to filter out far away points (i.e. infinite
points).
@param mask Input/output mask for inliers in points1 and points2. If it is not empty, then it marks
inliers in points1 and points2 for then given essential matrix E. Only these inliers will be used to
recover pose. In the output mask only inliers which pass the cheirality check.
@param triangulatedPoints 3D points which were reconstructed by triangulation.
<p>
This function differs from the one above that it outputs the triangulated 3D point that are used for
the cheirality check.
 */
@Namespace("cv") public static native int recoverPose( @ByVal Mat E, @ByVal Mat points1, @ByVal Mat points2,
                            @ByVal Mat cameraMatrix, @ByVal Mat R, @ByVal Mat t, double distanceThresh, @ByVal(nullValue = "cv::InputOutputArray(cv::noArray())") Mat mask,
                            @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat triangulatedPoints);
@Namespace("cv") public static native int recoverPose( @ByVal Mat E, @ByVal Mat points1, @ByVal Mat points2,
                            @ByVal Mat cameraMatrix, @ByVal Mat R, @ByVal Mat t, double distanceThresh);
@Namespace("cv") public static native int recoverPose( @ByVal UMat E, @ByVal UMat points1, @ByVal UMat points2,
                            @ByVal UMat cameraMatrix, @ByVal UMat R, @ByVal UMat t, double distanceThresh, @ByVal(nullValue = "cv::InputOutputArray(cv::noArray())") UMat mask,
                            @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat triangulatedPoints);
@Namespace("cv") public static native int recoverPose( @ByVal UMat E, @ByVal UMat points1, @ByVal UMat points2,
                            @ByVal UMat cameraMatrix, @ByVal UMat R, @ByVal UMat t, double distanceThresh);
@Namespace("cv") public static native int recoverPose( @ByVal GpuMat E, @ByVal GpuMat points1, @ByVal GpuMat points2,
                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat R, @ByVal GpuMat t, double distanceThresh, @ByVal(nullValue = "cv::InputOutputArray(cv::noArray())") GpuMat mask,
                            @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat triangulatedPoints);
@Namespace("cv") public static native int recoverPose( @ByVal GpuMat E, @ByVal GpuMat points1, @ByVal GpuMat points2,
                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat R, @ByVal GpuMat t, double distanceThresh);

/** \brief For points in an image of a stereo pair, computes the corresponding epilines in the other image.
<p>
@param points Input points. {@code N \times 1} or {@code 1 \times N} matrix of type CV_32FC2 or
vector\<Point2f\> .
@param whichImage Index of the image (1 or 2) that contains the points .
@param F Fundamental matrix that can be estimated using #findFundamentalMat or #stereoRectify .
@param lines Output vector of the epipolar lines corresponding to the points in the other image.
Each line {@code ax + by + c=0} is encoded by 3 numbers {@code (a, b, c)} .
<p>
For every point in one of the two images of a stereo pair, the function finds the equation of the
corresponding epipolar line in the other image.
<p>
From the fundamental matrix definition (see #findFundamentalMat ), line {@code l^{(2)}_i} in the second
image for the point {@code p^{(1)}_i} in the first image (when whichImage=1 ) is computed as:
<p>
<pre>{@code \[l^{(2)}_i = F p^{(1)}_i\]}</pre>
<p>
And vice versa, when whichImage=2, {@code l^{(1)}_i} is computed from {@code p^{(2)}_i} as:
<p>
<pre>{@code \[l^{(1)}_i = F^T p^{(2)}_i\]}</pre>
<p>
Line coefficients are defined up to a scale. They are normalized so that {@code a_i^2+b_i^2=1} .
 */
@Namespace("cv") public static native void computeCorrespondEpilines( @ByVal Mat points, int whichImage,
                                             @ByVal Mat F, @ByVal Mat lines );
@Namespace("cv") public static native void computeCorrespondEpilines( @ByVal UMat points, int whichImage,
                                             @ByVal UMat F, @ByVal UMat lines );
@Namespace("cv") public static native void computeCorrespondEpilines( @ByVal GpuMat points, int whichImage,
                                             @ByVal GpuMat F, @ByVal GpuMat lines );

/** \brief This function reconstructs 3-dimensional points (in homogeneous coordinates) by using
their observations with a stereo camera.
<p>
@param projMatr1 3x4 projection matrix of the first camera, i.e. this matrix projects 3D points
given in the world's coordinate system into the first image.
@param projMatr2 3x4 projection matrix of the second camera, i.e. this matrix projects 3D points
given in the world's coordinate system into the second image.
@param projPoints1 2xN array of feature points in the first image. In the case of the c++ version,
it can be also a vector of feature points or two-channel matrix of size 1xN or Nx1.
@param projPoints2 2xN array of corresponding points in the second image. In the case of the c++
version, it can be also a vector of feature points or two-channel matrix of size 1xN or Nx1.
@param points4D 4xN array of reconstructed points in homogeneous coordinates. These points are
returned in the world's coordinate system.
<p>
\note
   Keep in mind that all input data should be of float type in order for this function to work.
<p>
\note
   If the projection matrices from \ref stereoRectify are used, then the returned points are
   represented in the first camera's rectified coordinate system.
<p>
@see
   reprojectImageTo3D
 */
@Namespace("cv") public static native void triangulatePoints( @ByVal Mat projMatr1, @ByVal Mat projMatr2,
                                     @ByVal Mat projPoints1, @ByVal Mat projPoints2,
                                     @ByVal Mat points4D );
@Namespace("cv") public static native void triangulatePoints( @ByVal UMat projMatr1, @ByVal UMat projMatr2,
                                     @ByVal UMat projPoints1, @ByVal UMat projPoints2,
                                     @ByVal UMat points4D );
@Namespace("cv") public static native void triangulatePoints( @ByVal GpuMat projMatr1, @ByVal GpuMat projMatr2,
                                     @ByVal GpuMat projPoints1, @ByVal GpuMat projPoints2,
                                     @ByVal GpuMat points4D );

/** \brief Refines coordinates of corresponding points.
<p>
@param F 3x3 fundamental matrix.
@param points1 1xN array containing the first set of points.
@param points2 1xN array containing the second set of points.
@param newPoints1 The optimized points1.
@param newPoints2 The optimized points2.
<p>
The function implements the Optimal Triangulation Method (see Multiple View Geometry for details).
For each given point correspondence points1[i] \<-\> points2[i], and a fundamental matrix F, it
computes the corrected correspondences newPoints1[i] \<-\> newPoints2[i] that minimize the geometric
error {@code d(points1[i], newPoints1[i])^2 + d(points2[i],newPoints2[i])^2} (where {@code d(a,b)} is the
geometric distance between points {@code a} and {@code b} ) subject to the epipolar constraint
{@code newPoints2^T * F * newPoints1 = 0} .
 */
@Namespace("cv") public static native void correctMatches( @ByVal Mat F, @ByVal Mat points1, @ByVal Mat points2,
                                  @ByVal Mat newPoints1, @ByVal Mat newPoints2 );
@Namespace("cv") public static native void correctMatches( @ByVal UMat F, @ByVal UMat points1, @ByVal UMat points2,
                                  @ByVal UMat newPoints1, @ByVal UMat newPoints2 );
@Namespace("cv") public static native void correctMatches( @ByVal GpuMat F, @ByVal GpuMat points1, @ByVal GpuMat points2,
                                  @ByVal GpuMat newPoints1, @ByVal GpuMat newPoints2 );

/** \brief Filters off small noise blobs (speckles) in the disparity map
<p>
@param img The input 16-bit signed disparity image
@param newVal The disparity value used to paint-off the speckles
@param maxSpeckleSize The maximum speckle size to consider it a speckle. Larger blobs are not
affected by the algorithm
@param maxDiff Maximum difference between neighbor disparity pixels to put them into the same
blob. Note that since StereoBM, StereoSGBM and may be other algorithms return a fixed-point
disparity map, where disparity values are multiplied by 16, this scale factor should be taken into
account when specifying this parameter value.
@param buf The optional temporary buffer to avoid memory allocation within the function.
 */
@Namespace("cv") public static native void filterSpeckles( @ByVal Mat img, double newVal,
                                  int maxSpeckleSize, double maxDiff,
                                  @ByVal(nullValue = "cv::InputOutputArray(cv::noArray())") Mat buf );
@Namespace("cv") public static native void filterSpeckles( @ByVal Mat img, double newVal,
                                  int maxSpeckleSize, double maxDiff );
@Namespace("cv") public static native void filterSpeckles( @ByVal UMat img, double newVal,
                                  int maxSpeckleSize, double maxDiff,
                                  @ByVal(nullValue = "cv::InputOutputArray(cv::noArray())") UMat buf );
@Namespace("cv") public static native void filterSpeckles( @ByVal UMat img, double newVal,
                                  int maxSpeckleSize, double maxDiff );
@Namespace("cv") public static native void filterSpeckles( @ByVal GpuMat img, double newVal,
                                  int maxSpeckleSize, double maxDiff,
                                  @ByVal(nullValue = "cv::InputOutputArray(cv::noArray())") GpuMat buf );
@Namespace("cv") public static native void filterSpeckles( @ByVal GpuMat img, double newVal,
                                  int maxSpeckleSize, double maxDiff );

/** computes valid disparity ROI from the valid ROIs of the rectified images (that are returned by #stereoRectify) */
@Namespace("cv") public static native @ByVal Rect getValidDisparityROI( @ByVal Rect roi1, @ByVal Rect roi2,
                                        int minDisparity, int numberOfDisparities,
                                        int blockSize );

/** validates disparity using the left-right check. The matrix "cost" should be computed by the stereo correspondence algorithm */
@Namespace("cv") public static native void validateDisparity( @ByVal Mat disparity, @ByVal Mat cost,
                                     int minDisparity, int numberOfDisparities,
                                     int disp12MaxDisp/*=1*/ );
@Namespace("cv") public static native void validateDisparity( @ByVal Mat disparity, @ByVal Mat cost,
                                     int minDisparity, int numberOfDisparities );
@Namespace("cv") public static native void validateDisparity( @ByVal UMat disparity, @ByVal UMat cost,
                                     int minDisparity, int numberOfDisparities,
                                     int disp12MaxDisp/*=1*/ );
@Namespace("cv") public static native void validateDisparity( @ByVal UMat disparity, @ByVal UMat cost,
                                     int minDisparity, int numberOfDisparities );
@Namespace("cv") public static native void validateDisparity( @ByVal GpuMat disparity, @ByVal GpuMat cost,
                                     int minDisparity, int numberOfDisparities,
                                     int disp12MaxDisp/*=1*/ );
@Namespace("cv") public static native void validateDisparity( @ByVal GpuMat disparity, @ByVal GpuMat cost,
                                     int minDisparity, int numberOfDisparities );

/** \brief Reprojects a disparity image to 3D space.
<p>
@param disparity Input single-channel 8-bit unsigned, 16-bit signed, 32-bit signed or 32-bit
floating-point disparity image. The values of 8-bit / 16-bit signed formats are assumed to have no
fractional bits. If the disparity is 16-bit signed format, as computed by \ref StereoBM or
\ref StereoSGBM and maybe other algorithms, it should be divided by 16 (and scaled to float) before
being used here.
@param _3dImage Output 3-channel floating-point image of the same size as disparity. Each element of
_3dImage(x,y) contains 3D coordinates of the point (x,y) computed from the disparity map. If one
uses Q obtained by \ref stereoRectify, then the returned points are represented in the first
camera's rectified coordinate system.
@param Q {@code 4 \times 4} perspective transformation matrix that can be obtained with
\ref stereoRectify.
@param handleMissingValues Indicates, whether the function should handle missing values (i.e.
points where the disparity was not computed). If handleMissingValues=true, then pixels with the
minimal disparity that corresponds to the outliers (see StereoMatcher::compute ) are transformed
to 3D points with a very large Z value (currently set to 10000).
@param ddepth The optional output array depth. If it is -1, the output image will have CV_32F
depth. ddepth can also be set to CV_16S, CV_32S or CV_32F.
<p>
The function transforms a single-channel disparity map to a 3-channel image representing a 3D
surface. That is, for each pixel (x,y) and the corresponding disparity d=disparity(x,y) , it
computes:
<p>
<pre>{@code \[\begin{bmatrix}
X \\
Y \\
Z \\
W
\end{bmatrix} = Q \begin{bmatrix}
x \\
y \\
\texttt{disparity} (x,y) \\
z
\end{bmatrix}.\]}</pre>
<p>
@see
   To reproject a sparse set of points {(x,y,d),...} to 3D space, use perspectiveTransform.
 */
@Namespace("cv") public static native void reprojectImageTo3D( @ByVal Mat disparity,
                                      @ByVal Mat _3dImage, @ByVal Mat Q,
                                      @Cast("bool") boolean handleMissingValues/*=false*/,
                                      int ddepth/*=-1*/ );
@Namespace("cv") public static native void reprojectImageTo3D( @ByVal Mat disparity,
                                      @ByVal Mat _3dImage, @ByVal Mat Q );
@Namespace("cv") public static native void reprojectImageTo3D( @ByVal UMat disparity,
                                      @ByVal UMat _3dImage, @ByVal UMat Q,
                                      @Cast("bool") boolean handleMissingValues/*=false*/,
                                      int ddepth/*=-1*/ );
@Namespace("cv") public static native void reprojectImageTo3D( @ByVal UMat disparity,
                                      @ByVal UMat _3dImage, @ByVal UMat Q );
@Namespace("cv") public static native void reprojectImageTo3D( @ByVal GpuMat disparity,
                                      @ByVal GpuMat _3dImage, @ByVal GpuMat Q,
                                      @Cast("bool") boolean handleMissingValues/*=false*/,
                                      int ddepth/*=-1*/ );
@Namespace("cv") public static native void reprojectImageTo3D( @ByVal GpuMat disparity,
                                      @ByVal GpuMat _3dImage, @ByVal GpuMat Q );

/** \brief Calculates the Sampson Distance between two points.
<p>
The function cv::sampsonDistance calculates and returns the first order approximation of the geometric error as:
<pre>{@code \[
sd( \texttt{pt1} , \texttt{pt2} )=
\frac{(\texttt{pt2}^t \cdot \texttt{F} \cdot \texttt{pt1})^2}
{((\texttt{F} \cdot \texttt{pt1})(0))^2 +
((\texttt{F} \cdot \texttt{pt1})(1))^2 +
((\texttt{F}^t \cdot \texttt{pt2})(0))^2 +
((\texttt{F}^t \cdot \texttt{pt2})(1))^2}
\]}</pre>
The fundamental matrix may be calculated using the #findFundamentalMat function. See \cite HartleyZ00 11.4.3 for details.
@param pt1 first homogeneous 2d point
@param pt2 second homogeneous 2d point
@param F fundamental matrix
@return The computed Sampson distance.
*/
@Namespace("cv") public static native double sampsonDistance(@ByVal Mat pt1, @ByVal Mat pt2, @ByVal Mat F);
@Namespace("cv") public static native double sampsonDistance(@ByVal UMat pt1, @ByVal UMat pt2, @ByVal UMat F);
@Namespace("cv") public static native double sampsonDistance(@ByVal GpuMat pt1, @ByVal GpuMat pt2, @ByVal GpuMat F);

/** \brief Computes an optimal affine transformation between two 3D point sets.
<p>
It computes
<pre>{@code \[
\begin{bmatrix}
x\\
y\\
z\\
\end{bmatrix}
=
\begin{bmatrix}
a_{11} & a_{12} & a_{13}\\
a_{21} & a_{22} & a_{23}\\
a_{31} & a_{32} & a_{33}\\
\end{bmatrix}
\begin{bmatrix}
X\\
Y\\
Z\\
\end{bmatrix}
+
\begin{bmatrix}
b_1\\
b_2\\
b_3\\
\end{bmatrix}
\]}</pre>
<p>
@param src First input 3D point set containing {@code (X,Y,Z)}.
@param dst Second input 3D point set containing {@code (x,y,z)}.
@param out Output 3D affine transformation matrix {@code 3 \times 4} of the form
<pre>{@code \[
\begin{bmatrix}
a_{11} & a_{12} & a_{13} & b_1\\
a_{21} & a_{22} & a_{23} & b_2\\
a_{31} & a_{32} & a_{33} & b_3\\
\end{bmatrix}
\]}</pre>
@param inliers Output vector indicating which points are inliers (1-inlier, 0-outlier).
@param ransacThreshold Maximum reprojection error in the RANSAC algorithm to consider a point as
an inlier.
@param confidence Confidence level, between 0 and 1, for the estimated transformation. Anything
between 0.95 and 0.99 is usually good enough. Values too close to 1 can slow down the estimation
significantly. Values lower than 0.8-0.9 can result in an incorrectly estimated transformation.
<p>
The function estimates an optimal 3D affine transformation between two 3D point sets using the
RANSAC algorithm.
 */
@Namespace("cv") public static native int estimateAffine3D(@ByVal Mat src, @ByVal Mat dst,
                                   @ByVal Mat out, @ByVal Mat inliers,
                                   double ransacThreshold/*=3*/, double confidence/*=0.99*/);
@Namespace("cv") public static native int estimateAffine3D(@ByVal Mat src, @ByVal Mat dst,
                                   @ByVal Mat out, @ByVal Mat inliers);
@Namespace("cv") public static native int estimateAffine3D(@ByVal UMat src, @ByVal UMat dst,
                                   @ByVal UMat out, @ByVal UMat inliers,
                                   double ransacThreshold/*=3*/, double confidence/*=0.99*/);
@Namespace("cv") public static native int estimateAffine3D(@ByVal UMat src, @ByVal UMat dst,
                                   @ByVal UMat out, @ByVal UMat inliers);
@Namespace("cv") public static native int estimateAffine3D(@ByVal GpuMat src, @ByVal GpuMat dst,
                                   @ByVal GpuMat out, @ByVal GpuMat inliers,
                                   double ransacThreshold/*=3*/, double confidence/*=0.99*/);
@Namespace("cv") public static native int estimateAffine3D(@ByVal GpuMat src, @ByVal GpuMat dst,
                                   @ByVal GpuMat out, @ByVal GpuMat inliers);

/** \brief Computes an optimal affine transformation between two 3D point sets.
<p>
It computes {@code R,s,t} minimizing {@code \sum{i} dst_i - c \cdot R \cdot src_i }
where {@code R} is a 3x3 rotation matrix, {@code t} is a 3x1 translation vector and {@code s} is a
scalar size value. This is an implementation of the algorithm by Umeyama \cite umeyama1991least .
The estimated affine transform has a homogeneous scale which is a subclass of affine
transformations with 7 degrees of freedom. The paired point sets need to comprise at least 3
points each.
<p>
@param src First input 3D point set.
@param dst Second input 3D point set.
@param scale If null is passed, the scale parameter c will be assumed to be 1.0.
Else the pointed-to variable will be set to the optimal scale.
@param force_rotation If true, the returned rotation will never be a reflection.
This might be unwanted, e.g. when optimizing a transform between a right- and a
left-handed coordinate system.
@return 3D affine transformation matrix {@code 3 \times 4} of the form
<pre>{@code \[T =
\begin{bmatrix}
R & t\\
\end{bmatrix}
\]}</pre>
 <p>
 */
@Namespace("cv") public static native @ByVal Mat estimateAffine3D(@ByVal Mat src, @ByVal Mat dst,
                                        DoublePointer scale/*=nullptr*/, @Cast("bool") boolean force_rotation/*=true*/);
@Namespace("cv") public static native @ByVal Mat estimateAffine3D(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv") public static native @ByVal Mat estimateAffine3D(@ByVal Mat src, @ByVal Mat dst,
                                        DoubleBuffer scale/*=nullptr*/, @Cast("bool") boolean force_rotation/*=true*/);
@Namespace("cv") public static native @ByVal Mat estimateAffine3D(@ByVal Mat src, @ByVal Mat dst,
                                        double[] scale/*=nullptr*/, @Cast("bool") boolean force_rotation/*=true*/);
@Namespace("cv") public static native @ByVal Mat estimateAffine3D(@ByVal UMat src, @ByVal UMat dst,
                                        DoublePointer scale/*=nullptr*/, @Cast("bool") boolean force_rotation/*=true*/);
@Namespace("cv") public static native @ByVal Mat estimateAffine3D(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv") public static native @ByVal Mat estimateAffine3D(@ByVal UMat src, @ByVal UMat dst,
                                        DoubleBuffer scale/*=nullptr*/, @Cast("bool") boolean force_rotation/*=true*/);
@Namespace("cv") public static native @ByVal Mat estimateAffine3D(@ByVal UMat src, @ByVal UMat dst,
                                        double[] scale/*=nullptr*/, @Cast("bool") boolean force_rotation/*=true*/);
@Namespace("cv") public static native @ByVal Mat estimateAffine3D(@ByVal GpuMat src, @ByVal GpuMat dst,
                                        DoublePointer scale/*=nullptr*/, @Cast("bool") boolean force_rotation/*=true*/);
@Namespace("cv") public static native @ByVal Mat estimateAffine3D(@ByVal GpuMat src, @ByVal GpuMat dst);
@Namespace("cv") public static native @ByVal Mat estimateAffine3D(@ByVal GpuMat src, @ByVal GpuMat dst,
                                        DoubleBuffer scale/*=nullptr*/, @Cast("bool") boolean force_rotation/*=true*/);
@Namespace("cv") public static native @ByVal Mat estimateAffine3D(@ByVal GpuMat src, @ByVal GpuMat dst,
                                        double[] scale/*=nullptr*/, @Cast("bool") boolean force_rotation/*=true*/);

/** \brief Computes an optimal translation between two 3D point sets.
 *
 * It computes
 * <pre>{@code \[
 * \begin{bmatrix}
 * x\\
 * y\\
 * z\\
 * \end{bmatrix}
 * =
 * \begin{bmatrix}
 * X\\
 * Y\\
 * Z\\
 * \end{bmatrix}
 * +
 * \begin{bmatrix}
 * b_1\\
 * b_2\\
 * b_3\\
 * \end{bmatrix}
 * \]}</pre>
 *
 * @param src First input 3D point set containing {@code (X,Y,Z)}.
 * @param dst Second input 3D point set containing {@code (x,y,z)}.
 * @param out Output 3D translation vector {@code 3 \times 1} of the form
 * <pre>{@code \[
 * \begin{bmatrix}
 * b_1 \\
 * b_2 \\
 * b_3 \\
 * \end{bmatrix}
 * \]}</pre>
 * @param inliers Output vector indicating which points are inliers (1-inlier, 0-outlier).
 * @param ransacThreshold Maximum reprojection error in the RANSAC algorithm to consider a point as
 * an inlier.
 * @param confidence Confidence level, between 0 and 1, for the estimated transformation. Anything
 * between 0.95 and 0.99 is usually good enough. Values too close to 1 can slow down the estimation
 * significantly. Values lower than 0.8-0.9 can result in an incorrectly estimated transformation.
 *
 * The function estimates an optimal 3D translation between two 3D point sets using the
 * RANSAC algorithm.
 *  */
@Namespace("cv") public static native int estimateTranslation3D(@ByVal Mat src, @ByVal Mat dst,
                                        @ByVal Mat out, @ByVal Mat inliers,
                                        double ransacThreshold/*=3*/, double confidence/*=0.99*/);
@Namespace("cv") public static native int estimateTranslation3D(@ByVal Mat src, @ByVal Mat dst,
                                        @ByVal Mat out, @ByVal Mat inliers);
@Namespace("cv") public static native int estimateTranslation3D(@ByVal UMat src, @ByVal UMat dst,
                                        @ByVal UMat out, @ByVal UMat inliers,
                                        double ransacThreshold/*=3*/, double confidence/*=0.99*/);
@Namespace("cv") public static native int estimateTranslation3D(@ByVal UMat src, @ByVal UMat dst,
                                        @ByVal UMat out, @ByVal UMat inliers);
@Namespace("cv") public static native int estimateTranslation3D(@ByVal GpuMat src, @ByVal GpuMat dst,
                                        @ByVal GpuMat out, @ByVal GpuMat inliers,
                                        double ransacThreshold/*=3*/, double confidence/*=0.99*/);
@Namespace("cv") public static native int estimateTranslation3D(@ByVal GpuMat src, @ByVal GpuMat dst,
                                        @ByVal GpuMat out, @ByVal GpuMat inliers);

/** \brief Computes an optimal affine transformation between two 2D point sets.
<p>
It computes
<pre>{@code \[
\begin{bmatrix}
x\\
y\\
\end{bmatrix}
=
\begin{bmatrix}
a_{11} & a_{12}\\
a_{21} & a_{22}\\
\end{bmatrix}
\begin{bmatrix}
X\\
Y\\
\end{bmatrix}
+
\begin{bmatrix}
b_1\\
b_2\\
\end{bmatrix}
\]}</pre>
<p>
@param from First input 2D point set containing {@code (X,Y)}.
@param to Second input 2D point set containing {@code (x,y)}.
@param inliers Output vector indicating which points are inliers (1-inlier, 0-outlier).
@param method Robust method used to compute transformation. The following methods are possible:
-   \ref RANSAC - RANSAC-based robust method
-   \ref LMEDS - Least-Median robust method
RANSAC is the default method.
@param ransacReprojThreshold Maximum reprojection error in the RANSAC algorithm to consider
a point as an inlier. Applies only to RANSAC.
@param maxIters The maximum number of robust method iterations.
@param confidence Confidence level, between 0 and 1, for the estimated transformation. Anything
between 0.95 and 0.99 is usually good enough. Values too close to 1 can slow down the estimation
significantly. Values lower than 0.8-0.9 can result in an incorrectly estimated transformation.
@param refineIters Maximum number of iterations of refining algorithm (Levenberg-Marquardt).
Passing 0 will disable refining, so the output matrix will be output of robust method.
<p>
@return Output 2D affine transformation matrix {@code 2 \times 3} or empty matrix if transformation
could not be estimated. The returned matrix has the following form:
<pre>{@code \[
\begin{bmatrix}
a_{11} & a_{12} & b_1\\
a_{21} & a_{22} & b_2\\
\end{bmatrix}
\]}</pre>
<p>
The function estimates an optimal 2D affine transformation between two 2D point sets using the
selected robust algorithm.
<p>
The computed transformation is then refined further (using only inliers) with the
Levenberg-Marquardt method to reduce the re-projection error even more.
<p>
\note
The RANSAC method can handle practically any ratio of outliers but needs a threshold to
distinguish inliers from outliers. The method LMeDS does not need any threshold but it works
correctly only when there are more than 50% of inliers.
<p>
@see estimateAffinePartial2D, getAffineTransform
*/
@Namespace("cv") public static native @ByVal Mat estimateAffine2D(@ByVal Mat from, @ByVal Mat to, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat inliers,
                                  int method/*=cv::RANSAC*/, double ransacReprojThreshold/*=3*/,
                                  @Cast("size_t") long maxIters/*=2000*/, double confidence/*=0.99*/,
                                  @Cast("size_t") long refineIters/*=10*/);
@Namespace("cv") public static native @ByVal Mat estimateAffine2D(@ByVal Mat from, @ByVal Mat to);
@Namespace("cv") public static native @ByVal Mat estimateAffine2D(@ByVal UMat from, @ByVal UMat to, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat inliers,
                                  int method/*=cv::RANSAC*/, double ransacReprojThreshold/*=3*/,
                                  @Cast("size_t") long maxIters/*=2000*/, double confidence/*=0.99*/,
                                  @Cast("size_t") long refineIters/*=10*/);
@Namespace("cv") public static native @ByVal Mat estimateAffine2D(@ByVal UMat from, @ByVal UMat to);
@Namespace("cv") public static native @ByVal Mat estimateAffine2D(@ByVal GpuMat from, @ByVal GpuMat to, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat inliers,
                                  int method/*=cv::RANSAC*/, double ransacReprojThreshold/*=3*/,
                                  @Cast("size_t") long maxIters/*=2000*/, double confidence/*=0.99*/,
                                  @Cast("size_t") long refineIters/*=10*/);
@Namespace("cv") public static native @ByVal Mat estimateAffine2D(@ByVal GpuMat from, @ByVal GpuMat to);


@Namespace("cv") public static native @ByVal Mat estimateAffine2D(@ByVal Mat pts1, @ByVal Mat pts2, @ByVal Mat inliers,
                     @Const @ByRef UsacParams params);
@Namespace("cv") public static native @ByVal Mat estimateAffine2D(@ByVal UMat pts1, @ByVal UMat pts2, @ByVal UMat inliers,
                     @Const @ByRef UsacParams params);
@Namespace("cv") public static native @ByVal Mat estimateAffine2D(@ByVal GpuMat pts1, @ByVal GpuMat pts2, @ByVal GpuMat inliers,
                     @Const @ByRef UsacParams params);

/** \brief Computes an optimal limited affine transformation with 4 degrees of freedom between
two 2D point sets.
<p>
@param from First input 2D point set.
@param to Second input 2D point set.
@param inliers Output vector indicating which points are inliers.
@param method Robust method used to compute transformation. The following methods are possible:
-   \ref RANSAC - RANSAC-based robust method
-   \ref LMEDS - Least-Median robust method
RANSAC is the default method.
@param ransacReprojThreshold Maximum reprojection error in the RANSAC algorithm to consider
a point as an inlier. Applies only to RANSAC.
@param maxIters The maximum number of robust method iterations.
@param confidence Confidence level, between 0 and 1, for the estimated transformation. Anything
between 0.95 and 0.99 is usually good enough. Values too close to 1 can slow down the estimation
significantly. Values lower than 0.8-0.9 can result in an incorrectly estimated transformation.
@param refineIters Maximum number of iterations of refining algorithm (Levenberg-Marquardt).
Passing 0 will disable refining, so the output matrix will be output of robust method.
<p>
@return Output 2D affine transformation (4 degrees of freedom) matrix {@code 2 \times 3} or
empty matrix if transformation could not be estimated.
<p>
The function estimates an optimal 2D affine transformation with 4 degrees of freedom limited to
combinations of translation, rotation, and uniform scaling. Uses the selected algorithm for robust
estimation.
<p>
The computed transformation is then refined further (using only inliers) with the
Levenberg-Marquardt method to reduce the re-projection error even more.
<p>
Estimated transformation matrix is:
<pre>{@code \[ \begin{bmatrix} \cos(\theta) \cdot s & -\sin(\theta) \cdot s & t_x \\
                \sin(\theta) \cdot s & \cos(\theta) \cdot s & t_y
\end{bmatrix} \]}</pre>
Where {@code  \theta } is the rotation angle, {@code  s } the scaling factor and {@code  t_x, t_y } are
translations in {@code  x, y } axes respectively.
<p>
\note
The RANSAC method can handle practically any ratio of outliers but need a threshold to
distinguish inliers from outliers. The method LMeDS does not need any threshold but it works
correctly only when there are more than 50% of inliers.
<p>
@see estimateAffine2D, getAffineTransform
*/
@Namespace("cv") public static native @ByVal Mat estimateAffinePartial2D(@ByVal Mat from, @ByVal Mat to, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat inliers,
                                  int method/*=cv::RANSAC*/, double ransacReprojThreshold/*=3*/,
                                  @Cast("size_t") long maxIters/*=2000*/, double confidence/*=0.99*/,
                                  @Cast("size_t") long refineIters/*=10*/);
@Namespace("cv") public static native @ByVal Mat estimateAffinePartial2D(@ByVal Mat from, @ByVal Mat to);
@Namespace("cv") public static native @ByVal Mat estimateAffinePartial2D(@ByVal UMat from, @ByVal UMat to, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat inliers,
                                  int method/*=cv::RANSAC*/, double ransacReprojThreshold/*=3*/,
                                  @Cast("size_t") long maxIters/*=2000*/, double confidence/*=0.99*/,
                                  @Cast("size_t") long refineIters/*=10*/);
@Namespace("cv") public static native @ByVal Mat estimateAffinePartial2D(@ByVal UMat from, @ByVal UMat to);
@Namespace("cv") public static native @ByVal Mat estimateAffinePartial2D(@ByVal GpuMat from, @ByVal GpuMat to, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat inliers,
                                  int method/*=cv::RANSAC*/, double ransacReprojThreshold/*=3*/,
                                  @Cast("size_t") long maxIters/*=2000*/, double confidence/*=0.99*/,
                                  @Cast("size_t") long refineIters/*=10*/);
@Namespace("cv") public static native @ByVal Mat estimateAffinePartial2D(@ByVal GpuMat from, @ByVal GpuMat to);

/** \example samples/cpp/tutorial_code/features2D/Homography/decompose_homography.cpp
An example program with homography decomposition.
<p>
Check \ref tutorial_homography "the corresponding tutorial" for more details.
*/

/** \brief Decompose a homography matrix to rotation(s), translation(s) and plane normal(s).
<p>
@param H The input homography matrix between two images.
@param K The input camera intrinsic matrix.
@param rotations Array of rotation matrices.
@param translations Array of translation matrices.
@param normals Array of plane normal matrices.
<p>
This function extracts relative camera motion between two views of a planar object and returns up to
four mathematical solution tuples of rotation, translation, and plane normal. The decomposition of
the homography matrix H is described in detail in \cite Malis.
<p>
If the homography H, induced by the plane, gives the constraint
<pre>{@code \[s_i \vecthree{x'_i}{y'_i}{1} \sim H \vecthree{x_i}{y_i}{1}\]}</pre> on the source image points
{@code p_i} and the destination image points {@code p'_i}, then the tuple of rotations[k] and
translations[k] is a change of basis from the source camera's coordinate system to the destination
camera's coordinate system. However, by decomposing H, one can only get the translation normalized
by the (typically unknown) depth of the scene, i.e. its direction but with normalized length.
<p>
If point correspondences are available, at least two solutions may further be invalidated, by
applying positive depth constraint, i.e. all points must be in front of the camera.
 */
@Namespace("cv") public static native int decomposeHomographyMat(@ByVal Mat H,
                                        @ByVal Mat K,
                                        @ByVal MatVector rotations,
                                        @ByVal MatVector translations,
                                        @ByVal MatVector normals);
@Namespace("cv") public static native int decomposeHomographyMat(@ByVal Mat H,
                                        @ByVal Mat K,
                                        @ByVal UMatVector rotations,
                                        @ByVal UMatVector translations,
                                        @ByVal UMatVector normals);
@Namespace("cv") public static native int decomposeHomographyMat(@ByVal Mat H,
                                        @ByVal Mat K,
                                        @ByVal GpuMatVector rotations,
                                        @ByVal GpuMatVector translations,
                                        @ByVal GpuMatVector normals);
@Namespace("cv") public static native int decomposeHomographyMat(@ByVal UMat H,
                                        @ByVal UMat K,
                                        @ByVal MatVector rotations,
                                        @ByVal MatVector translations,
                                        @ByVal MatVector normals);
@Namespace("cv") public static native int decomposeHomographyMat(@ByVal UMat H,
                                        @ByVal UMat K,
                                        @ByVal UMatVector rotations,
                                        @ByVal UMatVector translations,
                                        @ByVal UMatVector normals);
@Namespace("cv") public static native int decomposeHomographyMat(@ByVal UMat H,
                                        @ByVal UMat K,
                                        @ByVal GpuMatVector rotations,
                                        @ByVal GpuMatVector translations,
                                        @ByVal GpuMatVector normals);
@Namespace("cv") public static native int decomposeHomographyMat(@ByVal GpuMat H,
                                        @ByVal GpuMat K,
                                        @ByVal MatVector rotations,
                                        @ByVal MatVector translations,
                                        @ByVal MatVector normals);
@Namespace("cv") public static native int decomposeHomographyMat(@ByVal GpuMat H,
                                        @ByVal GpuMat K,
                                        @ByVal UMatVector rotations,
                                        @ByVal UMatVector translations,
                                        @ByVal UMatVector normals);
@Namespace("cv") public static native int decomposeHomographyMat(@ByVal GpuMat H,
                                        @ByVal GpuMat K,
                                        @ByVal GpuMatVector rotations,
                                        @ByVal GpuMatVector translations,
                                        @ByVal GpuMatVector normals);

/** \brief Filters homography decompositions based on additional information.
<p>
@param rotations Vector of rotation matrices.
@param normals Vector of plane normal matrices.
@param beforePoints Vector of (rectified) visible reference points before the homography is applied
@param afterPoints Vector of (rectified) visible reference points after the homography is applied
@param possibleSolutions Vector of int indices representing the viable solution set after filtering
@param pointsMask optional Mat/Vector of 8u type representing the mask for the inliers as given by the #findHomography function
<p>
This function is intended to filter the output of the #decomposeHomographyMat based on additional
information as described in \cite Malis . The summary of the method: the #decomposeHomographyMat function
returns 2 unique solutions and their "opposites" for a total of 4 solutions. If we have access to the
sets of points visible in the camera frame before and after the homography transformation is applied,
we can determine which are the true potential solutions and which are the opposites by verifying which
homographies are consistent with all visible reference points being in front of the camera. The inputs
are left unchanged; the filtered solution set is returned as indices into the existing one.
<p>
*/
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal MatVector rotations,
                                                           @ByVal MatVector normals,
                                                           @ByVal Mat beforePoints,
                                                           @ByVal Mat afterPoints,
                                                           @ByVal Mat possibleSolutions,
                                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat pointsMask);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal MatVector rotations,
                                                           @ByVal MatVector normals,
                                                           @ByVal Mat beforePoints,
                                                           @ByVal Mat afterPoints,
                                                           @ByVal Mat possibleSolutions);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal UMatVector rotations,
                                                           @ByVal UMatVector normals,
                                                           @ByVal Mat beforePoints,
                                                           @ByVal Mat afterPoints,
                                                           @ByVal Mat possibleSolutions,
                                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat pointsMask);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal UMatVector rotations,
                                                           @ByVal UMatVector normals,
                                                           @ByVal Mat beforePoints,
                                                           @ByVal Mat afterPoints,
                                                           @ByVal Mat possibleSolutions);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal GpuMatVector rotations,
                                                           @ByVal GpuMatVector normals,
                                                           @ByVal Mat beforePoints,
                                                           @ByVal Mat afterPoints,
                                                           @ByVal Mat possibleSolutions,
                                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat pointsMask);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal GpuMatVector rotations,
                                                           @ByVal GpuMatVector normals,
                                                           @ByVal Mat beforePoints,
                                                           @ByVal Mat afterPoints,
                                                           @ByVal Mat possibleSolutions);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal MatVector rotations,
                                                           @ByVal MatVector normals,
                                                           @ByVal UMat beforePoints,
                                                           @ByVal UMat afterPoints,
                                                           @ByVal UMat possibleSolutions,
                                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat pointsMask);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal MatVector rotations,
                                                           @ByVal MatVector normals,
                                                           @ByVal UMat beforePoints,
                                                           @ByVal UMat afterPoints,
                                                           @ByVal UMat possibleSolutions);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal UMatVector rotations,
                                                           @ByVal UMatVector normals,
                                                           @ByVal UMat beforePoints,
                                                           @ByVal UMat afterPoints,
                                                           @ByVal UMat possibleSolutions,
                                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat pointsMask);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal UMatVector rotations,
                                                           @ByVal UMatVector normals,
                                                           @ByVal UMat beforePoints,
                                                           @ByVal UMat afterPoints,
                                                           @ByVal UMat possibleSolutions);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal GpuMatVector rotations,
                                                           @ByVal GpuMatVector normals,
                                                           @ByVal UMat beforePoints,
                                                           @ByVal UMat afterPoints,
                                                           @ByVal UMat possibleSolutions,
                                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat pointsMask);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal GpuMatVector rotations,
                                                           @ByVal GpuMatVector normals,
                                                           @ByVal UMat beforePoints,
                                                           @ByVal UMat afterPoints,
                                                           @ByVal UMat possibleSolutions);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal MatVector rotations,
                                                           @ByVal MatVector normals,
                                                           @ByVal GpuMat beforePoints,
                                                           @ByVal GpuMat afterPoints,
                                                           @ByVal GpuMat possibleSolutions,
                                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat pointsMask);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal MatVector rotations,
                                                           @ByVal MatVector normals,
                                                           @ByVal GpuMat beforePoints,
                                                           @ByVal GpuMat afterPoints,
                                                           @ByVal GpuMat possibleSolutions);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal UMatVector rotations,
                                                           @ByVal UMatVector normals,
                                                           @ByVal GpuMat beforePoints,
                                                           @ByVal GpuMat afterPoints,
                                                           @ByVal GpuMat possibleSolutions,
                                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat pointsMask);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal UMatVector rotations,
                                                           @ByVal UMatVector normals,
                                                           @ByVal GpuMat beforePoints,
                                                           @ByVal GpuMat afterPoints,
                                                           @ByVal GpuMat possibleSolutions);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal GpuMatVector rotations,
                                                           @ByVal GpuMatVector normals,
                                                           @ByVal GpuMat beforePoints,
                                                           @ByVal GpuMat afterPoints,
                                                           @ByVal GpuMat possibleSolutions,
                                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat pointsMask);
@Namespace("cv") public static native void filterHomographyDecompByVisibleRefpoints(@ByVal GpuMatVector rotations,
                                                           @ByVal GpuMatVector normals,
                                                           @ByVal GpuMat beforePoints,
                                                           @ByVal GpuMat afterPoints,
                                                           @ByVal GpuMat possibleSolutions);
// Targeting ../opencv_calib3d/StereoMatcher.java


// Targeting ../opencv_calib3d/StereoBM.java


// Targeting ../opencv_calib3d/StereoSGBM.java




/** cv::undistort mode */
/** enum cv::UndistortTypes */
public static final int
    PROJ_SPHERICAL_ORTHO  = 0,
    PROJ_SPHERICAL_EQRECT = 1;

/** \brief Transforms an image to compensate for lens distortion.
<p>
The function transforms an image to compensate radial and tangential lens distortion.
<p>
The function is simply a combination of #initUndistortRectifyMap (with unity R ) and #remap
(with bilinear interpolation). See the former function for details of the transformation being
performed.
<p>
Those pixels in the destination image, for which there is no correspondent pixels in the source
image, are filled with zeros (black color).
<p>
A particular subset of the source image that will be visible in the corrected image can be regulated
by newCameraMatrix. You can use #getOptimalNewCameraMatrix to compute the appropriate
newCameraMatrix depending on your requirements.
<p>
The camera matrix and the distortion parameters can be determined using #calibrateCamera. If
the resolution of images is different from the resolution used at the calibration stage, {@code f_x,
f_y, c_x} and {@code c_y} need to be scaled accordingly, while the distortion coefficients remain
the same.
<p>
@param src Input (distorted) image.
@param dst Output (corrected) image that has the same size and type as src .
@param cameraMatrix Input camera matrix {@code A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}} .
@param distCoeffs Input vector of distortion coefficients
{@code (k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \tau_x, \tau_y]]]])}
of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.
@param newCameraMatrix Camera matrix of the distorted image. By default, it is the same as
cameraMatrix but you may additionally scale and shift the result by using a different matrix.
 */
@Namespace("cv") public static native void undistort( @ByVal Mat src, @ByVal Mat dst,
                             @ByVal Mat cameraMatrix,
                             @ByVal Mat distCoeffs,
                             @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat newCameraMatrix );
@Namespace("cv") public static native void undistort( @ByVal Mat src, @ByVal Mat dst,
                             @ByVal Mat cameraMatrix,
                             @ByVal Mat distCoeffs );
@Namespace("cv") public static native void undistort( @ByVal UMat src, @ByVal UMat dst,
                             @ByVal UMat cameraMatrix,
                             @ByVal UMat distCoeffs,
                             @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat newCameraMatrix );
@Namespace("cv") public static native void undistort( @ByVal UMat src, @ByVal UMat dst,
                             @ByVal UMat cameraMatrix,
                             @ByVal UMat distCoeffs );
@Namespace("cv") public static native void undistort( @ByVal GpuMat src, @ByVal GpuMat dst,
                             @ByVal GpuMat cameraMatrix,
                             @ByVal GpuMat distCoeffs,
                             @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat newCameraMatrix );
@Namespace("cv") public static native void undistort( @ByVal GpuMat src, @ByVal GpuMat dst,
                             @ByVal GpuMat cameraMatrix,
                             @ByVal GpuMat distCoeffs );

/** \brief Computes the undistortion and rectification transformation map.
<p>
The function computes the joint undistortion and rectification transformation and represents the
result in the form of maps for #remap. The undistorted image looks like original, as if it is
captured with a camera using the camera matrix =newCameraMatrix and zero distortion. In case of a
monocular camera, newCameraMatrix is usually equal to cameraMatrix, or it can be computed by
#getOptimalNewCameraMatrix for a better control over scaling. In case of a stereo camera,
newCameraMatrix is normally set to P1 or P2 computed by #stereoRectify .
<p>
Also, this new camera is oriented differently in the coordinate space, according to R. That, for
example, helps to align two heads of a stereo camera so that the epipolar lines on both images
become horizontal and have the same y- coordinate (in case of a horizontally aligned stereo camera).
<p>
The function actually builds the maps for the inverse mapping algorithm that is used by #remap. That
is, for each pixel {@code (u, v)} in the destination (corrected and rectified) image, the function
computes the corresponding coordinates in the source image (that is, in the original image from
camera). The following process is applied:
<pre>{@code \[
\begin{array}{l}
x  \leftarrow (u - {c'}_x)/{f'}_x  \\
y  \leftarrow (v - {c'}_y)/{f'}_y  \\
{[X\,Y\,W]} ^T  \leftarrow R^{-1}*[x \, y \, 1]^T  \\
x'  \leftarrow X/W  \\
y'  \leftarrow Y/W  \\
r^2  \leftarrow x'^2 + y'^2 \\
x''  \leftarrow x' \frac{1 + k_1 r^2 + k_2 r^4 + k_3 r^6}{1 + k_4 r^2 + k_5 r^4 + k_6 r^6}
+ 2p_1 x' y' + p_2(r^2 + 2 x'^2)  + s_1 r^2 + s_2 r^4\\
y''  \leftarrow y' \frac{1 + k_1 r^2 + k_2 r^4 + k_3 r^6}{1 + k_4 r^2 + k_5 r^4 + k_6 r^6}
+ p_1 (r^2 + 2 y'^2) + 2 p_2 x' y' + s_3 r^2 + s_4 r^4 \\
s\vecthree{x'''}{y'''}{1} =
\vecthreethree{R_{33}(\tau_x, \tau_y)}{0}{-R_{13}((\tau_x, \tau_y)}
{0}{R_{33}(\tau_x, \tau_y)}{-R_{23}(\tau_x, \tau_y)}
{0}{0}{1} R(\tau_x, \tau_y) \vecthree{x''}{y''}{1}\\
map_x(u,v)  \leftarrow x''' f_x + c_x  \\
map_y(u,v)  \leftarrow y''' f_y + c_y
\end{array}
\]}</pre>
where {@code (k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \tau_x, \tau_y]]]])}
are the distortion coefficients.
<p>
In case of a stereo camera, this function is called twice: once for each camera head, after
#stereoRectify, which in its turn is called after #stereoCalibrate. But if the stereo camera
was not calibrated, it is still possible to compute the rectification transformations directly from
the fundamental matrix using #stereoRectifyUncalibrated. For each camera, the function computes
homography H as the rectification transformation in a pixel domain, not a rotation matrix R in 3D
space. R can be computed from H as
<pre>{@code \[\texttt{R} = \texttt{cameraMatrix} ^{-1} \cdot \texttt{H} \cdot \texttt{cameraMatrix}\]}</pre>
where cameraMatrix can be chosen arbitrarily.
<p>
@param cameraMatrix Input camera matrix {@code A=\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}} .
@param distCoeffs Input vector of distortion coefficients
{@code (k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \tau_x, \tau_y]]]])}
of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.
@param R Optional rectification transformation in the object space (3x3 matrix). R1 or R2 ,
computed by #stereoRectify can be passed here. If the matrix is empty, the identity transformation
is assumed. In cvInitUndistortMap R assumed to be an identity matrix.
@param newCameraMatrix New camera matrix {@code A'=\vecthreethree{f_x'}{0}{c_x'}{0}{f_y'}{c_y'}{0}{0}{1}}.
@param size Undistorted image size.
@param m1type Type of the first output map that can be CV_32FC1, CV_32FC2 or CV_16SC2, see #convertMaps
@param map1 The first output map.
@param map2 The second output map.
 */
@Namespace("cv") public static native void initUndistortRectifyMap(@ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                             @ByVal Mat R, @ByVal Mat newCameraMatrix,
                             @ByVal Size size, int m1type, @ByVal Mat map1, @ByVal Mat map2);
@Namespace("cv") public static native void initUndistortRectifyMap(@ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                             @ByVal UMat R, @ByVal UMat newCameraMatrix,
                             @ByVal Size size, int m1type, @ByVal UMat map1, @ByVal UMat map2);
@Namespace("cv") public static native void initUndistortRectifyMap(@ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                             @ByVal GpuMat R, @ByVal GpuMat newCameraMatrix,
                             @ByVal Size size, int m1type, @ByVal GpuMat map1, @ByVal GpuMat map2);

/** \brief Computes the projection and inverse-rectification transformation map. In essense, this is the inverse of
#initUndistortRectifyMap to accomodate stereo-rectification of projectors ('inverse-cameras') in projector-camera pairs.
<p>
The function computes the joint projection and inverse rectification transformation and represents the
result in the form of maps for #remap. The projected image looks like a distorted version of the original which,
once projected by a projector, should visually match the original. In case of a monocular camera, newCameraMatrix
is usually equal to cameraMatrix, or it can be computed by
#getOptimalNewCameraMatrix for a better control over scaling. In case of a projector-camera pair,
newCameraMatrix is normally set to P1 or P2 computed by #stereoRectify .
<p>
The projector is oriented differently in the coordinate space, according to R. In case of projector-camera pairs,
this helps align the projector (in the same manner as #initUndistortRectifyMap for the camera) to create a stereo-rectified pair. This
allows epipolar lines on both images to become horizontal and have the same y-coordinate (in case of a horizontally aligned projector-camera pair).
<p>
The function builds the maps for the inverse mapping algorithm that is used by #remap. That
is, for each pixel {@code (u, v)} in the destination (projected and inverse-rectified) image, the function
computes the corresponding coordinates in the source image (that is, in the original digital image). The following process is applied:
<p>
<pre>{@code \[
\begin{array}{l}
\text{newCameraMatrix}\\
x  \leftarrow (u - {c'}_x)/{f'}_x  \\
y  \leftarrow (v - {c'}_y)/{f'}_y  \\

\\\text{Undistortion}
\\\scriptsize{\textit{though equation shown is for radial undistortion, function implements cv::undistortPoints()}}\\
r^2  \leftarrow x^2 + y^2 \\
\theta \leftarrow \frac{1 + k_1 r^2 + k_2 r^4 + k_3 r^6}{1 + k_4 r^2 + k_5 r^4 + k_6 r^6}\\
x' \leftarrow \frac{x}{\theta} \\
y'  \leftarrow \frac{y}{\theta} \\

\\\text{Rectification}\\
{[X\,Y\,W]} ^T  \leftarrow R*[x' \, y' \, 1]^T  \\
x''  \leftarrow X/W  \\
y''  \leftarrow Y/W  \\

\\\text{cameraMatrix}\\
map_x(u,v)  \leftarrow x'' f_x + c_x  \\
map_y(u,v)  \leftarrow y'' f_y + c_y
\end{array}
\]}</pre>
where {@code (k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \tau_x, \tau_y]]]])}
are the distortion coefficients vector distCoeffs.
<p>
In case of a stereo-rectified projector-camera pair, this function is called for the projector while #initUndistortRectifyMap is called for the camera head.
This is done after #stereoRectify, which in turn is called after #stereoCalibrate. If the projector-camera pair
is not calibrated, it is still possible to compute the rectification transformations directly from
the fundamental matrix using #stereoRectifyUncalibrated. For the projector and camera, the function computes
homography H as the rectification transformation in a pixel domain, not a rotation matrix R in 3D
space. R can be computed from H as
<pre>{@code \[\texttt{R} = \texttt{cameraMatrix} ^{-1} \cdot \texttt{H} \cdot \texttt{cameraMatrix}\]}</pre>
where cameraMatrix can be chosen arbitrarily.
<p>
@param cameraMatrix Input camera matrix {@code A=\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}} .
@param distCoeffs Input vector of distortion coefficients
{@code (k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \tau_x, \tau_y]]]])}
of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.
@param R Optional rectification transformation in the object space (3x3 matrix). R1 or R2,
computed by #stereoRectify can be passed here. If the matrix is empty, the identity transformation
is assumed.
@param newCameraMatrix New camera matrix {@code A'=\vecthreethree{f_x'}{0}{c_x'}{0}{f_y'}{c_y'}{0}{0}{1}}.
@param size Distorted image size.
@param m1type Type of the first output map. Can be CV_32FC1, CV_32FC2 or CV_16SC2, see #convertMaps
@param map1 The first output map for #remap.
@param map2 The second output map for #remap.
 */
@Namespace("cv") public static native void initInverseRectificationMap( @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                           @ByVal Mat R, @ByVal Mat newCameraMatrix,
                           @Const @ByRef Size size, int m1type, @ByVal Mat map1, @ByVal Mat map2 );
@Namespace("cv") public static native void initInverseRectificationMap( @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                           @ByVal UMat R, @ByVal UMat newCameraMatrix,
                           @Const @ByRef Size size, int m1type, @ByVal UMat map1, @ByVal UMat map2 );
@Namespace("cv") public static native void initInverseRectificationMap( @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                           @ByVal GpuMat R, @ByVal GpuMat newCameraMatrix,
                           @Const @ByRef Size size, int m1type, @ByVal GpuMat map1, @ByVal GpuMat map2 );

/** initializes maps for #remap for wide-angle */
@Namespace("cv") public static native float initWideAngleProjMap(@ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                           @ByVal Size imageSize, int destImageWidth,
                           int m1type, @ByVal Mat map1, @ByVal Mat map2,
                           @Cast("cv::UndistortTypes") int projType/*=cv::PROJ_SPHERICAL_EQRECT*/, double alpha/*=0*/);
@Namespace("cv") public static native float initWideAngleProjMap(@ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                           @ByVal Size imageSize, int destImageWidth,
                           int m1type, @ByVal Mat map1, @ByVal Mat map2);
@Namespace("cv") public static native float initWideAngleProjMap(@ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                           @ByVal Size imageSize, int destImageWidth,
                           int m1type, @ByVal UMat map1, @ByVal UMat map2,
                           @Cast("cv::UndistortTypes") int projType/*=cv::PROJ_SPHERICAL_EQRECT*/, double alpha/*=0*/);
@Namespace("cv") public static native float initWideAngleProjMap(@ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                           @ByVal Size imageSize, int destImageWidth,
                           int m1type, @ByVal UMat map1, @ByVal UMat map2);
@Namespace("cv") public static native float initWideAngleProjMap(@ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                           @ByVal Size imageSize, int destImageWidth,
                           int m1type, @ByVal GpuMat map1, @ByVal GpuMat map2,
                           @Cast("cv::UndistortTypes") int projType/*=cv::PROJ_SPHERICAL_EQRECT*/, double alpha/*=0*/);
@Namespace("cv") public static native float initWideAngleProjMap(@ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                           @ByVal Size imageSize, int destImageWidth,
                           int m1type, @ByVal GpuMat map1, @ByVal GpuMat map2);
@Namespace("cv") public static native float initWideAngleProjMap(@ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                           @ByVal Size imageSize, int destImageWidth,
                           int m1type, @ByVal Mat map1, @ByVal Mat map2,
                           int projType);
@Namespace("cv") public static native float initWideAngleProjMap(@ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                           @ByVal Size imageSize, int destImageWidth,
                           int m1type, @ByVal UMat map1, @ByVal UMat map2,
                           int projType);
@Namespace("cv") public static native float initWideAngleProjMap(@ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                           @ByVal Size imageSize, int destImageWidth,
                           int m1type, @ByVal GpuMat map1, @ByVal GpuMat map2,
                           int projType);

/** \brief Returns the default new camera matrix.
<p>
The function returns the camera matrix that is either an exact copy of the input cameraMatrix (when
centerPrinicipalPoint=false ), or the modified one (when centerPrincipalPoint=true).
<p>
In the latter case, the new camera matrix will be:
<p>
<pre>{@code \[\begin{bmatrix} f_x && 0 && ( \texttt{imgSize.width} -1)*0.5  \\ 0 && f_y && ( \texttt{imgSize.height} -1)*0.5  \\ 0 && 0 && 1 \end{bmatrix} ,\]}</pre>
<p>
where {@code f_x} and {@code f_y} are {@code (0,0)} and {@code (1,1)} elements of cameraMatrix, respectively.
<p>
By default, the undistortion functions in OpenCV (see #initUndistortRectifyMap, #undistort) do not
move the principal point. However, when you work with stereo, it is important to move the principal
points in both views to the same y-coordinate (which is required by most of stereo correspondence
algorithms), and may be to the same x-coordinate too. So, you can form the new camera matrix for
each view where the principal points are located at the center.
<p>
@param cameraMatrix Input camera matrix.
@param imgsize Camera view image size in pixels.
@param centerPrincipalPoint Location of the principal point in the new camera matrix. The
parameter indicates whether this location should be at the image center or not.
 */
@Namespace("cv") public static native @ByVal Mat getDefaultNewCameraMatrix(@ByVal Mat cameraMatrix, @ByVal(nullValue = "cv::Size()") Size imgsize,
                              @Cast("bool") boolean centerPrincipalPoint/*=false*/);
@Namespace("cv") public static native @ByVal Mat getDefaultNewCameraMatrix(@ByVal Mat cameraMatrix);
@Namespace("cv") public static native @ByVal Mat getDefaultNewCameraMatrix(@ByVal UMat cameraMatrix, @ByVal(nullValue = "cv::Size()") Size imgsize,
                              @Cast("bool") boolean centerPrincipalPoint/*=false*/);
@Namespace("cv") public static native @ByVal Mat getDefaultNewCameraMatrix(@ByVal UMat cameraMatrix);
@Namespace("cv") public static native @ByVal Mat getDefaultNewCameraMatrix(@ByVal GpuMat cameraMatrix, @ByVal(nullValue = "cv::Size()") Size imgsize,
                              @Cast("bool") boolean centerPrincipalPoint/*=false*/);
@Namespace("cv") public static native @ByVal Mat getDefaultNewCameraMatrix(@ByVal GpuMat cameraMatrix);

/** \brief Computes the ideal point coordinates from the observed point coordinates.
<p>
The function is similar to #undistort and #initUndistortRectifyMap but it operates on a
sparse set of points instead of a raster image. Also the function performs a reverse transformation
to  #projectPoints. In case of a 3D object, it does not reconstruct its 3D coordinates, but for a
planar object, it does, up to a translation vector, if the proper R is specified.
<p>
For each observed point coordinate {@code (u, v)} the function computes:
<pre>{@code \[
\begin{array}{l}
x^{"}  \leftarrow (u - c_x)/f_x  \\
y^{"}  \leftarrow (v - c_y)/f_y  \\
(x',y') = undistort(x^{"},y^{"}, \texttt{distCoeffs}) \\
{[X\,Y\,W]} ^T  \leftarrow R*[x' \, y' \, 1]^T  \\
x  \leftarrow X/W  \\
y  \leftarrow Y/W  \\
\text{only performed if P is specified:} \\
u'  \leftarrow x {f'}_x + {c'}_x  \\
v'  \leftarrow y {f'}_y + {c'}_y
\end{array}
\]}</pre>
<p>
where *undistort* is an approximate iterative algorithm that estimates the normalized original
point coordinates out of the normalized distorted point coordinates ("normalized" means that the
coordinates do not depend on the camera matrix).
<p>
The function can be used for both a stereo camera head or a monocular camera (when R is empty).
@param src Observed point coordinates, 2xN/Nx2 1-channel or 1xN/Nx1 2-channel (CV_32FC2 or CV_64FC2) (or
vector\<Point2f\> ).
@param dst Output ideal point coordinates (1xN/Nx1 2-channel or vector\<Point2f\> ) after undistortion and reverse perspective
transformation. If matrix P is identity or omitted, dst will contain normalized point coordinates.
@param cameraMatrix Camera matrix {@code \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}} .
@param distCoeffs Input vector of distortion coefficients
{@code (k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \tau_x, \tau_y]]]])}
of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.
@param R Rectification transformation in the object space (3x3 matrix). R1 or R2 computed by
#stereoRectify can be passed here. If the matrix is empty, the identity transformation is used.
@param P New camera matrix (3x3) or new projection matrix (3x4) {@code \begin{bmatrix} {f'}_x & 0 & {c'}_x & t_x \\ 0 & {f'}_y & {c'}_y & t_y \\ 0 & 0 & 1 & t_z \end{bmatrix}}. P1 or P2 computed by
#stereoRectify can be passed here. If the matrix is empty, the identity new camera matrix is used.
 */
@Namespace("cv") public static native void undistortPoints(@ByVal Mat src, @ByVal Mat dst,
                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                     @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat R, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat P);
@Namespace("cv") public static native void undistortPoints(@ByVal Mat src, @ByVal Mat dst,
                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs);
@Namespace("cv") public static native void undistortPoints(@ByVal UMat src, @ByVal UMat dst,
                     @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                     @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat R, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat P);
@Namespace("cv") public static native void undistortPoints(@ByVal UMat src, @ByVal UMat dst,
                     @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs);
@Namespace("cv") public static native void undistortPoints(@ByVal GpuMat src, @ByVal GpuMat dst,
                     @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                     @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat R, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat P);
@Namespace("cv") public static native void undistortPoints(@ByVal GpuMat src, @ByVal GpuMat dst,
                     @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs);
/** \overload
    \note Default version of #undistortPoints does 5 iterations to compute undistorted points.
 */
@Namespace("cv") public static native @Name("undistortPoints") void undistortPointsIter(@ByVal Mat src, @ByVal Mat dst,
                     @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                     @ByVal Mat R, @ByVal Mat P, @ByVal TermCriteria criteria);
@Namespace("cv") public static native @Name("undistortPoints") void undistortPointsIter(@ByVal UMat src, @ByVal UMat dst,
                     @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                     @ByVal UMat R, @ByVal UMat P, @ByVal TermCriteria criteria);
@Namespace("cv") public static native @Name("undistortPoints") void undistortPointsIter(@ByVal GpuMat src, @ByVal GpuMat dst,
                     @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                     @ByVal GpuMat R, @ByVal GpuMat P, @ByVal TermCriteria criteria);

/** \} calib3d
<p>
/** \brief The methods in this namespace use a so-called fisheye camera model.
  \ingroup calib3d_fisheye
*/
/** \addtogroup calib3d_fisheye
 *  \{ */

    /** enum cv::fisheye:: */
    public static final int
        FISHEYE_CALIB_USE_INTRINSIC_GUESS   = 1 << 0,
        FISHEYE_CALIB_RECOMPUTE_EXTRINSIC   = 1 << 1,
        FISHEYE_CALIB_CHECK_COND            = 1 << 2,
        FISHEYE_CALIB_FIX_SKEW              = 1 << 3,
        FISHEYE_CALIB_FIX_K1                = 1 << 4,
        FISHEYE_CALIB_FIX_K2                = 1 << 5,
        FISHEYE_CALIB_FIX_K3                = 1 << 6,
        FISHEYE_CALIB_FIX_K4                = 1 << 7,
        FISHEYE_CALIB_FIX_INTRINSIC         = 1 << 8,
        FISHEYE_CALIB_FIX_PRINCIPAL_POINT   = 1 << 9,
        FISHEYE_CALIB_ZERO_DISPARITY        = 1 << 10,
        FISHEYE_CALIB_FIX_FOCAL_LENGTH      = 1 << 11;

    /** \brief Projects points using fisheye model
    <p>
    @param objectPoints Array of object points, 1xN/Nx1 3-channel (or vector\<Point3f\> ), where N is
    the number of points in the view.
    @param imagePoints Output array of image points, 2xN/Nx2 1-channel or 1xN/Nx1 2-channel, or
    vector\<Point2f\>.
    @param affine
    @param K Camera intrinsic matrix {@code cameramatrix{K}}.
    @param D Input vector of distortion coefficients {@code \distcoeffsfisheye}.
    @param alpha The skew coefficient.
    @param jacobian Optional output 2Nx15 jacobian matrix of derivatives of image points with respect
    to components of the focal lengths, coordinates of the principal point, distortion coefficients,
    rotation vector, translation vector, and the skew. In the old interface different components of
    the jacobian are returned via different output parameters.
    <p>
    The function computes projections of 3D points to the image plane given intrinsic and extrinsic
    camera parameters. Optionally, the function computes Jacobians - matrices of partial derivatives of
    image points coordinates (as functions of all the input parameters) with respect to the particular
    parameters, intrinsic and/or extrinsic.
     */
    @Namespace("cv::fisheye") public static native void projectPoints(@ByVal Mat objectPoints, @ByVal Mat imagePoints, @Const @ByRef Mat affine,
            @ByVal Mat K, @ByVal Mat D, double alpha/*=0*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat jacobian);
    @Namespace("cv::fisheye") public static native void projectPoints(@ByVal Mat objectPoints, @ByVal Mat imagePoints, @Const @ByRef Mat affine,
            @ByVal Mat K, @ByVal Mat D);
    @Namespace("cv::fisheye") public static native void projectPoints(@ByVal UMat objectPoints, @ByVal UMat imagePoints, @Const @ByRef Mat affine,
            @ByVal UMat K, @ByVal UMat D, double alpha/*=0*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat jacobian);
    @Namespace("cv::fisheye") public static native void projectPoints(@ByVal UMat objectPoints, @ByVal UMat imagePoints, @Const @ByRef Mat affine,
            @ByVal UMat K, @ByVal UMat D);
    @Namespace("cv::fisheye") public static native void projectPoints(@ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints, @Const @ByRef Mat affine,
            @ByVal GpuMat K, @ByVal GpuMat D, double alpha/*=0*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat jacobian);
    @Namespace("cv::fisheye") public static native void projectPoints(@ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints, @Const @ByRef Mat affine,
            @ByVal GpuMat K, @ByVal GpuMat D);

    /** \overload */
    @Namespace("cv::fisheye") public static native void projectPoints(@ByVal Mat objectPoints, @ByVal Mat imagePoints, @ByVal Mat rvec, @ByVal Mat tvec,
            @ByVal Mat K, @ByVal Mat D, double alpha/*=0*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat jacobian);
    @Namespace("cv::fisheye") public static native void projectPoints(@ByVal UMat objectPoints, @ByVal UMat imagePoints, @ByVal UMat rvec, @ByVal UMat tvec,
            @ByVal UMat K, @ByVal UMat D, double alpha/*=0*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat jacobian);
    @Namespace("cv::fisheye") public static native void projectPoints(@ByVal GpuMat objectPoints, @ByVal GpuMat imagePoints, @ByVal GpuMat rvec, @ByVal GpuMat tvec,
            @ByVal GpuMat K, @ByVal GpuMat D, double alpha/*=0*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat jacobian);

    /** \brief Distorts 2D points using fisheye model.
    <p>
    @param undistorted Array of object points, 1xN/Nx1 2-channel (or vector\<Point2f\> ), where N is
    the number of points in the view.
    @param K Camera intrinsic matrix {@code cameramatrix{K}}.
    @param D Input vector of distortion coefficients {@code \distcoeffsfisheye}.
    @param alpha The skew coefficient.
    @param distorted Output array of image points, 1xN/Nx1 2-channel, or vector\<Point2f\> .
    <p>
    Note that the function assumes the camera intrinsic matrix of the undistorted points to be identity.
    This means if you want to transform back points undistorted with #fisheye::undistortPoints you have to
    multiply them with {@code P^{-1}}.
     */
    @Namespace("cv::fisheye") public static native void distortPoints(@ByVal Mat undistorted, @ByVal Mat distorted, @ByVal Mat K, @ByVal Mat D, double alpha/*=0*/);
    @Namespace("cv::fisheye") public static native void distortPoints(@ByVal Mat undistorted, @ByVal Mat distorted, @ByVal Mat K, @ByVal Mat D);
    @Namespace("cv::fisheye") public static native void distortPoints(@ByVal UMat undistorted, @ByVal UMat distorted, @ByVal UMat K, @ByVal UMat D, double alpha/*=0*/);
    @Namespace("cv::fisheye") public static native void distortPoints(@ByVal UMat undistorted, @ByVal UMat distorted, @ByVal UMat K, @ByVal UMat D);
    @Namespace("cv::fisheye") public static native void distortPoints(@ByVal GpuMat undistorted, @ByVal GpuMat distorted, @ByVal GpuMat K, @ByVal GpuMat D, double alpha/*=0*/);
    @Namespace("cv::fisheye") public static native void distortPoints(@ByVal GpuMat undistorted, @ByVal GpuMat distorted, @ByVal GpuMat K, @ByVal GpuMat D);

    /** \brief Undistorts 2D points using fisheye model
    <p>
    @param distorted Array of object points, 1xN/Nx1 2-channel (or vector\<Point2f\> ), where N is the
    number of points in the view.
    @param K Camera intrinsic matrix {@code cameramatrix{K}}.
    @param D Input vector of distortion coefficients {@code \distcoeffsfisheye}.
    @param R Rectification transformation in the object space: 3x3 1-channel, or vector: 3x1/1x3
    1-channel or 1x1 3-channel
    @param P New camera intrinsic matrix (3x3) or new projection matrix (3x4)
    @param undistorted Output array of image points, 1xN/Nx1 2-channel, or vector\<Point2f\> .
     */

    /** \brief Computes undistortion and rectification maps for image transform by #remap. If D is empty zero
    distortion is used, if R or P is empty identity matrixes are used.
    <p>
    @param K Camera intrinsic matrix {@code cameramatrix{K}}.
    @param D Input vector of distortion coefficients {@code \distcoeffsfisheye}.
    @param R Rectification transformation in the object space: 3x3 1-channel, or vector: 3x1/1x3
    1-channel or 1x1 3-channel
    @param P New camera intrinsic matrix (3x3) or new projection matrix (3x4)
    @param size Undistorted image size.
    @param m1type Type of the first output map that can be CV_32FC1 or CV_16SC2 . See #convertMaps
    for details.
    @param map1 The first output map.
    @param map2 The second output map.
     */

    /** \brief Transforms an image to compensate for fisheye lens distortion.
    <p>
    @param distorted image with fisheye lens distortion.
    @param undistorted Output image with compensated fisheye lens distortion.
    @param K Camera intrinsic matrix {@code cameramatrix{K}}.
    @param D Input vector of distortion coefficients {@code \distcoeffsfisheye}.
    @param Knew Camera intrinsic matrix of the distorted image. By default, it is the identity matrix but you
    may additionally scale and shift the result by using a different matrix.
    @param new_size the new size
    <p>
    The function transforms an image to compensate radial and tangential lens distortion.
    <p>
    The function is simply a combination of #fisheye::initUndistortRectifyMap (with unity R ) and #remap
    (with bilinear interpolation). See the former function for details of the transformation being
    performed.
    <p>
    See below the results of undistortImage.
       -   a\) result of undistort of perspective camera model (all possible coefficients (k_1, k_2, k_3,
            k_4, k_5, k_6) of distortion were optimized under calibration)
        -   b\) result of #fisheye::undistortImage of fisheye camera model (all possible coefficients (k_1, k_2,
            k_3, k_4) of fisheye distortion were optimized under calibration)
        -   c\) original image was captured with fisheye lens
    <p>
    Pictures a) and b) almost the same. But if we consider points of image located far from the center
    of image, we can notice that on image a) these points are distorted.
    <p>
    ![image](pics/fisheye_undistorted.jpg)
     */
    @Namespace("cv::fisheye") public static native void undistortImage(@ByVal Mat distorted, @ByVal Mat undistorted,
            @ByVal Mat K, @ByVal Mat D, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat Knew, @Const @ByRef(nullValue = "cv::Size()") Size new_size);
    @Namespace("cv::fisheye") public static native void undistortImage(@ByVal Mat distorted, @ByVal Mat undistorted,
            @ByVal Mat K, @ByVal Mat D);
    @Namespace("cv::fisheye") public static native void undistortImage(@ByVal UMat distorted, @ByVal UMat undistorted,
            @ByVal UMat K, @ByVal UMat D, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat Knew, @Const @ByRef(nullValue = "cv::Size()") Size new_size);
    @Namespace("cv::fisheye") public static native void undistortImage(@ByVal UMat distorted, @ByVal UMat undistorted,
            @ByVal UMat K, @ByVal UMat D);
    @Namespace("cv::fisheye") public static native void undistortImage(@ByVal GpuMat distorted, @ByVal GpuMat undistorted,
            @ByVal GpuMat K, @ByVal GpuMat D, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat Knew, @Const @ByRef(nullValue = "cv::Size()") Size new_size);
    @Namespace("cv::fisheye") public static native void undistortImage(@ByVal GpuMat distorted, @ByVal GpuMat undistorted,
            @ByVal GpuMat K, @ByVal GpuMat D);

    /** \brief Estimates new camera intrinsic matrix for undistortion or rectification.
    <p>
    @param K Camera intrinsic matrix {@code cameramatrix{K}}.
    @param image_size Size of the image
    @param D Input vector of distortion coefficients {@code \distcoeffsfisheye}.
    @param R Rectification transformation in the object space: 3x3 1-channel, or vector: 3x1/1x3
    1-channel or 1x1 3-channel
    @param P New camera intrinsic matrix (3x3) or new projection matrix (3x4)
    @param balance Sets the new focal length in range between the min focal length and the max focal
    length. Balance is in range of [0, 1].
    @param new_size the new size
    @param fov_scale Divisor for new focal length.
     */
    @Namespace("cv::fisheye") public static native void estimateNewCameraMatrixForUndistortRectify(@ByVal Mat K, @ByVal Mat D, @Const @ByRef Size image_size, @ByVal Mat R,
            @ByVal Mat P, double balance/*=0.0*/, @Const @ByRef(nullValue = "cv::Size()") Size new_size, double fov_scale/*=1.0*/);
    @Namespace("cv::fisheye") public static native void estimateNewCameraMatrixForUndistortRectify(@ByVal Mat K, @ByVal Mat D, @Const @ByRef Size image_size, @ByVal Mat R,
            @ByVal Mat P);
    @Namespace("cv::fisheye") public static native void estimateNewCameraMatrixForUndistortRectify(@ByVal UMat K, @ByVal UMat D, @Const @ByRef Size image_size, @ByVal UMat R,
            @ByVal UMat P, double balance/*=0.0*/, @Const @ByRef(nullValue = "cv::Size()") Size new_size, double fov_scale/*=1.0*/);
    @Namespace("cv::fisheye") public static native void estimateNewCameraMatrixForUndistortRectify(@ByVal UMat K, @ByVal UMat D, @Const @ByRef Size image_size, @ByVal UMat R,
            @ByVal UMat P);
    @Namespace("cv::fisheye") public static native void estimateNewCameraMatrixForUndistortRectify(@ByVal GpuMat K, @ByVal GpuMat D, @Const @ByRef Size image_size, @ByVal GpuMat R,
            @ByVal GpuMat P, double balance/*=0.0*/, @Const @ByRef(nullValue = "cv::Size()") Size new_size, double fov_scale/*=1.0*/);
    @Namespace("cv::fisheye") public static native void estimateNewCameraMatrixForUndistortRectify(@ByVal GpuMat K, @ByVal GpuMat D, @Const @ByRef Size image_size, @ByVal GpuMat R,
            @ByVal GpuMat P);

    /** \brief Performs camera calibaration
    <p>
    @param objectPoints vector of vectors of calibration pattern points in the calibration pattern
    coordinate space.
    @param imagePoints vector of vectors of the projections of calibration pattern points.
    imagePoints.size() and objectPoints.size() and imagePoints[i].size() must be equal to
    objectPoints[i].size() for each i.
    @param image_size Size of the image used only to initialize the camera intrinsic matrix.
    @param K Output 3x3 floating-point camera intrinsic matrix
    {@code \cameramatrix{A}} . If
    \ref fisheye::CALIB_USE_INTRINSIC_GUESS is specified, some or all of fx, fy, cx, cy must be
    initialized before calling the function.
    @param D Output vector of distortion coefficients {@code \distcoeffsfisheye}.
    @param rvecs Output vector of rotation vectors (see Rodrigues ) estimated for each pattern view.
    That is, each k-th rotation vector together with the corresponding k-th translation vector (see
    the next output parameter description) brings the calibration pattern from the model coordinate
    space (in which object points are specified) to the world coordinate space, that is, a real
    position of the calibration pattern in the k-th pattern view (k=0.. *M* -1).
    @param tvecs Output vector of translation vectors estimated for each pattern view.
    @param flags Different flags that may be zero or a combination of the following values:
    -    \ref fisheye::CALIB_USE_INTRINSIC_GUESS  cameraMatrix contains valid initial values of
    fx, fy, cx, cy that are optimized further. Otherwise, (cx, cy) is initially set to the image
    center ( imageSize is used), and focal distances are computed in a least-squares fashion.
    -    \ref fisheye::CALIB_RECOMPUTE_EXTRINSIC  Extrinsic will be recomputed after each iteration
    of intrinsic optimization.
    -    \ref fisheye::CALIB_CHECK_COND  The functions will check validity of condition number.
    -    \ref fisheye::CALIB_FIX_SKEW  Skew coefficient (alpha) is set to zero and stay zero.
    -    \ref fisheye::CALIB_FIX_K1,..., \ref fisheye::CALIB_FIX_K4 Selected distortion coefficients
    are set to zeros and stay zero.
    -    \ref fisheye::CALIB_FIX_PRINCIPAL_POINT  The principal point is not changed during the global
optimization. It stays at the center or at a different location specified when \ref fisheye::CALIB_USE_INTRINSIC_GUESS is set too.
    -    \ref fisheye::CALIB_FIX_FOCAL_LENGTH The focal length is not changed during the global
optimization. It is the {@code max(width,height)/\pi} or the provided {@code f_x}, {@code f_y} when \ref fisheye::CALIB_USE_INTRINSIC_GUESS is set too.
    @param criteria Termination criteria for the iterative optimization algorithm.
     */
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal MatVector objectPoints, @ByVal MatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal Mat K, @ByVal Mat D, @ByVal MatVector rvecs, @ByVal MatVector tvecs, int flags/*=0*/,
                @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 100, DBL_EPSILON)") TermCriteria criteria);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal MatVector objectPoints, @ByVal MatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal Mat K, @ByVal Mat D, @ByVal MatVector rvecs, @ByVal MatVector tvecs);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal UMatVector objectPoints, @ByVal UMatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal Mat K, @ByVal Mat D, @ByVal UMatVector rvecs, @ByVal UMatVector tvecs, int flags/*=0*/,
                @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 100, DBL_EPSILON)") TermCriteria criteria);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal UMatVector objectPoints, @ByVal UMatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal Mat K, @ByVal Mat D, @ByVal UMatVector rvecs, @ByVal UMatVector tvecs);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal GpuMatVector objectPoints, @ByVal GpuMatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal Mat K, @ByVal Mat D, @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs, int flags/*=0*/,
                @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 100, DBL_EPSILON)") TermCriteria criteria);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal GpuMatVector objectPoints, @ByVal GpuMatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal Mat K, @ByVal Mat D, @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal MatVector objectPoints, @ByVal MatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal UMat K, @ByVal UMat D, @ByVal MatVector rvecs, @ByVal MatVector tvecs, int flags/*=0*/,
                @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 100, DBL_EPSILON)") TermCriteria criteria);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal MatVector objectPoints, @ByVal MatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal UMat K, @ByVal UMat D, @ByVal MatVector rvecs, @ByVal MatVector tvecs);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal UMatVector objectPoints, @ByVal UMatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal UMat K, @ByVal UMat D, @ByVal UMatVector rvecs, @ByVal UMatVector tvecs, int flags/*=0*/,
                @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 100, DBL_EPSILON)") TermCriteria criteria);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal UMatVector objectPoints, @ByVal UMatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal UMat K, @ByVal UMat D, @ByVal UMatVector rvecs, @ByVal UMatVector tvecs);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal GpuMatVector objectPoints, @ByVal GpuMatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal UMat K, @ByVal UMat D, @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs, int flags/*=0*/,
                @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 100, DBL_EPSILON)") TermCriteria criteria);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal GpuMatVector objectPoints, @ByVal GpuMatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal UMat K, @ByVal UMat D, @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal MatVector objectPoints, @ByVal MatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal GpuMat K, @ByVal GpuMat D, @ByVal MatVector rvecs, @ByVal MatVector tvecs, int flags/*=0*/,
                @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 100, DBL_EPSILON)") TermCriteria criteria);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal MatVector objectPoints, @ByVal MatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal GpuMat K, @ByVal GpuMat D, @ByVal MatVector rvecs, @ByVal MatVector tvecs);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal UMatVector objectPoints, @ByVal UMatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal GpuMat K, @ByVal GpuMat D, @ByVal UMatVector rvecs, @ByVal UMatVector tvecs, int flags/*=0*/,
                @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 100, DBL_EPSILON)") TermCriteria criteria);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal UMatVector objectPoints, @ByVal UMatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal GpuMat K, @ByVal GpuMat D, @ByVal UMatVector rvecs, @ByVal UMatVector tvecs);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal GpuMatVector objectPoints, @ByVal GpuMatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal GpuMat K, @ByVal GpuMat D, @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs, int flags/*=0*/,
                @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 100, DBL_EPSILON)") TermCriteria criteria);
    @Namespace("cv::fisheye") public static native double calibrate(@ByVal GpuMatVector objectPoints, @ByVal GpuMatVector imagePoints, @Const @ByRef Size image_size,
            @ByVal GpuMat K, @ByVal GpuMat D, @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs);

    /** \brief Stereo rectification for fisheye camera model
    <p>
    @param K1 First camera intrinsic matrix.
    @param D1 First camera distortion parameters.
    @param K2 Second camera intrinsic matrix.
    @param D2 Second camera distortion parameters.
    @param imageSize Size of the image used for stereo calibration.
    @param R Rotation matrix between the coordinate systems of the first and the second
    cameras.
    @param tvec Translation vector between coordinate systems of the cameras.
    @param R1 Output 3x3 rectification transform (rotation matrix) for the first camera.
    @param R2 Output 3x3 rectification transform (rotation matrix) for the second camera.
    @param P1 Output 3x4 projection matrix in the new (rectified) coordinate systems for the first
    camera.
    @param P2 Output 3x4 projection matrix in the new (rectified) coordinate systems for the second
    camera.
    @param Q Output {@code 4 \times 4} disparity-to-depth mapping matrix (see reprojectImageTo3D ).
    @param flags Operation flags that may be zero or \ref fisheye::CALIB_ZERO_DISPARITY . If the flag is set,
    the function makes the principal points of each camera have the same pixel coordinates in the
    rectified views. And if the flag is not set, the function may still shift the images in the
    horizontal or vertical direction (depending on the orientation of epipolar lines) to maximize the
    useful image area.
    @param newImageSize New image resolution after rectification. The same size should be passed to
    #initUndistortRectifyMap (see the stereo_calib.cpp sample in OpenCV samples directory). When (0,0)
    is passed (default), it is set to the original imageSize . Setting it to larger value can help you
    preserve details in the original image, especially when there is a big radial distortion.
    @param balance Sets the new focal length in range between the min focal length and the max focal
    length. Balance is in range of [0, 1].
    @param fov_scale Divisor for new focal length.
     */
    @Namespace("cv::fisheye") public static native void stereoRectify(@ByVal Mat K1, @ByVal Mat D1, @ByVal Mat K2, @ByVal Mat D2, @Const @ByRef Size imageSize, @ByVal Mat R, @ByVal Mat tvec,
            @ByVal Mat R1, @ByVal Mat R2, @ByVal Mat P1, @ByVal Mat P2, @ByVal Mat Q, int flags, @Const @ByRef(nullValue = "cv::Size()") Size newImageSize,
            double balance/*=0.0*/, double fov_scale/*=1.0*/);
    @Namespace("cv::fisheye") public static native void stereoRectify(@ByVal Mat K1, @ByVal Mat D1, @ByVal Mat K2, @ByVal Mat D2, @Const @ByRef Size imageSize, @ByVal Mat R, @ByVal Mat tvec,
            @ByVal Mat R1, @ByVal Mat R2, @ByVal Mat P1, @ByVal Mat P2, @ByVal Mat Q, int flags);
    @Namespace("cv::fisheye") public static native void stereoRectify(@ByVal UMat K1, @ByVal UMat D1, @ByVal UMat K2, @ByVal UMat D2, @Const @ByRef Size imageSize, @ByVal UMat R, @ByVal UMat tvec,
            @ByVal UMat R1, @ByVal UMat R2, @ByVal UMat P1, @ByVal UMat P2, @ByVal UMat Q, int flags, @Const @ByRef(nullValue = "cv::Size()") Size newImageSize,
            double balance/*=0.0*/, double fov_scale/*=1.0*/);
    @Namespace("cv::fisheye") public static native void stereoRectify(@ByVal UMat K1, @ByVal UMat D1, @ByVal UMat K2, @ByVal UMat D2, @Const @ByRef Size imageSize, @ByVal UMat R, @ByVal UMat tvec,
            @ByVal UMat R1, @ByVal UMat R2, @ByVal UMat P1, @ByVal UMat P2, @ByVal UMat Q, int flags);
    @Namespace("cv::fisheye") public static native void stereoRectify(@ByVal GpuMat K1, @ByVal GpuMat D1, @ByVal GpuMat K2, @ByVal GpuMat D2, @Const @ByRef Size imageSize, @ByVal GpuMat R, @ByVal GpuMat tvec,
            @ByVal GpuMat R1, @ByVal GpuMat R2, @ByVal GpuMat P1, @ByVal GpuMat P2, @ByVal GpuMat Q, int flags, @Const @ByRef(nullValue = "cv::Size()") Size newImageSize,
            double balance/*=0.0*/, double fov_scale/*=1.0*/);
    @Namespace("cv::fisheye") public static native void stereoRectify(@ByVal GpuMat K1, @ByVal GpuMat D1, @ByVal GpuMat K2, @ByVal GpuMat D2, @Const @ByRef Size imageSize, @ByVal GpuMat R, @ByVal GpuMat tvec,
            @ByVal GpuMat R1, @ByVal GpuMat R2, @ByVal GpuMat P1, @ByVal GpuMat P2, @ByVal GpuMat Q, int flags);

    /** \brief Performs stereo calibration
    <p>
    @param objectPoints Vector of vectors of the calibration pattern points.
    @param imagePoints1 Vector of vectors of the projections of the calibration pattern points,
    observed by the first camera.
    @param imagePoints2 Vector of vectors of the projections of the calibration pattern points,
    observed by the second camera.
    @param K1 Input/output first camera intrinsic matrix:
    {@code \vecthreethree{f_x^{(j)}}{0}{c_x^{(j)}}{0}{f_y^{(j)}}{c_y^{(j)}}{0}{0}{1}} , {@code j = 0,\, 1} . If
    any of \ref fisheye::CALIB_USE_INTRINSIC_GUESS , \ref fisheye::CALIB_FIX_INTRINSIC are specified,
    some or all of the matrix components must be initialized.
    @param D1 Input/output vector of distortion coefficients {@code \distcoeffsfisheye} of 4 elements.
    @param K2 Input/output second camera intrinsic matrix. The parameter is similar to K1 .
    @param D2 Input/output lens distortion coefficients for the second camera. The parameter is
    similar to D1 .
    @param imageSize Size of the image used only to initialize camera intrinsic matrix.
    @param R Output rotation matrix between the 1st and the 2nd camera coordinate systems.
    @param T Output translation vector between the coordinate systems of the cameras.
    @param flags Different flags that may be zero or a combination of the following values:
    -    \ref fisheye::CALIB_FIX_INTRINSIC  Fix K1, K2? and D1, D2? so that only R, T matrices
    are estimated.
    -    \ref fisheye::CALIB_USE_INTRINSIC_GUESS  K1, K2 contains valid initial values of
    fx, fy, cx, cy that are optimized further. Otherwise, (cx, cy) is initially set to the image
    center (imageSize is used), and focal distances are computed in a least-squares fashion.
    -    \ref fisheye::CALIB_RECOMPUTE_EXTRINSIC  Extrinsic will be recomputed after each iteration
    of intrinsic optimization.
    -    \ref fisheye::CALIB_CHECK_COND  The functions will check validity of condition number.
    -    \ref fisheye::CALIB_FIX_SKEW  Skew coefficient (alpha) is set to zero and stay zero.
    -   \ref fisheye::CALIB_FIX_K1,..., \ref fisheye::CALIB_FIX_K4 Selected distortion coefficients are set to zeros and stay
    zero.
    @param criteria Termination criteria for the iterative optimization algorithm.
     */
    

/** \} calib3d_fisheye */
 // end namespace fisheye

 //end namespace cv

// #if 0 //def __cplusplus
// #endif

// #endif


}
