/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.ximgproc;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Algorithm;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.utils.Converters;
import org.opencv.ximgproc.EdgeDrawing_Params;

public class EdgeDrawing
extends Algorithm {
    public static final int PREWITT = 0;
    public static final int SOBEL = 1;
    public static final int SCHARR = 2;
    public static final int LSD = 3;

    protected EdgeDrawing(long addr) {
        super(addr);
    }

    public static EdgeDrawing __fromPtr__(long addr) {
        return new EdgeDrawing(addr);
    }

    public void detectEdges(Mat src) {
        EdgeDrawing.detectEdges_0(this.nativeObj, src.nativeObj);
    }

    public void getEdgeImage(Mat dst) {
        EdgeDrawing.getEdgeImage_0(this.nativeObj, dst.nativeObj);
    }

    public void getGradientImage(Mat dst) {
        EdgeDrawing.getGradientImage_0(this.nativeObj, dst.nativeObj);
    }

    public List<MatOfPoint> getSegments() {
        ArrayList<MatOfPoint> retVal = new ArrayList<MatOfPoint>();
        Mat retValMat = new Mat(EdgeDrawing.getSegments_0(this.nativeObj));
        Converters.Mat_to_vector_vector_Point(retValMat, retVal);
        return retVal;
    }

    public void detectLines(Mat lines) {
        EdgeDrawing.detectLines_0(this.nativeObj, lines.nativeObj);
    }

    public void detectEllipses(Mat ellipses) {
        EdgeDrawing.detectEllipses_0(this.nativeObj, ellipses.nativeObj);
    }

    public void setParams(EdgeDrawing_Params parameters) {
        EdgeDrawing.setParams_0(this.nativeObj, parameters.nativeObj);
    }

    @Override
    protected void finalize() throws Throwable {
        EdgeDrawing.delete(this.nativeObj);
    }

    private static native void detectEdges_0(long var0, long var2);

    private static native void getEdgeImage_0(long var0, long var2);

    private static native void getGradientImage_0(long var0, long var2);

    private static native long getSegments_0(long var0);

    private static native void detectLines_0(long var0, long var2);

    private static native void detectEllipses_0(long var0, long var2);

    private static native void setParams_0(long var0, long var2);

    private static native void delete(long var0);
}

