// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_core;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.opencv.global.opencv_core.*;


@Namespace("cv::cuda") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_core.class)
public class GpuMatND extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public GpuMatND(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public GpuMatND(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public GpuMatND position(long position) {
        return (GpuMatND)super.position(position);
    }
    @Override public GpuMatND getPointer(long i) {
        return new GpuMatND((Pointer)this).offsetAddress(i);
    }


    /** destructor */

    /** default constructor */
    public GpuMatND() { super((Pointer)null); allocate(); }
    private native void allocate();

    /** \overload
    @param size Array of integers specifying an n-dimensional array shape.
    @param type Array type. Use CV_8UC1, ..., CV_16FC4 to create 1-4 channel matrices, or
    CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices.
    */
    public GpuMatND(@StdVector IntPointer size, int type) { super((Pointer)null); allocate(size, type); }
    private native void allocate(@StdVector IntPointer size, int type);
    public GpuMatND(@StdVector IntBuffer size, int type) { super((Pointer)null); allocate(size, type); }
    private native void allocate(@StdVector IntBuffer size, int type);
    public GpuMatND(@StdVector int[] size, int type) { super((Pointer)null); allocate(size, type); }
    private native void allocate(@StdVector int[] size, int type);

    /** \overload
    @param size Array of integers specifying an n-dimensional array shape.
    @param type Array type. Use CV_8UC1, ..., CV_16FC4 to create 1-4 channel matrices, or
    CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices.
    @param data Pointer to the user data. Matrix constructors that take data and step parameters do not
    allocate matrix data. Instead, they just initialize the matrix header that points to the specified
    data, which means that no data is copied. This operation is very efficient and can be used to
    process external data using OpenCV functions. The external data is not automatically deallocated, so
    you should take care of it.
    @param step Array of _size.size()-1 steps in case of a multi-dimensional array (the last step is always
    set to the element size). If not specified, the matrix is assumed to be continuous.
    */
    public GpuMatND(@StdVector IntPointer size, int type, Pointer data, @StdVector SizeTPointer step/*=cv::cuda::GpuMatND::StepArray()*/) { super((Pointer)null); allocate(size, type, data, step); }
    private native void allocate(@StdVector IntPointer size, int type, Pointer data, @StdVector SizeTPointer step/*=cv::cuda::GpuMatND::StepArray()*/);
    public GpuMatND(@StdVector IntPointer size, int type, Pointer data) { super((Pointer)null); allocate(size, type, data); }
    private native void allocate(@StdVector IntPointer size, int type, Pointer data);
    public GpuMatND(@StdVector IntBuffer size, int type, Pointer data, @StdVector SizeTPointer step/*=cv::cuda::GpuMatND::StepArray()*/) { super((Pointer)null); allocate(size, type, data, step); }
    private native void allocate(@StdVector IntBuffer size, int type, Pointer data, @StdVector SizeTPointer step/*=cv::cuda::GpuMatND::StepArray()*/);
    public GpuMatND(@StdVector IntBuffer size, int type, Pointer data) { super((Pointer)null); allocate(size, type, data); }
    private native void allocate(@StdVector IntBuffer size, int type, Pointer data);
    public GpuMatND(@StdVector int[] size, int type, Pointer data, @StdVector SizeTPointer step/*=cv::cuda::GpuMatND::StepArray()*/) { super((Pointer)null); allocate(size, type, data, step); }
    private native void allocate(@StdVector int[] size, int type, Pointer data, @StdVector SizeTPointer step/*=cv::cuda::GpuMatND::StepArray()*/);
    public GpuMatND(@StdVector int[] size, int type, Pointer data) { super((Pointer)null); allocate(size, type, data); }
    private native void allocate(@StdVector int[] size, int type, Pointer data);

    /** \brief Allocates GPU memory.
    Suppose there is some GPU memory already allocated. In that case, this method may choose to reuse that
    GPU memory under the specific condition: it must be of the same size and type, not externally allocated,
    the GPU memory is continuous(i.e., isContinuous() is true), and is not a sub-matrix of another GpuMatND
    (i.e., isSubmatrix() is false). In other words, this method guarantees that the GPU memory allocated by
    this method is always continuous and is not a sub-region of another GpuMatND.
    */
    public native void create(@StdVector IntPointer size, int type);
    public native void create(@StdVector IntBuffer size, int type);
    public native void create(@StdVector int[] size, int type);

    public native void release();

    public native @NoException void swap(@ByRef GpuMatND m);

    /** \brief Creates a full copy of the array and the underlying data.
    The method creates a full copy of the array. It mimics the behavior of Mat::clone(), i.e.
    the original step is not taken into account. So, the array copy is a continuous array
    occupying total()\*elemSize() bytes.
    */
    public native @ByVal GpuMatND clone();

    /** \overload
    This overload is non-blocking, so it may return even if the copy operation is not finished.
    */
    public native @ByVal GpuMatND clone(@ByRef Stream stream);

    /** \brief Extracts a sub-matrix.
    The operator makes a new header for the specified sub-array of \*this.
    The operator is an O(1) operation, that is, no matrix data is copied.
    @param ranges Array of selected ranges along each dimension.
    */
    public native @ByVal @Name("operator ()") GpuMatND apply(@Const @ByRef RangeVector ranges);

    /** \brief Creates a GpuMat header for a 2D plane part of an n-dim matrix.
    \note The returned GpuMat is constructed with the constructor for user-allocated data.
    That is, It does not perform reference counting.
    \note This function does not increment this GpuMatND's reference counter.
    */
    public native @ByVal GpuMat createGpuMatHeader(@StdVector IntPointer idx, @ByVal Range rowRange, @ByVal Range colRange);
    public native @ByVal GpuMat createGpuMatHeader(@StdVector IntBuffer idx, @ByVal Range rowRange, @ByVal Range colRange);
    public native @ByVal GpuMat createGpuMatHeader(@StdVector int[] idx, @ByVal Range rowRange, @ByVal Range colRange);

    /** \overload
    Creates a GpuMat header if this GpuMatND is effectively 2D.
    \note The returned GpuMat is constructed with the constructor for user-allocated data.
    That is, It does not perform reference counting.
    \note This function does not increment this GpuMatND's reference counter.
    */
    public native @ByVal GpuMat createGpuMatHeader();

    /** \brief Extracts a 2D plane part of an n-dim matrix.
    It differs from createGpuMatHeader(IndexArray, Range, Range) in that it clones a part of this
    GpuMatND to the returned GpuMat.
    \note This operator does not increment this GpuMatND's reference counter;
    */
    public native @ByVal @Name("operator ()") GpuMat apply(@StdVector IntPointer idx, @ByVal Range rowRange, @ByVal Range colRange);
    public native @ByVal @Name("operator ()") GpuMat apply(@StdVector IntBuffer idx, @ByVal Range rowRange, @ByVal Range colRange);
    public native @ByVal @Name("operator ()") GpuMat apply(@StdVector int[] idx, @ByVal Range rowRange, @ByVal Range colRange);

    /** \brief Extracts a 2D plane part of an n-dim matrix if this GpuMatND is effectively 2D.
    It differs from createGpuMatHeader() in that it clones a part of this GpuMatND.
    \note This operator does not increment this GpuMatND's reference counter;
    */
    public native @ByVal @Name("operator cv::cuda::GpuMat") GpuMat asGpuMat();

    public GpuMatND(@Const @ByRef GpuMatND arg0) { super((Pointer)null); allocate(arg0); }
    private native void allocate(@Const @ByRef GpuMatND arg0);
    public native @ByRef @Name("operator =") GpuMatND put(@Const @ByRef GpuMatND arg0);

// #if defined(__GNUC__) && __GNUC__ < 5
    // error: function '...' defaulted on its first declaration with an exception-specification
    // that differs from the implicit declaration '...'
// #else
// #endif

    public native void upload(@ByVal Mat src);
    public native void upload(@ByVal UMat src);
    public native void upload(@ByVal GpuMat src);
    public native void upload(@ByVal Mat src, @ByRef Stream stream);
    public native void upload(@ByVal UMat src, @ByRef Stream stream);
    public native void upload(@ByVal GpuMat src, @ByRef Stream stream);
    public native void download(@ByVal Mat dst);
    public native void download(@ByVal UMat dst);
    public native void download(@ByVal GpuMat dst);
    public native void download(@ByVal Mat dst, @ByRef Stream stream);
    public native void download(@ByVal UMat dst, @ByRef Stream stream);
    public native void download(@ByVal GpuMat dst, @ByRef Stream stream);

    /** returns true iff the GpuMatND data is continuous
     *  (i.e. when there are no gaps between successive rows) */
    public native @Cast("bool") boolean isContinuous();

    /** returns true if the matrix is a sub-matrix of another matrix */
    public native @Cast("bool") boolean isSubmatrix();

    /** returns element size in bytes */
    public native @Cast("size_t") long elemSize();

    /** returns the size of element channel in bytes */
    public native @Cast("size_t") long elemSize1();

    /** returns true if data is null */
    public native @Cast("bool") boolean empty();

    /** returns true if not empty and points to external(user-allocated) gpu memory */
    public native @Cast("bool") boolean external();

    /** returns pointer to the first byte of the GPU memory */
    public native @Cast("uchar*") BytePointer getDevicePtr();

    /** returns the total number of array elements */
    public native @Cast("size_t") long total();

    /** returns the size of underlying memory in bytes */
    public native @Cast("size_t") long totalMemSize();

    /** returns element type */
    public native int type();
    /** includes several bit-fields:
    - the magic signature
    - continuity flag
    - depth
    - number of channels
    */
    public native int flags(); public native GpuMatND flags(int setter);

    /** matrix dimensionality */
    public native int dims(); public native GpuMatND dims(int setter);

    /** shape of this array */
    public native @StdVector IntPointer size(); public native GpuMatND size(IntPointer setter);

    /** step values
    Their semantics is identical to the semantics of step for Mat.
    */
    public native @StdVector SizeTPointer step(); public native GpuMatND step(SizeTPointer setter);
}
