// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_stitching;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;
import org.bytedeco.opencv.opencv_objdetect.*;
import static org.bytedeco.opencv.global.opencv_objdetect.*;
import org.bytedeco.opencv.opencv_video.*;
import static org.bytedeco.opencv.global.opencv_video.*;
import org.bytedeco.opencv.opencv_ml.*;
import static org.bytedeco.opencv.global.opencv_ml.*;
import org.bytedeco.opencv.opencv_shape.*;
import static org.bytedeco.opencv.global.opencv_shape.*;
import org.bytedeco.opencv.opencv_xfeatures2d.*;
import static org.bytedeco.opencv.global.opencv_xfeatures2d.*;

import static org.bytedeco.opencv.global.opencv_stitching.*;


/** \addtogroup stitching
 *  \{
<p>
/** \brief Describes camera parameters.
<p>
\note Translation is assumed to be zero during the whole stitching pipeline. :
 */
@Namespace("cv::detail") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_stitching.class)
public class CameraParams extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CameraParams(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CameraParams(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public CameraParams position(long position) {
        return (CameraParams)super.position(position);
    }
    @Override public CameraParams getPointer(long i) {
        return new CameraParams((Pointer)this).offsetAddress(i);
    }

    public CameraParams() { super((Pointer)null); allocate(); }
    private native void allocate();
    public CameraParams(@Const @ByRef CameraParams other) { super((Pointer)null); allocate(other); }
    private native void allocate(@Const @ByRef CameraParams other);
    public native @ByRef @Name("operator =") CameraParams put(@Const @ByRef CameraParams other);
    public native @ByVal Mat K();

    public native double focal(); public native CameraParams focal(double setter); // Focal length
    public native double aspect(); public native CameraParams aspect(double setter); // Aspect ratio
    public native double ppx(); public native CameraParams ppx(double setter); // Principal point X
    public native double ppy(); public native CameraParams ppy(double setter); // Principal point Y
    public native @ByRef Mat R(); public native CameraParams R(Mat setter); // Rotation
    public native @ByRef Mat t(); public native CameraParams t(Mat setter); // Translation
}
