/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.aruco;

import java.util.ArrayList;
import java.util.List;
import org.opencv.aruco.Dictionary;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfPoint3f;
import org.opencv.core.Point3;
import org.opencv.utils.Converters;

public class Board {
    protected final long nativeObj;

    protected Board(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static Board __fromPtr__(long addr) {
        return new Board(addr);
    }

    public static Board create(List<Mat> objPoints, Dictionary dictionary, Mat ids) {
        Mat objPoints_mat = Converters.vector_Mat_to_Mat(objPoints);
        return Board.__fromPtr__(Board.create_0(objPoints_mat.nativeObj, dictionary.getNativeObjAddr(), ids.nativeObj));
    }

    public void setIds(Mat ids) {
        Board.setIds_0(this.nativeObj, ids.nativeObj);
    }

    public List<MatOfPoint3f> get_objPoints() {
        ArrayList<MatOfPoint3f> retVal = new ArrayList<MatOfPoint3f>();
        Mat retValMat = new Mat(Board.get_objPoints_0(this.nativeObj));
        Converters.Mat_to_vector_vector_Point3f(retValMat, retVal);
        return retVal;
    }

    public Dictionary get_dictionary() {
        return Dictionary.__fromPtr__(Board.get_dictionary_0(this.nativeObj));
    }

    public MatOfInt get_ids() {
        return MatOfInt.fromNativeAddr(Board.get_ids_0(this.nativeObj));
    }

    public void set_ids(MatOfInt ids) {
        MatOfInt ids_mat = ids;
        Board.set_ids_0(this.nativeObj, ids_mat.nativeObj);
    }

    public Point3 get_rightBottomBorder() {
        return new Point3(Board.get_rightBottomBorder_0(this.nativeObj));
    }

    protected void finalize() throws Throwable {
        Board.delete(this.nativeObj);
    }

    private static native long create_0(long var0, long var2, long var4);

    private static native void setIds_0(long var0, long var2);

    private static native long get_objPoints_0(long var0);

    private static native long get_dictionary_0(long var0);

    private static native long get_ids_0(long var0);

    private static native void set_ids_0(long var0, long var2);

    private static native double[] get_rightBottomBorder_0(long var0);

    private static native void delete(long var0);
}

