// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_tracking;

import org.bytedeco.javacpp.annotation.Index;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import org.bytedeco.opencv.opencv_plot.*;
import static org.bytedeco.opencv.global.opencv_plot.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;
import org.bytedeco.opencv.opencv_video.*;
import static org.bytedeco.opencv.global.opencv_video.*;

import static org.bytedeco.opencv.global.opencv_tracking.*;

@Name("std::deque<cv::detail::tracking::tbm::TrackedObject>") @Properties(inherit = org.bytedeco.opencv.presets.opencv_tracking.class)
public class TrackedObjectDeque extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TrackedObjectDeque(Pointer p) { super(p); }
    public TrackedObjectDeque(TrackedObject value) { this(1); put(0, value); }
    public TrackedObjectDeque(TrackedObject ... array) { this(array.length); put(array); }
    public TrackedObjectDeque()       { allocate();  }
    public TrackedObjectDeque(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator =") @ByRef TrackedObjectDeque put(@ByRef TrackedObjectDeque x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    public TrackedObject front() { return get(0); }
    public TrackedObject back() { return get(size() - 1); }
    @Index(function = "at") public native @ByRef TrackedObject get(@Cast("size_t") long i);
    public native TrackedObjectDeque put(@Cast("size_t") long i, TrackedObject value);

    public native @ByVal Iterator insert(@ByVal Iterator pos, @ByRef TrackedObject value);
    public native @ByVal Iterator erase(@ByVal Iterator pos);
    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator ++") @ByRef Iterator increment();
        public native @Name("operator ==") boolean equals(@ByRef Iterator it);
        public native @Name("operator *") @ByRef @Const TrackedObject get();
    }

    public TrackedObject[] get() {
        TrackedObject[] array = new TrackedObject[size() < Integer.MAX_VALUE ? (int)size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; i++) {
            array[i] = get(i);
        }
        return array;
    }
    @Override public String toString() {
        return java.util.Arrays.toString(get());
    }

    public TrackedObject pop_back() {
        long size = size();
        TrackedObject value = get(size - 1);
        resize(size - 1);
        return value;
    }
    public TrackedObjectDeque push_back(TrackedObject value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public TrackedObjectDeque put(TrackedObject value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public TrackedObjectDeque put(TrackedObject ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

