/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.pytorch;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.pytorch.TensorIndex;
import org.bytedeco.pytorch.presets.torch;

@Name(value={"std::vector<at::indexing::TensorIndex>"})
@Properties(inherit={torch.class})
public class TensorIndexVector
extends Pointer {
    public TensorIndexVector(Pointer p) {
        super(p);
    }

    public TensorIndexVector(TensorIndex value) {
        this(1L);
        this.put(0L, value);
    }

    public TensorIndexVector(TensorIndex ... array) {
        this(array.length);
        this.put(array);
    }

    public TensorIndexVector() {
        this.allocate();
    }

    public TensorIndexVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native TensorIndexVector put(@ByRef TensorIndexVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public TensorIndex front() {
        return this.get(0L);
    }

    public TensorIndex back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native TensorIndex get(@Cast(value={"size_t"}) long var1);

    public native TensorIndexVector put(@Cast(value={"size_t"}) long var1, TensorIndex var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef TensorIndex var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public TensorIndex[] get() {
        TensorIndex[] array = new TensorIndex[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public TensorIndex pop_back() {
        long size = this.size();
        TensorIndex value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public TensorIndexVector push_back(TensorIndex value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public TensorIndexVector put(TensorIndex value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public TensorIndexVector put(TensorIndex ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native TensorIndex get();
    }
}

