/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.tensorflowlite;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.StdMove;
import org.bytedeco.javacpp.annotation.UniquePtr;
import org.bytedeco.tensorflowlite.Subgraph;
import org.bytedeco.tensorflowlite.presets.tensorflowlite;

@Name(value={"std::vector<std::unique_ptr<tflite::Subgraph> >"})
@Properties(inherit={tensorflowlite.class})
public class SubgraphVector
extends Pointer {
    public SubgraphVector(Pointer p) {
        super(p);
    }

    public SubgraphVector(@Cast(value={"", "std::unique_ptr<tflite::Subgraph>&&"}) Subgraph value) {
        this(1L);
        this.put(0L, value);
    }

    public SubgraphVector(Subgraph ... array) {
        this(array.length);
        this.put(array);
    }

    public SubgraphVector() {
        this.allocate();
    }

    public SubgraphVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native SubgraphVector put(@ByRef @StdMove SubgraphVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Subgraph front() {
        return this.get(0L);
    }

    public Subgraph back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @UniquePtr
    @Cast(value={"", "std::unique_ptr<tflite::Subgraph>&&"})
    public native Subgraph get(@Cast(value={"size_t"}) long var1);

    public native SubgraphVector put(@Cast(value={"size_t"}) long var1, Subgraph var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @UniquePtr @Cast(value={"", "std::unique_ptr<tflite::Subgraph>&&"}) Subgraph var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Subgraph[] get() {
        Subgraph[] array = new Subgraph[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Subgraph pop_back() {
        long size = this.size();
        Subgraph value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public SubgraphVector push_back(Subgraph value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public SubgraphVector put(Subgraph value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public SubgraphVector put(Subgraph ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @UniquePtr
        @Cast(value={"", "std::unique_ptr<tflite::Subgraph>&&"})
        public native Subgraph get();
    }
}

