/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.tensorflow;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.tensorflow.TF_Buffer;
import org.bytedeco.tensorflow.presets.tensorflow;

@Properties(inherit={tensorflow.class})
public abstract class AbstractTF_Buffer
extends Pointer {
    public AbstractTF_Buffer(Pointer p) {
        super(p);
    }

    public static TF_Buffer newBuffer() {
        TF_Buffer b = org.bytedeco.tensorflow.global.tensorflow.TF_NewBuffer();
        if (b != null) {
            b.deallocator(new DeleteDeallocator(b));
        }
        return b;
    }

    public static TF_Buffer newBufferFromString(byte[] proto) {
        return AbstractTF_Buffer.newBufferFromString((Pointer)new BytePointer(proto));
    }

    public static TF_Buffer newBufferFromString(Pointer proto) {
        TF_Buffer b = org.bytedeco.tensorflow.global.tensorflow.TF_NewBufferFromString(proto, proto.limit());
        if (b != null) {
            b.deallocator(new DeleteDeallocator(b));
        }
        return b;
    }

    public void delete() {
        this.deallocate();
    }

    protected static class DeleteDeallocator
    extends TF_Buffer
    implements Pointer.Deallocator {
        DeleteDeallocator(TF_Buffer s) {
            super(s);
        }

        public void deallocate() {
            if (!this.isNull()) {
                org.bytedeco.tensorflow.global.tensorflow.TF_DeleteBuffer(this);
            }
            this.setNull();
        }
    }
}

