/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.tensorflow;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.bytedeco.tensorflow.StringArray;
import org.bytedeco.tensorflow.Tensor;
import org.bytedeco.tensorflow.TensorShape;
import org.bytedeco.tensorflow.presets.tensorflow;

@Properties(inherit={tensorflow.class})
public abstract class AbstractTensor
extends Pointer
implements Indexable {
    public AbstractTensor(Pointer p) {
        super(p);
    }

    public static Tensor create(float[] data, TensorShape shape) {
        Tensor t = new Tensor(1, shape);
        FloatBuffer b = (FloatBuffer)t.createBuffer();
        b.put(data);
        return t;
    }

    public static Tensor create(double[] data, TensorShape shape) {
        Tensor t = new Tensor(2, shape);
        DoubleBuffer b = (DoubleBuffer)t.createBuffer();
        b.put(data);
        return t;
    }

    public static Tensor create(int[] data, TensorShape shape) {
        Tensor t = new Tensor(3, shape);
        IntBuffer b = (IntBuffer)t.createBuffer();
        b.put(data);
        return t;
    }

    public static Tensor create(short[] data, TensorShape shape) {
        Tensor t = new Tensor(5, shape);
        ShortBuffer b = (ShortBuffer)t.createBuffer();
        b.put(data);
        return t;
    }

    public static Tensor create(byte[] data, TensorShape shape) {
        Tensor t = new Tensor(6, shape);
        ByteBuffer b = (ByteBuffer)t.createBuffer();
        b.put(data);
        return t;
    }

    public static Tensor create(long[] data, TensorShape shape) {
        Tensor t = new Tensor(9, shape);
        LongBuffer b = (LongBuffer)t.createBuffer();
        b.put(data);
        return t;
    }

    public static Tensor create(String[] data, TensorShape shape) {
        Tensor t = new Tensor(7, shape);
        StringArray a = t.createStringArray();
        int i = 0;
        while ((long)i < a.capacity()) {
            a.position(i).put(data[i]);
            ++i;
        }
        return t;
    }

    public abstract int dtype();

    public abstract int dims();

    public abstract long dim_size(int var1);

    public abstract long NumElements();

    public abstract long TotalBytes();

    public abstract BytePointer tensor_data();

    public <B extends Buffer> B createBuffer() {
        return this.createBuffer(0L);
    }

    public <B extends Buffer> B createBuffer(long index) {
        BytePointer ptr = this.tensor_data();
        long size = this.TotalBytes();
        switch (this.dtype()) {
            case 1: 
            case 8: {
                return (B)new FloatPointer((Pointer)ptr).position(index).capacity(size / 4L).asBuffer();
            }
            case 2: {
                return (B)new DoublePointer((Pointer)ptr).position(index).capacity(size / 8L).asBuffer();
            }
            case 3: 
            case 13: {
                return (B)new IntPointer((Pointer)ptr).position(index).capacity(size / 4L).asBuffer();
            }
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return (B)ptr.position(index).capacity(size).asBuffer();
            }
            case 5: 
            case 14: {
                return (B)new ShortPointer((Pointer)ptr).position(index).capacity(size / 2L).asBuffer();
            }
            case 9: {
                return (B)new LongPointer((Pointer)ptr).position(index).capacity(size / 8L).asBuffer();
            }
        }
        assert (false);
        return null;
    }

    public <I extends Indexer> I createIndexer() {
        return this.createIndexer(true);
    }

    public <I extends Indexer> I createIndexer(boolean direct) {
        BytePointer ptr = this.tensor_data();
        int dims = this.dims();
        long size = this.TotalBytes();
        boolean complex = this.dtype() == 8;
        boolean scalar = dims == 0;
        dims = (complex ? 1 : 0) + (scalar ? 1 : dims);
        long[] sizes = new long[dims];
        long[] strides = new long[dims];
        sizes[dims - 1] = complex ? 2L : (scalar ? 1L : this.dim_size(dims - 1));
        strides[dims - 1] = 1L;
        for (int i = dims - 2; i >= 0; --i) {
            sizes[i] = scalar ? 1L : this.dim_size(i);
            strides[i] = sizes[i + 1] * strides[i + 1];
        }
        switch (this.dtype()) {
            case 1: 
            case 8: {
                return (I)FloatIndexer.create((FloatPointer)new FloatPointer((Pointer)ptr).capacity(size / 4L), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
            case 2: {
                return (I)DoubleIndexer.create((DoublePointer)new DoublePointer((Pointer)ptr).capacity(size / 8L), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
            case 3: 
            case 13: {
                return (I)IntIndexer.create((IntPointer)new IntPointer((Pointer)ptr).capacity(size / 4L), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
            case 4: 
            case 10: 
            case 12: {
                return (I)UByteIndexer.create((BytePointer)ptr.capacity(size), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
            case 6: 
            case 11: {
                return (I)ByteIndexer.create((BytePointer)ptr.capacity(size), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
            case 14: {
                return (I)UShortIndexer.create((ShortPointer)new ShortPointer((Pointer)ptr).capacity(size / 2L), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
            case 5: {
                return (I)ShortIndexer.create((ShortPointer)new ShortPointer((Pointer)ptr).capacity(size / 2L), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
            case 9: {
                return (I)LongIndexer.create((LongPointer)new LongPointer((Pointer)ptr).capacity(size / 8L), (long[])sizes, (long[])strides, (boolean)direct).indexable((Indexable)this);
            }
        }
        assert (false);
        return null;
    }

    public StringArray createStringArray() {
        if (this.dtype() != 7) {
            return null;
        }
        long size = this.NumElements();
        return (StringArray)new StringArray((Pointer)this.tensor_data()).capacity(size).limit(size);
    }

    static {
        Loader.load();
    }
}

