/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.tensorflow;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.tensorflow.NodeBuilder;
import org.bytedeco.tensorflow.presets.tensorflow;

@Name(value={"std::vector<tensorflow::NodeBuilder::NodeOut>"})
@Properties(inherit={tensorflow.class})
public class NodeOutVector
extends Pointer {
    public NodeOutVector(Pointer p) {
        super(p);
    }

    public NodeOutVector(NodeBuilder.NodeOut value) {
        this(1L);
        this.put(0L, value);
    }

    public NodeOutVector(NodeBuilder.NodeOut ... array) {
        this(array.length);
        this.put(array);
    }

    public NodeOutVector() {
        this.allocate();
    }

    public NodeOutVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator="})
    @ByRef
    public native NodeOutVector put(@ByRef NodeOutVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    @Index(function="at")
    @ByRef
    public native NodeBuilder.NodeOut get(@Cast(value={"size_t"}) long var1);

    public native NodeOutVector put(@Cast(value={"size_t"}) long var1, NodeBuilder.NodeOut var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef NodeBuilder.NodeOut var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public NodeBuilder.NodeOut[] get() {
        NodeBuilder.NodeOut[] array = new NodeBuilder.NodeOut[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public NodeBuilder.NodeOut pop_back() {
        long size = this.size();
        NodeBuilder.NodeOut value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public NodeOutVector push_back(NodeBuilder.NodeOut value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public NodeOutVector put(NodeBuilder.NodeOut value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public NodeOutVector put(NodeBuilder.NodeOut ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator=="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator*"})
        @ByRef
        @Const
        public native NodeBuilder.NodeOut get();
    }
}

