/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.tensorflow;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.StdString;
import org.bytedeco.tensorflow.AbstractTensor;
import org.bytedeco.tensorflow.AllocationAttributes;
import org.bytedeco.tensorflow.AllocationDescription;
import org.bytedeco.tensorflow.Allocator;
import org.bytedeco.tensorflow.ResourceHandle;
import org.bytedeco.tensorflow.TensorBuffer;
import org.bytedeco.tensorflow.TensorDescription;
import org.bytedeco.tensorflow.TensorProto;
import org.bytedeco.tensorflow.TensorShape;
import org.bytedeco.tensorflow.bfloat16;
import org.bytedeco.tensorflow.presets.tensorflow;

@Namespace(value="tensorflow")
@NoOffset
@Properties(inherit={tensorflow.class})
public class Tensor
extends AbstractTensor {
    private TensorBuffer buffer;

    public Tensor(Pointer p) {
        super(p);
    }

    public Tensor() {
        super(null);
        this.allocate();
    }

    private native void allocate();

    public Tensor(@Cast(value={"tensorflow::DataType"}) int type, @Const @ByRef TensorShape shape) {
        super(null);
        this.allocate(type, shape);
    }

    private native void allocate(@Cast(value={"tensorflow::DataType"}) int var1, @Const @ByRef TensorShape var2);

    public Tensor(Allocator a, @Cast(value={"tensorflow::DataType"}) int type, @Const @ByRef TensorShape shape) {
        super(null);
        this.allocate(a, type, shape);
    }

    private native void allocate(Allocator var1, @Cast(value={"tensorflow::DataType"}) int var2, @Const @ByRef TensorShape var3);

    public Tensor(Allocator a, @Cast(value={"tensorflow::DataType"}) int type, @Const @ByRef TensorShape shape, @Const @ByRef AllocationAttributes allocation_attr) {
        super(null);
        this.allocate(a, type, shape, allocation_attr);
    }

    private native void allocate(Allocator var1, @Cast(value={"tensorflow::DataType"}) int var2, @Const @ByRef TensorShape var3, @Const @ByRef AllocationAttributes var4);

    public Tensor(@Cast(value={"tensorflow::DataType"}) int type) {
        super(null);
        this.allocate(type);
    }

    private native void allocate(@Cast(value={"tensorflow::DataType"}) int var1);

    public Tensor(float scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(float var1);

    public Tensor(double scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(double var1);

    public Tensor(@Cast(value={"tensorflow::uint16"}) short scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(@Cast(value={"tensorflow::uint16"}) short var1);

    public Tensor(@Cast(value={"tensorflow::uint8"}) byte scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(@Cast(value={"tensorflow::uint8"}) byte var1);

    public Tensor(@StdString BytePointer scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(@StdString BytePointer var1);

    public Tensor(@StdString String scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(@StdString String var1);

    public Tensor(@ByVal @Cast(value={"tensorflow::complex64*"}) FloatPointer scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(@ByVal @Cast(value={"tensorflow::complex64*"}) FloatPointer var1);

    public Tensor(@ByVal @Cast(value={"tensorflow::complex64*"}) FloatBuffer scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(@ByVal @Cast(value={"tensorflow::complex64*"}) FloatBuffer var1);

    public Tensor(float ... scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(float ... var1);

    public Tensor(@ByVal @Cast(value={"tensorflow::complex128*"}) DoublePointer scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(@ByVal @Cast(value={"tensorflow::complex128*"}) DoublePointer var1);

    public Tensor(@ByVal @Cast(value={"tensorflow::complex128*"}) DoubleBuffer scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(@ByVal @Cast(value={"tensorflow::complex128*"}) DoubleBuffer var1);

    public Tensor(@ByVal @Cast(value={"tensorflow::complex128*"}) double[] scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(@ByVal @Cast(value={"tensorflow::complex128*"}) double[] var1);

    public Tensor(@Cast(value={"tensorflow::int64"}) long scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(@Cast(value={"tensorflow::int64"}) long var1);

    public Tensor(@Cast(value={"bool"}) boolean scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(@Cast(value={"bool"}) boolean var1);

    public Tensor(@ByVal bfloat16 scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(@ByVal bfloat16 var1);

    public Tensor(@ByVal ResourceHandle scalar_value) {
        super(null);
        this.allocate(scalar_value);
    }

    private native void allocate(@ByVal ResourceHandle var1);

    public Tensor(@Const @ByRef Tensor other) {
        super(null);
        this.allocate(other);
    }

    private native void allocate(@Const @ByRef Tensor var1);

    public Tensor(@Cast(value={"tensorflow::DataType"}) int type, TensorShape shape, TensorBuffer buf) {
        super(null);
        this.allocate(type, shape, buf);
        this.buffer = buf;
    }

    private native void allocate(@Cast(value={"tensorflow::DataType"}) int var1, @Const @ByRef TensorShape var2, TensorBuffer var3);

    public Tensor(@Cast(value={"tensorflow::DataType"}) int type, TensorShape shape, final Pointer data) {
        this(type, shape, new TensorBuffer(data){

            @Override
            public Pointer data() {
                return data;
            }

            @Override
            public long size() {
                return data.limit();
            }

            @Override
            public TensorBuffer root_buffer() {
                return this;
            }

            @Override
            public void FillAllocationDescription(AllocationDescription proto) {
            }
        });
    }

    @Override
    @Cast(value={"tensorflow::DataType"})
    public native int dtype();

    @Const
    @ByRef
    public native TensorShape shape();

    @Override
    public native int dims();

    @Override
    @Cast(value={"tensorflow::int64"})
    public native long dim_size(int var1);

    @Override
    @Cast(value={"tensorflow::int64"})
    public native long NumElements();

    @Cast(value={"bool"})
    public native boolean IsSameSize(@Const @ByRef Tensor var1);

    @Cast(value={"bool"})
    public native boolean SharesBufferWith(@Const @ByRef Tensor var1);

    @Cast(value={"bool"})
    public native boolean IsInitialized();

    @Override
    @Cast(value={"size_t"})
    public native long TotalBytes();

    @Cast(value={"size_t"})
    public native long AllocatedBytes();

    @Cast(value={"bool"})
    public native boolean IsAligned();

    @ByRef
    @Name(value={"operator ="})
    public native Tensor put(@Const @ByRef Tensor var1);

    @Cast(value={"bool"})
    public native boolean CopyFrom(@Const @ByRef Tensor var1, @Const @ByRef TensorShape var2);

    @ByVal
    public native Tensor Slice(@Cast(value={"tensorflow::int64"}) long var1, @Cast(value={"tensorflow::int64"}) long var3);

    @ByVal
    public native Tensor SubSlice(@Cast(value={"tensorflow::int64"}) long var1);

    @Cast(value={"bool"})
    public native boolean FromProto(@Const @ByRef TensorProto var1);

    @Cast(value={"bool"})
    public native boolean FromProto(Allocator var1, @Const @ByRef TensorProto var2);

    public native void AsProtoField(TensorProto var1);

    public native void AsProtoTensorContent(TensorProto var1);

    @StdString
    public native BytePointer SummarizeValue(@Cast(value={"tensorflow::int64"}) long var1, @Cast(value={"bool"}) boolean var3);

    @StdString
    public native BytePointer SummarizeValue(@Cast(value={"tensorflow::int64"}) long var1);

    @StdString
    public native BytePointer DebugString();

    public native void FillDescription(TensorDescription var1);

    @Override
    @tensorflow.StringPiece
    public native BytePointer tensor_data();

    public native void UnsafeCopyFromInternal(@Const @ByRef Tensor var1, @Cast(value={"tensorflow::DataType"}) int var2, @Const @ByRef TensorShape var3);

    static {
        Loader.load();
    }
}

