/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.tensorflow;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.tensorflow.TensorProto;
import org.bytedeco.tensorflow.presets.tensorflow;

@Name(value={"std::vector<tensorflow::TensorProto>"})
@Properties(inherit={tensorflow.class})
public class TensorProtoVector
extends Pointer {
    public TensorProtoVector(Pointer p) {
        super(p);
    }

    public TensorProtoVector(TensorProto value) {
        this(1L);
        this.put(0L, value);
    }

    public TensorProtoVector(TensorProto ... array) {
        this(array.length);
        this.put(array);
    }

    public TensorProtoVector() {
        this.allocate();
    }

    public TensorProtoVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator="})
    @ByRef
    public native TensorProtoVector put(@ByRef TensorProtoVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    @Index(function="at")
    @ByRef
    public native TensorProto get(@Cast(value={"size_t"}) long var1);

    public native TensorProtoVector put(@Cast(value={"size_t"}) long var1, TensorProto var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef TensorProto var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public TensorProto[] get() {
        TensorProto[] array = new TensorProto[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public TensorProto pop_back() {
        long size = this.size();
        TensorProto value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public TensorProtoVector push_back(TensorProto value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public TensorProtoVector put(TensorProto value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public TensorProtoVector put(TensorProto ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator=="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator*"})
        @ByRef
        @Const
        public native TensorProto get();
    }
}

