// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.tesseract;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.leptonica.*;
import static org.bytedeco.leptonica.global.lept.*;

import static org.bytedeco.tesseract.global.tesseract.*;


/**
 * Interface for rendering tesseract results into a document, such as text,
 * HOCR or pdf. This class is abstract. Specific classes handle individual
 * formats. This interface is then used to inject the renderer class into
 * tesseract when processing images.
 *
 * For simplicity implementing this with tesseract version 3.01,
 * the renderer contains document state that is cleared from document
 * to document just as the TessBaseAPI is. This way the base API can just
 * delegate its rendering functionality to injected renderers, and the
 * renderers can manage the associated state needed for the specific formats
 * in addition to the heuristics for producing it.
 */
@Namespace("tesseract") @NoOffset @Properties(inherit = org.bytedeco.tesseract.presets.tesseract.class)
public class TessResultRenderer extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TessResultRenderer(Pointer p) { super(p); }


  // Takes ownership of pointer so must be new'd instance.
  // Renderers aren't ordered, but appends the sequences of next parameter
  // and existing next(). The renderers should be unique across both lists.
  public native void insert(TessResultRenderer next);

  // Returns the next renderer or nullptr.
  public native TessResultRenderer next();

  /**
   * Starts a new document with the given title.
   * This clears the contents of the output data.
   * Title should use UTF-8 encoding.
   */
  public native @Cast("bool") boolean BeginDocument(@Cast("const char*") BytePointer title);
  public native @Cast("bool") boolean BeginDocument(String title);

  /**
   * Adds the recognized text from the source image to the current document.
   * Invalid if BeginDocument not yet called.
   *
   * Note that this API is a bit weird but is designed to fit into the
   * current TessBaseAPI implementation where the api has lots of state
   * information that we might want to add in.
   */
  public native @Cast("bool") boolean AddImage(TessBaseAPI api);

  /**
   * Finishes the document and finalizes the output data
   * Invalid if BeginDocument not yet called.
   */
  public native @Cast("bool") boolean EndDocument();

  public native @Cast("const char*") BytePointer file_extension();
  public native @Cast("const char*") BytePointer title();

  // Is everything fine? Otherwise something went wrong.
  public native @Cast("bool") boolean happy();

  /**
   * Returns the index of the last image given to AddImage
   * (i.e. images are incremented whether the image succeeded or not)
   *
   * This is always defined. It means either the number of the
   * current image, the last image ended, or in the completed document
   * depending on when in the document lifecycle you are looking at it.
   * Will return -1 if a document was never started.
   */
  public native int imagenum();
}
