/**
 * Copyright 2014-2018 yangming.liu<bytefox@126.com>.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, see <http://www.gnu.org/licenses/>.
 */
package org.bytesoft.bytejta.supports.resource.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class StatementImpl implements Statement {
	private Statement delegate;
	private ConnectionImpl connection;

	public <T> T unwrap(Class<T> iface) throws SQLException {
		return delegate.unwrap(iface);
	}

	public ResultSet executeQuery(String sql) throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.executeQuery(sql);
	}

	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		return delegate.isWrapperFor(iface);
	}

	public int executeUpdate(String sql) throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.executeUpdate(sql);
	}

	public void close() throws SQLException {
		delegate.close();
	}

	public int getMaxFieldSize() throws SQLException {
		return delegate.getMaxFieldSize();
	}

	public void setMaxFieldSize(int max) throws SQLException {
		delegate.setMaxFieldSize(max);
	}

	public int getMaxRows() throws SQLException {
		return delegate.getMaxRows();
	}

	public void setMaxRows(int max) throws SQLException {
		delegate.setMaxRows(max);
	}

	public void setEscapeProcessing(boolean enable) throws SQLException {
		delegate.setEscapeProcessing(enable);
	}

	public int getQueryTimeout() throws SQLException {
		return delegate.getQueryTimeout();
	}

	public void setQueryTimeout(int seconds) throws SQLException {
		delegate.setQueryTimeout(seconds);
	}

	public void cancel() throws SQLException {
		delegate.cancel();
	}

	public SQLWarning getWarnings() throws SQLException {
		return delegate.getWarnings();
	}

	public void clearWarnings() throws SQLException {
		delegate.clearWarnings();
	}

	public void setCursorName(String name) throws SQLException {
		delegate.setCursorName(name);
	}

	public boolean execute(String sql) throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.execute(sql);
	}

	public ResultSet getResultSet() throws SQLException {
		return delegate.getResultSet();
	}

	public int getUpdateCount() throws SQLException {
		return delegate.getUpdateCount();
	}

	public boolean getMoreResults() throws SQLException {
		return delegate.getMoreResults();
	}

	public void setFetchDirection(int direction) throws SQLException {
		delegate.setFetchDirection(direction);
	}

	public int getFetchDirection() throws SQLException {
		return delegate.getFetchDirection();
	}

	public void setFetchSize(int rows) throws SQLException {
		delegate.setFetchSize(rows);
	}

	public int getFetchSize() throws SQLException {
		return delegate.getFetchSize();
	}

	public int getResultSetConcurrency() throws SQLException {
		return delegate.getResultSetConcurrency();
	}

	public int getResultSetType() throws SQLException {
		return delegate.getResultSetType();
	}

	public void addBatch(String sql) throws SQLException {
		delegate.addBatch(sql);
	}

	public void clearBatch() throws SQLException {
		delegate.clearBatch();
	}

	public int[] executeBatch() throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.executeBatch();
	}

	public Connection getConnection() throws SQLException {
		return connection;
	}

	public boolean getMoreResults(int current) throws SQLException {
		return delegate.getMoreResults(current);
	}

	public ResultSet getGeneratedKeys() throws SQLException {
		return delegate.getGeneratedKeys();
	}

	public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.executeUpdate(sql, autoGeneratedKeys);
	}

	public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.executeUpdate(sql, columnIndexes);
	}

	public int executeUpdate(String sql, String[] columnNames) throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.executeUpdate(sql, columnNames);
	}

	public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.execute(sql, autoGeneratedKeys);
	}

	public boolean execute(String sql, int[] columnIndexes) throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.execute(sql, columnIndexes);
	}

	public boolean execute(String sql, String[] columnNames) throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.execute(sql, columnNames);
	}

	public int getResultSetHoldability() throws SQLException {
		return delegate.getResultSetHoldability();
	}

	public boolean isClosed() throws SQLException {
		return delegate.isClosed();
	}

	public void setPoolable(boolean poolable) throws SQLException {
		delegate.setPoolable(poolable);
	}

	public boolean isPoolable() throws SQLException {
		return delegate.isPoolable();
	}

	public void closeOnCompletion() throws SQLException {
		delegate.closeOnCompletion();
	}

	public boolean isCloseOnCompletion() throws SQLException {
		return delegate.isCloseOnCompletion();
	}

	public long getLargeUpdateCount() throws SQLException {
		return delegate.getLargeUpdateCount();
	}

	public void setLargeMaxRows(long max) throws SQLException {
		delegate.setLargeMaxRows(max);
	}

	public long getLargeMaxRows() throws SQLException {
		return delegate.getLargeMaxRows();
	}

	public long[] executeLargeBatch() throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.executeLargeBatch();
	}

	public long executeLargeUpdate(String sql) throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.executeLargeUpdate(sql);
	}

	public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.executeLargeUpdate(sql, autoGeneratedKeys);
	}

	public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.executeLargeUpdate(sql, columnIndexes);
	}

	public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
		this.connection.checkTransactionStatusIfNecessary();
		return delegate.executeLargeUpdate(sql, columnNames);
	}

	public void setConnection(ConnectionImpl connection) {
		this.connection = connection;
	}

	public Statement getDelegate() {
		return delegate;
	}

	public void setDelegate(Statement delegate) {
		this.delegate = delegate;
	}

}
