/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.compensable.aware.CompensableEndpointAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class SpringCloudEndpointPostProcessor
implements InitializingBean,
BeanFactoryPostProcessor,
BeanPostProcessor,
EnvironmentAware {
    static final Logger logger = LoggerFactory.getLogger(SpringCloudEndpointPostProcessor.class);
    private Environment environment;
    private String identifier;

    public void afterPropertiesSet() throws Exception {
        this.initializeEndpointIfNecessary();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.injectEndpointIfNecessary(bean);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.injectEndpointIfNecessary(bean);
        return bean;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        int i;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ArrayList<BeanDefinition> beanDefList = new ArrayList<BeanDefinition>();
        String[] beanNameArray = beanFactory.getBeanDefinitionNames();
        for (i = 0; i < beanNameArray.length; ++i) {
            String beanName = beanNameArray[i];
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            String beanClassName = beanDef.getBeanClassName();
            Class<?> beanClass = null;
            try {
                beanClass = cl.loadClass(beanClassName);
            }
            catch (Exception ex) {
                logger.debug("Cannot load class {}, beanId= {}!", new Object[]{beanClassName, beanName, ex});
                continue;
            }
            if (!CompensableEndpointAware.class.isAssignableFrom(beanClass)) continue;
            beanDefList.add(beanDef);
        }
        this.initializeEndpointIfNecessary();
        for (i = 0; i < beanDefList.size(); ++i) {
            BeanDefinition beanDef = (BeanDefinition)beanDefList.get(i);
            MutablePropertyValues mpv = beanDef.getPropertyValues();
            mpv.addPropertyValue("endpoint", (Object)this.identifier);
        }
    }

    private void injectEndpointIfNecessary(Object bean) {
        CompensableEndpointAware aware;
        if (CompensableEndpointAware.class.isInstance(bean) && StringUtils.isBlank((CharSequence)(aware = (CompensableEndpointAware)bean).getEndpoint())) {
            this.initializeEndpointIfNecessary();
            aware.setEndpoint(this.identifier);
        }
    }

    public void initializeEndpointIfNecessary() {
        if (StringUtils.isBlank((CharSequence)this.identifier)) {
            String host = CommonUtils.getInetAddress();
            String name = this.environment.getProperty("spring.application.name");
            String port = this.environment.getProperty("server.port");
            this.identifier = String.format("%s:%s:%s", host, name, port);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

