/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.feign;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytetcc.supports.springcloud.feign.CompensableFeignHandler;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.openfeign.FeignClient;

public class CompensableFeignBeanPostProcessor
implements BeanPostProcessor,
InitializingBean {
    static final String FEIGN_CLAZZ_NAME = "feign.ReflectiveFeign$FeignInvocationHandler";
    private Field singletonTargetSourceTargetField = null;
    private volatile boolean statefully;

    public void afterPropertiesSet() throws Exception {
        Field field = SingletonTargetSource.class.getDeclaredField("target");
        field.setAccessible(true);
        this.singletonTargetSourceTargetField = field;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!Proxy.isProxyClass(bean.getClass())) {
            return bean;
        }
        TargetSource targetSource = null;
        Object object = bean;
        if (Advised.class.isInstance(bean)) {
            Advised advised = (Advised)bean;
            Class[] interfaces = advised.getProxiedInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class intf = interfaces[i];
                if (intf.getAnnotation(FeignClient.class) == null) continue;
                targetSource = advised.getTargetSource();
                try {
                    object = targetSource.getTarget();
                    break;
                }
                catch (Exception error) {
                    throw new IllegalStateException();
                }
            }
        }
        InvocationHandler handler = Proxy.getInvocationHandler(object);
        if (targetSource == null && !StringUtils.equals((CharSequence)FEIGN_CLAZZ_NAME, (CharSequence)handler.getClass().getName())) {
            return bean;
        }
        Object proxied = this.createProxiedObject(object);
        if (targetSource == null) {
            return proxied;
        }
        if (SingletonTargetSource.class.isInstance(targetSource)) {
            try {
                this.singletonTargetSourceTargetField.set(targetSource, proxied);
            }
            catch (IllegalArgumentException error) {
                throw new IllegalStateException("Error occurred!");
            }
            catch (IllegalAccessException error) {
                throw new IllegalStateException("Error occurred!");
            }
        } else {
            throw new IllegalStateException("Not supported yet!");
        }
        return bean;
    }

    private Object createProxiedObject(Object origin) {
        InvocationHandler handler = Proxy.getInvocationHandler(origin);
        CompensableFeignHandler feignHandler = new CompensableFeignHandler();
        feignHandler.setDelegate(handler);
        feignHandler.setStatefully(this.statefully);
        Class<?> clazz = origin.getClass();
        Class<?>[] interfaces = clazz.getInterfaces();
        ClassLoader loader = clazz.getClassLoader();
        return Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)feignHandler);
    }

    public boolean isStatefully() {
        return this.statefully;
    }

    public void setStatefully(boolean statefully) {
        this.statefully = statefully;
    }
}

