/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.feign;

import feign.FeignException;
import feign.Request;
import feign.Response;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytetcc.supports.springcloud.SpringCloudBeanRegistry;
import org.bytesoft.bytetcc.supports.springcloud.feign.CompensableFeignResult;
import org.bytesoft.common.utils.SerializeUtils;
import org.bytesoft.compensable.TransactionContext;
import org.bytesoft.transaction.remote.RemoteCoordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CompensableFeignDecoder
implements Decoder,
InitializingBean,
ApplicationContextAware {
    static Logger logger = LoggerFactory.getLogger(CompensableFeignDecoder.class);
    static final String HEADER_TRANCACTION_KEY = "X-BYTETCC-TRANSACTION";
    static final String HEADER_PROPAGATION_KEY = "X-BYTETCC-PROPAGATION";
    static final String HEADER_RECURSIVELY_KEY = "X-BYTETCC-RECURSIVELY";
    private ApplicationContext applicationContext;
    private Decoder delegate;
    private ObjectFactory<HttpMessageConverters> objectFactory;

    public CompensableFeignDecoder() {
    }

    public CompensableFeignDecoder(Decoder decoder) {
        this.delegate = decoder;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.delegate == null) {
            this.invokeAfterPropertiesSet();
        }
    }

    public void invokeAfterPropertiesSet() throws Exception {
        ResponseEntityDecoder feignDecoder = null;
        String[] beanNameArray = this.applicationContext.getBeanNamesForType(Decoder.class);
        for (int i = 0; beanNameArray != null && i < beanNameArray.length; ++i) {
            String beanName = beanNameArray[i];
            Object beanInst = this.applicationContext.getBean(beanName);
            if (CompensableFeignDecoder.class.isInstance(beanInst)) continue;
            if (feignDecoder != null) {
                throw new RuntimeException("There are more than one feign.codec.Decoder exists!");
            }
            feignDecoder = (Decoder)beanInst;
        }
        if (feignDecoder == null) {
            feignDecoder = new ResponseEntityDecoder((Decoder)new SpringDecoder(this.objectFactory));
        }
        this.delegate = feignDecoder;
    }

    public Object decode(Response resp, Type type) throws IOException, DecodeException, FeignException {
        Request request = resp.request();
        String reqTransactionStr = this.getHeaderValue(request, HEADER_TRANCACTION_KEY);
        String reqPropagationStr = this.getHeaderValue(request, HEADER_PROPAGATION_KEY);
        String respTransactionStr = this.getHeaderValue(resp, HEADER_TRANCACTION_KEY);
        String respPropagationStr = this.getHeaderValue(resp, HEADER_PROPAGATION_KEY);
        String respRecursivelyStr = this.getHeaderValue(resp, HEADER_RECURSIVELY_KEY);
        if (StringUtils.isBlank((CharSequence)reqTransactionStr)) {
            return this.delegate.decode(resp, type);
        }
        if (StringUtils.isBlank((CharSequence)reqPropagationStr)) {
            return this.delegate.decode(resp, type);
        }
        boolean participantInvolved = StringUtils.isNotBlank((CharSequence)respTransactionStr) || StringUtils.isNotBlank((CharSequence)respPropagationStr);
        CompensableFeignResult result = new CompensableFeignResult();
        try {
            String transactionStr = StringUtils.isBlank((CharSequence)respTransactionStr) ? reqTransactionStr : respTransactionStr;
            String propagationStr = StringUtils.isBlank((CharSequence)respPropagationStr) ? reqPropagationStr : respPropagationStr;
            byte[] byteArray = Base64.getDecoder().decode(transactionStr);
            TransactionContext transactionContext = (TransactionContext)SerializeUtils.deserializeObject((byte[])byteArray);
            SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
            RemoteCoordinator remoteCoordinator = beanRegistry.getConsumeCoordinator(propagationStr);
            result.setTransactionContext(transactionContext);
            result.setRemoteParticipant(remoteCoordinator);
            result.setParticipantValidFlag(!participantInvolved || StringUtils.equalsIgnoreCase((CharSequence)respRecursivelyStr, (CharSequence)"TRUE"));
        }
        catch (IOException ex) {
            logger.error("Error occurred while decoding response({})!", (Object)resp, (Object)ex);
        }
        Object value = this.delegate.decode(resp, type);
        result.setResult(value);
        if (result.isParticipantValidFlag()) {
            throw result;
        }
        return value;
    }

    private String getHeaderValue(Request req, String headerName) {
        Map headers = req.headers();
        Collection values = (Collection)headers.get(headerName);
        String value = null;
        if (values != null && !values.isEmpty()) {
            String[] array = new String[values.size()];
            values.toArray(array);
            value = array[0];
        }
        return value;
    }

    private String getHeaderValue(Response resp, String headerName) {
        Map headers = resp.headers();
        Collection values = (Collection)headers.get(headerName);
        String value = null;
        if (values != null && !values.isEmpty()) {
            String[] array = new String[values.size()];
            values.toArray(array);
            value = array[0];
        }
        return value;
    }

    public ObjectFactory<HttpMessageConverters> getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory<HttpMessageConverters> objectFactory) {
        this.objectFactory = objectFactory;
    }

    public Decoder getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Decoder delegate) {
        this.delegate = delegate;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

