/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.feign;

import feign.Request;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytetcc.supports.springcloud.SpringCloudBeanRegistry;
import org.bytesoft.bytetcc.supports.springcloud.feign.CompensableFeignResult;
import org.bytesoft.common.utils.SerializeUtils;
import org.bytesoft.compensable.TransactionContext;
import org.bytesoft.transaction.remote.RemoteCoordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CompensableFeignErrorDecoder
implements ErrorDecoder,
InitializingBean,
ApplicationContextAware {
    static Logger logger = LoggerFactory.getLogger(CompensableFeignErrorDecoder.class);
    static final String HEADER_TRANCACTION_KEY = "X-BYTETCC-TRANSACTION";
    static final String HEADER_PROPAGATION_KEY = "X-BYTETCC-PROPAGATION";
    static final String HEADER_RECURSIVELY_KEY = "X-BYTETCC-RECURSIVELY";
    private ApplicationContext applicationContext;
    private ErrorDecoder delegate;

    public CompensableFeignErrorDecoder() {
    }

    public CompensableFeignErrorDecoder(ErrorDecoder decoder) {
        this.delegate = decoder;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.delegate == null) {
            this.invokeAfterPropertiesSet();
        }
    }

    public void invokeAfterPropertiesSet() throws Exception {
        ErrorDecoder.Default errorDecoder = null;
        String[] beanNameArray = this.applicationContext.getBeanNamesForType(ErrorDecoder.class);
        for (int i = 0; beanNameArray != null && i < beanNameArray.length; ++i) {
            String beanName = beanNameArray[i];
            Object beanInst = this.applicationContext.getBean(beanName);
            if (CompensableFeignErrorDecoder.class.isInstance(beanInst)) continue;
            if (errorDecoder != null) {
                throw new RuntimeException("There are more than one feign.codec.ErrorDecoder exists!");
            }
            errorDecoder = (ErrorDecoder)beanInst;
        }
        if (errorDecoder == null) {
            errorDecoder = new ErrorDecoder.Default();
        }
        this.delegate = errorDecoder;
    }

    public Exception decode(String methodKey, Response resp) {
        Request request = resp.request();
        String reqTransactionStr = this.getHeaderValue(request, HEADER_TRANCACTION_KEY);
        String reqPropagationStr = this.getHeaderValue(request, HEADER_PROPAGATION_KEY);
        String respTransactionStr = this.getHeaderValue(resp, HEADER_TRANCACTION_KEY);
        String respPropagationStr = this.getHeaderValue(resp, HEADER_PROPAGATION_KEY);
        String respRecursivelyStr = this.getHeaderValue(resp, HEADER_RECURSIVELY_KEY);
        if (StringUtils.isBlank((CharSequence)reqTransactionStr)) {
            return this.delegate.decode(methodKey, resp);
        }
        if (StringUtils.isBlank((CharSequence)reqPropagationStr)) {
            return this.delegate.decode(methodKey, resp);
        }
        boolean participantInvolved = StringUtils.isNotBlank((CharSequence)respTransactionStr) || StringUtils.isNotBlank((CharSequence)respPropagationStr);
        CompensableFeignResult result = new CompensableFeignResult();
        try {
            String transactionStr = StringUtils.isBlank((CharSequence)respTransactionStr) ? reqTransactionStr : respTransactionStr;
            String propagationStr = StringUtils.isBlank((CharSequence)respPropagationStr) ? reqPropagationStr : respPropagationStr;
            byte[] byteArray = Base64.getDecoder().decode(transactionStr);
            TransactionContext transactionContext = (TransactionContext)SerializeUtils.deserializeObject((byte[])byteArray);
            SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
            RemoteCoordinator remoteCoordinator = beanRegistry.getConsumeCoordinator(propagationStr);
            result.setTransactionContext(transactionContext);
            result.setRemoteParticipant(remoteCoordinator);
            result.setParticipantValidFlag(!participantInvolved || StringUtils.equalsIgnoreCase((CharSequence)respRecursivelyStr, (CharSequence)"TRUE"));
        }
        catch (IOException ex) {
            logger.error("Error occurred while decoding response: methodKey= {}, response= {}", new Object[]{methodKey, resp, ex});
        }
        Exception value = this.delegate.decode(methodKey, resp);
        result.setError(true);
        result.setResult(value);
        if (result.isParticipantValidFlag()) {
            throw result;
        }
        return value;
    }

    private String getHeaderValue(Request req, String headerName) {
        Map headers = req.headers();
        Collection values = (Collection)headers.get(headerName);
        String value = null;
        if (values != null && !values.isEmpty()) {
            String[] array = new String[values.size()];
            values.toArray(array);
            value = array[0];
        }
        return value;
    }

    private String getHeaderValue(Response resp, String headerName) {
        Map headers = resp.headers();
        Collection values = (Collection)headers.get(headerName);
        String value = null;
        if (values != null && !values.isEmpty()) {
            String[] array = new String[values.size()];
            values.toArray(array);
            value = array[0];
        }
        return value;
    }

    public ErrorDecoder getDelegate() {
        return this.delegate;
    }

    public void setDelegate(ErrorDecoder delegate) {
        this.delegate = delegate;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

