/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.feign;

import com.netflix.loadbalancer.Server;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.bytesoft.bytejta.supports.rpc.TransactionRequestImpl;
import org.bytesoft.bytejta.supports.rpc.TransactionResponseImpl;
import org.bytesoft.bytetcc.CompensableTransactionImpl;
import org.bytesoft.bytetcc.supports.springcloud.SpringCloudBeanRegistry;
import org.bytesoft.bytetcc.supports.springcloud.feign.CompensableFeignResult;
import org.bytesoft.bytetcc.supports.springcloud.loadbalancer.CompensableLoadBalancerInterceptor;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.CompensableManager;
import org.bytesoft.compensable.TransactionContext;
import org.bytesoft.transaction.remote.RemoteCoordinator;
import org.bytesoft.transaction.supports.rpc.TransactionInterceptor;
import org.bytesoft.transaction.supports.rpc.TransactionRequest;
import org.bytesoft.transaction.supports.rpc.TransactionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompensableFeignHandler
implements InvocationHandler {
    static final Logger logger = LoggerFactory.getLogger(CompensableFeignHandler.class);
    private InvocationHandler delegate;
    private volatile boolean statefully;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        final SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
        CompensableBeanFactory beanFactory = beanRegistry.getBeanFactory();
        CompensableManager compensableManager = beanFactory.getCompensableManager();
        final TransactionInterceptor transactionInterceptor = beanFactory.getTransactionInterceptor();
        CompensableTransactionImpl compensable = (CompensableTransactionImpl)compensableManager.getCompensableTransactionQuietly();
        if (compensable == null) {
            return this.delegate.invoke(proxy, method, args);
        }
        final TransactionContext transactionContext = compensable.getTransactionContext();
        if (!transactionContext.isCompensable()) {
            return this.delegate.invoke(proxy, method, args);
        }
        final TransactionRequestImpl request = new TransactionRequestImpl();
        TransactionResponseImpl response = new TransactionResponseImpl();
        beanRegistry.setLoadBalancerInterceptor(new CompensableLoadBalancerInterceptor(this.statefully){

            @Override
            public void afterCompletion(Server server) {
                beanRegistry.removeLoadBalancerInterceptor();
                if (server == null) {
                    logger.warn("There is no suitable server, the TransactionInterceptor.beforeSendRequest() operation is not executed!");
                    return;
                }
                request.setTransactionContext((org.bytesoft.transaction.TransactionContext)transactionContext);
                String instanceId = this.getInstanceId(server);
                RemoteCoordinator coordinator = beanRegistry.getConsumeCoordinator(instanceId);
                request.setTargetTransactionCoordinator(coordinator);
                transactionInterceptor.beforeSendRequest((TransactionRequest)request);
            }
        });
        response.setTransactionContext((org.bytesoft.transaction.TransactionContext)transactionContext);
        try {
            Object object = this.delegate.invoke(proxy, method, args);
            return object;
        }
        catch (Throwable error) {
            Throwable cause = error.getCause();
            CompensableFeignResult cfresult = null;
            if (CompensableFeignResult.class.isInstance(error)) {
                cfresult = (CompensableFeignResult)error;
            } else if (CompensableFeignResult.class.isInstance(cause)) {
                cfresult = (CompensableFeignResult)cause;
            }
            if (cfresult == null) {
                throw error;
            }
            response.setParticipantDelistFlag(cfresult.isParticipantValidFlag());
            Object targetResult = cfresult.getResult();
            if (!cfresult.isError()) {
                Object object = targetResult;
                return object;
            }
            if (RuntimeException.class.isInstance(targetResult)) {
                throw (RuntimeException)targetResult;
            }
            throw new RuntimeException((Exception)targetResult);
        }
        finally {
            Object interceptedValue = response.getHeader(TransactionInterceptor.class.getName());
            if (!Boolean.valueOf(String.valueOf(interceptedValue)).booleanValue()) {
                response.setParticipantEnlistFlag(request.isParticipantEnlistFlag());
                RemoteCoordinator coordinator = request.getTargetTransactionCoordinator();
                response.setSourceTransactionCoordinator(coordinator);
                transactionInterceptor.afterReceiveResponse((TransactionResponse)response);
            }
        }
    }

    public boolean isStatefully() {
        return this.statefully;
    }

    public void setStatefully(boolean statefully) {
        this.statefully = statefully;
    }

    public InvocationHandler getDelegate() {
        return this.delegate;
    }

    public void setDelegate(InvocationHandler delegate) {
        this.delegate = delegate;
    }
}

