/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.hystrix;

import feign.hystrix.FallbackFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.bytesoft.bytetcc.supports.springcloud.hystrix.CompensableHystrixFallbackHandler;
import org.bytesoft.bytetcc.supports.springcloud.hystrix.CompensableHystrixInvocationHandler;

public class CompensableHystrixFallbackFactoryHandler
implements InvocationHandler {
    private final FallbackFactory<?> fallbackFactory;
    private final Class<?> fallbackType;

    public CompensableHystrixFallbackFactoryHandler(FallbackFactory<?> fallbackFactory, Class<?> fallbackType) {
        this.fallbackFactory = fallbackFactory;
        this.fallbackType = fallbackType;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object fallback = method.invoke(this.fallbackFactory, args);
        CompensableHystrixFallbackHandler fallbackHandler = new CompensableHystrixFallbackHandler(fallback);
        ClassLoader classLoader = fallback.getClass().getClassLoader();
        Class[] interfaces = new Class[]{CompensableHystrixInvocationHandler.class, this.fallbackType};
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)fallbackHandler);
    }

    public FallbackFactory<?> getFallbackFactory() {
        return this.fallbackFactory;
    }
}

