/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.hystrix;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.bytesoft.bytetcc.CompensableTransactionImpl;
import org.bytesoft.bytetcc.supports.springcloud.SpringCloudBeanRegistry;
import org.bytesoft.bytetcc.supports.springcloud.hystrix.CompensableHystrixInvocation;
import org.bytesoft.bytetcc.supports.springcloud.hystrix.CompensableHystrixInvocationHandler;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.CompensableManager;
import org.bytesoft.compensable.TransactionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompensableHystrixFeignHandler
implements InvocationHandler {
    static final Logger logger = LoggerFactory.getLogger(CompensableHystrixFeignHandler.class);
    private InvocationHandler delegate;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return this.delegate.invoke(proxy, method, args);
        }
        SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
        CompensableBeanFactory beanFactory = beanRegistry.getBeanFactory();
        CompensableManager compensableManager = beanFactory.getCompensableManager();
        CompensableTransactionImpl compensable = (CompensableTransactionImpl)compensableManager.getCompensableTransactionQuietly();
        if (compensable == null) {
            return this.delegate.invoke(proxy, method, args);
        }
        TransactionContext transactionContext = compensable.getTransactionContext();
        if (!transactionContext.isCompensable()) {
            return this.delegate.invoke(proxy, method, args);
        }
        Method targetMethod = CompensableHystrixInvocationHandler.class.getDeclaredMethod("invoke", CompensableHystrixInvocation.class);
        CompensableHystrixInvocation invocation = new CompensableHystrixInvocation();
        invocation.setThread(Thread.currentThread());
        invocation.setMethod(method);
        invocation.setArgs(args);
        Object[] targetArgs = new Object[]{invocation};
        return this.delegate.invoke(proxy, targetMethod, targetArgs);
    }

    public InvocationHandler getDelegate() {
        return this.delegate;
    }

    public void setDelegate(InvocationHandler delegate) {
        this.delegate = delegate;
    }
}

