/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.hystrix;

import com.netflix.loadbalancer.Server;
import feign.InvocationHandlerFactory;
import java.lang.reflect.Method;
import java.util.Map;
import org.bytesoft.bytejta.supports.rpc.TransactionRequestImpl;
import org.bytesoft.bytejta.supports.rpc.TransactionResponseImpl;
import org.bytesoft.bytetcc.CompensableTransactionImpl;
import org.bytesoft.bytetcc.supports.springcloud.SpringCloudBeanRegistry;
import org.bytesoft.bytetcc.supports.springcloud.feign.CompensableFeignResult;
import org.bytesoft.bytetcc.supports.springcloud.hystrix.CompensableHystrixInvocation;
import org.bytesoft.bytetcc.supports.springcloud.loadbalancer.CompensableLoadBalancerInterceptor;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.CompensableManager;
import org.bytesoft.compensable.CompensableTransaction;
import org.bytesoft.compensable.TransactionContext;
import org.bytesoft.transaction.Transaction;
import org.bytesoft.transaction.remote.RemoteCoordinator;
import org.bytesoft.transaction.supports.rpc.TransactionInterceptor;
import org.bytesoft.transaction.supports.rpc.TransactionRequest;
import org.bytesoft.transaction.supports.rpc.TransactionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompensableHystrixMethodHandler
implements InvocationHandlerFactory.MethodHandler {
    static final Logger logger = LoggerFactory.getLogger(CompensableHystrixMethodHandler.class);
    private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;
    private volatile boolean statefully;

    public CompensableHystrixMethodHandler(Map<Method, InvocationHandlerFactory.MethodHandler> handlerMap) {
        this.dispatch = handlerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object[] argv) throws Throwable {
        final SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
        CompensableBeanFactory beanFactory = beanRegistry.getBeanFactory();
        CompensableManager compensableManager = beanFactory.getCompensableManager();
        final TransactionInterceptor transactionInterceptor = beanFactory.getTransactionInterceptor();
        CompensableHystrixInvocation invocation = (CompensableHystrixInvocation)argv[0];
        Thread thread = invocation.getThread();
        Method method = invocation.getMethod();
        Object[] args = invocation.getArgs();
        CompensableTransactionImpl compensable = (CompensableTransactionImpl)compensableManager.getCompensableTransaction(thread);
        if (compensable == null) {
            return this.dispatch.get(method).invoke(args);
        }
        final TransactionContext transactionContext = compensable.getTransactionContext();
        if (!transactionContext.isCompensable()) {
            return this.dispatch.get(method).invoke(args);
        }
        final TransactionRequestImpl request = new TransactionRequestImpl();
        TransactionResponseImpl response = new TransactionResponseImpl();
        beanRegistry.setLoadBalancerInterceptor(new CompensableLoadBalancerInterceptor(this.statefully){

            @Override
            public void afterCompletion(Server server) {
                beanRegistry.removeLoadBalancerInterceptor();
                if (server == null) {
                    logger.warn("There is no suitable server, the TransactionInterceptor.beforeSendRequest() operation is not executed!");
                    return;
                }
                request.setTransactionContext((org.bytesoft.transaction.TransactionContext)transactionContext);
                String instanceId = this.getInstanceId(server);
                RemoteCoordinator coordinator = beanRegistry.getConsumeCoordinator(instanceId);
                request.setTargetTransactionCoordinator(coordinator);
                transactionInterceptor.beforeSendRequest((TransactionRequest)request);
            }
        });
        response.setTransactionContext((org.bytesoft.transaction.TransactionContext)transactionContext);
        try {
            this.attachThreadIfNecessary(thread);
            Object object = this.dispatch.get(method).invoke(args);
            return object;
        }
        catch (Throwable error) {
            Throwable cause = error.getCause();
            CompensableFeignResult cfresult = null;
            if (CompensableFeignResult.class.isInstance(error)) {
                cfresult = (CompensableFeignResult)error;
            } else if (CompensableFeignResult.class.isInstance(cause)) {
                cfresult = (CompensableFeignResult)cause;
            }
            if (cfresult == null) {
                throw error;
            }
            response.setParticipantDelistFlag(cfresult.isParticipantValidFlag());
            Object targetResult = cfresult.getResult();
            if (!cfresult.isError()) {
                Object object = targetResult;
                return object;
            }
            if (RuntimeException.class.isInstance(targetResult)) {
                throw (RuntimeException)targetResult;
            }
            throw new RuntimeException((Exception)targetResult);
        }
        finally {
            try {
                Object interceptedValue = response.getHeader(TransactionInterceptor.class.getName());
                if (!Boolean.valueOf(String.valueOf(interceptedValue)).booleanValue()) {
                    response.setParticipantEnlistFlag(request.isParticipantEnlistFlag());
                    RemoteCoordinator coordinator = request.getTargetTransactionCoordinator();
                    response.setSourceTransactionCoordinator(coordinator);
                    transactionInterceptor.afterReceiveResponse((TransactionResponse)response);
                }
            }
            finally {
                this.detachThreadIfNecessary(thread);
            }
        }
    }

    private void attachThreadIfNecessary(Thread thread) {
        SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
        CompensableBeanFactory beanFactory = beanRegistry.getBeanFactory();
        CompensableManager compensableManager = beanFactory.getCompensableManager();
        CompensableTransaction compensable = compensableManager.getCompensableTransaction(thread);
        if (!Thread.currentThread().equals(thread)) {
            compensableManager.attachThread((Transaction)compensable);
        }
    }

    private void detachThreadIfNecessary(Thread thread) {
        SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
        CompensableBeanFactory beanFactory = beanRegistry.getBeanFactory();
        CompensableManager compensableManager = beanFactory.getCompensableManager();
        if (!Thread.currentThread().equals(thread)) {
            compensableManager.detachThread();
        }
    }

    public boolean isStatefully() {
        return this.statefully;
    }

    public void setStatefully(boolean statefully) {
        this.statefully = statefully;
    }

    public Map<Method, InvocationHandlerFactory.MethodHandler> getDispatch() {
        return this.dispatch;
    }
}

