/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.loadbalancer;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytetcc.CompensableTransactionImpl;
import org.bytesoft.bytetcc.supports.springcloud.SpringCloudBeanRegistry;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.CompensableManager;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;

public abstract class CompensableLoadBalancerInterceptor {
    private final boolean stateful;

    public CompensableLoadBalancerInterceptor() {
        this(false);
    }

    public CompensableLoadBalancerInterceptor(boolean stateful) {
        this.stateful = stateful;
    }

    public List<Server> beforeCompletion(List<Server> servers) {
        SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
        CompensableBeanFactory beanFactory = beanRegistry.getBeanFactory();
        CompensableManager compensableManager = beanFactory.getCompensableManager();
        ArrayList<Server> readyServerList = new ArrayList<Server>();
        ArrayList<Server> unReadyServerList = new ArrayList<Server>();
        if (this.stateful) {
            boolean applicationEnlisted = false;
            for (int i = 0; servers != null && i < servers.size(); ++i) {
                int port;
                String addr;
                Server server = servers.get(i);
                String application = null;
                String instanceId = null;
                if (DiscoveryEnabledServer.class.isInstance(server)) {
                    DiscoveryEnabledServer discoveryEnabledServer = (DiscoveryEnabledServer)server;
                    InstanceInfo instanceInfo = discoveryEnabledServer.getInstanceInfo();
                    addr = instanceInfo.getIPAddr();
                    application = instanceInfo.getAppName();
                    port = instanceInfo.getPort();
                    instanceId = String.format("%s:%s:%s", addr, application, port);
                } else {
                    Server.MetaInfo metaInfo = server.getMetaInfo();
                    String host = server.getHost();
                    addr = host.matches("\\d+(\\.\\d+){3}") ? host : CommonUtils.getInetAddress((String)host);
                    application = metaInfo.getAppName();
                    port = server.getPort();
                    instanceId = String.format("%s:%s:%s", addr, application, port);
                }
                CompensableTransactionImpl compensable = (CompensableTransactionImpl)compensableManager.getCompensableTransactionQuietly();
                XAResourceDescriptor descriptor = compensable.getRemoteCoordinator(application);
                if (descriptor == null) {
                    if (server.isReadyToServe()) {
                        readyServerList.add(server);
                        continue;
                    }
                    unReadyServerList.add(server);
                    continue;
                }
                String identifier = descriptor.getIdentifier();
                applicationEnlisted = true;
                if (!StringUtils.equals((CharSequence)identifier, (CharSequence)instanceId)) continue;
                ArrayList<Server> serverList = new ArrayList<Server>();
                serverList.add(server);
                return serverList;
            }
            if (applicationEnlisted) {
                return new ArrayList<Server>();
            }
        } else {
            for (int i = 0; servers != null && i < servers.size(); ++i) {
                Server server = servers.get(i);
                if (server.isReadyToServe()) {
                    readyServerList.add(server);
                    continue;
                }
                unReadyServerList.add(server);
            }
        }
        return readyServerList.isEmpty() ? unReadyServerList : readyServerList;
    }

    public abstract void afterCompletion(Server var1);

    public String getInstanceId(Server server) {
        String instanceId = null;
        if (DiscoveryEnabledServer.class.isInstance(server)) {
            DiscoveryEnabledServer discoveryEnabledServer = (DiscoveryEnabledServer)server;
            InstanceInfo instanceInfo = discoveryEnabledServer.getInstanceInfo();
            String addr = instanceInfo.getIPAddr();
            String appName = instanceInfo.getAppName();
            int port = instanceInfo.getPort();
            instanceId = String.format("%s:%s:%s", addr, appName, port);
        } else {
            Server.MetaInfo metaInfo = server.getMetaInfo();
            String host = server.getHost();
            String addr = host.matches("\\d+(\\.\\d+){3}") ? host : CommonUtils.getInetAddress((String)host);
            String appName = metaInfo.getAppName();
            int port = server.getPort();
            instanceId = String.format("%s:%s:%s", addr, appName, port);
        }
        return instanceId;
    }
}

