/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.loadbalancer;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytetcc.supports.springcloud.SpringCloudBeanRegistry;
import org.bytesoft.bytetcc.supports.springcloud.loadbalancer.CompensableLoadBalancerInterceptor;
import org.bytesoft.bytetcc.supports.springcloud.rule.CompensableRule;
import org.bytesoft.bytetcc.supports.springcloud.rule.CompensableRuleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class CompensableLoadBalancerRuleImpl
extends AbstractLoadBalancerRule
implements IRule {
    static final String CONSTANT_RULE_KEY = "org.bytesoft.bytetcc.NFCompensableRuleClassName";
    static Logger logger = LoggerFactory.getLogger(CompensableLoadBalancerRuleImpl.class);
    static Class<?> compensableRuleClass;
    private IClientConfig clientConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server choose(Object key) {
        SpringCloudBeanRegistry registry = SpringCloudBeanRegistry.getInstance();
        CompensableLoadBalancerInterceptor interceptor = registry.getLoadBalancerInterceptor();
        if (compensableRuleClass == null) {
            Environment environment = registry.getEnvironment();
            String clazzName = environment.getProperty(CONSTANT_RULE_KEY);
            if (StringUtils.isNotBlank((CharSequence)clazzName)) {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    compensableRuleClass = classLoader.loadClass(clazzName);
                }
                catch (Exception ex) {
                    logger.error("Error occurred while loading class {}.", (Object)clazzName, (Object)ex);
                    compensableRuleClass = CompensableRuleImpl.class;
                }
            } else {
                compensableRuleClass = CompensableRuleImpl.class;
            }
        }
        CompensableRule compensableRule = null;
        if (CompensableRuleImpl.class.equals(compensableRuleClass)) {
            compensableRule = new CompensableRuleImpl();
        } else {
            try {
                compensableRule = (CompensableRule)compensableRuleClass.newInstance();
            }
            catch (Exception ex) {
                logger.error("Can not create an instance of class {}.", (Object)compensableRuleClass.getName(), (Object)ex);
                compensableRule = new CompensableRuleImpl();
            }
        }
        compensableRule.initWithNiwsConfig(this.clientConfig);
        compensableRule.setLoadBalancer(this.getLoadBalancer());
        if (interceptor == null) {
            return compensableRule.chooseServer(key);
        }
        ILoadBalancer loadBalancer = this.getLoadBalancer();
        List servers = loadBalancer.getAllServers();
        Server server = null;
        try {
            List<Server> serverList = interceptor.beforeCompletion(servers);
            server = compensableRule.chooseServer(key, serverList);
            interceptor.afterCompletion(server);
        }
        catch (Throwable throwable) {
            interceptor.afterCompletion(server);
            throw throwable;
        }
        return server;
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public IClientConfig getClientConfig() {
        return this.clientConfig;
    }
}

