/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.rule;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import java.util.List;
import java.util.Random;
import org.bytesoft.bytetcc.supports.springcloud.rule.CompensableRule;

public class CompensableRuleImpl
implements CompensableRule {
    static final Random RANDOM = new Random();
    private IClientConfig clientConfig;
    private ILoadBalancer loadBalancer;

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    @Override
    public Server chooseServer(Object key, List<Server> serverList) {
        if (serverList == null || serverList.isEmpty()) {
            return null;
        }
        if (serverList.size() == 1) {
            return serverList.get(0);
        }
        return serverList.get(RANDOM.nextInt(serverList.size()));
    }

    @Override
    public Server chooseServer(Object key) {
        List reachableServers = this.loadBalancer.getReachableServers();
        List allServers = this.loadBalancer.getAllServers();
        if (reachableServers != null && !reachableServers.isEmpty()) {
            return (Server)reachableServers.get(RANDOM.nextInt(reachableServers.size()));
        }
        if (allServers != null && !allServers.isEmpty()) {
            return (Server)allServers.get(RANDOM.nextInt(allServers.size()));
        }
        return null;
    }

    public IClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @Override
    public ILoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    @Override
    public void setLoadBalancer(ILoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }
}

