/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.cache2k.Cache;

public abstract class CacheManager
implements Iterable<Cache> {
    private static CacheManager defaultManager;
    private static String defaultName;

    public static String getDefaultName() {
        return defaultName;
    }

    public static void setDefaultName(String defaultName) {
        if (defaultManager != null) {
            throw new IllegalStateException("default CacheManager already created");
        }
        CacheManager.defaultName = defaultName;
    }

    public static synchronized CacheManager getInstance() {
        if (defaultManager != null && !defaultManager.isDestroyed()) {
            return defaultManager;
        }
        try {
            defaultManager = (CacheManager)Class.forName("org.cache2k.impl.CacheManagerImpl").newInstance();
        }
        catch (Exception e) {
            throw new LinkageError("cache2k implementation not found, cache2k-core.jar missing?", e);
        }
        return defaultManager;
    }

    public abstract String getName();

    @Override
    public abstract Iterator<Cache> iterator();

    public abstract void clear();

    public abstract void destroy();

    public abstract boolean isDestroyed();

    static {
        defaultName = "default";
        try {
            Context ctx = new InitialContext();
            ctx = (Context)ctx.lookup("java:comp/env");
            String _name = (String)ctx.lookup("org.cache2k.CacheManager.defaultName");
            if (_name != null) {
                defaultName = _name;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

