/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;

public class SingleProviderResolver {
    static Map<ClassLoader, SingleProviderResolver> loader2resolver = new HashMap<ClassLoader, SingleProviderResolver>();
    private ClassLoader classLoader;
    private HashMap<Class<?>, Object> type2instance = new HashMap();

    public static SingleProviderResolver getInstance() {
        return SingleProviderResolver.getInstance(Thread.currentThread().getContextClassLoader());
    }

    public static synchronized SingleProviderResolver getInstance(ClassLoader cl) {
        SingleProviderResolver r = loader2resolver.get(cl);
        if (r == null) {
            r = new SingleProviderResolver(cl);
            loader2resolver.put(cl, r);
        }
        return r;
    }

    private SingleProviderResolver(ClassLoader cl) {
        this.classLoader = cl;
    }

    public <T> T resolve(Class<T> c) {
        if (c == null) {
            throw new NullPointerException("requested provider interface is null");
        }
        Object obj = this.type2instance.get(c);
        if (obj == null) {
            obj = this.loadProvider(c);
            this.type2instance.put(c, obj);
        }
        return (T)obj;
    }

    <T> T loadProvider(Class<T> c) {
        try {
            String _className = this.readFile("org/cache2k/services/" + c.getName());
            if (_className == null) {
                throw new LinkageError("Provider missing for: " + c.getName());
            }
            return (T)this.classLoader.loadClass(_className).newInstance();
        }
        catch (Exception e) {
            throw new LinkageError("Error instantiating " + c.getName() + ", got " + e.toString());
        }
    }

    String readFile(String _name) throws IOException {
        InputStream in = this.classLoader.getResourceAsStream(_name);
        if (in == null) {
            throw new IOException("Class resource file not found: " + _name);
        }
        LineNumberReader r = new LineNumberReader(new InputStreamReader(in));
        String l = r.readLine();
        while (l != null) {
            if (!l.startsWith("#")) {
                return l;
            }
            l = r.readLine();
        }
        return null;
    }
}

