/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.cache2k.BulkCacheSource;
import org.cache2k.Cache;
import org.cache2k.CacheConfig;
import org.cache2k.CacheSource;
import org.cache2k.CacheSourceWithMetaInfo;
import org.cache2k.EntryExpiryCalculator;
import org.cache2k.ExceptionExpiryCalculator;
import org.cache2k.ExperimentalBulkCacheSource;
import org.cache2k.RefreshController;
import org.cache2k.RootAnyBuilder;
import org.cache2k.spi.Cache2kCoreProvider;
import org.cache2k.spi.SingleProviderResolver;

public abstract class CacheBuilder<K, T>
extends RootAnyBuilder<K, T>
implements Cloneable {
    private static CacheBuilder PROTOTYPE;
    protected EntryExpiryCalculator entryExpiryCalculator;
    protected CacheSource cacheSource;
    protected CacheSourceWithMetaInfo cacheSourceWithMetaInfo;
    protected RefreshController refreshController;
    protected ExperimentalBulkCacheSource experimentalBulkCacheSource;
    protected BulkCacheSource bulkCacheSource;
    protected ExceptionExpiryCalculator exceptionExpiryCalculator;

    public static <K, T> CacheBuilder<K, T> newCache(Class<K> _keyType, Class<T> _valueType) {
        CacheBuilder cb = null;
        try {
            cb = (CacheBuilder)PROTOTYPE.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        cb.ctor(_keyType, _valueType, null);
        return cb;
    }

    public static <K, C extends Collection<T>, T> CacheBuilder<K, C> newCache(Class<K> _keyType, Class<C> _collectionType, Class<T> _entryType) {
        CacheBuilder cb = null;
        try {
            cb = (CacheBuilder)PROTOTYPE.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        cb.ctor(_keyType, _collectionType, _entryType);
        return cb;
    }

    protected void ctor(Class<K> _keyType, Class<T> _valueType, Class<?> _entryType) {
        this.root = this;
        this.config = new CacheConfig();
        this.config.setValueType(_valueType);
        this.config.setKeyType(_keyType);
        this.config.setEntryType(_entryType);
    }

    public CacheBuilder<K, T> name(Class<?> _class, String _fieldName) {
        this.config.setName(_class.getSimpleName() + "." + _fieldName);
        return this;
    }

    public CacheBuilder<K, T> name(Class<?> _class) {
        this.config.setName(_class.getSimpleName());
        return this;
    }

    public CacheBuilder<K, T> name(Object _containingObject, String _fieldName) {
        return this.name(_containingObject.getClass(), _fieldName);
    }

    public CacheBuilder<K, T> name(String v) {
        this.config.setName(v);
        return this;
    }

    public CacheBuilder<K, T> keepDataAfterExpired(boolean v) {
        this.config.setKeepDataAfterExpired(v);
        return this;
    }

    public CacheBuilder<K, T> maxSize(int v) {
        this.config.setMaxSize(v);
        return this;
    }

    public CacheBuilder<K, T> maxSizeBound(int v) {
        this.config.setMaxSizeHighBound(v);
        return this;
    }

    public CacheBuilder<K, T> eternal(boolean v) {
        this.config.setEternal(v);
        return this;
    }

    public CacheBuilder<K, T> suppressExceptions(boolean v) {
        this.config.setSuppressExceptions(v);
        return this;
    }

    public CacheBuilder<K, T> heapEntryCapacity(int v) {
        this.config.setHeapEntryCapacity(v);
        return this;
    }

    public CacheBuilder<K, T> expiryDuration(long v, TimeUnit u) {
        this.config.setExpiryMillis(u.toMillis(v));
        return this;
    }

    public CacheBuilder<K, T> exceptionExpiryDuration(long v, TimeUnit u) {
        this.config.setExceptionExpiryMillis(u.toMillis(v));
        return this;
    }

    public CacheBuilder<K, T> expirySecs(int v) {
        this.config.setExpiryMillis(v * 1000);
        return this;
    }

    public CacheBuilder<K, T> expiryMillis(long v) {
        this.config.setExpiryMillis(v);
        return this;
    }

    public CacheBuilder<K, T> source(CacheSource<K, T> g) {
        this.cacheSource = g;
        return this;
    }

    public CacheBuilder<K, T> source(CacheSourceWithMetaInfo<K, T> g) {
        this.cacheSourceWithMetaInfo = g;
        return this;
    }

    public CacheBuilder<K, T> source(ExperimentalBulkCacheSource<K, T> g) {
        this.experimentalBulkCacheSource = g;
        return this;
    }

    public CacheBuilder<K, T> source(BulkCacheSource<K, T> g) {
        this.bulkCacheSource = g;
        return this;
    }

    public CacheBuilder<K, T> entryExpiryCalculator(EntryExpiryCalculator c) {
        this.entryExpiryCalculator = c;
        return this;
    }

    public CacheBuilder<K, T> exceptionExpiryCalculator(ExceptionExpiryCalculator c) {
        this.exceptionExpiryCalculator = c;
        return this;
    }

    public CacheBuilder<K, T> refreshController(RefreshController c) {
        this.refreshController = c;
        return this;
    }

    public CacheBuilder<K, T> implementation(Class<?> c) {
        this.config.setImplementation(c);
        return this;
    }

    @Deprecated
    public CacheConfig getConfig() {
        return null;
    }

    @Override
    public abstract Cache<K, T> build();

    static {
        try {
            Cache2kCoreProvider _provider = SingleProviderResolver.getInstance().resolve(Cache2kCoreProvider.class);
            PROTOTYPE = _provider.getBuilderImplementation().newInstance();
        }
        catch (Exception ex) {
            throw new Error("cache2k-core module missing, no builder prototype", ex);
        }
    }
}

