/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.cache2k.BulkCacheSource;
import org.cache2k.Cache;
import org.cache2k.CacheConfig;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.CacheSource;
import org.cache2k.CacheSourceWithMetaInfo;
import org.cache2k.CacheTypeDescriptor;
import org.cache2k.EntryExpiryCalculator;
import org.cache2k.ExperimentalBulkCacheSource;
import org.cache2k.RefreshController;
import org.cache2k.RootAnyBuilder;
import org.cache2k.customization.ExceptionExpiryCalculator;
import org.cache2k.customization.ExpiryCalculator;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.CacheLoader;
import org.cache2k.integration.CacheWriter;
import org.cache2k.integration.ExceptionPropagator;
import org.cache2k.spi.Cache2kCoreProvider;
import org.cache2k.spi.SingleProviderResolver;

public abstract class CacheBuilder<K, V>
extends RootAnyBuilder<K, V>
implements Cloneable {
    private static CacheBuilder PROTOTYPE;
    protected CacheManager manager;
    protected CacheSource cacheSource;
    protected CacheSourceWithMetaInfo cacheSourceWithMetaInfo;
    protected ExperimentalBulkCacheSource experimentalBulkCacheSource;
    protected BulkCacheSource bulkCacheSource;
    protected CacheWriter cacheWriter;
    protected ExceptionPropagator exceptionPropagator;

    public static CacheBuilder<?, ?> newCache() {
        return CacheBuilder.fromConfig(new CacheConfig());
    }

    public static <K, T> CacheBuilder<K, T> newCache(Class<K> _keyType, Class<T> _valueType) {
        return CacheBuilder.fromConfig(CacheConfig.of(_keyType, _valueType));
    }

    public static <K, T> CacheBuilder<K, T> newCache(CacheTypeDescriptor<K> _keyType, Class<T> _valueType) {
        return CacheBuilder.fromConfig(CacheConfig.of(_keyType, _valueType));
    }

    public static <K, T> CacheBuilder<K, T> newCache(Class<K> _keyType, CacheTypeDescriptor<T> _valueType) {
        return CacheBuilder.fromConfig(CacheConfig.of(_keyType, _valueType));
    }

    public static <K, T> CacheBuilder<K, T> newCache(CacheTypeDescriptor<K> _keyType, CacheTypeDescriptor<T> _valueType) {
        return CacheBuilder.fromConfig(CacheConfig.of(_keyType, _valueType));
    }

    public static <K, C extends Collection<T>, T> CacheBuilder<K, C> newCache(Class<K> _keyType, Class<C> _collectionType, Class<T> _entryType) {
        return CacheBuilder.fromConfig(CacheConfig.of(_keyType, _collectionType));
    }

    static <K, T> CacheBuilder<K, T> fromConfig(CacheConfig<K, T> c) {
        CacheBuilder cb = null;
        try {
            cb = (CacheBuilder)PROTOTYPE.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        cb.root = cb;
        cb.config = c;
        return cb;
    }

    public <K2> CacheBuilder<K2, V> keyType(Class<K2> t) {
        this.config.setKeyType(t);
        return this;
    }

    public <T2> CacheBuilder<K, T2> valueType(Class<T2> t) {
        this.config.setValueType(t);
        return this;
    }

    public <K2> CacheBuilder<K2, V> keyType(CacheTypeDescriptor<K2> t) {
        this.config.setKeyType(t);
        return this;
    }

    public <T2> CacheBuilder<K, T2> valueType(CacheTypeDescriptor<T2> t) {
        this.config.setValueType(t);
        return this;
    }

    public CacheBuilder<K, V> name(Class<?> _class, String _fieldName) {
        this.config.setName(_class.getSimpleName() + "." + _fieldName);
        return this;
    }

    public CacheBuilder<K, V> name(Class<?> _class) {
        this.config.setName(_class.getSimpleName());
        return this;
    }

    public CacheBuilder<K, V> name(Object _containingObject, String _fieldName) {
        return this.name(_containingObject.getClass(), _fieldName);
    }

    public CacheBuilder<K, V> manager(CacheManager m) {
        this.manager = m;
        return this;
    }

    public CacheBuilder<K, V> name(String v) {
        this.config.setName(v);
        return this;
    }

    public CacheBuilder<K, V> keepDataAfterExpired(boolean v) {
        this.config.setKeepDataAfterExpired(v);
        return this;
    }

    public CacheBuilder<K, V> entryCapacity(int v) {
        this.config.setEntryCapacity(v);
        return this;
    }

    public CacheBuilder<K, V> maxSize(int v) {
        this.config.setEntryCapacity(v);
        return this;
    }

    public CacheBuilder<K, V> maxSizeBound(int v) {
        return this;
    }

    public CacheBuilder<K, V> eternal(boolean v) {
        this.config.setEternal(v);
        return this;
    }

    public CacheBuilder<K, V> suppressExceptions(boolean v) {
        this.config.setSuppressExceptions(v);
        return this;
    }

    public CacheBuilder<K, V> heapEntryCapacity(int v) {
        this.config.setHeapEntryCapacity(v);
        return this;
    }

    public CacheBuilder<K, V> expiryDuration(long v, TimeUnit u) {
        this.config.setExpiryMillis(u.toMillis(v));
        return this;
    }

    public CacheBuilder<K, V> exceptionExpiryDuration(long v, TimeUnit u) {
        this.config.setExceptionExpiryMillis(u.toMillis(v));
        return this;
    }

    public CacheBuilder<K, V> expirySecs(int v) {
        this.config.setExpiryMillis(v * 1000);
        return this;
    }

    public CacheBuilder<K, V> expiryMillis(long v) {
        this.config.setExpiryMillis(v);
        return this;
    }

    public CacheBuilder<K, V> exceptionPropagator(ExceptionPropagator ep) {
        this.exceptionPropagator = ep;
        return this;
    }

    public CacheBuilder<K, V> source(CacheSource<K, V> g) {
        this.cacheSource = g;
        return this;
    }

    public CacheBuilder<K, V> source(CacheSourceWithMetaInfo<K, V> g) {
        this.cacheSourceWithMetaInfo = g;
        return this;
    }

    public CacheBuilder<K, V> source(ExperimentalBulkCacheSource<K, V> g) {
        this.experimentalBulkCacheSource = g;
        return this;
    }

    public CacheBuilder<K, V> source(BulkCacheSource<K, V> g) {
        this.bulkCacheSource = g;
        return this;
    }

    public CacheBuilder<K, V> loader(CacheLoader<K, V> l) {
        this.config.setLoader(l);
        return this;
    }

    public CacheBuilder<K, V> loader(AdvancedCacheLoader<K, V> l) {
        this.config.setAdvancedLoader(l);
        return this;
    }

    public CacheBuilder<K, V> writer(CacheWriter<K, V> w) {
        this.cacheWriter = w;
        return this;
    }

    public abstract CacheBuilder<K, V> addListener(CacheEntryOperationListener<K, V> var1);

    public CacheBuilder<K, V> entryExpiryCalculator(EntryExpiryCalculator<K, V> c) {
        this.expiryCalculator(c);
        return this;
    }

    public CacheBuilder<K, V> expiryCalculator(ExpiryCalculator<K, V> c) {
        this.config.setExpiryCalculator(c);
        return this;
    }

    public CacheBuilder<K, V> exceptionExpiryCalculator(ExceptionExpiryCalculator<K> c) {
        this.config.setExceptionExpiryCalculator(c);
        return this;
    }

    public CacheBuilder<K, V> refreshController(final RefreshController lc) {
        this.expiryCalculator(new ExpiryCalculator<K, V>(){

            @Override
            public long calculateExpiryTime(K _key, V _value, long _loadTime, CacheEntry<K, V> _oldEntry) {
                if (_oldEntry != null) {
                    return lc.calculateNextRefreshTime(_oldEntry.getValue(), _value, _oldEntry.getLastModification(), _loadTime);
                }
                return lc.calculateNextRefreshTime(null, _value, 0L, _loadTime);
            }
        });
        return this;
    }

    public CacheBuilder<K, V> implementation(Class<?> c) {
        this.config.setImplementation(c);
        return this;
    }

    public CacheBuilder<K, V> refreshAhead(boolean f) {
        this.config.setRefreshAhead(f);
        return this;
    }

    public CacheBuilder<K, V> backgroundRefresh(boolean f) {
        this.config.setRefreshAhead(f);
        return this;
    }

    public CacheBuilder<K, V> sharpExpiry(boolean f) {
        this.config.setSharpExpiry(f);
        return this;
    }

    public CacheBuilder<K, V> loaderThreadCount(int v) {
        this.config.setLoaderThreadCount(v);
        return this;
    }

    public CacheBuilder<K, V> storeByReference(boolean v) {
        this.config.setStoreByReference(v);
        return this;
    }

    @Deprecated
    public CacheConfig getConfig() {
        return null;
    }

    @Override
    public abstract Cache<K, V> build();

    static {
        try {
            Cache2kCoreProvider _provider = SingleProviderResolver.getInstance().resolve(Cache2kCoreProvider.class);
            PROTOTYPE = _provider.getBuilderImplementation().newInstance();
        }
        catch (Exception ex) {
            throw new Error("cache2k-core module missing, no builder prototype", ex);
        }
    }
}

