/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.io.Serializable;
import java.util.List;
import org.cache2k.CacheType;
import org.cache2k.CacheTypeDescriptor;
import org.cache2k.customization.ExceptionExpiryCalculator;
import org.cache2k.customization.ExpiryCalculator;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.CacheLoader;

public class CacheConfig<K, V>
implements Serializable {
    private boolean storeByReference;
    private String name;
    private CacheTypeDescriptor keyType;
    private CacheTypeDescriptor valueType;
    private Class<?> implementation;
    private int maxSize = 2000;
    private int entryCapacity = 2000;
    private int maxSizeHighBound = Integer.MAX_VALUE;
    private int maxSizeLowBound = 0;
    private int heapEntryCapacity = -1;
    private boolean refreshAhead = false;
    private long expiryMillis = 600000L;
    private long exceptionExpiryMillis = -1L;
    private boolean keepDataAfterExpired = true;
    private boolean sharpExpiry = false;
    private List<Object> moduleConfiguration;
    private boolean suppressExceptions = true;
    private CacheLoader<K, V> loader;
    private AdvancedCacheLoader<K, V> advancedLoader;
    private int loaderThreadCount;
    private ExpiryCalculator<K, V> expiryCalculator;
    private ExceptionExpiryCalculator<K> exceptionExpiryCalculator;

    public static <K, V> CacheConfig<K, V> of(Class<K> keyType, Class<V> valueType) {
        CacheConfig<K, V> c = new CacheConfig<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> CacheConfig<K, V> of(Class<K> keyType, CacheTypeDescriptor<V> valueType) {
        CacheConfig<K, V> c = new CacheConfig<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> CacheConfig<K, V> of(CacheTypeDescriptor<K> keyType, Class<V> valueType) {
        CacheConfig<K, V> c = new CacheConfig<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public static <K, V> CacheConfig<K, V> of(CacheTypeDescriptor<K> keyType, CacheTypeDescriptor<V> valueType) {
        CacheConfig<K, V> c = new CacheConfig<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getEntryCapacity() {
        return this.entryCapacity;
    }

    public void setEntryCapacity(int v) {
        this.entryCapacity = v;
    }

    public int getMaxSize() {
        return this.entryCapacity;
    }

    public void setMaxSize(int v) {
        this.entryCapacity = v;
    }

    public int getMaxSizeHighBound() {
        return this.maxSizeHighBound;
    }

    public void setMaxSizeHighBound(int maxSizeHighBound) {
        if (this.maxSize > maxSizeHighBound) {
            this.maxSize = maxSizeHighBound;
        }
        this.maxSizeHighBound = maxSizeHighBound;
    }

    public int getMaxSizeLowBound() {
        return this.maxSizeLowBound;
    }

    public void setMaxSizeLowBound(int maxSizeLowBound) {
        if (this.maxSize < maxSizeLowBound) {
            this.maxSize = maxSizeLowBound;
        }
        this.maxSizeLowBound = maxSizeLowBound;
    }

    public boolean isRefreshAhead() {
        return this.refreshAhead;
    }

    public void setRefreshAhead(boolean v) {
        this.refreshAhead = v;
    }

    public boolean isBackgroundRefresh() {
        return this.refreshAhead;
    }

    public void setBackgroundRefresh(boolean v) {
        this.refreshAhead = v;
    }

    public CacheTypeDescriptor getKeyType() {
        return this.keyType;
    }

    void checkNull(Object v) {
        if (v == null) {
            throw new NullPointerException("null value not allowed");
        }
    }

    public void setKeyType(Class<?> v) {
        this.checkNull(v);
        this.setKeyType(CacheType.fromClass(v));
    }

    public void setKeyType(CacheTypeDescriptor v) {
        this.checkNull(v);
        if (this.keyType != null && !v.equals(this.keyType)) {
            throw new IllegalArgumentException("Key type may only set once.");
        }
        if (v.isArray()) {
            throw new IllegalArgumentException("Arrays are not supported for keys");
        }
        this.keyType = v.getBeanRepresentation();
    }

    public CacheTypeDescriptor<V> getValueType() {
        return this.valueType;
    }

    public void setValueType(Class<?> v) {
        this.checkNull(v);
        this.setValueType(new CacheTypeDescriptor.OfClass(v));
    }

    public void setValueType(CacheTypeDescriptor v) {
        this.checkNull(v);
        if (this.valueType != null && !v.equals(this.valueType)) {
            throw new IllegalArgumentException("Value type may only set once.");
        }
        if (v.isArray()) {
            throw new IllegalArgumentException("Arrays are not supported for values");
        }
        this.valueType = v.getBeanRepresentation();
    }

    public boolean isEternal() {
        return this.expiryMillis == -1L || this.expiryMillis == Long.MAX_VALUE;
    }

    public void setEternal(boolean v) {
        if (v) {
            this.expiryMillis = -1L;
        }
    }

    public void setExpirySeconds(int v) {
        if (v == -1 || v == Integer.MAX_VALUE) {
            this.expiryMillis = -1L;
        }
        this.expiryMillis = (long)v * 1000L;
    }

    public int getExpirySeconds() {
        if (this.isEternal()) {
            return -1;
        }
        return (int)(this.expiryMillis / 1000L);
    }

    public long getExpiryMillis() {
        return this.expiryMillis;
    }

    public void setExpiryMillis(long expiryMillis) {
        this.expiryMillis = expiryMillis;
    }

    public long getExceptionExpiryMillis() {
        return this.exceptionExpiryMillis;
    }

    public void setExceptionExpiryMillis(long v) {
        this.exceptionExpiryMillis = v;
    }

    public boolean isKeepDataAfterExpired() {
        return this.keepDataAfterExpired;
    }

    public void setKeepDataAfterExpired(boolean v) {
        this.keepDataAfterExpired = v;
    }

    public boolean isSharpExpiry() {
        return this.sharpExpiry;
    }

    public void setSharpExpiry(boolean sharpExpiry) {
        this.sharpExpiry = sharpExpiry;
    }

    public boolean isSuppressExceptions() {
        return this.suppressExceptions;
    }

    public void setSuppressExceptions(boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }

    public int getHeapEntryCapacity() {
        return this.heapEntryCapacity;
    }

    public void setHeapEntryCapacity(int v) {
        this.heapEntryCapacity = v;
    }

    public List<Object> getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    public void setModuleConfiguration(List<Object> moduleConfiguration) {
        this.moduleConfiguration = moduleConfiguration;
    }

    public Class<?> getImplementation() {
        return this.implementation;
    }

    public void setImplementation(Class<?> cacheImplementation) {
        this.implementation = cacheImplementation;
    }

    public CacheLoader<K, V> getLoader() {
        return this.loader;
    }

    public void setLoader(CacheLoader<K, V> v) {
        this.loader = v;
    }

    public AdvancedCacheLoader<K, V> getAdvancedLoader() {
        return this.advancedLoader;
    }

    public void setAdvancedLoader(AdvancedCacheLoader<K, V> v) {
        this.advancedLoader = v;
    }

    public int getLoaderThreadCount() {
        return this.loaderThreadCount;
    }

    public void setLoaderThreadCount(int v) {
        this.loaderThreadCount = v;
    }

    public ExceptionExpiryCalculator<K> getExceptionExpiryCalculator() {
        return this.exceptionExpiryCalculator;
    }

    public void setExceptionExpiryCalculator(ExceptionExpiryCalculator<K> _exceptionExpiryCalculator) {
        this.exceptionExpiryCalculator = _exceptionExpiryCalculator;
    }

    public ExpiryCalculator<K, V> getExpiryCalculator() {
        return this.expiryCalculator;
    }

    public void setExpiryCalculator(ExpiryCalculator<K, V> _expiryCalculator) {
        this.expiryCalculator = _expiryCalculator;
    }

    public boolean isStoreByReference() {
        return this.storeByReference;
    }

    public void setStoreByReference(boolean _storeByReference) {
        this.storeByReference = _storeByReference;
    }
}

